/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.segment;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.ql.ResultSets;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.NavigateComponent;
import ai.platon.scent.dom.nodes.NavigateDocument;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.segment.AnchorFrameLocator;
import ai.platon.scent.segment.BlockLocator;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016RQ\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/segment/NavigationLocator;", "Lai/platon/scent/segment/AnchorFrameLocator;", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Lai/platon/scent/dom/HarvestOptions;)V", "anchorGroups", "Lcom/google/common/collect/TreeMultimap;", "", "kotlin.jvm.PlatformType", "Lai/platon/scent/dom/nodes/AnchorGroup;", "getAnchorGroups", "()Lcom/google/common/collect/TreeMultimap;", "documents", "", "Lai/platon/scent/dom/nodes/NavigateDocument;", "getDocuments", "()Ljava/util/List;", "locate", "", "Lorg/jsoup/nodes/Element;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "docs", "toReport", "prefix", "postfix", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nBlockLocators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockLocators.kt\nai/platon/scent/segment/NavigationLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1620#2,3:383\n2634#2:386\n1360#2:388\n1446#2,2:389\n1360#2:391\n1446#2,2:392\n766#2:394\n857#2,2:395\n1448#2,3:397\n1855#2,2:400\n1603#2,9:403\n1855#2:412\n1856#2:414\n1612#2:415\n1360#2:417\n1446#2,5:418\n1054#2:423\n1864#2,3:424\n1#3:387\n1#3:402\n1#3:413\n1#3:416\n*S KotlinDebug\n*F\n+ 1 BlockLocators.kt\nai/platon/scent/segment/NavigationLocator\n*L\n306#1:383,3\n307#1:386\n308#1:388\n308#1:389,2\n308#1:391\n308#1:392,2\n308#1:394\n308#1:395,2\n308#1:397,3\n309#1:400,2\n322#1:403,9\n322#1:412\n322#1:414\n322#1:415\n332#1:417\n332#1:418,5\n332#1:423\n332#1:424,3\n307#1:387\n322#1:413\n*E\n"})
public class NavigationLocator
extends AnchorFrameLocator {
    @NotNull
    private final List<NavigateDocument> documents;
    private final TreeMultimap<String, AnchorGroup> anchorGroups;

    public NavigationLocator(@NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.documents = new ArrayList();
        this.anchorGroups = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)ComparisonsKt.reverseOrder());
    }

    @NotNull
    public final List<NavigateDocument> getDocuments() {
        return this.documents;
    }

    public final TreeMultimap<String, AnchorGroup> getAnchorGroups() {
        return this.anchorGroups;
    }

    @Override
    @NotNull
    public List<Element> locate(@NotNull FeaturedDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isInitialized((Document)doc.getDocument()).get()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.locate(CollectionsKt.listOf((Object)doc));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Element> locate(@NotNull List<? extends FeaturedDocument> docs) {
        void $this$mapNotNullTo$iv$iv;
        Iterator $this$flatMapTo$iv$iv3;
        NavigateDocument it;
        Iterator it2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        Iterable iterable = docs;
        Collection destination$iv = this.documents;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            FeaturedDocument featuredDocument = (FeaturedDocument)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new NavigateDocument((FeaturedDocument)it2));
        }
        Iterable $this$onEach$iv = this.documents;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $i$f$mapTo22 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (NavigateDocument)element$iv;
            boolean bl2 = false;
            it.partition(this.getOptions());
        }
        Iterable $this$flatMap$iv = $i$f$mapTo22;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        it2 = $this$flatMapTo$iv$iv3.iterator();
        while (it2.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv$iv = it2.next();
            it = (NavigateDocument)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$flatMap$iv2 = it.getAnchorGroups();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$filterTo$iv$iv;
                AnchorGroup it3 = (AnchorGroup)element$iv$iv2;
                boolean bl4 = false;
                Iterable $this$filter$iv = it3.leafNodes();
                boolean $i$f$filter = false;
                Iterable iterable3 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                    AnchorGroup it4 = (AnchorGroup)element$iv$iv3;
                    boolean bl5 = false;
                    if (!(it4.getSize() >= 5)) continue;
                    destination$iv$iv3.add(element$iv$iv3);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AnchorGroup it5 = (AnchorGroup)element$iv;
            boolean bl6 = false;
            this.anchorGroups.put((Object)it5.getPath(), (Object)it5);
        }
        if (this.getLog().isInfoEnabled()) {
            Object element$iv;
            Iterable $i$f$forEach2 = this.documents;
            int $this$flatMapTo$iv$iv3 = 0;
            for (Object it5 : $i$f$forEach2) {
                NavigateDocument bl6 = (NavigateDocument)it5;
                int n = $this$flatMapTo$iv$iv3;
                boolean bl7 = false;
                int n2 = it.getComponents().size();
                $this$flatMapTo$iv$iv3 = n + n2;
            }
            int numComponents = $this$flatMapTo$iv$iv3;
            element$iv = "Found %d anchor groups from %d navigate components";
            Object[] it5 = new Object[]{this.anchorGroups.size(), numComponents};
            String string = String.format((String)element$iv, Arrays.copyOf(it5, it5.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String message2 = string;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(BlockLocator.toReport$default(this, message2, null, 2, null));
            } else {
                this.getLog().info(message2);
            }
        }
        Collection collection = this.anchorGroups.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable $this$flatMapTo$iv$iv3 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl8 = false;
            AnchorGroup it6 = (AnchorGroup)element$iv$iv;
            boolean bl9 = false;
            NavigateComponent navigateComponent = it6.getComponent();
            if ((navigateComponent != null ? navigateComponent.getElement() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toReport(@NotNull String prefix, @NotNull String postfix) {
        void $this$sortedByDescending$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        StringBuilder sb = new StringBuilder(prefix);
        SimpleResultSet rs = null;
        rs = ResultSets.newSimpleResultSet();
        String[] stringArray = new String[]{" ", "Name", "X", "Y", "W", "H", "E C", "AnchorImgs", "Anchors", "Child Widths", "Child Heights", "Sqr Areas", "Memo", "Score"};
        String[] it = stringArray;
        boolean $i$a$-let-NavigationLocator$toReport$22 = false;
        ResultSets.addColumns((SimpleResultSet)rs, (String[])Arrays.copyOf(it, it.length));
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        Iterable $i$a$-let-NavigationLocator$toReport$22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NavigateDocument it2 = (NavigateDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NavigateComponent it = (NavigateComponent)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (NavigateComponent)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
            }
        }), (int)100);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String sqrtArea2;
            Comparable[] comparableArray;
            Frequency frequency;
            void component;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (NavigateComponent)item$iv;
            int i = n;
            boolean bl = false;
            Element e = component.getElement();
            String name = StringUtils.abbreviateMiddle((String)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCanonicalName((Node)((Node)e)), (String)"..", (int)40);
            Frequency it3 = frequency = NodeExtKt.getChildrenWidths((Node)((Node)e));
            boolean bl2 = false;
            Object object = !((Collection)it3).isEmpty() ? frequency : null;
            Multiset.Entry widths = object != null ? object.getMostEntry() : null;
            Object it4 = comparableArray = NodeExtKt.getChildrenHeights((Node)((Node)e));
            boolean $i$a$-takeIf-NavigationLocator$toReport$4$heights$22 = false;
            Object object2 = !((Collection)it4).isEmpty() ? comparableArray : null;
            Multiset.Entry heights = object2 != null ? object2.getMostEntry() : null;
            it4 = "%.0f / %d";
            Object[] $i$a$-takeIf-NavigationLocator$toReport$4$heights$22 = new Object[]{NodeExtKt.getSqrtArea((Node)((Node)e)), NodeExtKt.getChildrenAreas((Node)((Node)e)).size()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)it4, Arrays.copyOf($i$a$-takeIf-NavigationLocator$toReport$4$heights$22, $i$a$-takeIf-NavigationLocator$toReport$4$heights$22.length)), (String)"format(...)");
            comparableArray = new Comparable[]{Integer.valueOf(i + 1), name, Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getX((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getY((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getWidth((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getHeight((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)e))), Integer.valueOf(NodeExtKt.getNumAnchorImages((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumAnchors((Node)((Node)e))), "m" + widths + " / " + NodeExtKt.getChildrenWidths((Node)((Node)e)).size(), "m" + heights + " / " + NodeExtKt.getChildrenHeights((Node)((Node)e)).size(), sqrtArea2, component.getMemo(), component.getScore()};
            it4 = comparableArray;
            boolean bl3 = false;
            rs.addRow((Object[])Arrays.copyOf(it4, ((Comparable[])it4).length));
        }
        StringBuilder stringBuilder = sb.append('\n');
        SimpleResultSet simpleResultSet = rs;
        Intrinsics.checkNotNullExpressionValue((Object)simpleResultSet, (String)"element");
        stringBuilder.append(new ResultSetFormatter((ResultSet)simpleResultSet, false, false, 0, null, 30, null).toString());
        Collection collection = this.anchorGroups.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        SimpleResultSet rs2 = AnchorGroup.Companion.toResultSet((Iterable)collection);
        String string = sb.append('\n').append(new ResultSetFormatter((ResultSet)rs2, false, false, 0, null, 30, null).toString()).append(postfix).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

