/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.analysis.AutoMiner;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.AutoMiningTask;
import ai.platon.scent.analysis.DocumentLoader;
import ai.platon.scent.analysis.HarvestResultCache;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.view.CorpusVisualizer;
import ai.platon.scent.common.Systems;
import ai.platon.scent.common.message.ScentMiscMessageWriter;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.FullFeaturedDocumentKt;
import ai.platon.scent.dom.nodes.NavigateAnchor;
import ai.platon.scent.dom.nodes.NavigateDocument;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.entities.AnchorGroupInfo;
import ai.platon.scent.entities.HarvestResult;
import ai.platon.scent.entities.HarvestTableInfo;
import ai.platon.scent.entities.HarvestTaskStatus;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.segment.NavigationLocator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u0006\u0010\"\u001a\u00020#JI\u0010$\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u0019J.\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010\"\u001a\u00020#H\u0002J4\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020\u000e2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020:0>2\u0006\u00107\u001a\u00020\u001c2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020 0\u0016H\u0002J\u000e\u0010@\u001a\u00020A2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010B\u001a\u00020/2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00102\u001a\u0002032\u0006\u0010C\u001a\u00020AH\u0002J\u0016\u0010D\u001a\u00020,2\u0006\u0010E\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006F"}, d2={"Lai/platon/scent/analysis/AutoMiner;", "", "harvestResultCache", "Lai/platon/scent/analysis/HarvestResultCache;", "messageWriter", "Lai/platon/scent/common/message/ScentMiscMessageWriter;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/analysis/HarvestResultCache;Lai/platon/scent/common/message/ScentMiscMessageWriter;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getHarvestResultCache", "()Lai/platon/scent/analysis/HarvestResultCache;", "logger", "Lorg/slf4j/Logger;", "maxNumShow", "", "getMaxNumShow", "()I", "getMessageWriter", "()Lai/platon/scent/common/message/ScentMiscMessageWriter;", "minSamples", "getMinSamples", "arrangeDocuments", "", "Lai/platon/scent/dom/nodes/VisualDocument;", "task", "Lai/platon/scent/analysis/AutoMiningTask;", "arrangeLinks", "Ljava/util/SortedSet;", "Lai/platon/scent/dom/nodes/AnchorGroup;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "docs", "options", "Lai/platon/scent/dom/HarvestOptions;", "create", "portalPage", "Lai/platon/pulsar/persist/WebPage;", "anchorGroups", "itemOptions", "documentLoader", "Lai/platon/scent/analysis/DocumentLoader;", "harvestResult", "Lai/platon/scent/entities/HarvestResult;", "(Lai/platon/scent/dom/HNormUrl;Lai/platon/pulsar/persist/WebPage;Ljava/util/SortedSet;Lai/platon/scent/dom/HarvestOptions;Lai/platon/scent/analysis/DocumentLoader;Lai/platon/scent/entities/HarvestResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "diagnose", "", "result", "Lai/platon/scent/analysis/AutoMiningResult;", "start", "Ljava/time/Instant;", "draw", "loadAnchorGroupTo", "page", "anchorGroup", "destination", "", "", "logAnchorAnalysisRound", "round", "urls", "", "documents", "mine", "Lai/platon/scent/entities/PageTableGroup;", "reportTableGroup", "tableGroup", "updateTaskStatus", "miningTask", "scent-auto-mining"})
public final class AutoMiner {
    @NotNull
    private final HarvestResultCache harvestResultCache;
    @NotNull
    private final ScentMiscMessageWriter messageWriter;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    private final int maxNumShow;
    private final int minSamples;

    public AutoMiner(@NotNull HarvestResultCache harvestResultCache, @NotNull ScentMiscMessageWriter messageWriter, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)harvestResultCache, (String)"harvestResultCache");
        Intrinsics.checkNotNullParameter((Object)messageWriter, (String)"messageWriter");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.harvestResultCache = harvestResultCache;
        this.messageWriter = messageWriter;
        this.conf = conf;
        Logger logger = LoggerFactory.getLogger(AutoMiner.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        this.maxNumShow = 50;
        this.minSamples = 10;
    }

    @NotNull
    public final HarvestResultCache getHarvestResultCache() {
        return this.harvestResultCache;
    }

    @NotNull
    public final ScentMiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    public final int getMaxNumShow() {
        return this.maxNumShow;
    }

    public final int getMinSamples() {
        return this.minSamples;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object create(@NotNull HNormUrl var1_1, @NotNull WebPage var2_2, @NotNull SortedSet<AnchorGroup> var3_3, @NotNull HarvestOptions var4_4, @NotNull DocumentLoader var5_5, @NotNull HarvestResult var6_6, @NotNull Continuation<? super AutoMiningTask> var7_7) {
        if (!(var7_7 instanceof create.1)) ** GOTO lbl-1000
        var27_8 = var7_7;
        if ((var27_8.label & -2147483648) != 0) {
            var27_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var7_7){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ AutoMiner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.create(null, null, null, null, null, null, (Continuation<? super AutoMiningTask>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var28_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                startTime = Instant.now();
                portalOptions = portalUrl.getHOptions();
                var11_13 = false;
                documents = CollectionsKt.emptyList();
                topNAnchorGroups = portalUrl.getOptions().getTopNAnchorGroups();
                maxSize = 0;
                task = new Ref.ObjectRef();
                round = 0;
                elapsed = Duration.ofSeconds(0L);
                timeout = Duration.ofMinutes(2L);
                it = anchorGroups.iterator();
lbl23:
                // 3 sources

                while (it.hasNext()) {
                    var18_22 = round;
                    round = var18_22 + 1;
                    if (var18_22 >= topNAnchorGroups || maxSize >= this.getMinSamples() || elapsed.compareTo(timeout) >= 0) break block0;
                    if (round > 1) {
                        var18_23 = new Object[]{Boxing.boxInt((int)round), Boxing.boxInt((int)documents.size()), Boxing.boxInt((int)this.getMinSamples())};
                        this.logger.warn("In round #{} found {} samples but at least {} are required, trying the next group", var18_23);
                    }
                    anchorGroup = (AnchorGroup)it.next();
                    var20_28 = false;
                    urls = new LinkedHashSet<E>();
                    if (portalOptions.getLoadAnchorGroup()) {
                        Intrinsics.checkNotNullExpressionValue((Object)anchorGroup, (String)"anchorGroup");
                        this.loadAnchorGroupTo(portalPage, anchorGroup, urls, portalOptions);
                    }
                    SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)anchorGroup.getUrlStrings()), (int)portalOptions.getTopLinks()), (Collection)urls);
                    $continuation.L$0 = this;
                    $continuation.L$1 = portalUrl;
                    $continuation.L$2 = portalPage;
                    $continuation.L$3 = itemOptions;
                    $continuation.L$4 = documentLoader;
                    $continuation.L$5 = harvestResult;
                    $continuation.L$6 = startTime;
                    $continuation.L$7 = portalOptions;
                    $continuation.L$8 = task;
                    $continuation.L$9 = timeout;
                    $continuation.L$10 = it;
                    $continuation.L$11 = anchorGroup;
                    $continuation.L$12 = urls;
                    $continuation.I$0 = topNAnchorGroups;
                    $continuation.I$1 = maxSize;
                    $continuation.I$2 = round;
                    $continuation.label = 1;
                    v0 = documentLoader.loadAll(portalUrl, urls, itemOptions, (Continuation<? super ArrayList<FeaturedDocument>>)$continuation);
                    if (v0 == var28_10) {
                        return var28_10;
                    }
                    ** GOTO lbl79
                }
                break;
            }
            case 1: {
                round = $continuation.I$2;
                maxSize = $continuation.I$1;
                topNAnchorGroups = $continuation.I$0;
                urls = (Set)$continuation.L$12;
                anchorGroup = (AnchorGroup)$continuation.L$11;
                it = (Iterator<E>)$continuation.L$10;
                timeout = (Duration)$continuation.L$9;
                task = (Ref.ObjectRef)$continuation.L$8;
                portalOptions = (HarvestOptions)$continuation.L$7;
                startTime = (Instant)$continuation.L$6;
                harvestResult = (HarvestResult)$continuation.L$5;
                documentLoader = (DocumentLoader)$continuation.L$4;
                itemOptions = (HarvestOptions)$continuation.L$3;
                portalPage = (WebPage)$continuation.L$2;
                portalUrl = (HNormUrl)$continuation.L$1;
                this = (AutoMiner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl79:
                // 2 sources

                featuredDocuments = (ArrayList)v0;
                this.logger.info("Total {} featured documents, {} urls", (Object)Boxing.boxInt((int)featuredDocuments.size()), (Object)Boxing.boxInt((int)urls.size()));
                task0 = new AutoMiningTask(portalUrl, portalPage, featuredDocuments, itemOptions);
                Intrinsics.checkNotNullExpressionValue((Object)anchorGroup, (String)"anchorGroup");
                task0.setAnchorGroup(anchorGroup);
                documents = this.arrangeDocuments(task0);
                if (documents.size() > maxSize) {
                    maxSize = documents.size();
                    task.element = task0;
                }
                Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
                elapsed = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)startTime, null, (int)2, null);
                if (!this.logger.isInfoEnabled()) ** GOTO lbl23
                this.logAnchorAnalysisRound(round, urls, anchorGroup, featuredDocuments);
                ** GOTO lbl23
            }
        }
        if (elapsed.compareTo(timeout) >= 0) {
            this.logger.warn("Harvest task takes long time({}) | {}", (Object)elapsed, (Object)portalUrl);
        }
        if (task.element != null) {
            block14: {
                anchorGroup = harvestResult.getStatus().getAnchorGroups();
                var24_30 = harvestResult.getStatus();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (AnchorGroupInfo)element$iv;
                    $i$a$-firstOrNull-AutoMiner$create$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getAnchorGroupPath(), (Object)((AutoMiningTask)task.element).getAnchorGroup().getPath())) continue;
                    v1 = element$iv;
                    break block14;
                }
                v1 = null;
            }
            var25_33 = v1;
            var24_30.setAnchorGroup((AnchorGroupInfo)var25_33);
        }
        return task.element;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<AnchorGroup> arrangeLinks(@NotNull HNormUrl portalUrl, @NotNull FeaturedDocument doc) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        HarvestOptions options = portalUrl.getHOptions();
        HarvestResult harvestResult = this.harvestResultCache.computeIfAbsent((NormUrl)portalUrl);
        CharSequence charSequence = options.getOutLinkSelector();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            void $this$mapTo$iv$iv;
            String restrictCss = QueriesKt.appendSelectorIfMissing((String)options.getOutLinkSelector(), (String)"a");
            Object[] $this$map$iv = (Object[])FeaturedDocument.select$default((FeaturedDocument)doc, (String)restrictCss, (int)0, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Element element = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                NavigateAnchor navigateAnchor = new NavigateAnchor((Element)it, null, options.getIgnoreUrlQuery(), 2, null);
                collection.add(navigateAnchor);
            }
            List anchors = (List)destination$iv$iv;
            $this$map$iv = new AnchorGroup[]{new AnchorGroup(options.getOutLinkSelector(), anchors, null, null, 12, null)};
            return SetsKt.sortedSetOf((Object[])$this$map$iv);
        }
        NavigationLocator locator = new NavigationLocator(options);
        locator.locate(doc);
        Iterable $this$map$iv = locator.getAnchorGroups().values();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"locator.anchorGroups.values()");
        SortedSet anchorGroups = CollectionsKt.toSortedSet((Iterable)$this$map$iv, (Comparator)ComparisonsKt.reverseOrder());
        $this$map$iv = anchorGroups;
        Collection destination$iv = harvestResult.getStatus().getAnchorGroups();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            AnchorGroup anchorGroup = (AnchorGroup)item$iv;
            Collection collection = destination$iv;
            boolean bl3 = false;
            AnchorGroupInfo anchorGroupInfo = new AnchorGroupInfo(options.getOutLinkSelector(), it.getPath(), it.getSize());
            collection.add(anchorGroupInfo);
        }
        Object[] objectArray = (Object[])anchorGroups;
        boolean bl4 = false;
        if (!objectArray.isEmpty()) {
            objectArray = new Object[]{anchorGroups.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.info("Found {} anchor groups in page {} | file://{}", objectArray);
        } else {
            this.logger.warn("\n!!! No navigate url is found in document {} | file://{} !!!\n", (Object)doc.getLocation(), (Object)NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal());
        }
        return anchorGroups;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<AnchorGroup> arrangeLinks(@NotNull List<? extends FeaturedDocument> docs, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (docs.isEmpty()) {
            return SetsKt.sortedSetOf((Object[])new AnchorGroup[0]);
        }
        CharSequence charSequence = options.getOutLinkSelector();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            Iterable list$iv$iv;
            FeaturedDocument it;
            void $this$flatMapTo$iv$iv;
            String restrictCss = QueriesKt.appendSelectorIfMissing((String)options.getOutLinkSelector(), (String)"a");
            Iterable $this$flatMap$iv = docs;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FeaturedDocument)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = (Iterable)FeaturedDocument.select$default((FeaturedDocument)it, (String)restrictCss, (int)0, (int)0, (int)6, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                NavigateAnchor navigateAnchor = new NavigateAnchor((Element)it, null, options.getIgnoreUrlQuery(), 2, null);
                collection.add(navigateAnchor);
            }
            List anchors = (List)destination$iv$iv;
            $this$map$iv = new AnchorGroup[]{new AnchorGroup(options.getOutLinkSelector(), anchors, null, null, 12, null)};
            return SetsKt.sortedSetOf((Object[])$this$map$iv);
        }
        NavigationLocator locator = new NavigationLocator(options);
        locator.locate(docs);
        Collection $this$map$iv = locator.getAnchorGroups().values();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"locator.anchorGroups.values()");
        SortedSet anchorGroups = CollectionsKt.toSortedSet((Iterable)$this$map$iv, (Comparator)ComparisonsKt.reverseOrder());
        FeaturedDocument doc = (FeaturedDocument)CollectionsKt.first(docs);
        Object[] objectArray = (Object[])anchorGroups;
        boolean bl4 = false;
        if (!objectArray.isEmpty()) {
            objectArray = new Object[]{anchorGroups.size(), docs.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.info("Find {} anchor groups in {} pages, portal {} | file://{}", objectArray);
        } else {
            objectArray = new Object[]{docs.size(), doc.getLocation(), NodeExtKt.getExportPaths((Document)doc.getDocument()).getPortal()};
            this.logger.warn("\n!!! No navigate url is found in {} pages, portal {} | file://{} !!!\n", objectArray);
        }
        return anchorGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<VisualDocument> arrangeDocuments(@NotNull AutoMiningTask task) {
        VisualDocument visualDocument;
        Collection collection;
        void $this$mapTo$iv;
        NavigateDocument $this$arrangeDocuments_u24lambda_u2d6_u24lambda_u2d5;
        NavigateDocument navigateDocument;
        Object it;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Iterable<FeaturedDocument> $this$forEach$iv = task.getDocuments();
        boolean $i$f$forEach22 = false;
        for (FeaturedDocument element$iv : $this$forEach$iv) {
            it = element$iv;
            boolean bl = false;
            navigateDocument = new NavigateDocument((FeaturedDocument)it);
            boolean bl2 = false;
            boolean bl3 = false;
            $this$arrangeDocuments_u24lambda_u2d6_u24lambda_u2d5 = navigateDocument;
            boolean bl4 = false;
            $this$arrangeDocuments_u24lambda_u2d6_u24lambda_u2d5.partition(task.getItemOptions());
        }
        Iterable<FeaturedDocument> $i$f$forEach22 = task.getDocuments();
        Collection destination$iv = new ArrayList(task.getNumSamples());
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            navigateDocument = (FeaturedDocument)item$iv;
            collection = destination$iv;
            boolean bl = false;
            visualDocument = new VisualDocument((FeaturedDocument)it2, task.getItemOptions());
            collection.add(visualDocument);
        }
        ArrayList samples = (ArrayList)destination$iv;
        AnalysablePageCorpus corpus = new AnalysablePageCorpus(task.getPortalUrl(), samples, this.conf);
        try {
            this.logger.info(Systems.INSTANCE.getHeapMessage());
            corpus.arrangeDocuments();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            $i$f$mapTo2 = false;
            List $i$f$mapTo2 = CollectionsKt.emptyList();
            return $i$f$mapTo2;
        }
        finally {
            this.logger.info(Systems.INSTANCE.getHeapMessage());
        }
        task.setCorpus$scent_auto_mining(corpus);
        if (this.logger.isDebugEnabled()) {
            void $this$forEachIndexed$iv;
            FeaturedDocument it3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = corpus.getDocuments$scent_auto_mining();
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $this$arrangeDocuments_u24lambda_u2d6_u24lambda_u2d5 = (VisualDocument)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                visualDocument = it3.getFeaturedDocument();
                collection.add(visualDocument);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void document;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                it3 = (FeaturedDocument)item$iv;
                int i = n;
                boolean bl5 = false;
                FullFeaturedDocumentKt.annotateNodes((FeaturedDocument)document, (HarvestOptions)task.getItemOptions());
                AppFiles.INSTANCE.saveTo(document.getPrettyHtml(), NodeExtKt.getExportPaths((Document)document.getDocument()).getAnnotatedView(), true);
            }
        }
        return corpus.getDocuments$scent_auto_mining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final PageTableGroup mine(@NotNull AutoMiningTask task) {
        PageTableGroup pageTableGroup;
        AutoCloseable autoCloseable;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Instant start = Instant.now();
        if (task.getCorpus$scent_auto_mining() == null) {
            this.arrangeDocuments(task);
        }
        if ((autoCloseable = task.getCorpus$scent_auto_mining()) == null) {
            return PageTableGroup.Companion.getEMPTY();
        }
        AnalysablePageCorpus corpus = autoCloseable;
        autoCloseable = corpus;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AutoCloseable it = autoCloseable;
            boolean bl3 = false;
            AutoMiningResult result = ((AnalysablePageCorpus)it).analysis();
            Intrinsics.checkNotNullExpressionValue((Object)start, (String)"start");
            this.diagnose(task, result, start);
            pageTableGroup = result.getTableGroup();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return pageTableGroup;
    }

    private final void diagnose(AutoMiningTask task, AutoMiningResult result, Instant start) {
        boolean diagnose2 = task.getPortalUrl().getHOptions().getDiagnose();
        if (diagnose2 || this.logger.isInfoEnabled()) {
            this.reportTableGroup(task, start, result.getTableGroup());
        }
        if (task.getPortalUrl().getHOptions().getDraw()) {
            task.setDrawTiles(true);
            task.setDrawLeafElements(true);
            task.setDrawComponents(true);
            this.draw(task);
        }
    }

    public final void draw(@NotNull AutoMiningTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        AutoMiningResult autoMiningResult = task.getMiningResult();
        if (autoMiningResult == null) {
            return;
        }
        AutoMiningResult result = autoMiningResult;
        new CorpusVisualizer(result, task.getDrawTiles(), task.getDrawLeafElements(), task.getDrawComponents()).draw();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HarvestResult updateTaskStatus(@NotNull AutoMiningTask miningTask, @NotNull HarvestResult harvestResult) {
        double d;
        List<VisualDocument> list;
        int n;
        Intrinsics.checkNotNullParameter((Object)miningTask, (String)"miningTask");
        Intrinsics.checkNotNullParameter((Object)harvestResult, (String)"harvestResult");
        AutoMiningResult autoMiningResult = miningTask.getMiningResult();
        if (autoMiningResult == null) {
            return harvestResult;
        }
        AutoMiningResult miningResult = autoMiningResult;
        PageTableGroup tableGroup = miningResult.getTableGroup();
        HarvestTaskStatus taskStatus = harvestResult.getStatus();
        String configuredUrl = miningTask.getConfiguredUrl();
        taskStatus.setNSuccessPages(miningTask.getNumSamples());
        taskStatus.setNFailedPages(miningTask.getAnchorGroup().getSize() - miningTask.getNumSamples());
        taskStatus.setNTables(tableGroup.getSize());
        Object object = tableGroup.getTables();
        HarvestTaskStatus harvestTaskStatus = taskStatus;
        boolean bl = false;
        int n2 = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            OpenMapTable openMapTable = (OpenMapTable)t;
            n = n2;
            boolean bl2 = false;
            int n3 = it.getNumColumns();
            n2 = n + n3;
        }
        n = n2;
        harvestTaskStatus.setNFields(n);
        object = miningTask.getCorpus$scent_auto_mining();
        taskStatus.setNRecoverableDocuments(object == null ? 0 : ((list = ((AnalysablePageCorpus)object).getDocuments$scent_auto_mining()) == null ? 0 : (n2 = list.size())));
        object = miningTask.getCorpus$scent_auto_mining();
        taskStatus.setRecoverableConfidence(object == null ? 0.0 : (d = ((AnalysablePageCorpus)object).getRecoverableConfidence$scent_auto_mining()));
        Iterable $this$forEach$iv = tableGroup.getTables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OpenMapTable table = (OpenMapTable)element$iv;
            boolean bl3 = false;
            TableData data = PageTableKt.getData((OpenMapTable)table);
            HarvestTableInfo tableInfo = new HarvestTableInfo(configuredUrl, 0, 0, data.getName(), null, table.getNumRows(), table.getNumColumns(), data.getDataTypeStatistics(), data.getClusterTaskStatus(), data.getClusterGroupMetrics(), 22, null);
            taskStatus.getTableInfos().add(tableInfo);
        }
        return harvestResult;
    }

    private final void reportTableGroup(AutoMiningTask task, Instant start, PageTableGroup tableGroup) {
        AnalysablePageCorpus analysablePageCorpus = task.getCorpus$scent_auto_mining();
        if (analysablePageCorpus == null) {
            return;
        }
        AnalysablePageCorpus corpus = analysablePageCorpus;
        Duration elapsed = Duration.between(start, Instant.now());
        int numNature = corpus.getNaturalComponents$scent_auto_mining().size();
        this.logger.info("Total " + elapsed + " to analyze " + task.getNumSamples() + " documents, found " + numNature + " natural components, generated " + tableGroup.getSize() + " tables");
        if (tableGroup.isNotEmpty()) {
            String s2 = CollectionsKt.joinToString$default((Iterable)tableGroup.getTables(), (CharSequence)", ", null, null, (int)0, null, (Function1)reportTableGroup.s.1.INSTANCE, (int)30, null);
            this.logger.info("Table dimensions (row x col): " + s2);
        } else {
            this.logger.warn("!!! No table generated !!!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logAnchorAnalysisRound(int round, Set<String> urls, AnchorGroup anchorGroup, List<? extends FeaturedDocument> documents) {
        int n = this.maxNumShow;
        int n2 = documents.size();
        boolean bl = false;
        int numShow = Math.min(n, n2);
        String s2 = "Round #" + round + " find " + documents.size() + "/" + urls.size() + "/" + anchorGroup.getSize() + " documents/urls/anchors in group #" + anchorGroup.getId() + "[" + anchorGroup.getPath() + "] with score <" + anchorGroup.getScore() + ">";
        if (this.logger.isDebugEnabled()) {
            void $this$mapIndexedTo$iv$iv;
            StringBuilder sb = new StringBuilder(s2);
            sb.append(":\n");
            Iterable $this$mapIndexed$iv = CollectionsKt.take((Iterable)documents, (int)numShow);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                String string;
                void doc;
                void j;
                int n3 = index$iv$iv++;
                boolean bl2 = false;
                if (n3 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FeaturedDocument featuredDocument = (FeaturedDocument)item$iv$iv;
                int n4 = n3;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "%d.\t%s [%s]\t->\t file://%s";
                Object[] objectArray = new Object[]{(int)(j + true), StringUtils.abbreviateMiddle((String)doc.getLocation(), (String)"...", (int)100), Strings.readableBytes((long)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getContentBytes((Document)doc.getDocument())), NodeExtKt.getExportPaths((Document)doc.getDocument()).getAnnotatedView()};
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                collection.add(string);
            }
            CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)sb, (CharSequence)"\n", null, null, (int)0, null, (Function1)logAnchorAnalysisRound.2.INSTANCE, (int)60, null);
            this.logger.debug(sb.toString());
        } else {
            this.logger.info(s2);
        }
    }

    private final void loadAnchorGroupTo(WebPage page, AnchorGroup anchorGroup, Set<String> destination, HarvestOptions options) {
        String ident = "gn:" + anchorGroup.getId();
        Map map = page.getVividLinks();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"page.vividLinks");
        SequencesKt.toCollection((Sequence)SequencesKt.take((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence((Map)map), (Function1)((Function1)new Function1<Map.Entry<? extends CharSequence, ? extends CharSequence>, String>(ident){
            final /* synthetic */ String $ident;
            {
                this.$ident = $ident;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull Map.Entry<? extends CharSequence, ? extends CharSequence> it) {
                Map.Entry<? extends CharSequence, ? extends CharSequence> entry;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object object = it;
                String string = this.$ident;
                boolean bl = false;
                boolean bl2 = false;
                Map.Entry<? extends CharSequence, ? extends CharSequence> it2 = object;
                boolean bl3 = false;
                CharSequence charSequence = it2.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"it.value");
                Map.Entry<? extends CharSequence, ? extends CharSequence> entry2 = entry = StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) ? object : null;
                return entry == null ? null : ((object = entry.getKey()) == null ? null : object.toString());
            }
        })), (int)options.getMaxLoadedAnchors()), (Collection)destination);
    }
}

