/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.NormUrl;
import ai.platon.scent.common.Auth;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.entities.HarvestResult;
import ai.platon.scent.entities.HarvestTaskStatus;
import ai.platon.scent.entities.PageTableGroup;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\bH\u0086\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/platon/scent/analysis/HarvestResultCache;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "activeTaskStatus", "Ljava/util/TreeMap;", "", "Lai/platon/scent/entities/HarvestResult;", "computeIfAbsent", "normUrl", "Lai/platon/pulsar/common/urls/NormUrl;", "configuredUrl", "mappingFunction", "Lkotlin/Function1;", "computeIfAbsentOrExpired", "findByUUID", "uuid", "get", "getIfActive", "Lai/platon/scent/dom/HNormUrl;", "remove", "set", "", "task", "scent-auto-mining"})
public final class HarvestResultCache {
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final TreeMap<String, HarvestResult> activeTaskStatus;

    public HarvestResultCache(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.activeTaskStatus = new TreeMap();
    }

    @Nullable
    public final synchronized HarvestResult get(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.get(configuredUrl);
    }

    @Nullable
    public final synchronized HarvestResult findByUUID(@NotNull String uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Collection<HarvestResult> collection = this.activeTaskStatus.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"activeTaskStatus.values");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HarvestResult it = (HarvestResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStatus().getUuid(), (Object)uuid)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final synchronized HarvestResult getIfActive(@NotNull HNormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        String configuredUrl = normUrl.getConfiguredUrl();
        HarvestResult result = this.activeTaskStatus.get(configuredUrl);
        if (result != null) {
            HarvestTaskStatus harvestTaskStatus = result.getStatus();
            Duration duration = normUrl.getOptions().getExpires();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"normUrl.options.expires");
            if (harvestTaskStatus.isExpired(duration)) {
                this.remove(configuredUrl);
                return null;
            }
        }
        return result;
    }

    public final synchronized void set(@NotNull String configuredUrl, @NotNull HarvestResult task) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Map map = this.activeTaskStatus;
        boolean bl = false;
        map.put(configuredUrl, task);
    }

    @Nullable
    public final synchronized HarvestResult remove(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.remove(configuredUrl);
    }

    @NotNull
    public final synchronized HarvestResult computeIfAbsentOrExpired(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        String configuredUrl = normUrl.getConfiguredUrl();
        HarvestResult status = this.activeTaskStatus.get(configuredUrl);
        if (status != null) {
            HarvestTaskStatus harvestTaskStatus = status.getStatus();
            Duration duration = normUrl.getOptions().getExpires();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"normUrl.options.expires");
            if (harvestTaskStatus.isExpired(duration)) {
                this.activeTaskStatus.remove(configuredUrl);
            }
        }
        return this.computeIfAbsent(normUrl.getConfiguredUrl());
    }

    @NotNull
    public final synchronized HarvestResult computeIfAbsent(@NotNull NormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        return this.computeIfAbsent(normUrl.getConfiguredUrl());
    }

    @NotNull
    public final synchronized HarvestResult computeIfAbsent(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        HarvestResult harvestResult = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestResultCache.computeIfAbsent$lambda-1(configuredUrl, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestResult, (String)"activeTaskStatus.compute\u2026bleGroup.EMPTY)\n        }");
        return harvestResult;
    }

    @NotNull
    public final synchronized HarvestResult computeIfAbsent(@NotNull String configuredUrl, @NotNull Function1<? super String, HarvestResult> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Function1<? super String, HarvestResult> function1 = mappingFunction;
        HarvestResult harvestResult = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestResultCache.computeIfAbsent$lambda-2(function1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestResult, (String)"activeTaskStatus.compute\u2026uredUrl, mappingFunction)");
        return harvestResult;
    }

    private static final HarvestResult computeIfAbsent$lambda-1(String $configuredUrl, String it) {
        Intrinsics.checkNotNullParameter((Object)$configuredUrl, (String)"$configuredUrl");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HarvestResult(new HarvestTaskStatus(Auth.INSTANCE.getSYSTEM_AUTH(), $configuredUrl, 0, null, null, 0, 0, 0, 0, 0, 0.0, 0, 0, null, null, 32764, null), PageTableGroup.Companion.getEMPTY());
    }

    private static final HarvestResult computeIfAbsent$lambda-2(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (HarvestResult)$tmp0.invoke((Object)p0);
    }
}

