/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.ScoreVector;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.PageCorpusTabulator;
import ai.platon.scent.common.options.CellType;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.HyperPath;
import ai.platon.scent.dom.nodes.HyperPathBuilder;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.entities.ClusterTaskStatus;
import ai.platon.scent.entities.ColumnData;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.NodeClusterGroupMetrics;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.RowData;
import ai.platon.scent.entities.TableData;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.base.Strings;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J \u0010*\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J,\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\f2\b\b\u0002\u00102\u001a\u00020\u00072\b\b\u0002\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0002J\u001a\u00106\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u000209H\u0002J\u001a\u0010:\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u000209H\u0002J\u001a\u0010;\u001a\u00020\f2\b\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010=\u001a\u00020#J\b\u0010>\u001a\u00020\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lai/platon/scent/analysis/corpus/PageCorpusTabulator;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "clusterGroup", "Lai/platon/scent/ml/unsupervised/TileClusterGroup;", "groupIndex", "", "cellType", "Lai/platon/scent/common/options/CellType;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Lai/platon/scent/ml/unsupervised/TileClusterGroup;ILai/platon/scent/common/options/CellType;)V", "command", "", "documentSize", "options", "Lai/platon/scent/dom/HarvestOptions;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "qualifiedClusters", "", "Lai/platon/scent/ml/unsupervised/TileCluster;", "getQualifiedClusters", "()Ljava/util/List;", "qualifiedClusters$delegate", "Lkotlin/Lazy;", "qualifiedRate", "", "qualifiedSize", "buildColumnAttributes", "", "cluster", "column", "Lai/platon/pulsar/common/OpenMapTable$Column;", "buildDatabaseRows", "table", "Lai/platon/pulsar/common/OpenMapTable;", "buildHtmlRows", "buildNodeRows", "buildPlainTextRows", "buildRows", "buildTitleColumnAttributes", "computeQualifiedClusters", "createXSQL", "url", "restrictPath", "Lai/platon/scent/dom/nodes/HyperPath;", "fillSpecialCells", "getDocTitle", "location", "title", "displayLength", "textOnly", "", "getReadableLink", "getRichText", "lastValue", "node", "Lorg/jsoup/nodes/Node;", "getSlimHtml", "getText", "initRows", "tabulate", "validateClusterOrder", "Companion", "scent-auto-mining"})
public final class PageCorpusTabulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final TileClusterGroup clusterGroup;
    private final int groupIndex;
    @NotNull
    private final CellType cellType;
    @NotNull
    private final HNormUrl portalUrl;
    @NotNull
    private final HarvestOptions options;
    @NotNull
    private final String command;
    private final int documentSize;
    private final double qualifiedRate;
    private final double qualifiedSize;
    @NotNull
    private final Lazy qualifiedClusters$delegate;
    @NotNull
    private static final Logger logger = LogsKt.getLogger((Object)Companion);

    public PageCorpusTabulator(@NotNull AnalysablePageCorpus corpus, @NotNull TileClusterGroup clusterGroup, int groupIndex, @NotNull CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter((Object)clusterGroup, (String)"clusterGroup");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.corpus = corpus;
        this.clusterGroup = clusterGroup;
        this.groupIndex = groupIndex;
        this.cellType = cellType;
        this.portalUrl = this.corpus.getPortalUrl();
        this.options = this.corpus.getOptions();
        this.command = this.portalUrl + " " + this.options.getArgs();
        this.documentSize = this.corpus.getDocuments$scent_auto_mining().size();
        this.qualifiedRate = 0.5;
        double d = this.qualifiedRate * (double)this.documentSize;
        double d2 = 2.0;
        boolean bl = false;
        this.qualifiedSize = Math.max(d, d2);
        this.qualifiedClusters$delegate = LangKt.usfLazy((Function0)((Function0)new Function0<List<? extends TileCluster>>(this){
            final /* synthetic */ PageCorpusTabulator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<TileCluster> invoke() {
                return PageCorpusTabulator.access$computeQualifiedClusters(this.this$0);
            }
        }));
    }

    public /* synthetic */ PageCorpusTabulator(AnalysablePageCorpus analysablePageCorpus, TileClusterGroup tileClusterGroup, int n, CellType cellType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            cellType = CellType.SLIM_HTML;
        }
        this(analysablePageCorpus, tileClusterGroup, n, cellType);
    }

    private final List<TileCluster> getQualifiedClusters() {
        Lazy lazy = this.qualifiedClusters$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OpenMapTable tabulate() {
        List list;
        String $this$flatMapTo$iv$iv;
        Object v0;
        boolean $i$f$firstOrNull;
        Element sampleComponent;
        List recognizedComponents;
        OpenMapTable table;
        ScoreVector score2;
        block11: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Element it;
            if (this.corpus.getDocuments$scent_auto_mining().isEmpty() || this.clusterGroup.isEmpty() || this.clusterGroup.isConstant()) {
                return new OpenMapTable(0, 0, 2, null);
            }
            int numColumns = 1 + this.getQualifiedClusters().size() + 1;
            score2 = this.clusterGroup.getScore();
            table = new OpenMapTable(numColumns, this.groupIndex);
            if (this.getQualifiedClusters().isEmpty()) {
                return table;
            }
            if (logger.isDebugEnabled()) {
                this.validateClusterOrder();
            }
            Iterable $this$distinctBy$iv = this.corpus.getComponentElements$scent_auto_mining();
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                it = (Element)e$iv;
                boolean bl = false;
                String key$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)it)).getSelector2();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Element bl = (Element)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)it2)).getSelector2(), (Object)NodeExtKt.getUniqueName((Node)((Node)it2)));
                collection.add(pair);
            }
            recognizedComponents = (List)destination$iv$iv;
            sampleComponent = (Element)CollectionsKt.first(((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getComponents());
            Iterable $this$firstOrNull$iv = ((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getComponents();
            $i$f$firstOrNull = false;
            for (Object element$iv22 : $this$firstOrNull$iv) {
                it = (Element)element$iv22;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)NodeExtKt.getOwnerDocument((Node)((Node)it)).title(), (Object)NodeExtKt.getOwnerDocument((Node)((Node)sampleComponent)).title()))) continue;
                v0 = element$iv22;
                break block11;
            }
            v0 = null;
        }
        Element sampleComponent2 = v0;
        String titleSuffix = "";
        if (sampleComponent2 != null) {
            Object element$iv22;
            $i$f$firstOrNull = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)sampleComponent)) != ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)sampleComponent2));
            boolean $i$f$mapTo22 = false;
            boolean element$iv22 = false;
            element$iv22 = false;
            boolean it3 = false;
            if (!$i$f$firstOrNull) {
                boolean bl = false;
                String it3 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(it3.toString());
            }
            Document document = sampleComponent.ownerDocument();
            Intrinsics.checkNotNull((Object)document);
            String $i$f$mapTo22 = document.title();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapTo22, (String)"sampleComponent.ownerDocument()!!.title()");
            Object t1 = $i$f$mapTo22;
            Document document2 = sampleComponent2.ownerDocument();
            Intrinsics.checkNotNull((Object)document2);
            element$iv22 = document2.title();
            Intrinsics.checkNotNullExpressionValue(element$iv22, (String)"sampleComponent2.ownerDocument()!!.title()");
            Object t2 = element$iv22;
            element$iv22 = Strings.commonSuffix((CharSequence)((CharSequence)t1), (CharSequence)((CharSequence)t2));
            Intrinsics.checkNotNullExpressionValue(element$iv22, (String)"commonSuffix(t1, t2)");
            it3 = false;
            titleSuffix = ((Object)StringsKt.trim((CharSequence)((CharSequence)element$iv22))).toString();
        }
        Object $this$flatMap$iv = this.getQualifiedClusters();
        int $i$f$flatMap = 0;
        Iterable it3 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            TileCluster it = (TileCluster)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        List list2 = list = (List)destination$iv$iv;
        HyperPath hyperPath2 = new HyperPathBuilder(list2).build();
        $this$flatMap$iv = hyperPath2.getPath();
        $i$f$flatMap = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedTop((Node)((Node)sampleComponent));
        $this$flatMapTo$iv$iv = NodeExtKt.getName((Node)((Node)sampleComponent));
        int n = this.documentSize;
        String $i$f$flatMapTo22 = score2.toString();
        int n2 = this.clusterGroup.getClusters().size();
        int n3 = this.getQualifiedClusters().size();
        double list$iv$iv2 = this.clusterGroup.getDistortion();
        String string = titleSuffix;
        DataTypeStatistics dataTypeStatistics = this.clusterGroup.getDataTypeStatistics();
        ClusterTaskStatus clusterTaskStatus = this.clusterGroup.getClusterTaskStatus();
        NodeClusterGroupMetrics nodeClusterGroupMetrics = this.clusterGroup.getMetrics();
        double d = this.clusterGroup.getMicroP();
        double d2 = this.clusterGroup.getMicroR();
        double d3 = this.clusterGroup.getMicroF1();
        double d4 = this.clusterGroup.getMacroP();
        double d5 = this.clusterGroup.getMacroR();
        double d6 = this.clusterGroup.getMacroF1();
        int n4 = this.clusterGroup.getNumFineFields();
        double d7 = this.clusterGroup.getFineFieldRate();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$flatMapTo22, (String)"toString()");
        PageTableKt.setData((OpenMapTable)table, (TableData)new TableData(false, (String)$this$flatMap$iv, null, $i$f$flatMap, $this$flatMapTo$iv$iv, n, null, $i$f$flatMapTo22, n2, n3, string, list$iv$iv2, dataTypeStatistics, clusterTaskStatus, nodeClusterGroupMetrics, d, d2, d3, d4, d5, d6, n4, d7, null, 8388677, null));
        PageTableKt.getData((OpenMapTable)table).getUrls().addAll((Collection)this.corpus.getDocumentUrls$scent_auto_mining());
        PageTableKt.getData((OpenMapTable)table).getRecognizedComponents().addAll(recognizedComponents);
        this.buildTitleColumnAttributes(table.getColumns()[0]);
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            n2 = index$iv++;
            n3 = 0;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster list$iv$iv2 = (TileCluster)item$iv;
            int k = n2;
            boolean bl = false;
            int j = k + 1;
            this.buildColumnAttributes((TileCluster)cluster2, table.getColumns()[j]);
        }
        String string2 = (String)CollectionsKt.firstOrNull((Iterable)this.corpus.getDocumentUrls$scent_auto_mining());
        String sampleUrl = string2 == null ? "http://example.com" : string2;
        PageTableKt.getData((OpenMapTable)table).setXsql(this.createXSQL(table, sampleUrl, hyperPath2));
        this.initRows(table);
        this.buildRows(table);
        this.fillSpecialCells(table);
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private final String createXSQL(OpenMapTable table, String url, HyperPath restrictPath) {
        void $this$filterTo$iv$iv;
        StringBuilder sb;
        StringBuilder stringBuilder = sb = new StringBuilder();
        String string = "select ";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        boolean i = false;
        OpenMapTable.Column[] $this$filter$iv = table.getColumns();
        boolean $i$f$filter = false;
        OpenMapTable.Column[] columnArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var12_18 = $this$filterTo$iv$iv;
        int n = ((void)var12_18).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var12_18[j];
            boolean bl3 = false;
            CharSequence charSequence = PageTableKt.getData((OpenMapTable.Column)it).getHyperPath();
            boolean bl4 = false;
            boolean bl5 = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List columns = (List)destination$iv$iv;
        SequencesKt.joinTo$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])table.getColumns()), (Function1)createXSQL.1.INSTANCE), (Function1)createXSQL.2.INSTANCE), (Appendable)sb, (CharSequence)",\n", null, null, (int)0, null, (Function1)createXSQL.3.INSTANCE, (int)60, null);
        CharSequence charSequence = sb;
        String string2 = "\nfrom load_and_select('" + url + "', '" + restrictPath + "');";
        boolean bl6 = false;
        StringBuilder stringBuilder4 = charSequence.append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringBuilder stringBuilder5 = stringBuilder4;
        boolean bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillSpecialCells(OpenMapTable table) {
        ((OpenMapTable.Column)ArraysKt.first((Object[])table.getColumns())).setName("Title");
        ((OpenMapTable.Column)ArraysKt.last((Object[])table.getColumns())).setName("Url");
        String titleSuffix = PageTableKt.getData((OpenMapTable)table).getTitleSuffix();
        boolean textOnly = this.cellType == CellType.PLAIN_TEXT;
        Iterable $this$forEach$iv = table.getRows();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String string2;
            void it;
            OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
            boolean bl = false;
            String string3 = PageTableKt.getData((OpenMapTable.Row)row).getTitle();
            boolean bl2 = false;
            boolean bl3 = false;
            String string4 = string3;
            RowData rowData = PageTableKt.getData((OpenMapTable.Row)row);
            boolean bl4 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl5 = false;
            boolean bl6 = !StringsKt.isBlank((CharSequence)charSequence);
            RowData rowData2 = rowData;
            String string5 = string2 = bl6 ? string3 : null;
            if (string2 == null) {
                string = "Link";
            } else {
                string3 = StringsKt.removeSuffix((String)string2, (CharSequence)titleSuffix);
                if (string3 == null) {
                    string = "Link";
                } else {
                    void it2;
                    String string6 = string3;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    charSequence = string6;
                    rowData = rowData2;
                    boolean bl9 = false;
                    CharSequence charSequence2 = (CharSequence)it2;
                    boolean bl10 = false;
                    bl6 = !StringsKt.isBlank((CharSequence)charSequence2);
                    rowData2 = rowData;
                    String string7 = bl6 ? string6 : null;
                    string = string7 == null ? "Link" : string7;
                }
            }
            rowData2.setTitle(string);
            row.setValue(0, (Object)PageCorpusTabulator.getDocTitle$default(this, PageTableKt.getData((OpenMapTable.Row)row).getLocation(), PageTableKt.getData((OpenMapTable.Row)row).getTitle(), 0, textOnly, 4, null));
            string2 = this.cellType;
            int n = WhenMappings.$EnumSwitchMapping$0[string2.ordinal()];
            switch (n) {
                case 1: {
                    row.setValue(table.getNumColumns() - 1, (Object)this.getReadableLink(PageTableKt.getData((OpenMapTable.Row)row).getLocation()));
                    break;
                }
                case 2: {
                    row.setValue(table.getNumColumns() - 1, (Object)PageTableKt.getData((OpenMapTable.Row)row).getLocation());
                    break;
                }
                default: {
                    row.setValue(table.getNumColumns() - 1, (Object)("<a href='" + PageTableKt.getData((OpenMapTable.Row)row).getLocation() + "' target='_blank' class='-hidden'>detail&gt;</a>"));
                }
            }
        }
    }

    private final void validateClusterOrder() {
        for (Pair pair : CollectionsKt.zipWithNext((Iterable)this.getQualifiedClusters())) {
            double o2;
            Node n1 = ((NodePoint)((Object)CollectionsKt.first(((TileCluster)pair.getFirst()).getPoints()))).getNode();
            Node n2 = ((NodePoint)((Object)CollectionsKt.first(((TileCluster)pair.getSecond()).getPoints()))).getNode();
            double o1 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)n1);
            if (!(o1 > (o2 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)n2)))) continue;
            logger.warn("Unexpected cluster order");
            logger.warn(NodeExtKt.getUniqueName((Node)n1) + " (" + o1 + ")\t\t" + NodeExtKt.getUniqueName((Node)n2) + " (" + o2 + ")");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%10d%10d%10d%10d";
            Object[] objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedCenterY((Node)n1), NodeExtKt.getX((Node)n1), NodeExtKt.getWidth((Node)n1), NodeExtKt.getHeight((Node)n1)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            logger.warn(string2);
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string = "%10d%10d%10d%10d";
            objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedCenterY((Node)n2), NodeExtKt.getX((Node)n2), NodeExtKt.getWidth((Node)n2), NodeExtKt.getHeight((Node)n2)};
            bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            logger.warn(string3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTitleColumnAttributes(OpenMapTable.Column column) {
        Iterable iterable = ((TileCluster)CollectionsKt.first(this.getQualifiedClusters())).getPoints();
        boolean bl = false;
        int n = 0;
        for (Object t : iterable) {
            void it;
            NodePoint nodePoint = (NodePoint)((Object)t);
            int n2 = n;
            boolean bl2 = false;
            Document document = it.getNode().ownerDocument();
            Intrinsics.checkNotNull((Object)document);
            int n3 = document.title().length();
            n = n2 + n3;
        }
        double aveLength = (double)n / this.qualifiedSize;
        PageTableKt.getData((OpenMapTable.Column)column).setDisplay("title");
        PageTableKt.getData((OpenMapTable.Column)column).setAveLen(aveLength);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumnAttributes(TileCluster cluster2, OpenMapTable.Column column) {
        double d;
        Object v1;
        void $this$minByOrNull$iv;
        double d2;
        String string;
        void $this$mapTo$iv;
        String string2;
        Collection collection;
        void $this$mapTo$iv2;
        List points = cluster2.getPoints();
        Node sampleNode = ((NodePoint)((Object)CollectionsKt.first(points))).getNode();
        Iterable iterable = points;
        Iterable destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            collection = destination$iv;
            boolean bl = false;
            string2 = NodeExtKt.getLocation((Node)it.getNode());
            collection.add(string2);
        }
        Frequency urlFrequency = (Frequency)destination$iv;
        destination$iv = points;
        Collection destination$iv2 = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NodePoint bl = (NodePoint)((Object)item$iv);
            collection = destination$iv2;
            boolean bl2 = false;
            string2 = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)it.getNode()).getSelector2();
            collection.add(string2);
        }
        Frequency pathFrequency = (Frequency)destination$iv2;
        ConfuseMatrix m = cluster2.getConfuseMatrix();
        ColumnData columnData = PageTableKt.getData((OpenMapTable.Column)column);
        boolean bl = false;
        boolean bl3 = false;
        ColumnData $this$buildColumnAttributes_u24lambda_u2d14 = columnData;
        boolean bl4 = false;
        StringCompanionObject bl2 = StringCompanionObject.INSTANCE;
        String string3 = "c%02d";
        Object object = new Object[]{cluster2.getLabel()};
        boolean bl5 = false;
        String string4 = String.format(string3, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        $this$buildColumnAttributes_u24lambda_u2d14.setClusterId(string4);
        $this$buildColumnAttributes_u24lambda_u2d14.setDisplay(NodeExtKt.getName((Node)sampleNode));
        $this$buildColumnAttributes_u24lambda_u2d14.setCName(cluster2.getNames().toString());
        int numPaths = pathFrequency.elementSet().size();
        $this$buildColumnAttributes_u24lambda_u2d14.setNumPath(numPaths);
        Multiset.Entry mostEntry = pathFrequency.getMostEntry();
        object = (String)mostEntry.getElement();
        $this$buildColumnAttributes_u24lambda_u2d14.setPath1(object == null ? "" : ((string = ((String)object).toString()) == null ? "" : string));
        $this$buildColumnAttributes_u24lambda_u2d14.setNumPath1(mostEntry.getCount());
        if (numPaths > 1) {
            String string5;
            Multiset.Entry leastEntry = pathFrequency.getLeastEntry();
            String string6 = (String)leastEntry.getElement();
            $this$buildColumnAttributes_u24lambda_u2d14.setPath2(string6 == null ? "" : ((string5 = string6.toString()) == null ? "" : string5));
            $this$buildColumnAttributes_u24lambda_u2d14.setNumPath2(leastEntry.getCount());
        }
        object = points;
        ColumnData columnData2 = $this$buildColumnAttributes_u24lambda_u2d14;
        bl5 = false;
        double d3 = 0.0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            NodePoint nodePoint = (NodePoint)((Object)t);
            d2 = d3;
            boolean bl6 = false;
            RealVector realVector = it.getNode().getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"it.node.extension.features");
            double d4 = VectorsKt.get((RealVector)realVector, (int)DefinedFeaturesKt.CH);
            d3 = d2 + d4;
        }
        d2 = d3;
        columnData2.setAveLen(d2 / (double)points.size());
        Iterable iterable2 = points;
        columnData2 = $this$buildColumnAttributes_u24lambda_u2d14;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                NodePoint it = (NodePoint)((Object)minElem$iv);
                boolean bl7 = false;
                double minValue$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it.getNode());
                do {
                    Object e$iv = iterator$iv.next();
                    NodePoint it2 = (NodePoint)((Object)e$iv);
                    $i$a$-minByOrNull-PageCorpusTabulator$buildColumnAttributes$1$2 = false;
                    double v$iv = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it2.getNode());
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        Object var34_47 = v1;
        object = var34_47;
        columnData2.setMinFreq(object == null ? 0.0 : ((iterable2 = ((NodePoint)((Object)object)).getNode()) == null ? 0.0 : (d = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)iterable2))));
        $this$buildColumnAttributes_u24lambda_u2d14.setNumUri(urlFrequency.size());
        $this$buildColumnAttributes_u24lambda_u2d14.setMaxUrlFreq((double)urlFrequency.getMostEntry().getCount());
        $this$buildColumnAttributes_u24lambda_u2d14.setDistortion(cluster2.getDistortion());
        $this$buildColumnAttributes_u24lambda_u2d14.setInt(cluster2.isInt());
        $this$buildColumnAttributes_u24lambda_u2d14.setFloat(cluster2.isFloat());
        $this$buildColumnAttributes_u24lambda_u2d14.setNumeric(cluster2.isNumeric());
        $this$buildColumnAttributes_u24lambda_u2d14.setNumericLike(cluster2.isNumericLike());
        $this$buildColumnAttributes_u24lambda_u2d14.setMoneyLike(cluster2.isMoneyLike());
        $this$buildColumnAttributes_u24lambda_u2d14.setLazy(cluster2.isLazy());
        $this$buildColumnAttributes_u24lambda_u2d14.setTp(m.getTp());
        $this$buildColumnAttributes_u24lambda_u2d14.setFp(m.getFp());
        $this$buildColumnAttributes_u24lambda_u2d14.setFn(m.getFn());
        $this$buildColumnAttributes_u24lambda_u2d14.setTn(m.getTn());
        $this$buildColumnAttributes_u24lambda_u2d14.setPrecision(m.getPrecision());
        $this$buildColumnAttributes_u24lambda_u2d14.setRecall(m.getRecall());
        $this$buildColumnAttributes_u24lambda_u2d14.setF1(m.getF1());
        $this$buildColumnAttributes_u24lambda_u2d14.setHyperPath(cluster2.getHyperPath().getPath());
    }

    /*
     * WARNING - void declaration
     */
    private final void initRows(OpenMapTable table) {
        TileCluster it;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.corpus.getDocuments$scent_auto_mining();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            VisualDocument visualDocument = (VisualDocument)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Integer n = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPid((Node)((Node)it.getBody()));
            map.put(n, element$iv$iv);
        }
        Map indexedDocuments = destination$iv$iv;
        $i$f$associateBy = false;
        Set failedPids = new LinkedHashSet();
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (TileCluster)item$iv;
            int k = n;
            boolean bl2 = false;
            Map<Integer, List<NodePoint>> $this$forEach$iv = cluster2.getPagePoints();
            boolean $i$f$forEach = false;
            Map<Integer, List<NodePoint>> map = $this$forEach$iv;
            boolean bl3 = false;
            Iterator<Map.Entry<Integer, List<NodePoint>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Document document;
                Map.Entry<Integer, List<NodePoint>> element$iv;
                Map.Entry<Integer, List<NodePoint>> $dstr$pid$points = element$iv = iterator.next();
                boolean bl4 = false;
                Map.Entry<Integer, List<NodePoint>> entry = $dstr$pid$points;
                boolean bl5 = false;
                int pid = ((Number)entry.getKey()).intValue();
                Map.Entry<Integer, List<NodePoint>> entry2 = $dstr$pid$points;
                boolean bl6 = false;
                List<NodePoint> points = entry2.getValue();
                if (failedPids.contains(pid)) continue;
                VisualDocument visualDocument = (VisualDocument)indexedDocuments.get(pid);
                Document document2 = document = visualDocument == null ? null : visualDocument.getDocument();
                if (document == null) {
                    failedPids.add(pid);
                    continue;
                }
                String location = NodeExtKt.getLocation((Node)((Node)document));
                Iterable $this$forEach$iv2 = points;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    NodePoint point = (NodePoint)((Object)element$iv2);
                    boolean bl7 = false;
                    Element element = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getOwnerComponent((Node)point.getNode());
                    if (element == null) continue;
                    Element component = element;
                    table.computeIfAbsent(location, (Function1)new Function1<OpenMapTable.Row, Unit>(table, component, pid, location, document){
                        final /* synthetic */ OpenMapTable $table;
                        final /* synthetic */ Element $component;
                        final /* synthetic */ int $pid;
                        final /* synthetic */ String $location;
                        final /* synthetic */ Document $document;
                        {
                            this.$table = $table;
                            this.$component = $component;
                            this.$pid = $pid;
                            this.$location = $location;
                            this.$document = $document;
                            super(1);
                        }

                        public final void invoke(@NotNull OpenMapTable.Row it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            PageTableKt.getData((OpenMapTable.Row)it).setOwnerTable(this.$table);
                            PageTableKt.getData((OpenMapTable.Row)it).setComponent(this.$component);
                            PageTableKt.getData((OpenMapTable.Row)it).setPid(this.$pid);
                            PageTableKt.getData((OpenMapTable.Row)it).setLocation(this.$location);
                            RowData rowData = PageTableKt.getData((OpenMapTable.Row)it);
                            String string = this.$document.title();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.title()");
                            rowData.setTitle(string);
                            PageTableKt.getData((OpenMapTable.Row)it).setExportPath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getAnnotatedView()).toString());
                            PageTableKt.getData((OpenMapTable.Row)it).setTilePath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getTileView()).toString());
                            PageTableKt.getData((OpenMapTable.Row)it).setEntityPath(((Object)NodeExtKt.getExportPaths((Document)this.$document).getEntityView()).toString());
                        }
                    });
                }
            }
        }
        Collection collection = failedPids;
        boolean bl = false;
        if (!collection.isEmpty()) {
            logger.warn("There {} nodes can not find owner document", (Object)failedPids.size());
        }
    }

    private final void buildRows(OpenMapTable table) {
        CellType cellType = this.cellType;
        int n = WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()];
        switch (n) {
            case 2: {
                this.buildPlainTextRows(table);
                break;
            }
            case 1: {
                this.buildDatabaseRows(table);
                break;
            }
            case 3: {
                this.buildHtmlRows(table);
                break;
            }
            default: {
                this.buildNodeRows(table);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildNodeRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int j = n;
            boolean bl2 = false;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl3 = false;
                OpenMapTable.Row row = table.computeIfAbsent(NodeExtKt.getLocation((Node)point.getNode()));
                boolean bl4 = false;
                boolean bl5 = false;
                OpenMapTable.Row it = row;
                boolean bl6 = false;
                it.set(j, new OpenMapTable.Cell(j, (Object)point.getNode()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPlainTextRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl2 = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl3 = false;
                OpenMapTable.Row row = table.get(NodeExtKt.getLocation((Node)point.getNode()));
                if (row == null) continue;
                OpenMapTable.Row row2 = row;
                boolean bl4 = false;
                boolean bl5 = false;
                OpenMapTable.Row it = row2;
                boolean bl6 = false;
                it.set(j, new OpenMapTable.Cell(j, (Object)this.getText(it.get(j), point.getNode())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildDatabaseRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl2 = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl3 = false;
                OpenMapTable.Row row = table.get(NodeExtKt.getLocation((Node)point.getNode()));
                if (row == null) continue;
                OpenMapTable.Row row2 = row;
                boolean bl4 = false;
                boolean bl5 = false;
                OpenMapTable.Row it = row2;
                boolean bl6 = false;
                it.set(j, new OpenMapTable.Cell(j, (Object)this.getText(it.get(j), point.getNode())));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildHtmlRows(OpenMapTable table) {
        Iterable $this$forEachIndexed$iv = this.getQualifiedClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int k = n;
            boolean bl2 = false;
            int j = k + 1;
            Iterable $this$forEach$iv = cluster2.getPoints();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NodePoint point = (NodePoint)((Object)element$iv);
                boolean bl3 = false;
                OpenMapTable.Row row = table.get(NodeExtKt.getLocation((Node)point.getNode()));
                if (row == null) continue;
                OpenMapTable.Row row2 = row;
                boolean bl4 = false;
                boolean bl5 = false;
                OpenMapTable.Row it = row2;
                boolean bl6 = false;
                OpenMapTable.Cell cell = new OpenMapTable.Cell(j, (Object)this.getSlimHtml(it.get(j), point.getNode()));
                if (this.options.getShowTip()) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%.3f";
                    Object[] objectArray = new Object[]{ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getGeoOrder((Node)point.getNode())};
                    boolean bl7 = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    PageTableKt.setTip((OpenMapTable.Cell)cell, (String)string2);
                }
                it.set(j, cell);
            }
        }
    }

    private final String getReadableLink(String location) {
        String url = UrlUtils.normalize$default((String)location, (boolean)false, (int)2, null);
        Object link = url;
        if (((String)link).length() > 80) {
            String string = StringUtils.abbreviateMiddle((String)link, (String)"..", (int)80);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abbreviateMiddle(link, \"..\", 80)");
            link = string;
            link = "<a href='" + url + "' target='_blank'>" + (String)link + "</a>";
        }
        return link;
    }

    private final String getDocTitle(String location, String title, int displayLength, boolean textOnly) {
        if (textOnly) {
            return title;
        }
        String displayTitle = StringUtils.abbreviate((String)title, (int)displayLength);
        return "<a href='" + location + "' title='" + title + "' target='_blank'>" + displayTitle + "</a>";
    }

    static /* synthetic */ String getDocTitle$default(PageCorpusTabulator pageCorpusTabulator, String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 150;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return pageCorpusTabulator.getDocTitle(string, string2, n, bl);
    }

    private final String getText(Object lastValue, Node node) {
        Object object;
        if (lastValue != null) {
            String string = lastValue.toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString() + "\t";
        } else {
            object = "";
        }
        String lastText = object;
        CharSequence charSequence = NodeExtKt.isImage((Node)node) ? node.attr("abs:src") : (NodeExtKt.isAnchor((Node)node) ? node.attr("abs:href") : NodeExtKt.getCleanText((Node)node));
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"when {\n            node.\u2026 node.cleanText\n        }");
        String text2 = charSequence;
        charSequence = lastText;
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)charSequence) ? lastText + "\n" + text2 : text2;
    }

    private final String getRichText(Object lastValue, Node node) {
        Object object;
        if (lastValue != null) {
            String string = lastValue.toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString() + "\t";
        } else {
            object = "";
        }
        String lastText = object;
        String text2 = NodeExtKt.isImage((Node)node) ? NodeExtKt.getSlimHtml((Node)node) : (NodeExtKt.isAnchor((Node)node) ? NodeExtKt.getSlimHtml((Node)node) : (NodeExtKt.isNumeric((Node)node) ? "<em class='numeric'>" + NodeExtKt.getCleanText((Node)node) + "</em>" : (NodeExtKt.isMoneyLike((Node)node) ? "<em class='money'>" + NodeExtKt.getCleanText((Node)node) + "</em>" : NodeExtKt.getCleanText((Node)node))));
        CharSequence charSequence = lastText;
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)charSequence) ? lastText + "\n" + text2 : text2;
    }

    private final String getSlimHtml(Object lastValue, Node node) {
        Object object;
        String text2 = this.getText(lastValue, node);
        if (StringsKt.isBlank((CharSequence)text2)) {
            return "";
        }
        if (lastValue != null) {
            String string = lastValue.toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            object = ((Object)StringsKt.trim((CharSequence)string2)).toString() + "\n";
        } else {
            object = "";
        }
        String lastStrValue = object;
        String value = NodeExtKt.getSlimHtml((Node)node);
        CharSequence charSequence = lastStrValue + value;
        String string = "\n";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List parts = string.split(charSequence, n);
        String visibleParts2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)parts, (int)3), (CharSequence)"\n", null, null, (int)0, null, (Function1)getSlimHtml.visibleParts.1.INSTANCE, (int)30, null);
        Object hiddenParts2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)parts, (int)3), (CharSequence)"\n", null, null, (int)0, null, (Function1)getSlimHtml.hiddenParts.1.INSTANCE, (int)30, null);
        CharSequence charSequence2 = (CharSequence)hiddenParts2;
        bl = false;
        if (charSequence2.length() > 0) {
            hiddenParts2 = "<div class='hidden'>" + (String)hiddenParts2 + "</div>";
        }
        return visibleParts2 + (String)hiddenParts2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TileCluster> computeQualifiedClusters() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.clusterGroup.getClusters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TileCluster it = (TileCluster)element$iv$iv;
            boolean bl = false;
            if (!((double)it.getPoints().size() >= this.qualifiedSize && (this.options.getShowImage() || !it.isImage()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TileCluster it = (TileCluster)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getOrder());
                it = (TileCluster)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getOrder();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
    }

    public static final /* synthetic */ List access$computeQualifiedClusters(PageCorpusTabulator $this) {
        return $this.computeQualifiedClusters();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/analysis/corpus/PageCorpusTabulator$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "combineTables", "Lai/platon/pulsar/common/OpenMapTable;", "tables", "", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OpenMapTable combineTables(@NotNull List<OpenMapTable> tables) {
            Object object;
            void it;
            boolean bl;
            Pair $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Iterable $this$flatMap$iv = tables;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                OpenMapTable table = (OpenMapTable)element$iv$iv;
                boolean bl2 = false;
                OpenMapTable.Column[] $this$map$iv = table.getColumns();
                boolean $i$f$map = false;
                OpenMapTable.Column[] columnArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (String item$iv$iv : $this$mapTo$iv$iv) {
                    void var21_46 = item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    bl = false;
                    object = TuplesKt.to((Object)table.getIdent(), (Object)it);
                    collection.add(object);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List combinedColumns = (List)destination$iv$iv;
            OpenMapTable combinedTable = new OpenMapTable(combinedColumns.size(), 0);
            PageTableKt.getData((OpenMapTable)combinedTable).setCombined(true);
            OpenMapTable.Column[] $this$forEachIndexed$iv = combinedTable.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (OpenMapTable.Column item$iv : $this$forEachIndexed$iv) {
                void it2;
                void c;
                String item$iv$iv;
                int n = index$iv++;
                OpenMapTable.Column bl2 = item$iv;
                int i = n;
                boolean bl3 = false;
                $this$mapTo$iv$iv = (Pair)combinedColumns.get(i);
                int tableId = ((Number)$this$mapTo$iv$iv.component1()).intValue();
                OpenMapTable.Column prototype = (OpenMapTable.Column)$this$mapTo$iv$iv.component2();
                String string = prototype.getName();
                int n2 = 0;
                int n3 = 0;
                item$iv$iv = string;
                it = c;
                boolean bl4 = false;
                bl = new Regex("T\\d+C\\d+").matches((CharSequence)it2);
                object = bl ? string : null;
                it.setName((String)((Object)(object == null ? "T" + tableId + prototype.getName() : object)));
                PageTableKt.setData((OpenMapTable.Column)c, (ColumnData)PageTableKt.getData((OpenMapTable.Column)prototype));
                c.getAttributes().putAll(prototype.getAttributes());
            }
            int columnIndexStart = 0;
            Iterable $this$forEachIndexed$iv2 = tables;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv : $this$forEachIndexed$iv2) {
                void table;
                int n = index$iv2++;
                boolean bl5 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                OpenMapTable i = (OpenMapTable)item$iv;
                int i2 = n;
                boolean bl6 = false;
                Iterable $this$forEach$iv = table.getRows();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
                    boolean bl7 = false;
                    if (row.getCells().length != table.getNumColumns()) {
                        logger.warn("Cell count doesn't match column count | " + row.getCells().length + " <- " + table.getNumColumns());
                    }
                    OpenMapTable.Row combinedRow = combinedTable.computeIfAbsent(PageTableKt.getData((OpenMapTable.Row)row).getLocation());
                    OpenMapTable.Cell[] $this$forEachIndexed$iv3 = row.getCells();
                    boolean $i$f$forEachIndexed3 = false;
                    int index$iv3 = 0;
                    for (OpenMapTable.Cell item$iv2 : $this$forEachIndexed$iv3) {
                        void cell;
                        int n4 = index$iv3++;
                        OpenMapTable.Cell cell2 = item$iv2;
                        int j = n4;
                        boolean bl8 = false;
                        void var32_61 = cell;
                        combinedRow.setValue(columnIndexStart + j, var32_61 == null ? null : var32_61.getValue());
                    }
                }
                columnIndexStart += table.getNumColumns();
            }
            return combinedTable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CellType.values().length];
            nArray[CellType.DATABASE.ordinal()] = 1;
            nArray[CellType.PLAIN_TEXT.ordinal()] = 2;
            nArray[CellType.SLIM_HTML.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

