/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.words.blackwhite;

import ai.platon.pulsar.common.BlackWhiteResourceConfig;
import ai.platon.pulsar.common.FuzzyProbability;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.scent.feature.WordFeature;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Better semantic approach is required")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\b\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u001c\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u0016\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/feature/words/blackwhite/EntityNameFeature;", "Lai/platon/scent/feature/WordFeature;", "blackWhiteConfig", "Lai/platon/pulsar/common/BlackWhiteResourceConfig;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/BlackWhiteResourceConfig;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getMaxSimilarity", "", "text", "", "potentialTitles", "", "getQuickMaxSimilarity", "getQuickSimilarity", "text2", "getSimilarity", "strip", "name", "Companion", "scent-auto-mining"})
public final class EntityNameFeature
extends WordFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    private static final int MinProductTitleSize = 6;
    private static final int MaxProductTitleSize = 100;
    private static final Pattern PAT_REMOVE_COMMENT_POTION = Pattern.compile("((\uff08.+?\uff09)|(\u3010.+?\u3011))");

    public EntityNameFeature(@NotNull BlackWhiteResourceConfig blackWhiteConfig, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)blackWhiteConfig, (String)"blackWhiteConfig");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(blackWhiteConfig);
        this.conf = conf;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final double getQuickSimilarity(@NotNull String text2, @NotNull String text22) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)text22, (String)"text2");
        HashSet<String> set = new HashSet<String>();
        set.add(text22);
        return this.getQuickMaxSimilarity(text2, (Set<String>)set);
    }

    public final double getQuickMaxSimilarity(@NotNull String text2, @NotNull Set<String> potentialTitles) {
        String text3;
        boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(potentialTitles, (String)"potentialTitles");
        if (!this.validate(text2)) {
            return 0.0;
        }
        double sim = 0.0;
        for (String potentialTitle : potentialTitles) {
            String text22;
            String string2 = Strings.stripNonCJKChar((String)potentialTitle);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stripNonCJKChar(potentialTitle)");
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)string2.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            string = Strings.stripNonCJKChar((String)text2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripNonCJKChar(text)");
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            if (text22.length() < text3.length()) {
                String tmp = text22;
                text22 = text3;
                text3 = tmp;
            }
            if (!this.validate(text22) || !StringsKt.contains$default((CharSequence)text22, (CharSequence)text3, (boolean)false, (int)2, null)) continue;
            sim = (double)text3.length() / (double)text22.length() + 0.15;
            if (FuzzyProbability.maybe((double)sim)) {
                // empty if block
            }
            if (!FuzzyProbability.veryLikely((double)sim)) continue;
        }
        if (!FuzzyProbability.veryLikely((double)sim)) {
            for (String potentialTitle : potentialTitles) {
                text3 = Strings.stripNonCJKChar((String)potentialTitle);
                Intrinsics.checkNotNullExpressionValue((Object)text3, (String)"stripNonCJKChar(potentialTitle)");
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)text3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                string = Strings.stripNonCJKChar((String)text2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripNonCJKChar(text)");
                bl = false;
                String string3 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                text3 = string3;
                sim = Double.NaN;
                if (FuzzyProbability.maybe((double)sim)) {
                    // empty if block
                }
                if (!FuzzyProbability.veryLikely((double)sim)) continue;
                break;
            }
        }
        return sim;
    }

    public final double getSimilarity(@NotNull String text2, @NotNull String text22) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)text22, (String)"text2");
        HashSet<String> set = new HashSet<String>();
        set.add(text22);
        return this.getMaxSimilarity(text2, (Set<String>)set);
    }

    public final double getMaxSimilarity(@NotNull String text2, @NotNull Set<String> potentialTitles) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(potentialTitles, (String)"potentialTitles");
        if (!this.validate(text2)) {
            return 0.0;
        }
        double sim = this.getQuickMaxSimilarity(text2, potentialTitles);
        if (FuzzyProbability.veryLikely((double)sim)) {
            return sim;
        }
        if (sim < FuzzyProbability.MAYBE.floor()) {
            return 0.0;
        }
        if (!this.conf.getBoolean("scent.nlp.semantic.similarity.enabled", false)) {
            return sim;
        }
        for (String potentialTitle : potentialTitles) {
            if (!this.validate(potentialTitle) || !this.validate(text2)) continue;
            sim = Double.NaN;
            if (FuzzyProbability.maybe((double)sim)) {
                // empty if block
            }
            if (!FuzzyProbability.veryLikely((double)sim)) continue;
            break;
        }
        return sim;
    }

    @NotNull
    public final String strip(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object name2 = name;
        if (!this.validate((String)name2)) {
            return "";
        }
        for (String word : this.getBlackWords()) {
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"word");
            name2 = StringsKt.replace$default((String)name2, (String)word, (String)"", (boolean)false, (int)4, null);
        }
        String string = Strings.trimNonCJKChar((String)name2, (String)"[]()\u3010\u3011\uff08\uff09");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimNonCJKChar(name, \"[]()\u3010\u3011\uff08\uff09\")");
        name2 = string;
        return !this.validate((String)name2) ? "" : name2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/feature/words/blackwhite/EntityNameFeature$Companion;", "", "()V", "MaxProductTitleSize", "", "getMaxProductTitleSize", "()I", "MinProductTitleSize", "getMinProductTitleSize", "PAT_REMOVE_COMMENT_POTION", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPAT_REMOVE_COMMENT_POTION", "()Ljava/util/regex/Pattern;", "validateSize", "", "name", "", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMinProductTitleSize() {
            return MinProductTitleSize;
        }

        public final int getMaxProductTitleSize() {
            return MaxProductTitleSize;
        }

        public final Pattern getPAT_REMOVE_COMMENT_POTION() {
            return PAT_REMOVE_COMMENT_POTION;
        }

        public final boolean validateSize(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return name.length() > this.getMinProductTitleSize() && name.length() < this.getMaxProductTitleSize();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

