/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.feature.words.weighted;

import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.QueriesKt;
import ai.platon.scent.feature.ScentRule;
import ai.platon.scent.feature.statistics.BlockStatRule;
import ai.platon.scent.feature.words.weighted.PhraseRule;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020 H\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020\"H\u0002J\u0006\u0010)\u001a\u00020\u0006R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u001e\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lai/platon/scent/feature/words/weighted/WeightedPhraseFeatureParser;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "resources", "", "", "(Lai/platon/pulsar/common/config/ImmutableConfig;Ljava/util/List;)V", "blockRules", "Lcom/google/common/collect/Multimap;", "Lai/platon/scent/feature/statistics/BlockStatRule;", "getBlockRules$scent_auto_mining", "()Lcom/google/common/collect/Multimap;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "excludes", "getExcludes$scent_auto_mining", "imports", "Ljava/util/Queue;", "Lai/platon/scent/feature/words/weighted/WeightedPhraseFeatureParser$ImportFile;", "getImports$scent_auto_mining", "()Ljava/util/Queue;", "includes", "getIncludes$scent_auto_mining", "processedImports", "", "getProcessedImports$scent_auto_mining", "()Ljava/util/Set;", "getResources", "()Ljava/util/List;", "getBlockRuleId", "eleBlock", "Lorg/jsoup/nodes/Element;", "parse", "", "doc", "Lorg/jsoup/nodes/Document;", "parseImport", "eleImport", "parseStep1", "parseStep2", "report", "Companion", "ImportFile", "scent-auto-mining"})
public final class WeightedPhraseFeatureParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final List<String> resources;
    @NotNull
    private final Queue<ImportFile> imports;
    @NotNull
    private final Set<ImportFile> processedImports;
    @NotNull
    private final Multimap<BlockStatRule, String> includes;
    @NotNull
    private final Multimap<BlockStatRule, String> excludes;
    @NotNull
    private final Multimap<String, BlockStatRule> blockRules;
    @NotNull
    private static final Logger log;

    public WeightedPhraseFeatureParser(@NotNull ImmutableConfig conf, @NotNull List<String> resources) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        this.conf = conf;
        this.resources = resources;
        this.imports = new LinkedList();
        this.processedImports = new HashSet();
        TreeMultimap treeMultimap = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create()");
        this.includes = (Multimap)treeMultimap;
        treeMultimap = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create()");
        this.excludes = (Multimap)treeMultimap;
        treeMultimap = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create()");
        this.blockRules = (Multimap)treeMultimap;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final List<String> getResources() {
        return this.resources;
    }

    @NotNull
    public final Queue<ImportFile> getImports$scent_auto_mining() {
        return this.imports;
    }

    @NotNull
    public final Set<ImportFile> getProcessedImports$scent_auto_mining() {
        return this.processedImports;
    }

    @NotNull
    public final Multimap<BlockStatRule, String> getIncludes$scent_auto_mining() {
        return this.includes;
    }

    @NotNull
    public final Multimap<BlockStatRule, String> getExcludes$scent_auto_mining() {
        return this.excludes;
    }

    @NotNull
    public final Multimap<String, BlockStatRule> getBlockRules$scent_auto_mining() {
        return this.blockRules;
    }

    @NotNull
    public final Multimap<String, BlockStatRule> parse() {
        Object object;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.resources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((Object)Paths.get(it, new String[0]).normalize()).toString();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new ImportFile(it, "");
            collection.add(object);
        }
        CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)this.imports);
        while (!this.imports.isEmpty()) {
            ImportFile importFile = this.imports.remove();
            InputStream stream = ResourceLoader.INSTANCE.getResourceAsStream(importFile.getFromFile());
            if (stream != null) {
                Document document = Jsoup.parse((InputStream)stream, (String)"utf-8", (String)importFile.getFromFile(), (Parser)Parser.xmlParser());
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(stream, \"utf-8\", i\u2026File, Parser.xmlParser())");
                Document doc = document;
                this.parse(doc);
            } else {
                log.warn("Failed to load resource " + importFile.getFromFile());
            }
            Intrinsics.checkNotNullExpressionValue((Object)importFile, (String)"importFile");
            this.processedImports.add(importFile);
        }
        return this.blockRules;
    }

    @NotNull
    public final String report() {
        StringBuilder sb = new StringBuilder();
        sb.append("imported files : \n");
        for (ImportFile file : this.processedImports) {
            sb.append("\t");
            sb.append(file.getFromFile());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("rules inspect : \n");
        for (Map.Entry entry : this.blockRules.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"blockRules.entries()");
            Map.Entry entry2 = entry;
            boolean bl = false;
            String key = (String)entry2.getKey();
            Map.Entry entry3 = entry;
            boolean bl2 = false;
            BlockStatRule value = (BlockStatRule)entry3.getValue();
            sb.append("\t");
            sb.append(key);
            sb.append(":");
            sb.append(value.getRules().size());
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final void parse(Document doc) {
        this.parseStep1(doc);
        this.parseStep2();
    }

    private final void parseImport(Element eleImport) {
        String location = NodeExtKt.getLocation((Node)((Node)eleImport));
        String baseDir = StringUtils.substring((String)location, (int)0, (int)StringUtils.lastIndexOf((CharSequence)location, (CharSequence)File.separator));
        Object path = baseDir + File.separator + eleImport.attr("file");
        ImportFile importFile = new ImportFile((String)(path = ((Object)Paths.get((String)path, new String[0]).normalize()).toString()), location);
        if (!this.processedImports.contains(importFile)) {
            this.imports.add(importFile);
        }
    }

    private final String getBlockRuleId(Element eleBlock) {
        String string = eleBlock.attr("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eleBlock.attr(\"label\")");
        String label = string;
        return NodeExtKt.getLocation((Node)((Node)eleBlock)) + "/" + label + "#" + eleBlock.attr("id");
    }

    private final void parseStep1(Document doc) {
        for (Element eleImport : QueriesKt.select2$default((Node)((Node)doc), (String)"blocks import", (int)0, (int)0, (int)6, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)eleImport, (String)"eleImport");
            this.parseImport(eleImport);
        }
        for (Element eleBlock : QueriesKt.select2$default((Node)((Node)doc), (String)"blocks block", (int)0, (int)0, (int)6, null)) {
            String string = eleBlock.attr("label");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eleBlock.attr(\"label\")");
            String label = string;
            Intrinsics.checkNotNullExpressionValue((Object)eleBlock, (String)"eleBlock");
            String id = this.getBlockRuleId(eleBlock);
            String string2 = eleBlock.attr("leaf-only");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eleBlock.attr(\"leaf-only\")");
            String leafOnly = string2;
            String string3 = eleBlock.attr("domain");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eleBlock.attr(\"domain\")");
            String domain = string3;
            BlockStatRule blockStatRule = new BlockStatRule(id, label, Intrinsics.areEqual((Object)leafOnly, (Object)"true"), domain);
            for (Element eleInc : QueriesKt.select2$default((Node)((Node)doc), (String)"blocks include-block", (int)0, (int)0, (int)6, null)) {
                this.includes.put((Object)blockStatRule, (Object)eleInc.attr("label"));
            }
            for (Element eleExc : QueriesKt.select2$default((Node)((Node)doc), (String)"blocks exclude-block", (int)0, (int)0, (int)6, null)) {
                this.excludes.put((Object)blockStatRule, (Object)eleExc.attr("label"));
            }
            for (Element elePhrase : eleBlock.getElementsByTag("phrase")) {
                String name = Strings.humanize((String)elePhrase.attr("name"));
                double score2 = NumberUtils.toDouble((String)elePhrase.attr("score"));
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                CharSequence charSequence = name;
                boolean bl = false;
                if (charSequence.length() == 0 || score2 == 0.0) continue;
                blockStatRule.getRules().add(new PhraseRule(name, score2));
            }
            this.blockRules.put((Object)label, (Object)blockStatRule);
        }
    }

    private final void parseStep2() {
        PhraseRule r;
        Object fromLabel;
        Iterator iterator;
        BlockStatRule toRule;
        LinkedListMultimap addons = LinkedListMultimap.create();
        for (Map.Entry entry : this.includes.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"includes.entries()");
            Map.Entry entry2 = entry;
            boolean bl = false;
            toRule = (BlockStatRule)entry2.getKey();
            iterator = entry;
            boolean bl2 = false;
            fromLabel = (String)iterator.getValue();
            for (BlockStatRule from : this.blockRules.get(fromLabel)) {
                for (ScentRule rule : from.getRules()) {
                    r = (PhraseRule)rule;
                    if (!(r.score() > 0.0)) continue;
                    addons.put((Object)toRule, (Object)new PhraseRule(r.phrase(), r.score()));
                }
            }
        }
        for (Map.Entry entry : this.excludes.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"excludes.entries()");
            fromLabel = entry;
            boolean bl = false;
            toRule = (BlockStatRule)fromLabel.getKey();
            iterator = entry;
            boolean from = false;
            fromLabel = (String)iterator.getValue();
            for (BlockStatRule from2 : this.blockRules.get(fromLabel)) {
                for (ScentRule rule : from2.getRules()) {
                    r = (PhraseRule)rule;
                    if (!(r.score() > 0.0)) continue;
                    addons.put((Object)toRule, (Object)new PhraseRule(r.phrase(), -1.0 * r.score()));
                }
            }
        }
        for (Map.Entry entry : addons.entries()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"addons.entries()");
            fromLabel = entry;
            boolean bl = false;
            BlockStatRule key = (BlockStatRule)fromLabel.getKey();
            iterator = entry;
            boolean bl3 = false;
            PhraseRule value = (PhraseRule)iterator.getValue();
            key.getRules().add(value);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(WeightedPhraseFeatureParser.class);
        Intrinsics.checkNotNull((Object)logger);
        log = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/feature/words/weighted/WeightedPhraseFeatureParser$ImportFile;", "", "fromFile", "", "toFile", "(Lai/platon/scent/feature/words/weighted/WeightedPhraseFeatureParser;Ljava/lang/String;Ljava/lang/String;)V", "getFromFile", "()Ljava/lang/String;", "setFromFile", "(Ljava/lang/String;)V", "getToFile", "setToFile", "equals", "", "other", "scent-auto-mining"})
    public final class ImportFile {
        @NotNull
        private String fromFile;
        @NotNull
        private String toFile;

        public ImportFile(@NotNull String fromFile, String toFile) {
            Intrinsics.checkNotNullParameter((Object)WeightedPhraseFeatureParser.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)fromFile, (String)"fromFile");
            Intrinsics.checkNotNullParameter((Object)toFile, (String)"toFile");
            this.fromFile = fromFile;
            this.toFile = toFile;
        }

        @NotNull
        public final String getFromFile() {
            return this.fromFile;
        }

        public final void setFromFile(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.fromFile = string;
        }

        @NotNull
        public final String getToFile() {
            return this.toFile;
        }

        public final void setToFile(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.toFile = string;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            Object object = other;
            Intrinsics.checkNotNull((Object)object);
            if (!Intrinsics.areEqual(object.getClass(), ImportFile.class)) {
                return false;
            }
            ImportFile o = (ImportFile)other;
            return Intrinsics.areEqual((Object)this.fromFile, (Object)o.fromFile) && Intrinsics.areEqual((Object)this.toFile, (Object)o.toFile);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/feature/words/weighted/WeightedPhraseFeatureParser$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

