/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.jsoup.ext.NodeExt;
import ai.platon.scent.ml.AffineTransformer;
import ai.platon.scent.ml.Bucketizer;
import ai.platon.scent.ml.EraseTransformer;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.HyperParametersKt;
import ai.platon.scent.ml.InsignificantFeatureRemover;
import ai.platon.scent.ml.NGramTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.NodePointEncoder;
import ai.platon.scent.ml.OneHotEncoder;
import ai.platon.scent.ml.ReversedOneHotIsolateTransformer;
import ai.platon.scent.ml.RowFormatter;
import ai.platon.scent.ml.Schema;
import ai.platon.scent.ml.SigmoidTransformer;
import ai.platon.scent.ml.Standardizer;
import ai.platon.scent.ml.unsupervised.PCA;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/ml/ClusterSensitiveNodeEncoder;", "Lai/platon/scent/ml/NodePointEncoder;", "nGram", "", "pcaRate", "", "dimension", "(IDI)V", "getPcaRate", "()D", "encode", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "Lkotlin/collections/ArrayList;", "nodes", "", "Lorg/jsoup/nodes/Node;", "scent-auto-mining"})
public class ClusterSensitiveNodeEncoder
extends NodePointEncoder {
    private final double pcaRate;

    public ClusterSensitiveNodeEncoder(int nGram, double pcaRate, int dimension) {
        super(nGram, dimension);
        this.pcaRate = pcaRate;
    }

    public /* synthetic */ ClusterSensitiveNodeEncoder(int n, double d, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            d = 1.0;
        }
        if ((n3 & 4) != 0) {
            n2 = FeatureRegistry.INSTANCE.getFeatureNames().size();
        }
        this(n, d, n2);
    }

    public final double getPcaRate() {
        return this.pcaRate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ArrayList<NodePoint> encode(@NotNull List<? extends Node> nodes2) {
        Object isolateEncoder;
        Object next;
        Object object;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        if (nodes2.isEmpty()) {
            boolean bl = false;
            return new ArrayList<NodePoint>();
        }
        ArrayList<NodePoint> points = new ArrayList<NodePoint>(this.getNGram() * nodes2.size());
        Iterable $this$forEach$iv = nodes2;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            NodeExt nodeExt;
            Node node;
            Node node2;
            Node it = (Node)element$iv2;
            boolean bl = false;
            ArrayRealVector curr = (ArrayRealVector)it.getExtension().getFeatures();
            points.add(new NodePoint(it, curr, true));
            Intrinsics.checkNotNull((Object)it.parent());
            Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"it.parent()!!");
            Node parent = node2;
            if (this.getNGram() > 1) {
                ArrayRealVector par = (ArrayRealVector)parent.getExtension().getFeatures();
                points.add(new NodePoint(it, par, true));
            }
            if (this.getNGram() > 2) {
                node = parent.previousSibling();
                object = node == null ? null : ((nodeExt = node.getExtension()) == null ? null : nodeExt.getFeatures());
                ArrayRealVector prev = (ArrayRealVector)(object == null ? (RealVector)new ArrayRealVector(this.getDimension()) : object);
                points.add(new NodePoint(it, prev, true));
            }
            if (this.getNGram() <= 3) continue;
            node = parent.nextSibling();
            object = node == null ? null : ((nodeExt = node.getExtension()) == null ? null : nodeExt.getFeatures());
            next = (ArrayRealVector)(object == null ? (RealVector)new ArrayRealVector(this.getDimension()) : object);
            points.add(new NodePoint(it, (ArrayRealVector)next, true));
        }
        ArrayList<NodePoint> xs = null;
        xs = points;
        int nTrace = HyperParametersKt.getTraceNFeatureLines();
        if (nTrace > 0) {
            RowFormatter.show$default(new RowFormatter(0, 0, 0, true, null, null, 55, null), xs, nTrace, false, null, 12, null);
        }
        element$iv2 = HyperParametersKt.getIgnoredFeatures();
        EraseTransformer eraser = new EraseTransformer(Arrays.copyOf(element$iv2, ((T)element$iv2).length), false, 2, null);
        Bucketizer bucketizer = new Bucketizer(false, 1, null);
        Iterable $this$forEachIndexed$iv = xs;
        boolean $i$f$forEachIndexed22 = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void point;
            int n = index$iv22++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl2 = false;
            NodePoint x = point;
            x = eraser.transform(x);
            eraser.show(x);
            x = bucketizer.transform(x);
            bucketizer.show(x);
            xs.set(i, x);
        }
        Schema schema = new Schema(null, 1, null);
        int[] $i$f$forEachIndexed22 = HyperParametersKt.getReversedOneHotIsolateFeatures();
        index$iv22 = 0;
        next = $i$f$forEachIndexed22;
        boolean item$iv = false;
        if (!(((Object)next).length == 0)) {
            int[] index$iv22 = HyperParametersKt.getReversedOneHotIsolateFeatures();
            isolateEncoder = new ReversedOneHotIsolateTransformer(Arrays.copyOf(index$iv22, index$iv22.length), schema, false);
            ((OneHotEncoder)isolateEncoder).fit((List<? extends NodePoint>)xs);
            schema = ((OneHotEncoder)isolateEncoder).transformSchema();
            xs = ((ReversedOneHotIsolateTransformer)isolateEncoder).transform((List<? extends NodePoint>)xs);
            ((FeatureTransformer)isolateEncoder).show((List<? extends NodePoint>)xs, nTrace, true);
        }
        isolateEncoder = HyperParametersKt.getNominalFeatures();
        boolean index$iv22 = false;
        next = isolateEncoder;
        item$iv = false;
        if (!(((Object)next).length == 0)) {
            int[] index$iv22 = HyperParametersKt.getNominalFeatures();
            OneHotEncoder hotEncoder = new OneHotEncoder(Arrays.copyOf(index$iv22, index$iv22.length), schema, 0.0, false, 4, null);
            hotEncoder.fit((List<? extends NodePoint>)xs);
            schema = hotEncoder.transformSchema();
            xs = hotEncoder.transform((List<? extends NodePoint>)xs);
            hotEncoder.show((List<? extends NodePoint>)xs, nTrace, true);
        }
        InsignificantFeatureRemover featureRemover = new InsignificantFeatureRemover(schema, false);
        featureRemover.fit((List<? extends NodePoint>)xs);
        schema = featureRemover.transformSchema();
        xs = featureRemover.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(featureRemover, xs, nTrace, false, 4, null);
        if (xs.size() > 2) {
            Standardizer standardizer = new Standardizer();
            standardizer.fit((List<? extends NodePoint>)xs);
            xs = standardizer.transform((List<? extends NodePoint>)xs);
        }
        SigmoidTransformer sigmoid = new SigmoidTransformer(false);
        xs = sigmoid.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(sigmoid, xs, nTrace, false, 4, null);
        if (HyperParametersKt.getApplyAffineTransform()) {
            AffineTransformer affine = new AffineTransformer(schema, false);
            affine.fit((List<? extends NodePoint>)xs);
            xs = affine.transform((List<? extends NodePoint>)xs);
            FeatureTransformer.show$default(affine, xs, nTrace, false, 4, null);
        }
        NGramTransformer nGramTransformer = new NGramTransformer(this.getNGram(), schema, false);
        schema = nGramTransformer.transformSchema();
        xs = nGramTransformer.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(nGramTransformer, xs, nTrace, false, 4, null);
        if (this.pcaRate > 0.0 && this.pcaRate < 1.0) {
            PCA pca = new PCA(xs, false, 0.0, 6, null).withProjection(this.pcaRate);
            xs = pca.project((List<? extends NodePoint>)xs);
            RowFormatter.show$default(new RowFormatter(0, 0, 0, false, null, null, 55, null), xs, nTrace, false, null, 12, null);
        }
        return xs;
    }
}

