/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0004J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/ml/FLD;", "", "x", "", "", "y", "", "L", "", "tol", "", "([[D[IID)V", "k", "mean", "mu", "Lsmile/math/matrix/DenseMatrix;", "p", "projection", "getProjection", "()Lsmile/math/matrix/DenseMatrix;", "smean", "smu", "[[D", "predict", "project", "([[D)[[D", "scent-auto-mining"})
public final class FLD {
    private int L;
    private double tol;
    private final int p;
    private final int k;
    @NotNull
    private final double[] mean;
    @NotNull
    private final DenseMatrix mu;
    @NotNull
    private final DenseMatrix projection;
    @NotNull
    private final double[] smean;
    @NotNull
    private final double[][] smu;

    public FLD(@NotNull double[][] x, @NotNull int[] y, int L, double tol) {
        int n;
        int n2;
        int j;
        int l;
        int j22;
        int i;
        int j3;
        int n3;
        int n4;
        int n5;
        int i2;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this.L = L;
        this.tol = tol;
        if (((Object[])x).length != y.length) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The sizes of X and Y don't match: %d != %d";
            Object[] objectArray = new Object[]{((Object[])x).length, y.length};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        int[] labels = Math.unique((int[])y);
        Arrays.sort(labels);
        int n6 = 0;
        int n7 = labels.length + -1;
        if (n6 <= n7) {
            do {
                int i3;
                if (labels[i3 = n6++] < 0) {
                    throw new IllegalArgumentException("Negative class label: " + labels[i3]);
                }
                if (i3 <= 0 || labels[i3] - labels[i3 - 1] <= 1) continue;
                throw new IllegalArgumentException("Missing class: " + (labels[i3 - 1] + 1));
            } while (n6 <= n7);
        }
        this.k = labels.length;
        if (this.k < 2) {
            throw new IllegalArgumentException("Only one class.");
        }
        if (this.tol < 0.0) {
            throw new IllegalArgumentException("Invalid tol: " + this.tol);
        }
        if (((Object[])x).length <= this.k) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Sample size is too small: %d <= %d";
            Object[] i3 = new Object[]{((Object[])x).length, this.k};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(i3, i3.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string3);
        }
        if (this.L >= this.k) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The dimensionality of mapped space is too high: %d >= %d";
            Object[] i3 = new Object[]{this.L, this.k};
            boolean bl = false;
            String string4 = String.format(string, Arrays.copyOf(i3, i3.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string4);
        }
        if (this.L <= 0) {
            this.L = this.k - 1;
        }
        int n8 = ((Object[])x).length;
        this.p = x[0].length;
        int[] ni = new int[this.k];
        double[] i3 = Math.colMeans((double[][])x);
        Intrinsics.checkNotNullExpressionValue((Object)i3, (String)"colMeans(x)");
        this.mean = i3;
        DenseMatrix T = Matrix.zeros((int)this.p, (int)this.p);
        DenseMatrix denseMatrix = Matrix.zeros((int)this.k, (int)this.p);
        Intrinsics.checkNotNullExpressionValue((Object)denseMatrix, (String)"zeros(k, p)");
        this.mu = denseMatrix;
        int n9 = 0;
        if (n9 < n8) {
            do {
                i2 = n9++;
                int c = y[i2];
                int[] nArray = ni;
                n5 = c;
                n4 = nArray[n5];
                nArray[n5] = n4 + 1;
                n3 = 0;
                n5 = this.p;
                if (n3 >= n5) continue;
                do {
                    j3 = n3++;
                    this.mu.add(c, j3, x[i2][j3]);
                } while (n3 < n5);
            } while (n9 < n8);
        }
        if ((n9 = 0) < (i2 = this.k)) {
            do {
                i = n9++;
                n3 = 0;
                n5 = this.p;
                if (n3 >= n5) continue;
                do {
                    j3 = n3++;
                    this.mu.div(i, j3, (double)ni[i]);
                    this.mu.sub(i, j3, this.mean[j3]);
                } while (n3 < n5);
            } while (n9 < i2);
        }
        if ((n9 = 0) < n8) {
            do {
                i2 = n9++;
                i = 0;
                n3 = this.p;
                if (i >= n3) continue;
                do {
                    int l2;
                    int j4;
                    if ((j3 = 0) > (j4 = i++)) continue;
                    do {
                        l2 = j3++;
                        T.add(j4, l2, (x[i2][j4] - this.mean[j4]) * (x[i2][l2] - this.mean[l2]));
                    } while (l2 != j4);
                } while (i < n3);
            } while (n9 < n8);
        }
        if ((n9 = 0) < (i2 = this.p)) {
            do {
                if ((n3 = 0) > (j22 = n9++)) continue;
                do {
                    l = n3++;
                    T.div(j22, l, (double)n8);
                    T.set(l, j22, T.get(j22, l));
                } while (l != j22);
            } while (n9 < i2);
        }
        DenseMatrix B = Matrix.zeros((int)this.p, (int)this.p);
        i2 = 0;
        j22 = this.k;
        if (i2 < j22) {
            do {
                int i4 = i2++;
                l = 0;
                j3 = this.p;
                if (l >= j3) continue;
                do {
                    int l3;
                    int j5;
                    int n10;
                    if ((n10 = 0) > (j5 = l++)) continue;
                    do {
                        l3 = n10++;
                        B.add(j5, l3, this.mu.get(i4, j5) * this.mu.get(i4, l3));
                    } while (l3 != j5);
                } while (l < j3);
            } while (i2 < j22);
        }
        if ((i2 = 0) < (j22 = this.p)) {
            do {
                int l4;
                if ((l = 0) > (j = i2++)) continue;
                do {
                    l4 = l++;
                    B.div(j, l4, (double)this.k);
                    B.set(l4, j, B.get(j, l4));
                } while (l4 != j);
            } while (i2 < j22);
        }
        T.setSymmetric(true);
        EVD eigen = T.eigen();
        FLD j22 = this;
        j22.tol *= this.tol;
        double[] s2 = eigen.getEigenValues();
        j = 0;
        l = s2.length + -1;
        if (j <= l) {
            do {
                int i5;
                if (s2[i5 = j++] < this.tol) {
                    throw new IllegalArgumentException("The covariance matrix is close to singular.");
                }
                s2[i5] = 1.0 / s2[i5];
            } while (j <= l);
        }
        DenseMatrix U = eigen.getEigenVectors();
        DenseMatrix UB = (DenseMatrix)U.atbmm((Object)B);
        n4 = 0;
        int n11 = this.k;
        if (n4 < n11) {
            do {
                int i6 = n4++;
                n2 = 0;
                n = this.p;
                if (n2 >= n) continue;
                do {
                    int j6 = n2++;
                    UB.mul(i6, j6, s2[j6]);
                } while (n2 < n);
            } while (n4 < n11);
        }
        B = (DenseMatrix)U.abmm((Object)UB);
        B.setSymmetric(true);
        eigen = B.eigen();
        U = eigen.getEigenVectors();
        DenseMatrix denseMatrix2 = Matrix.zeros((int)this.p, (int)this.L);
        Intrinsics.checkNotNullExpressionValue((Object)denseMatrix2, (String)"zeros(p, L)");
        this.projection = denseMatrix2;
        int n12 = 0;
        n11 = this.L;
        if (n12 < n11) {
            do {
                int j7 = n12++;
                n2 = 0;
                n = this.p;
                if (n2 >= n) continue;
                do {
                    int i7 = n2++;
                    this.projection.set(i7, j7, U.get(i7, j7));
                } while (n2 < n);
            } while (n12 < n11);
        }
        this.smean = new double[this.L];
        this.projection.atx(this.mean, this.smean);
        double[][] dArray = ((DenseMatrix)this.mu.abmm((Object)this.projection)).array();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"mu.abmm(projection).array()");
        this.smu = dArray;
    }

    public /* synthetic */ FLD(double[][] dArray, int[] nArray, int n, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            d = 1.0E-4;
        }
        this(dArray, nArray, n, d);
    }

    @NotNull
    public final DenseMatrix getProjection() {
        return this.projection;
    }

    public final int predict(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.p) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        double[] wx = this.project(x);
        int y = 0;
        double nearest = Double.POSITIVE_INFINITY;
        int n = 0;
        int n2 = this.k;
        if (n < n2) {
            do {
                int i;
                double d;
                if (!((d = Math.distance((double[])wx, (double[])this.smu[i = n++])) < nearest)) continue;
                nearest = d;
                y = i;
            } while (n < n2);
        }
        return y;
    }

    @NotNull
    public final double[] project(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (x.length != this.p) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        double[] y = new double[this.projection.ncols()];
        this.projection.atx(x, y);
        Math.minus((double[])y, (double[])this.smean);
        return y;
    }

    @NotNull
    public final double[][] project(@NotNull double[][] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        int n = 0;
        int n2 = ((Object[])x).length;
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[this.projection.ncols()];
        }
        double[][] y = dArrayArray;
        n = 0;
        n2 = ((Object[])x).length + -1;
        if (n <= n2) {
            do {
                int i;
                if (x[i = n++].length != this.p) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "Invalid input vector size: %d, expected: %d";
                    Object[] objectArray = new Object[]{x[i].length, this.p};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    throw new IllegalArgumentException(string2);
                }
                this.projection.atx(x[i], y[i]);
                Math.minus((double[])y[i], (double[])this.smean);
            } while (n <= n2);
        }
        return y;
    }
}

