/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\"\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020%R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006&"}, d2={"Lai/platon/scent/ml/LDA;", "", "x", "", "", "y", "", "tol", "", "priori", "([[D[ID[D)V", "C", "Lsmile/math/matrix/DenseMatrix;", "ct", "evd", "Lsmile/math/matrix/EVD;", "k", "", "mean", "mu", "[[D", "p", "getPriori", "()[D", "setPriori", "([D)V", "getTol", "()D", "setTol", "(D)V", "getX", "()[[D", "getY", "()[I", "predict", "posterior", "rd", "", "scent-auto-mining"})
public final class LDA {
    @NotNull
    private final double[][] x;
    @NotNull
    private final int[] y;
    private double tol;
    @NotNull
    private double[] priori;
    private final int p;
    private final int k;
    @NotNull
    private final double[] ct;
    @NotNull
    private final double[][] mu;
    @NotNull
    private final double[] mean;
    @NotNull
    private final DenseMatrix C;
    @NotNull
    private final EVD evd;

    public LDA(@NotNull double[][] x, @NotNull int[] y, double tol, @NotNull double[] priori) {
        int r;
        int c;
        int n;
        double[] dArray;
        int j;
        int n2;
        int n3;
        int i;
        int n4;
        int n5;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)priori, (String)"priori");
        this.x = x;
        this.y = y;
        this.tol = tol;
        this.priori = priori;
        if (((Object[])this.x).length != this.y.length) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The sizes of X and Y don't match: %d != %d";
            Object[] objectArray = new Object[]{((Object[])this.x).length, this.y.length};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string2);
        }
        double[] dArray2 = this.priori;
        int n6 = 0;
        double[] dArray3 = dArray2;
        int n7 = 0;
        if (!(dArray3.length == 0)) {
            if (this.priori.length < 2) {
                throw new IllegalArgumentException("Invalid number of priori probabilities: " + this.priori.length);
            }
            double sum = 0.0;
            dArray3 = this.priori;
            n7 = 0;
            n5 = dArray3.length;
            while (n7 < n5) {
                double pr = dArray3[n7];
                ++n7;
                if (pr <= 0.0 || pr >= 1.0) {
                    throw new IllegalArgumentException("Invalid priori probability: " + pr);
                }
                sum += pr;
            }
            if (java.lang.Math.abs(sum - 1.0) > 1.0E-10) {
                throw new IllegalArgumentException("The sum of priori probabilities is not one: " + sum);
            }
        }
        int[] labels = Math.unique((int[])this.y);
        Arrays.sort(labels);
        n6 = 0;
        int n8 = labels.length + -1;
        if (n6 <= n8) {
            do {
                int i42222;
                if (labels[i42222 = n6++] < 0) {
                    throw new IllegalArgumentException("Negative class label: " + labels[i42222]);
                }
                if (i42222 <= 0 || labels[i42222] - labels[i42222 - 1] <= 1) continue;
                throw new IllegalArgumentException("Missing class: " + (labels[i42222 - 1] + 1));
            } while (n6 <= n8);
        }
        this.k = labels.length;
        if (this.k < 2) {
            throw new IllegalArgumentException("Only one class.");
        }
        double[] dArray4 = this.priori;
        n8 = 0;
        Object i42222 = dArray4;
        n5 = 0;
        if (!(((double[])i42222).length == 0) && this.k != this.priori.length) {
            throw new IllegalArgumentException("The number of classes and the number of priori probabilities don't match.");
        }
        if (this.tol < 0.0) {
            throw new IllegalArgumentException("Invalid tol: " + this.tol);
        }
        int n9 = ((Object[])this.x).length;
        if (n9 <= this.k) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            i42222 = "Sample size is too small: %d <= %d";
            Object[] objectArray = new Object[]{n9, this.k};
            boolean pr = false;
            String string = String.format((String)i42222, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string);
        }
        this.p = this.x[0].length;
        int[] ni = new int[this.k];
        i42222 = Math.colMeans((double[][])this.x);
        Intrinsics.checkNotNullExpressionValue((Object)i42222, (String)"colMeans(x)");
        this.mean = i42222;
        i42222 = Matrix.zeros((int)this.p, (int)this.p);
        Intrinsics.checkNotNullExpressionValue((Object)i42222, (String)"zeros(p, p)");
        this.C = (DenseMatrix)i42222;
        int i42222 = 0;
        n5 = this.k;
        double[][] pr = new double[n5][];
        LDA lDA = this;
        while (i42222 < n5) {
            n4 = i42222++;
            pr[n4] = new double[this.p];
        }
        lDA.mu = pr;
        i42222 = 0;
        if (i42222 < n9) {
            do {
                i = i42222++;
                int c2 = this.y[i];
                int[] nArray = ni;
                n3 = c2;
                n2 = nArray[n3];
                nArray[n3] = n2 + 1;
                n4 = 0;
                n3 = this.p;
                if (n4 >= n3) continue;
                do {
                    j = n4++;
                    dArray = this.mu[c2];
                    n = j;
                    dArray[n] = dArray[n] + this.x[i][j];
                } while (n4 < n3);
            } while (i42222 < n9);
        }
        if ((i42222 = 0) < (i = this.k)) {
            do {
                int i2 = i42222++;
                n4 = 0;
                n3 = this.p;
                if (n4 >= n3) continue;
                do {
                    j = n4++;
                    dArray = this.mu[i2];
                    n = j;
                    dArray[n] = dArray[n] / (double)ni[i2];
                } while (n4 < n3);
            } while (i42222 < i);
        }
        double[] i42222 = this.priori;
        i = 0;
        if (i42222.length == 0) {
            this.priori = new double[this.k];
            int i42222 = 0;
            i = this.k;
            if (i42222 < i) {
                do {
                    int i3 = i42222++;
                    this.priori[i3] = (double)ni[i3] / (double)n9;
                } while (i42222 < i);
            }
        }
        this.ct = new double[this.k];
        int i42222 = 0;
        i = this.k;
        if (i42222 < i) {
            do {
                int i5 = i42222++;
                this.ct[i5] = java.lang.Math.log(this.priori[i5]);
            } while (i42222 < i);
        }
        if ((i42222 = 0) < n9) {
            do {
                i = i42222++;
                int n10 = 0;
                n4 = this.p;
                if (n10 >= n4) continue;
                do {
                    int n11;
                    if ((n2 = (c = n10++)) >= (n11 = this.p)) continue;
                    do {
                        r = n2++;
                        this.C.add(c, r, (this.x[i][c] - this.mean[c]) * (this.x[i][r] - this.mean[r]));
                    } while (n2 < n11);
                } while (n10 < n4);
            } while (i42222 < n9);
        }
        LDA i42222 = this;
        i42222.tol *= this.tol;
        double sd = n9 - this.k;
        int n12 = 0;
        n4 = this.p;
        if (n12 < n4) {
            do {
                int n13;
                if ((n2 = (c = n12++)) < (n13 = this.p)) {
                    do {
                        r = n2++;
                        this.C.div(c, r, sd);
                        this.C.set(r, c, this.C.get(c, r));
                    } while (n2 < n13);
                }
                if (!(this.C.get(c, c) < this.tol)) continue;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Covariance matrix (variable %d) is close to singular.";
                Object[] objectArray = new Object[]{c};
                boolean bl = false;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                throw new IllegalArgumentException(string3);
            } while (n12 < n4);
        }
        this.C.setSymmetric(true);
        EVD eVD = this.C.eigen();
        Intrinsics.checkNotNullExpressionValue((Object)eVD, (String)"C.eigen()");
        this.evd = eVD;
    }

    public /* synthetic */ LDA(double[][] dArray, int[] nArray, double d, double[] dArray2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 1.0E-4;
        }
        if ((n & 8) != 0) {
            dArray2 = new double[]{};
        }
        this(dArray, nArray, d, dArray2);
    }

    @NotNull
    public final double[][] getX() {
        return this.x;
    }

    @NotNull
    public final int[] getY() {
        return this.y;
    }

    public final double getTol() {
        return this.tol;
    }

    public final void setTol(double d) {
        this.tol = d;
    }

    @NotNull
    public final double[] getPriori() {
        return this.priori;
    }

    public final void setPriori(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.priori = dArray;
    }

    public final void rd() {
        int n = ((Object[])this.x).length;
        DenseMatrix Sw = Matrix.zeros((int)this.p, (int)this.p);
        DenseMatrix Sb = Matrix.zeros((int)this.p, (int)this.p);
        double[] m = Math.rowMeans((double[][])this.x);
        int n2 = 0;
        if (n2 < n) {
            do {
                int i = n2++;
                int n3 = 0;
                int n4 = this.p;
                if (n3 >= n4) continue;
                do {
                    int j = n3++;
                    Sb.set(i, j, (this.mu[i][j] - m[i]) * (this.mu[i][j] - m[i]));
                } while (n3 < n4);
            } while (n2 < n);
        }
        DenseMatrix D = Matrix.zeros((int)this.p, (int)this.p);
        this.C.mul(Sb, D);
        EVD evd = D.eigen();
        double[] dArray = evd.getEigenValues();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"evd.eigenValues");
        for (double s2 : dArray) {
            if (!(s2 < this.tol)) continue;
            throw new IllegalArgumentException("The covariance matrix is close to singular.");
        }
        double[] eigen = evd.getEigenValues();
        DenseMatrix W = evd.getEigenVectors();
    }

    public final int predict(@NotNull double[] x, @NotNull double[] posterior) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)posterior, (String)"posterior");
        double[] dArray = this.evd.getEigenValues();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"evd.eigenValues");
        for (double s2 : dArray) {
            if (!(s2 < this.tol)) continue;
            throw new IllegalArgumentException("The covariance matrix is close to singular.");
        }
        double[] eigen = this.evd.getEigenValues();
        DenseMatrix scaling = this.evd.getEigenVectors();
        if (x.length != this.p) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String s2 = "Invalid input vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{x.length, this.p};
            boolean bl = false;
            String string = String.format(s2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string);
        }
        if (posterior.length != this.k) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String s2 = "Invalid posterior vector size: %d, expected: %d";
            Object[] objectArray = new Object[]{posterior.length, this.k};
            boolean bl = false;
            String string = String.format(s2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            throw new IllegalArgumentException(string);
        }
        int y = 0;
        double max = Double.NEGATIVE_INFINITY;
        double[] d = new double[this.p];
        double[] ux = new double[this.p];
        int n2 = 0;
        int n3 = this.k;
        if (n2 < n3) {
            do {
                int i2 = n2++;
                int n4 = 0;
                int n5 = this.p;
                if (n4 < n5) {
                    do {
                        int j = n4++;
                        d[j] = x[j] - this.mu[i2][j];
                    } while (n4 < n5);
                }
                scaling.atx(d, ux);
                double f = 0.0;
                int n6 = 0;
                n = this.p;
                if (n6 < n) {
                    do {
                        int j = n6++;
                        f += ux[j] * ux[j] / eigen[j];
                    } while (n6 < n);
                }
                if (max < (f = this.ct[i2] - 0.5 * f)) {
                    max = f;
                    y = i2;
                }
                posterior[i2] = f;
            } while (n2 < n3);
        }
        double sum = 0.0;
        int n7 = 0;
        int n8 = this.k;
        if (n7 < n8) {
            do {
                i = n7++;
                posterior[i] = java.lang.Math.exp(posterior[i] - max);
                sum += posterior[i];
            } while (n7 < n8);
        }
        if ((n7 = 0) < (n8 = this.k)) {
            do {
                i = n7++;
                double[] dArray2 = posterior;
                n = i;
                dArray2[n] = dArray2[n] / sum;
            } while (n7 < n8);
        }
        return y;
    }
}

