/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.semisupervised;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.CheckState;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.geometric.GeometricsKt;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.dom.CalculatorUtils;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.VisualComponent;
import ai.platon.scent.dom.nodes.VisualDocument;
import ai.platon.scent.entities.ClusterTaskStatus;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.NodeClusterGroupMetrics;
import ai.platon.scent.ml.ClusterSensitiveComponentEncoder;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.semisupervised.ConstraintViolationPolicy;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.semisupervised.SKMOptions;
import ai.platon.scent.ml.semisupervised.SemiKMeans;
import ai.platon.scent.ml.unsupervised.ComponentCluster;
import ai.platon.scent.ml.unsupervised.ComponentClusterGroup;
import ai.platon.scent.ml.unsupervised.NodeClusterGroup;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.collect.TreeMultimap;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020(J$\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u0003H\u0002J\b\u0010.\u001a\u00020(H\u0002J\u001e\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u00020,0\u0003H\u0002J:\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u00020,0\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J\b\u00103\u001a\u00020(H\u0002J\u001e\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J\u0016\u00109\u001a\u00020:2\f\u00101\u001a\b\u0012\u0004\u0012\u00020,0\u0003H\u0002J\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\u00070<2\u0006\u0010>\u001a\u00020\bH\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020B2\u0006\u0010)\u001a\u00020BH\u0002J\u001e\u0010C\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u00032\u0006\u0010D\u001a\u00020\u000eH\u0002J\b\u0010E\u001a\u00020(H\u0002J4\u0010F\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00072\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00032\u0006\u0010G\u001a\u000205H\u0002JH\u0010H\u001a\u00020#2\u0006\u00100\u001a\u00020\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u00020,0\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u0010I\u001a\b\u0012\u0004\u0012\u0002050\u0003H\u0002R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0010R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006J"}, d2={"Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "Ljava/lang/AutoCloseable;", "documents", "", "Lai/platon/scent/dom/nodes/VisualDocument;", "uniquePathComponents", "Lcom/google/common/collect/TreeMultimap;", "", "Lai/platon/scent/dom/nodes/VisualComponent;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/util/List;Lcom/google/common/collect/TreeMultimap;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "componentClusterGroups", "", "Lai/platon/scent/ml/unsupervised/ComponentClusterGroup;", "getComponentClusterGroups$scent_auto_mining", "()Ljava/util/List;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getDocuments", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "options", "Lai/platon/scent/dom/HarvestOptions;", "reportPath", "Ljava/nio/file/Path;", "reportWriter", "Ljava/io/BufferedWriter;", "status", "Lai/platon/scent/entities/ClusterTaskStatus;", "getStatus", "()Lai/platon/scent/entities/ClusterTaskStatus;", "taskLogger", "tileClusterGroups", "Lai/platon/scent/ml/unsupervised/TileClusterGroup;", "getTileClusterGroups$scent_auto_mining", "getUniquePathComponents", "()Lcom/google/common/collect/TreeMultimap;", "close", "", "cluster", "clusterComponents", "seedNodes", "Lorg/jsoup/nodes/Element;", "nodes", "clusterNonUniquePathComponents", "clusterTiles", "taskName", "components", "Lorg/jsoup/nodes/Node;", "clusterTilesInUniquePathComponentSets", "generateParameterGrid", "Lai/platon/scent/ml/semisupervised/SKMOptions;", "numSeeds", "", "maxEpochs", "hasAcceptableRecall", "Lai/platon/pulsar/common/CheckState;", "isRelevant", "Lkotlin/Pair;", "", "component", "log", "message", "removePolysemousPoints", "Lai/platon/scent/ml/unsupervised/TileCluster;", "reportComponentClusters", "clusterGroup", "reportTileClusterGroups", "runKmeansForComponents", "skmOptions", "runKmeansForTiles", "parameterGrid", "scent-auto-mining"})
public final class NodeClusterRunner
implements AutoCloseable {
    @NotNull
    private final List<VisualDocument> documents;
    @NotNull
    private final TreeMultimap<String, VisualComponent> uniquePathComponents;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final Logger taskLogger;
    @NotNull
    private final HarvestOptions options;
    @NotNull
    private final List<ComponentClusterGroup> componentClusterGroups;
    @NotNull
    private final List<TileClusterGroup> tileClusterGroups;
    private final Path reportPath;
    @NotNull
    private final BufferedWriter reportWriter;
    @NotNull
    private final ClusterTaskStatus status;

    public NodeClusterRunner(@NotNull List<VisualDocument> documents, @NotNull TreeMultimap<String, VisualComponent> uniquePathComponents, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter(uniquePathComponents, (String)"uniquePathComponents");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.documents = documents;
        this.uniquePathComponents = uniquePathComponents;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(NodeClusterRunner.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(NodeClusterRunner.class), (String)".Task");
        OpenOption[] openOptionArray = (OpenOption[])CollectionsKt.firstOrNull(this.documents);
        HarvestOptions harvestOptions = openOptionArray == null ? null : openOptionArray.getOptions();
        this.options = harvestOptions == null ? HarvestOptions.Companion.create(this.conf.toVolatileConfig()) : harvestOptions;
        boolean bl = false;
        this.componentClusterGroups = new ArrayList();
        bl = false;
        this.tileClusterGroups = new ArrayList();
        this.reportPath = AppPaths.INSTANCE.getREPORT_DIR().resolve("harvest/corpus/clustering-result.log");
        this.status = new ClusterTaskStatus(0, null, 0, 0, 0, 0, 0.0, null, 255, null);
        Files.createDirectories(this.reportPath.getParent(), new FileAttribute[0]);
        openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.reportPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(report\u2026tandardOpenOption.APPEND)");
        this.reportWriter = bufferedWriter;
    }

    @NotNull
    public final List<VisualDocument> getDocuments() {
        return this.documents;
    }

    @NotNull
    public final TreeMultimap<String, VisualComponent> getUniquePathComponents() {
        return this.uniquePathComponents;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final List<ComponentClusterGroup> getComponentClusterGroups$scent_auto_mining() {
        return this.componentClusterGroups;
    }

    @NotNull
    public final List<TileClusterGroup> getTileClusterGroups$scent_auto_mining() {
        return this.tileClusterGroups;
    }

    @NotNull
    public final ClusterTaskStatus getStatus() {
        return this.status;
    }

    public final void cluster() {
        if (this.documents.isEmpty()) {
            return;
        }
        this.clusterTilesInUniquePathComponentSets();
        this.clusterNonUniquePathComponents();
        Iterable $this$forEach$iv = this.componentClusterGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentClusterGroup group = (ComponentClusterGroup)element$iv;
            boolean bl = false;
            group.forEach((Function1)new Function1<ComponentCluster, Unit>(this){
                final /* synthetic */ NodeClusterRunner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentCluster it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    NodeClusterRunner.access$clusterTiles(this.this$0, it.getDisplay(), it.getElements());
                }
            });
        }
        this.reportTileClusterGroups();
    }

    private final Pair<Boolean, String> isRelevant(VisualComponent component) {
        Element ele = component.getElement();
        VisualComponent c = component;
        return ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isGrouped((Node)((Node)ele)) ? TuplesKt.to((Object)false, (Object)"GROUPED") : (c.isDisabled() ? TuplesKt.to((Object)false, (Object)"DISABLED") : (this.options.getNoSubTable() && c.hasParent() ? TuplesKt.to((Object)false, (Object)"SUB_TABLE") : TuplesKt.to((Object)true, (Object)"")));
    }

    private final CheckState hasAcceptableRecall(List<? extends Element> components) {
        int n;
        int a = components.size();
        double r = 1.0 * (double)a / (double)(n = this.documents.size());
        int code = r >= 0.5 && r < 2.0 ? 0 : 1;
        return new CheckState(code, String.valueOf(r), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterTilesInUniquePathComponentSets() {
        NavigableMap navigableMap = this.uniquePathComponents.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"uniquePathComponents.asMap()");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            void $this$mapNotNullTo$iv;
            Map.Entry element$iv2;
            Map.Entry $dstr$path$components = element$iv2 = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$path$components;
            boolean bl3 = false;
            String path = (String)entry.getKey();
            Map.Entry entry2 = $dstr$path$components;
            boolean bl4 = false;
            Collection components = (Collection)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)components, (String)"components");
            Iterable iterable = components;
            Collection destination$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            String $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Element element;
                Object element$iv$iv;
                element$iv = element$iv$iv = iterator2.next();
                boolean bl5 = false;
                VisualComponent c = (VisualComponent)element$iv;
                boolean bl6 = false;
                Element element2 = c.getElement();
                boolean bl7 = false;
                boolean bl8 = false;
                Element it = element2;
                boolean bl9 = false;
                Intrinsics.checkNotNullExpressionValue((Object)c, (String)"c");
                if ((((Boolean)this.isRelevant(c).getFirst()).booleanValue() ? element2 : null) == null) continue;
                element = element;
                boolean bl10 = false;
                boolean bl11 = false;
                Element it$iv = element;
                boolean bl12 = false;
                destination$iv.add(it$iv);
            }
            ArrayList relevant = (ArrayList)destination$iv;
            if (this.hasAcceptableRecall(relevant).isOK()) {
                int sz = relevant.size();
                Element sample = (Element)CollectionsKt.first((List)relevant);
                String name = NodeExtKt.getName((Node)((Node)sample)) + "[" + sz + "][U]";
                $this$forEach$iv$iv = sample.nodeName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"sample.nodeName()");
                if (!StringsKt.startsWith$default((String)name, (String)$this$forEach$iv$iv, (boolean)false, (int)2, null)) {
                    name = sample.nodeName() + name;
                }
                String taskName = StringUtils.abbreviateMiddle((String)name, (String)"..", (int)30);
                Intrinsics.checkNotNullExpressionValue((Object)taskName, (String)"taskName");
                this.clusterTiles(taskName, relevant);
                continue;
            }
            if (!this.taskLogger.isInfoEnabled()) continue;
            Object[] sz = new Object[]{path, relevant.size(), components.size(), this.getDocuments().size()};
            this.taskLogger.info("Path component set {{}} is ill-analysable, {}/{}/{} (relevant/components/documents)", sz);
            Iterable $this$map$iv = components;
            boolean $i$f$map = false;
            Iterable name = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv = (VisualComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl13 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Pair pair = TuplesKt.to((Object)it, this.isRelevant((VisualComponent)it));
                collection.add(pair);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterNonUniquePathComponents() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Object v0;
        Function1 predicate2 = (Function1)new Function1<VisualComponent, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VisualComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !it.getHasUniquePath() && (Boolean)NodeClusterRunner.access$isRelevant(this.this$0, it).getFirst() != false;
            }
        };
        Iterable $this$maxByOrNull$iv = this.documents;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                int n;
                VisualDocument it = (VisualDocument)maxElem$iv;
                boolean bl = false;
                Iterable $this$count$iv = it.getComponents();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                        int n2 = ++count$iv;
                        boolean bl2 = false;
                        if (n2 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int maxValue$iv = n;
                do {
                    int v$iv;
                    int n3;
                    Iterator<Object> e$iv = iterator$iv.next();
                    VisualDocument it2 = (VisualDocument)e$iv;
                    visualComponent = false;
                    Iterable $this$count$iv2 = it2.getComponents();
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        n3 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            if (!((Boolean)predicate2.invoke(element$iv)).booleanValue()) continue;
                            int n4 = ++count$iv;
                            boolean bl3 = false;
                            if (n4 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n3 = count$iv;
                    }
                    if (maxValue$iv >= (v$iv = n3)) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        VisualDocument visualDocument = v0;
        if (visualDocument == null) {
            return;
        }
        VisualDocument seedDocument = visualDocument;
        Iterable $this$filter$iv = seedDocument.getComponents();
        boolean $i$f$filter = false;
        iterator$iv = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualComponent visualComponent = (VisualComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Element element = it.getElement();
            collection.add(element);
        }
        List seedNodes = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv2;
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = it.getComponents();
            boolean $i$f$filter2 = false;
            Iterable element$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                if (!((Boolean)predicate2.invoke(element$iv$iv2)).booleanValue()) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                VisualComponent visualComponent = (VisualComponent)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl4 = false;
                Element element = it3.getElement();
                collection.add(element);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List nodes2 = (List)destination$iv$iv2;
        CheckState status = this.hasAcceptableRecall(nodes2);
        if (status.isNotOK()) {
            this.logger.info("No acceptable recall (" + status.getMessage() + ")");
        }
        NodeClusterGroup clusterGroup = this.clusterComponents(seedNodes, nodes2);
        this.reportComponentClusters(nodes2, (ComponentClusterGroup)clusterGroup);
        clusterGroup = ((ComponentClusterGroup)clusterGroup).filter((Function1)new Function1<ComponentCluster, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ComponentCluster it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isNotEmpty() && it.getPointRecall() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPointRecall();
            }
        });
        if (clusterGroup.isNotEmpty()) {
            this.componentClusterGroups.add((ComponentClusterGroup)clusterGroup);
        }
    }

    private final ComponentClusterGroup clusterComponents(List<? extends Element> seedNodes, List<? extends Element> nodes2) {
        Function2 mustLink2 = clusterComponents.mustLink.1.INSTANCE;
        Function2 cannotLink2 = clusterComponents.cannotLink.1.INSTANCE;
        int n = this.documents.size();
        ConstraintViolationPolicy constraintViolationPolicy = ConstraintViolationPolicy.ABANDON;
        int n2 = this.conf.getInt("scent.cluster.page.component.nodes.max.iteration", 5);
        SKMOptions skmOptions = new SKMOptions(false, false, n, constraintViolationPolicy, false, mustLink2, cannotLink2, n2, 0, 1, null, 1296, null);
        ComponentClusterGroup clusterGroup = this.runKmeansForComponents("(Root)", nodes2, seedNodes, skmOptions);
        if (!this.options.getAllowOutliers()) {
            clusterGroup = clusterGroup.removeOutliers();
        }
        return clusterGroup;
    }

    private final void reportComponentClusters(List<? extends Element> nodes2, ComponentClusterGroup clusterGroup) {
        if (clusterGroup.isEmpty()) {
            return;
        }
        Ref.ObjectRef message2 = new Ref.ObjectRef();
        message2.element = "Total " + nodes2.size() + " components are clustered into " + clusterGroup.getSize() + " clusters: ";
        this.log((String)message2.element);
        clusterGroup.forEach((Function1)new Function1<ComponentCluster, Unit>(this, (Ref.ObjectRef<String>)message2){
            final /* synthetic */ NodeClusterRunner this$0;
            final /* synthetic */ Ref.ObjectRef<String> $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull ComponentCluster cluster2) {
                Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
                boolean ignore = cluster2.getPointRecall() < NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPointRecall();
                String mark = ignore ? "\u2718" : "\u2714";
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "%-2s%3d(%-3d estimated) components are grouped into cluster #%-3d, names: %s";
                Object[] objectArray = new Object[]{mark, cluster2.getPoints().size(), cluster2.getEstimatedNodes().size(), cluster2.getLabel(), cluster2.getNames()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                this.$message.element = string2;
                NodeClusterRunner.access$log(this.this$0, (String)this.$message.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterTiles(String taskName, List<? extends Element> components) {
        Object v0;
        Iterator $this$mapTo$iv$iv;
        Function1 predicate2 = clusterTiles.predicate.1.INSTANCE;
        Iterable $this$map$iv = components;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$onEach$iv;
            void $this$collectIfTo$iv$iv;
            void destination$iv$iv2;
            void component;
            Object item$iv$iv = iterator.next();
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object $this$collectIf$iv = (Node)component;
            boolean $i$f$collectIf = false;
            Node node = $this$collectIf$iv;
            boolean bl2 = false;
            Collection collection2 = new ArrayList();
            boolean $i$f$collectIfTo = false;
            NodeTraversor.traverse((NodeVisitor)new NodeVisitor((Collection)destination$iv$iv2, predicate2){
                final /* synthetic */ Collection $destination;
                final /* synthetic */ Function1 $predicate$inlined;
                {
                    this.$destination = $destination;
                    this.$predicate$inlined = function1;
                }

                public final void head(@NotNull Node node, int $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Node it = node;
                    boolean bl = false;
                    if (((Boolean)this.$predicate$inlined.invoke((Object)it)).booleanValue()) {
                        this.$destination.add(node);
                    }
                }
            }, (Node)$this$collectIfTo$iv$iv);
            $this$collectIf$iv = (List)destination$iv$iv2;
            boolean $i$f$onEach = false;
            node = $this$onEach$iv;
            bl2 = false;
            boolean bl3 = false;
            Node $this$apply$iv = node;
            boolean bl4 = false;
            for (Object element$iv : $this$apply$iv) {
                Node it = (Node)element$iv;
                boolean bl5 = false;
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setOwnerComponent((Node)it, (Element)component);
                CalculatorUtils.INSTANCE.updateRegionalFeatures(it);
            }
            List list = (List)node;
            collection.add(list);
        }
        List nodeFamilies = (List)destination$iv$iv;
        if (this.options.getDiagnose()) {
            Iterable $this$forEach$iv = components;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
            }
        }
        Iterable $this$maxByOrNull$iv = nodeFamilies;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                List it = (List)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.size();
                do {
                    Object e$iv = iterator$iv.next();
                    List it2 = (List)e$iv;
                    $i$a$-maxByOrNull-NodeClusterRunner$clusterTiles$seedNodes$1 = false;
                    int v$iv = it2.size();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        List $i$f$forEach = v0;
        if ($i$f$forEach == null) {
            return;
        }
        List seedNodes = $i$f$forEach;
        List nodes2 = CollectionsKt.flatten((Iterable)nodeFamilies);
        this.clusterTiles(taskName, components, seedNodes, nodes2);
    }

    private final void clusterTiles(String taskName, List<? extends Element> components, List<? extends Node> seedNodes, List<? extends Node> nodes2) {
        int maxEpochs = this.conf.getInt("scent.cluster.nodes.max.iteration", 5);
        List<SKMOptions> parameterGrid = this.generateParameterGrid(seedNodes.size(), maxEpochs);
        TileClusterGroup clusterGroups = this.runKmeansForTiles(taskName, components, nodes2, seedNodes, parameterGrid);
        if (clusterGroups.isNotEmpty()) {
            this.tileClusterGroups.add(clusterGroups);
        }
    }

    private final List<SKMOptions> generateParameterGrid(int numSeeds, int maxEpochs) {
        boolean $i$f$forEach;
        boolean bl = false;
        List grid = new ArrayList();
        if (this.options.getSearchParameterSpace()) {
            Boolean[] booleanArray = new Boolean[]{false, true};
            Boolean[] $this$forEach$iv = booleanArray;
            $i$f$forEach = false;
            for (Boolean element$iv : $this$forEach$iv) {
                boolean mustLink2 = element$iv;
                boolean bl2 = false;
                Boolean[] booleanArray2 = new Boolean[]{false, true};
                Boolean[] $this$forEach$iv2 = booleanArray2;
                boolean $i$f$forEach2 = false;
                for (Boolean element$iv2 : $this$forEach$iv2) {
                    boolean cannotLink2 = element$iv2;
                    boolean bl3 = false;
                    Integer[] integerArray = new Integer[]{numSeeds * 10, numSeeds};
                    Integer[] $this$forEach$iv3 = integerArray;
                    boolean $i$f$forEach3 = false;
                    for (Integer element$iv3 : $this$forEach$iv3) {
                        int capacity = ((Number)element$iv3).intValue();
                        boolean bl4 = false;
                        ConstraintViolationPolicy[] constraintViolationPolicyArray = new ConstraintViolationPolicy[]{ConstraintViolationPolicy.ABANDON, ConstraintViolationPolicy.DECAY};
                        ConstraintViolationPolicy[] $this$forEach$iv4 = constraintViolationPolicyArray;
                        boolean $i$f$forEach4 = false;
                        ConstraintViolationPolicy[] constraintViolationPolicyArray2 = $this$forEach$iv4;
                        int n = constraintViolationPolicyArray2.length;
                        for (int i = 0; i < n; ++i) {
                            ConstraintViolationPolicy element$iv4;
                            ConstraintViolationPolicy violation = element$iv4 = constraintViolationPolicyArray2[i];
                            boolean bl5 = false;
                            SKMOptions opt = new SKMOptions(mustLink2, cannotLink2, capacity, violation, false, null, null, 0, 0, 0, null, 2032, null);
                            grid.add(opt);
                        }
                    }
                }
            }
        } else {
            grid.add(new SKMOptions(false, false, numSeeds * 10, ConstraintViolationPolicy.ABANDON, false, null, null, 0, 0, 0, null, 2032, null));
        }
        Iterable $this$forEach$iv = grid;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SKMOptions it = (SKMOptions)element$iv;
            boolean bl6 = false;
            it.setMaxEpochs(maxEpochs);
            it.setPolysemous(this.options.getPolysemous());
        }
        return grid;
    }

    /*
     * WARNING - void declaration
     */
    private final ComponentClusterGroup runKmeansForComponents(String taskName, List<? extends Element> nodes2, List<? extends Element> seedNodes, SKMOptions skmOptions) {
        void $this$filterTo$iv$iv;
        ClusterSensitiveComponentEncoder encoder = new ClusterSensitiveComponentEncoder(skmOptions.getNGram(), this.options.getPcaRate(), 0, 4, null);
        ArrayList<NodePoint> points = encoder.encode(nodes2);
        Iterable $this$filter$iv = points;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodePoint it = (NodePoint)((Object)element$iv$iv);
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)seedNodes, (Object)it.getNode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initCenters = (List)destination$iv$iv;
        SemiKMeans clusterer = new SemiKMeans(points, initCenters, Reflection.getOrCreateKotlinClass(ComponentCluster.class), null, skmOptions, 8, null);
        ComponentClusterGroup clusterGroup = new ComponentClusterGroup(taskName, clusterer.cluster(), this.documents, this.options);
        return clusterGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final TileClusterGroup runKmeansForTiles(String taskName, List<? extends Element> components, List<? extends Node> nodes2, List<? extends Node> seedNodes, List<SKMOptions> parameterGrid) {
        void $this$filterTo$iv$iv;
        if (parameterGrid.isEmpty() || components.isEmpty() || nodes2.isEmpty() || seedNodes.isEmpty()) {
            return TileClusterGroup.Companion.getEMPTY();
        }
        Instant start = Instant.now();
        List distinctNodes = CollectionsKt.distinct((Iterable)nodes2);
        int numDuplicateNodes = nodes2.size() - distinctNodes.size();
        if (numDuplicateNodes > 0) {
            this.taskLogger.debug(numDuplicateNodes + " duplicate nodes are removed before clustering");
        }
        ClusterSensitiveComponentEncoder encoder = new ClusterSensitiveComponentEncoder(this.options.getNGram(), this.options.getPcaRate(), 0, 4, null);
        ArrayList<NodePoint> points = encoder.encode(distinctNodes);
        Iterable $this$filter$iv = points;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodePoint it = (NodePoint)((Object)element$iv$iv);
            boolean bl = false;
            if (!seedNodes.contains(it.getNode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initCenters = (List)destination$iv$iv;
        SemiKMeans clusterer = null;
        NodeClusterGroup clusterGroup = TileClusterGroup.Companion.getEMPTY();
        double minDistortion = Double.MAX_VALUE;
        double minPathDistortion = Double.MAX_VALUE;
        double minPidDistortion = Double.MAX_VALUE;
        boolean bl = false;
        List distortions = new ArrayList();
        SKMOptions bestOptions = SKMOptions.Companion.getDefault();
        boolean preferPathDistortion = LangKt.alwaysFalse();
        boolean moreDistortion = LangKt.alwaysFalse();
        Iterator<SKMOptions> it = parameterGrid.iterator();
        do {
            double pidDistortion2;
            clusterer = new SemiKMeans(points, initCenters, Reflection.getOrCreateKotlinClass(TileCluster.class), null, it.next(), 8, null);
            TileClusterGroup group = new TileClusterGroup(taskName, clusterer.cluster(), this.documents, components, this.options);
            double distortion22 = group.getDistortion();
            distortions.add(distortion22);
            if (distortion22 < minDistortion) {
                minDistortion = distortion22;
                bestOptions = clusterer.getOptions();
                clusterGroup = group;
            }
            if (!moreDistortion) continue;
            double pathDistortion2 = group.getPathDistortion();
            if (pathDistortion2 < minPathDistortion) {
                minPathDistortion = pathDistortion2;
                if (preferPathDistortion) {
                    bestOptions = clusterer.getOptions();
                    clusterGroup = group;
                }
            }
            if (!(minPidDistortion < (pidDistortion2 = group.getPidDistortion()))) continue;
            minPidDistortion = pidDistortion2;
        } while (it.hasNext());
        if (!this.options.getPolysemous()) {
            clusterGroup = ((TileClusterGroup)clusterGroup).removePolysemousPoints();
        }
        clusterGroup.estimate();
        clusterGroup = ((TileClusterGroup)clusterGroup).filter((Function1)new Function1<TileCluster, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileCluster it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getConfuseMatrix().getRecall() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumRecall() && it.getConfuseMatrix().getPrecision() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPrecision();
            }
        });
        if (clusterGroup.isEmpty()) {
            this.taskLogger.warn(taskName + " has no proper clusters");
            return clusterGroup;
        }
        boolean distortion22 = false;
        Set locations2 = new LinkedHashSet();
        ((TileClusterGroup)clusterGroup).forEach((Function1<? super TileCluster, Unit>)((Function1)new Function1<TileCluster, Unit>((Set<String>)locations2){
            final /* synthetic */ Set<String> $locations;
            {
                this.$locations = $locations;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TileCluster cluster2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
                Iterable iterable = cluster2.getPoints();
                Set<String> set = this.$locations;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl = false;
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setClusterId((Node)it.getNode(), (int)cluster2.getLabel());
                    set.add(NodeExtKt.getLocation((Node)it.getNode()));
                }
            }
        }));
        clusterGroup.estimate();
        this.status.setTotalDocuments(this.documents.size());
        this.status.setTotalDocumentRecall(locations2.size());
        ClusterTaskStatus distortion22 = this.status;
        distortion22.setTotalNodes(distortion22.getTotalNodes() + nodes2.size());
        distortion22 = this.status;
        distortion22.setTotalEpochs(distortion22.getTotalEpochs() + clusterer.getEpochs());
        distortion22 = this.status;
        distortion22.setTotalClusters(distortion22.getTotalClusters() + clusterGroup.getSize());
        distortion22 = this.status;
        distortion22.setTotalDistortion(distortion22.getTotalDistortion() + minDistortion);
        ConfuseMatrix metrics = clusterGroup.getConfuseMatrix();
        this.status.getConfuseMatrix().accumulate(clusterGroup.getConfuseMatrix());
        clusterGroup.setClusterTaskStatus(this.status);
        Rectangle rectangle = NodeExtKt.getRectangle((Node)((Node)CollectionsKt.first(components)));
        int x = GeometricsKt.component1((Rectangle)rectangle);
        int y = GeometricsKt.component2((Rectangle)rectangle);
        int w = GeometricsKt.component3((Rectangle)rectangle);
        int h2 = GeometricsKt.component4((Rectangle)rectangle);
        Duration elapsed = Duration.between(start, Instant.now());
        String mark = clusterGroup.isConstant() ? "\u2716" : (clusterGroup.getNumFineVariables() >= 5 && clusterGroup.getFineVariableRate() > 0.9 ? "\u2714\u2714\u2714\u2714\u2714 \ud83d\udcaf" : (clusterGroup.getNumFineVariables() >= 5 && clusterGroup.getFineVariableRate() > 0.8 ? "\u2714\u2714\u2714\u2714" : (clusterGroup.getNumFineVariables() > 0 && metrics.getF1() > 0.9 ? "\u2714\u2714\u2714" : (clusterGroup.getNumFineVariables() > 0 && metrics.getF1() > 0.8 ? "\u2714\u2714" : (metrics.getF1() > 0.8 ? "\u2714" : " ")))));
        DataTypeStatistics ds = clusterGroup.getDataTypeStatistics();
        String string = StringUtils.abbreviateMiddle((String)taskName, (String)"..", (int)35);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abbreviateMiddle(taskName, \"..\", 35)");
        String string2 = string;
        int n = (int)((TileClusterGroup)clusterGroup).getSqrtArea();
        int n2 = seedNodes.size();
        int n3 = distinctNodes.size();
        int n4 = ds.getNumLazy();
        int n5 = ds.getNumImages();
        int n6 = clusterer.getEpochs();
        Intrinsics.checkNotNullExpressionValue((Object)elapsed, (String)"elapsed");
        double d = metrics.getRecall();
        double d2 = metrics.getPrecision();
        double d3 = metrics.getF1();
        string = ((TileClusterGroup)clusterGroup).getScore().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clusterGroup.score.toString()");
        clusterGroup.setMetrics(new NodeClusterGroupMetrics(string2, x, y, w, h2, n, n2, n3, n4, n5, n6, elapsed, minDistortion, d, d2, d3, string, clusterGroup.getNumFields(), clusterGroup.getNumFineFields(), clusterGroup.getFineFieldRate(), ds.getNumConstants(), ds.getNumVariables(), clusterGroup.getNumFineVariables(), clusterGroup.getFineVariableRate(), mark));
        if (parameterGrid.size() > 1) {
            SKMOptions op = bestOptions;
            String distortionString2 = CollectionsKt.joinToString$default((Iterable)distortions, null, null, null, (int)0, null, (Function1)runKmeansForTiles.distortionString.1.INSTANCE, (int)31, null);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%-15s- distortions: %s\tbest options: (m:%b, c:%b, cap:%d, %s)";
            Object[] objectArray = new Object[]{taskName, distortionString2, op.getEnableMustLinks(), op.getEnableCannotLinks(), op.getCapacity(), op.getConstraintViolationPolicy()};
            boolean bl2 = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            String message2 = string4;
            this.log(message2);
        }
        if (LangKt.alwaysTrue() && this.taskLogger.isDebugEnabled()) {
            void $this$mapTo$iv;
            Iterable $this$forEach$iv = ((TileClusterGroup)clusterGroup).getComponents();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it2 = (Element)element$iv;
                boolean bl3 = false;
                this.taskLogger.debug("Components in tile cluster group: " + NodeExtKt.getNamedRect((Node)((Node)it2)));
            }
            Iterable $i$f$forEach22 = clusterGroup.getConfuseMatrices();
            Collection destination$iv = (Collection)new Frequency(null, 1, null);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)item$iv;
                Collection collection = destination$iv;
                boolean bl4 = false;
                Long l = MathKt.roundToLong((double)(it3.getF1() * (double)100)) / (long)5 * (long)5;
                collection.add(l);
            }
            Frequency f1s = (Frequency)destination$iv;
            this.taskLogger.debug(Frequency.toPString$default((Frequency)f1s, (String)"probabilities of f1 values:\t", null, null, (int)6, null));
        }
        return clusterGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.reportWriter;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object object;
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl3 = false;
            it.newLine();
            it.flush();
            BufferedWriter bufferedWriter = it;
            boolean bl4 = false;
            try {
                object = Result.Companion;
                BufferedWriter $this$close_u24lambda_u2d25_u24lambda_u2d23 = bufferedWriter;
                boolean bl5 = false;
                it.close();
                Unit unit = Unit.INSTANCE;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable2) {
                Result.Companion companion = Result.Companion;
                boolean bl7 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            bufferedWriter = object;
            bl4 = false;
            boolean bl8 = false;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)bufferedWriter);
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                boolean bl9 = false;
                boolean bl10 = false;
                Throwable throwable5 = throwable4;
                boolean bl11 = false;
                Throwable it2 = throwable5;
                boolean bl12 = false;
                this.logger.warn(it2.getMessage());
            }
            BufferedWriter bufferedWriter2 = bufferedWriter;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.componentClusterGroups.clear();
        this.tileClusterGroups.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportTileClusterGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tileClusterGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileClusterGroup tileClusterGroup = (TileClusterGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            NodeClusterGroupMetrics nodeClusterGroupMetrics = it.getMetrics();
            collection.add(nodeClusterGroupMetrics);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        List metrics = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                NodeClusterGroupMetrics it = (NodeClusterGroupMetrics)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getScore());
                it = (NodeClusterGroupMetrics)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getScore();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        SimpleResultSet rs = NodeClusterGroupMetrics.Companion.toResultSet(metrics);
        this.log(this.status + "\n" + new ResultSetFormatter((ResultSet)rs, false, true, false, null, 26, null));
    }

    private final void log(String message2) {
        this.reportWriter.write(message2);
        this.reportWriter.newLine();
        this.taskLogger.info(message2);
    }

    private final TileCluster removePolysemousPoints(TileCluster cluster2) {
        boolean bl = false;
        List uniquePoints = new ArrayList();
        cluster2.getPagePoints().forEach((arg_0, arg_1) -> NodeClusterRunner.removePolysemousPoints$lambda-29(uniquePoints, arg_0, arg_1));
        cluster2.getPoints().clear();
        cluster2.getPoints().addAll(uniquePoints);
        return cluster2;
    }

    private static final void removePolysemousPoints$lambda-29(List $uniquePoints, Integer pid, List points) {
        Intrinsics.checkNotNullParameter((Object)$uniquePoints, (String)"$uniquePoints");
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        if (points.size() > 1) {
            Iterable $this$sortedBy$iv = points;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            List sortedPoints = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    NodePoint it = (NodePoint)((Object)a);
                    boolean bl2 = false;
                    Comparable comparable = Double.valueOf(it.getCentroidDistance());
                    it = (NodePoint)((Object)b);
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = it.getCentroidDistance();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            });
            $uniquePoints.add(CollectionsKt.first((List)sortedPoints));
        } else {
            $uniquePoints.add(CollectionsKt.first((List)points));
        }
    }

    public static final /* synthetic */ Pair access$isRelevant(NodeClusterRunner $this, VisualComponent component) {
        return $this.isRelevant(component);
    }

    public static final /* synthetic */ HarvestOptions access$getOptions$p(NodeClusterRunner $this) {
        return $this.options;
    }

    public static final /* synthetic */ void access$log(NodeClusterRunner $this, String message2) {
        $this.log(message2);
    }

    public static final /* synthetic */ void access$clusterTiles(NodeClusterRunner $this, String taskName, List components) {
        $this.clusterTiles(taskName, components);
    }
}

