/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.ml.MathsKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001$B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J*\u0010\n\u001a\u00060\tR\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J7\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0016JU\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\tR\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u00020\u000f2\n\u0010\u0018\u001a\u00060\tR\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J;\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lai/platon/scent/ml/unsupervised/BBDTree;", "", "points", "", "Lorg/apache/commons/math3/linear/RealVector;", "(Ljava/util/List;)V", "index", "", "root", "Lai/platon/scent/ml/unsupervised/BBDTree$Node;", "buildNode", "begin", "", "end", "cluster", "", "centroids", "", "", "sums", "counts", "assignmentMap", "([[D[[D[I[I)D", "filter", "node", "candidates", "k", "(Lai/platon/scent/ml/unsupervised/BBDTree$Node;[[D[II[[D[I[I)D", "getNodeCost", "center", "prune", "", "radius", "bestIndex", "testIndex", "([D[D[[DII)Z", "Node", "scent-auto-mining"})
public final class BBDTree {
    @NotNull
    private final Node root;
    @NotNull
    private final int[] index;

    public BBDTree(@NotNull List<? extends RealVector> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        int n = points.size();
        this.index = new int[n];
        int n2 = 0;
        if (n2 < n) {
            do {
                int i;
                this.index[i] = i = n2++;
            } while (n2 < n);
        }
        this.root = this.buildNode(points, 0, n);
    }

    private final Node buildNode(List<? extends RealVector> points, int begin, int end) {
        int temp;
        int j;
        int dimension = points.get(0).getDimension();
        Node node = new Node(dimension);
        node.setCount(end - begin);
        node.setIndex(begin);
        RealVector point = points.get(this.index[begin]);
        ArrayRealVector lowerBound = new ArrayRealVector(point);
        ArrayRealVector upperBound = new ArrayRealVector(point);
        int n = begin + 1;
        if (n < end) {
            do {
                int i = n++;
                point = points.get(this.index[i]);
                int n2 = 0;
                if (n2 >= dimension) continue;
                do {
                    j = n2++;
                    double xj = VectorsKt.get((RealVector)point, (int)j);
                    if (VectorsKt.get((RealVector)((RealVector)lowerBound), (int)j) > xj) {
                        VectorsKt.set((RealVector)((RealVector)lowerBound), (int)j, (double)xj);
                    }
                    if (!(VectorsKt.get((RealVector)((RealVector)upperBound), (int)j) < xj)) continue;
                    VectorsKt.set((RealVector)((RealVector)upperBound), (int)j, (double)xj);
                } while (n2 < dimension);
            } while (n < end);
        }
        double maxRadius = -1.0;
        int splitIndex = -1;
        j = 0;
        if (j < dimension) {
            do {
                int i = j++;
                VectorsKt.set((RealVector)((RealVector)node.getCenter()), (int)i, (double)((VectorsKt.get((RealVector)((RealVector)lowerBound), (int)i) + VectorsKt.get((RealVector)((RealVector)upperBound), (int)i)) / (double)2));
                VectorsKt.set((RealVector)((RealVector)node.getRadius()), (int)i, (double)((VectorsKt.get((RealVector)((RealVector)upperBound), (int)i) - VectorsKt.get((RealVector)((RealVector)lowerBound), (int)i)) / (double)2));
                if (!(VectorsKt.get((RealVector)((RealVector)node.getRadius()), (int)i) > maxRadius)) continue;
                maxRadius = VectorsKt.get((RealVector)((RealVector)node.getRadius()), (int)i);
                splitIndex = i;
            } while (j < dimension);
        }
        if (maxRadius < 1.0E-10) {
            node.setUpper(null);
            node.setLower(node.getUpper());
            System.arraycopy(points.get(this.index[begin]), 0, node.getSum(), 0, dimension);
            if (end > begin + 1) {
                int len = end - begin;
                int n3 = 0;
                if (n3 < dimension) {
                    do {
                        int i = n3++;
                        ArrayRealVector arrayRealVector = node.getSum();
                        int n4 = i;
                        VectorsKt.set((RealVector)((RealVector)arrayRealVector), (int)n4, (double)(VectorsKt.get((RealVector)((RealVector)arrayRealVector), (int)n4) * (double)len));
                    } while (n3 < dimension);
                }
            }
            node.setCost(0.0);
            return node;
        }
        double splitCutoff = VectorsKt.get((RealVector)((RealVector)node.getCenter()), (int)splitIndex);
        int i1 = begin;
        int i2 = end - 1;
        int size = 0;
        while (i1 <= i2) {
            boolean i2Good;
            boolean i1Good = VectorsKt.get((RealVector)points.get(this.index[i1]), (int)splitIndex) < splitCutoff;
            boolean bl = i2Good = VectorsKt.get((RealVector)points.get(this.index[i2]), (int)splitIndex) >= splitCutoff;
            if (!i1Good && !i2Good) {
                temp = this.index[i1];
                this.index[i1] = this.index[i2];
                this.index[i2] = temp;
                i1Good = i2Good = true;
            }
            if (i1Good) {
                temp = i1;
                i1 = temp + 1;
                temp = size;
                size = temp + 1;
            }
            if (!i2Good) continue;
            temp = i2;
            i2 = temp + -1;
        }
        node.setLower(this.buildNode(points, begin, begin + size));
        node.setUpper(this.buildNode(points, begin + size, end));
        Node node2 = node.getLower();
        Intrinsics.checkNotNull((Object)node2);
        Node lower = node2;
        Node node3 = node.getUpper();
        Intrinsics.checkNotNull((Object)node3);
        Node upper = node3;
        temp = 0;
        if (temp < dimension) {
            do {
                int i = temp++;
                VectorsKt.set((RealVector)((RealVector)node.getSum()), (int)i, (double)(VectorsKt.get((RealVector)((RealVector)lower.getSum()), (int)i) + VectorsKt.get((RealVector)((RealVector)upper.getSum()), (int)i)));
            } while (temp < dimension);
        }
        double[] mean = new double[dimension];
        int n5 = 0;
        if (n5 < dimension) {
            do {
                int i = n5++;
                mean[i] = VectorsKt.get((RealVector)((RealVector)node.getSum()), (int)i) / (double)node.getCount();
            } while (n5 < dimension);
        }
        node.setCost(this.getNodeCost(lower, mean) + this.getNodeCost(upper, mean));
        return node;
    }

    private final double getNodeCost(Node node, double[] center) {
        int d = center.length;
        double scatter = 0.0;
        int n = 0;
        if (n < d) {
            do {
                int i = n++;
                double x = VectorsKt.get((RealVector)((RealVector)node.getSum()), (int)i) / (double)node.getCount() - center[i];
                scatter += x * x;
            } while (n < d);
        }
        return node.getCost() + (double)node.getCount() * scatter;
    }

    public final double cluster(@NotNull double[][] centroids, @NotNull double[][] sums, @NotNull int[] counts, @NotNull int[] assignmentMap) {
        Intrinsics.checkNotNullParameter((Object)centroids, (String)"centroids");
        Intrinsics.checkNotNullParameter((Object)sums, (String)"sums");
        Intrinsics.checkNotNullParameter((Object)counts, (String)"counts");
        Intrinsics.checkNotNullParameter((Object)assignmentMap, (String)"assignmentMap");
        int k = ((Object[])centroids).length;
        Arrays.fill(counts, 0);
        int[] candidates = new int[k];
        int n = 0;
        if (n < k) {
            do {
                int i;
                candidates[i] = i = n++;
                Arrays.fill(sums[i], 0.0);
            } while (n < k);
        }
        return this.filter(this.root, centroids, candidates, k, sums, counts, assignmentMap);
    }

    private final double filter(Node node, double[][] centroids, int[] candidates, int k, double[][] sums, int[] counts, int[] assignmentMap) {
        int newCandidates22;
        double[] dArray;
        int i;
        int d = centroids[0].length;
        double[] dArray2 = node.getCenter().getDataRef();
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"node.center.dataRef");
        double minDist = MathsKt.squaredDistance(dArray2, centroids[candidates[0]]);
        int closest = candidates[0];
        int n = 1;
        if (n < k) {
            do {
                i = n++;
                dArray = node.getCenter().getDataRef();
                Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"node.center.dataRef");
                double dist = MathsKt.squaredDistance(dArray, centroids[candidates[i]]);
                if (!(dist < minDist)) continue;
                minDist = dist;
                closest = candidates[i];
            } while (n < k);
        }
        if (node.getLower() != null) {
            int[] newCandidates22 = new int[k];
            int newk = 0;
            int dist = 0;
            if (dist < k) {
                do {
                    int i2 = dist++;
                    dArray = node.getCenter().getDataRef();
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"node.center.dataRef");
                    double[] dArray3 = dArray;
                    dArray = node.getRadius().getDataRef();
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"node.radius.dataRef");
                    if (this.prune(dArray3, dArray, centroids, closest, candidates[i2])) continue;
                    int n2 = newk;
                    newk = n2 + 1;
                    newCandidates22[n2] = candidates[i2];
                } while (dist < k);
            }
            if (newk > 1) {
                Node node2 = node.getLower();
                Intrinsics.checkNotNull((Object)node2);
                double d2 = this.filter(node2, centroids, newCandidates22, newk, sums, counts, assignmentMap);
                Node node3 = node.getUpper();
                Intrinsics.checkNotNull((Object)node3);
                return d2 + this.filter(node3, centroids, newCandidates22, newk, sums, counts, assignmentMap);
            }
        }
        if ((newCandidates22 = 0) < d) {
            do {
                i = newCandidates22++;
                double[] dist = sums[closest];
                int n3 = i;
                dist[n3] = dist[n3] + VectorsKt.get((RealVector)((RealVector)node.getSum()), (int)i);
            } while (newCandidates22 < d);
        }
        int[] newCandidates22 = counts;
        int n4 = closest;
        newCandidates22[n4] = newCandidates22[n4] + node.getCount();
        int last = node.getIndex() + node.getCount();
        n4 = node.getIndex();
        if (n4 < last) {
            do {
                int i3 = n4++;
                assignmentMap[this.index[i3]] = closest;
            } while (n4 < last);
        }
        return this.getNodeCost(node, centroids[closest]);
    }

    private final boolean prune(double[] center, double[] radius, double[][] centroids, int bestIndex, int testIndex) {
        if (bestIndex == testIndex) {
            return false;
        }
        int d = centroids[0].length;
        double[] best = centroids[bestIndex];
        double[] test = centroids[testIndex];
        double lhs = 0.0;
        double rhs = 0.0;
        int n = 0;
        if (n < d) {
            do {
                int i = n++;
                double diff = test[i] - best[i];
                lhs += diff * diff;
                if (diff > 0.0) {
                    rhs += (center[i] + radius[i] - best[i]) * diff;
                    continue;
                }
                rhs += (center[i] - radius[i] - best[i]) * diff;
            } while (n < d);
        }
        return lhs >= (double)2 * rhs;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R \u0010\u0019\u001a\b\u0018\u00010\u0000R\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR\u001a\u0010\"\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR \u0010%\u001a\b\u0018\u00010\u0000R\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e\u00a8\u0006("}, d2={"Lai/platon/scent/ml/unsupervised/BBDTree$Node;", "", "dimension", "", "(Lai/platon/scent/ml/unsupervised/BBDTree;I)V", "center", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "getCenter", "()Lorg/apache/commons/math3/linear/ArrayRealVector;", "setCenter", "(Lorg/apache/commons/math3/linear/ArrayRealVector;)V", "cost", "", "getCost", "()D", "setCost", "(D)V", "count", "getCount", "()I", "setCount", "(I)V", "index", "getIndex", "setIndex", "lower", "Lai/platon/scent/ml/unsupervised/BBDTree;", "getLower", "()Lai/platon/scent/ml/unsupervised/BBDTree$Node;", "setLower", "(Lai/platon/scent/ml/unsupervised/BBDTree$Node;)V", "radius", "getRadius", "setRadius", "sum", "getSum", "setSum", "upper", "getUpper", "setUpper", "scent-auto-mining"})
    public final class Node {
        private int count;
        private int index;
        @NotNull
        private ArrayRealVector center;
        @NotNull
        private ArrayRealVector radius;
        @NotNull
        private ArrayRealVector sum;
        private double cost;
        @Nullable
        private Node lower;
        @Nullable
        private Node upper;

        public Node(int dimension) {
            Intrinsics.checkNotNullParameter((Object)BBDTree.this, (String)"this$0");
            this.center = new ArrayRealVector(dimension);
            this.radius = new ArrayRealVector(dimension);
            this.sum = new ArrayRealVector(dimension);
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @NotNull
        public final ArrayRealVector getCenter() {
            return this.center;
        }

        public final void setCenter(@NotNull ArrayRealVector arrayRealVector) {
            Intrinsics.checkNotNullParameter((Object)arrayRealVector, (String)"<set-?>");
            this.center = arrayRealVector;
        }

        @NotNull
        public final ArrayRealVector getRadius() {
            return this.radius;
        }

        public final void setRadius(@NotNull ArrayRealVector arrayRealVector) {
            Intrinsics.checkNotNullParameter((Object)arrayRealVector, (String)"<set-?>");
            this.radius = arrayRealVector;
        }

        @NotNull
        public final ArrayRealVector getSum() {
            return this.sum;
        }

        public final void setSum(@NotNull ArrayRealVector arrayRealVector) {
            Intrinsics.checkNotNullParameter((Object)arrayRealVector, (String)"<set-?>");
            this.sum = arrayRealVector;
        }

        public final double getCost() {
            return this.cost;
        }

        public final void setCost(double d) {
            this.cost = d;
        }

        @Nullable
        public final Node getLower() {
            return this.lower;
        }

        public final void setLower(@Nullable Node node) {
            this.lower = node;
        }

        @Nullable
        public final Node getUpper() {
            return this.upper;
        }

        public final void setUpper(@Nullable Node node) {
            this.upper = node;
        }
    }
}

