/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.analysis.diagnosis.ClusteringEvaluator;
import ai.platon.scent.analysis.diagnosis.SumOfClusterVariances;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.KMeans;
import ai.platon.scent.ml.unsupervised.Measurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00170\u0003R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/ml/unsupervised/MultiKmeans;", "Lai/platon/scent/ml/unsupervised/Measurable;", "points", "", "Lai/platon/scent/ml/NodePoint;", "initCenters", "maxIterations", "", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "evaluator", "Lai/platon/scent/analysis/diagnosis/ClusteringEvaluator;", "(Ljava/util/List;Ljava/util/List;ILorg/apache/commons/math3/ml/distance/DistanceMeasure;Lai/platon/scent/analysis/diagnosis/ClusteringEvaluator;)V", "getEvaluator", "()Lai/platon/scent/analysis/diagnosis/ClusteringEvaluator;", "getInitCenters", "()Ljava/util/List;", "getMaxIterations", "()I", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "getPoints", "cluster", "Lai/platon/scent/ml/unsupervised/CentroidCluster;", "scent-auto-mining"})
public final class MultiKmeans
implements Measurable {
    @NotNull
    private final List<NodePoint> points;
    @NotNull
    private final List<List<NodePoint>> initCenters;
    private final int maxIterations;
    @NotNull
    private final DistanceMeasure measure;
    @NotNull
    private final ClusteringEvaluator evaluator;

    public MultiKmeans(@NotNull List<? extends NodePoint> points, @NotNull List<? extends List<? extends NodePoint>> initCenters, int maxIterations, @NotNull DistanceMeasure measure, @NotNull ClusteringEvaluator evaluator) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        Intrinsics.checkNotNullParameter(initCenters, (String)"initCenters");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        this.points = points;
        this.initCenters = initCenters;
        this.maxIterations = maxIterations;
        this.measure = measure;
        this.evaluator = evaluator;
    }

    public /* synthetic */ MultiKmeans(List list, List list2, int n, DistanceMeasure distanceMeasure, ClusteringEvaluator clusteringEvaluator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 100;
        }
        if ((n2 & 8) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        if ((n2 & 0x10) != 0) {
            clusteringEvaluator = new SumOfClusterVariances(distanceMeasure);
        }
        this(list, list2, n, distanceMeasure, clusteringEvaluator);
    }

    @NotNull
    public final List<NodePoint> getPoints() {
        return this.points;
    }

    @NotNull
    public final List<List<NodePoint>> getInitCenters() {
        return this.initCenters;
    }

    public final int getMaxIterations() {
        return this.maxIterations;
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @NotNull
    public final ClusteringEvaluator getEvaluator() {
        return this.evaluator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CentroidCluster<NodePoint>> cluster() {
        int n;
        Object v0;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv = this.initCenters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new KMeans(this.getPoints(), (List<? extends NodePoint>)it, this.getMaxIterations(), this.getMeasure());
            collection.add(object);
        }
        List kmeans = (List)destination$iv$iv;
        Iterable $this$map$iv2 = kmeans;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            KMeans bl = (KMeans)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = it.cluster();
            collection.add(object);
        }
        List results = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = results;
        boolean $i$f$map3 = false;
        Iterable $i$f$mapTo22 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            object = this.getEvaluator().score((List<? extends CentroidCluster<NodePoint>>)it);
            collection.add(object);
        }
        Iterable $this$minByOrNull$iv = CollectionsKt.withIndex((Iterable)((List)destination$iv$iv3));
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                IndexedValue it = (IndexedValue)minElem$iv;
                boolean bl = false;
                double minValue$iv = ((Number)it.getValue()).doubleValue();
                do {
                    Object e$iv = iterator$iv.next();
                    IndexedValue it2 = (IndexedValue)e$iv;
                    $i$a$-minByOrNull-MultiKmeans$cluster$bestSolution$2 = false;
                    double v$iv = ((Number)it2.getValue()).doubleValue();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        IndexedValue indexedValue = v0;
        int bestSolution = indexedValue == null ? 0 : (n = indexedValue.getIndex());
        return (List)results.get(bestSolution);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        return Measurable.DefaultImpls.findClosestCluster(this, i, point, clusters);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }
}

