/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.AppFiles;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.jsoup.ext.NodeExt;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.CorpusTextView;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.analysis.diagnosis.ClusterDiagnosor;
import ai.platon.scent.analysis.diagnosis.ClusterTaskDiagnotor;
import ai.platon.scent.analysis.diagnosis.Distance;
import ai.platon.scent.analysis.diagnosis.DistanceType;
import ai.platon.scent.analysis.diagnosis.NodeClusterDiagnotor;
import ai.platon.scent.dom.nodes.GraphBuilder;
import ai.platon.scent.dom.nodes.NodeVertex;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.NodeCluster;
import ai.platon.scent.ml.unsupervised.SeedSensitiveCluster;
import com.google.common.base.Strings;
import java.awt.Rectangle;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\"\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0017\u001a\u00020\u00062\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\f\b\u0002\u0010\u0014\u001a\u00060\u0012j\u0002`\u0013H\u0002J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lai/platon/scent/analysis/corpus/CorpusTextView;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "diagnotors", "", "Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Ljava/util/List;)V", "getCorpus", "()Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "getDiagnotors", "()Ljava/util/List;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "abstractOf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "doc", "Lai/platon/scent/analysis/corpus/VisualDocument;", "diagnotor", "build", "", "componentsAbstractOf", "reportIndexDocument", "Lai/platon/pulsar/dom/FeaturedDocument;", "saveAbstractOf", "document", "directory", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nCorpusTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorpusTextView.kt\nai/platon/scent/analysis/corpus/CorpusTextView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,363:1\n1864#2,3:364\n1864#2,2:367\n1864#2,3:369\n1866#2:372\n1054#2:373\n1549#2:375\n1620#2,3:376\n1603#2,9:379\n1855#2:388\n1856#2:390\n1612#2:391\n1549#2:392\n1620#2,3:393\n1045#2:396\n1559#2:397\n1590#2,4:398\n1855#2,2:402\n1864#2,3:404\n1864#2,3:407\n766#2:410\n857#2,2:411\n1855#2,2:413\n1855#2:415\n1855#2:416\n1549#2:417\n1620#2,3:418\n1856#2:423\n1856#2:424\n1#3:374\n1#3:389\n37#4,2:421\n*S KotlinDebug\n*F\n+ 1 CorpusTextView.kt\nai/platon/scent/analysis/corpus/CorpusTextView\n*L\n42#1:364,3\n65#1:367,2\n67#1:369,3\n65#1:372\n90#1:373\n109#1:375\n109#1:376,3\n110#1:379,9\n110#1:388\n110#1:390\n110#1:391\n111#1:392\n111#1:393,3\n112#1:396\n113#1:397\n113#1:398,4\n119#1:402,2\n122#1:404,3\n240#1:407,3\n251#1:410\n251#1:411,2\n252#1:413,2\n287#1:415\n288#1:416\n309#1:417\n309#1:418,3\n288#1:423\n287#1:424\n110#1:389\n309#1:421,2\n*E\n"})
public final class CorpusTextView {
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final List<ClusterTaskDiagnotor> diagnotors;

    public CorpusTextView(@NotNull AnalysablePageCorpus corpus, @NotNull List<ClusterTaskDiagnotor> diagnotors) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter(diagnotors, (String)"diagnotors");
        this.corpus = corpus;
        this.diagnotors = diagnotors;
    }

    @NotNull
    public final AnalysablePageCorpus getCorpus() {
        return this.corpus;
    }

    @NotNull
    public final List<ClusterTaskDiagnotor> getDiagnotors() {
        return this.diagnotors;
    }

    private final Path getReportDirectory() {
        return this.corpus.getReportDirectory();
    }

    /*
     * WARNING - void declaration
     */
    public final void build() {
        StringBuilder stringBuilder = null;
        stringBuilder = CorpusTextView.abstractOf$default(this, this.corpus, null, 2, null);
        Object filename = null;
        filename = "corpus-textual-abstract.txt";
        Path path = null;
        Path path2 = path = this.getReportDirectory().resolve((String)filename);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"element");
        AppFiles.INSTANCE.saveTo((Object)stringBuilder, path2, true);
        Iterable $this$forEachIndexed$iv = this.diagnotors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void diagnotor;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ClusterTaskDiagnotor clusterTaskDiagnotor = (ClusterTaskDiagnotor)item$iv;
            int i = n;
            boolean bl = false;
            stringBuilder = CorpusTextView.abstractOf$default(this, (ClusterTaskDiagnotor)diagnotor, null, 2, null);
            filename = "c" + i + "-component-clustering-report.txt";
            Path path3 = path = this.getReportDirectory().resolve((String)filename);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"element");
            AppFiles.INSTANCE.saveTo((Object)stringBuilder, path3, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder abstractOf(ClusterTaskDiagnotor diagnotor, StringBuilder sb) {
        void $this$forEach$iv;
        Iterator $this$mapIndexedTo$iv$iv;
        void $this$sortedBy$iv;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        List<RealVector> centroids = diagnotor.getCentroids();
        StringBuilder stringBuilder = sb.append("Clusters diagnotor\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder2 = sb.append(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = sb.append("Total " + centroids.size() + " clusters");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = sb.append("Url of random sample page: \n" + NodeExtKt.getLocation((Node)((NodePoint)((Object)((NodeCluster)CollectionsKt.first(diagnotor.getClusterGroup().getClusters())).getSample())).getNode()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = sb.append("Inter cluster distance matrix: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        String header2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(0, centroids.size() - 1)), (CharSequence)"", null, null, (int)0, null, (Function1)abstractOf.header.1.INSTANCE, (int)30, null);
        StringBuilder stringBuilder6 = sb.append(StringsKt.repeat((CharSequence)" ", (int)10) + header2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        Iterable $this$forEachIndexed$iv = centroids;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RealVector realVector = (RealVector)item$iv;
            int i = n;
            boolean bl = false;
            String string = "%10d";
            Object[] objectArray = new Object[]{i};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2);
            Iterable $this$forEachIndexed$iv2 = centroids;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                Object[] objectArray2;
                String string3;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RealVector realVector2 = (RealVector)item$iv2;
                int j = n2;
                boolean bl2 = false;
                if (i < j) {
                    void p2;
                    void p1;
                    string3 = "%10.4f";
                    objectArray2 = new Object[]{diagnotor.distance((RealVector)p1, (RealVector)p2)};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                    sb.append(string4);
                    continue;
                }
                string3 = "%10s";
                objectArray2 = new Object[]{"-"};
                String string5 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                sb.append(string5);
            }
            Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = sb.append("Inter cluster distance summaries: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        diagnotor.getDistanceSummary().forEach((arg_0, arg_1) -> CorpusTextView.abstractOf$lambda$3((Function2)new Function2<DistanceType, List<? extends Distance>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;
            {
                this.$sb = $sb;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull DistanceType type, @NotNull List<Distance> summary) {
                Object object;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter(summary, (String)"summary");
                Iterable $this$map$iv = summary;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (Distance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = "(%d,%d):%.2f";
                    Object[] objectArray = new Object[]{it.getI(), it.getJ(), it.getDistance()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    collection.add(string2);
                }
                String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)abstractOf.2.INSTANCE, (int)30, null);
                StringBuilder stringBuilder = this.$sb;
                String it = string;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder;
                String string3 = "%-20s%s";
                Object[] objectArray = new Object[]{type, it};
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                object = string4;
                StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = sb.append("Distortions: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        Object $this$sortedByDescending$iv = diagnotor.getClusterGroup().getClusters();
        boolean $i$f$sortedByDescending = false;
        Object it = $this$sortedByDescending$iv = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NodeCluster it = (NodeCluster)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getDistortion());
                it = (NodeCluster)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getDistortion()));
            }
        }), (CharSequence)"\t", null, null, (int)0, null, (Function1)abstractOf.4.INSTANCE, (int)30, null);
        boolean bl = false;
        StringBuilder stringBuilder9 = sb.append((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        Object object = diagnotor.getWidestCluster();
        if (object == null || (object = ((ClusterDiagnosor)object).getCluster()) == null || (object = (NodePoint)((Object)((Cluster)object).getFirst())) == null) {
            return sb;
        }
        Object sample = object;
        NodeClusterDiagnotor nodeClusterDiagnotor = diagnotor.getWidestCluster();
        if (nodeClusterDiagnotor == null) {
            return sb;
        }
        NodeClusterDiagnotor widest = nodeClusterDiagnotor;
        StringBuilder stringBuilder10 = sb.append("Widest cluster (diameter: " + widest.getDiameter() + ", distortion: " + widest.getCluster().getDistortion() + ") ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        StringBuilder stringBuilder11 = stringBuilder10.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
        StringBuilder stringBuilder12 = stringBuilder11.append(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((NodePoint)((Object)sample)).getNode()).getSelector3());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        StringBuilder stringBuilder13 = stringBuilder12.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
        StringBuilder stringBuilder14 = stringBuilder13.append(">>>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
        StringBuilder stringBuilder15 = stringBuilder14.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
        StringBuilder stringBuilder16 = stringBuilder15.append(NodeExtKt.getCleanText((Node)((NodePoint)((Object)sample)).getNode()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
        StringBuilder stringBuilder17 = stringBuilder16.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
        StringBuilder stringBuilder18 = stringBuilder17.append("<<<");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder19 = sb.append("Components: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19.append('\n'), (String)"append(...)");
        Iterable $this$map$iv = diagnotor.getInspectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            NodeClusterDiagnotor index$iv2 = (NodeClusterDiagnotor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it2.getCluster());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object it2 = $this$forEach$iv$iv$iv.iterator();
        while (it2.hasNext()) {
            SeedSensitiveCluster it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = it2.next();
            boolean bl4 = false;
            Cluster it3 = (Cluster)element$iv$iv;
            boolean bl5 = false;
            if ((it3 instanceof SeedSensitiveCluster ? (SeedSensitiveCluster)it3 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (SeedSensitiveCluster)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            collection.add(((NodePoint)((Object)((SeedSensitiveCluster)it2).getSeed())).getNode());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List components = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Node it = (Node)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NodeExtKt.getSequence((Node)it));
                it = (Node)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getSequence((Node)it)));
            }
        });
        Iterable $this$mapIndexed$iv = components;
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        Object item$iv$iv = $this$mapIndexedTo$iv$iv.iterator();
        while (item$iv$iv.hasNext()) {
            void n;
            void i;
            int bl7;
            Object item$iv$iv2 = item$iv$iv.next();
            if ((bl7 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (Node)item$iv$iv2;
            int bl4 = bl7;
            collection = destination$iv$iv;
            boolean bl8 = false;
            String string = "%d\t%d\t%50s\t[df:%.2f]\t%s\t%s";
            Object[] objectArray = new Object[]{(int)(i + true), NodeExtKt.getSequence((Node)n), ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)n).getSelector2(), FastMath.max((double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)n), (double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)n)), GeometricsKt.getStr((Rectangle)NodeExtKt.getRectangle((Node)n)), NodeExtKt.getCleanText((Node)n)};
            String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            collection.add(string6);
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String it4 = (String)element$iv;
            boolean bl9 = false;
            StringBuilder stringBuilder20 = sb.append(it4);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder20.append('\n'), (String)"append(...)");
        }
        Iterable $this$forEachIndexed$iv3 = diagnotor.getInspectors();
        boolean $i$f$forEachIndexed3 = false;
        int index$iv3 = 0;
        for (Object item$iv : $this$forEachIndexed$iv3) {
            void it5;
            int n;
            if ((n = index$iv3++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (NodeClusterDiagnotor)item$iv;
            int i = n;
            boolean bl10 = false;
            StringBuilder stringBuilder21 = sb.append("\n\n" + i + ".\t===================== c" + it5.getCluster().getLabel() + " ======================");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder21.append('\n'), (String)"append(...)");
            ClusterDiagnosor.show$default((ClusterDiagnosor)it5, 0, sb, 1, null);
        }
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, ClusterTaskDiagnotor clusterTaskDiagnotor, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(clusterTaskDiagnotor, stringBuilder);
    }

    private final void componentsAbstractOf(VisualDocument doc, StringBuilder sb) {
        Path path = NodeExtKt.getExportPaths((Document)doc.getDocument()).getAnnotatedView();
        StringBuilder stringBuilder = sb.append('\n').append(doc.getLocation()).append('\n').append(doc.getComponents().size()).append('\n').append(CollectionsKt.joinToString$default((Iterable)doc.getComponents(), null, null, null, (int)0, null, (Function1)componentsAbstractOf.1.INSTANCE, (int)31, null)).append('\n').append(path);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
    }

    static /* synthetic */ void componentsAbstractOf$default(CorpusTextView corpusTextView, VisualDocument visualDocument, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        corpusTextView.componentsAbstractOf(visualDocument, stringBuilder);
    }

    private final StringBuilder abstractOf(AnalysablePageCorpus corpus, StringBuilder sb) {
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, AnalysablePageCorpus analysablePageCorpus, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(analysablePageCorpus, stringBuilder);
    }

    private final void saveAbstractOf(VisualDocument document, Path directory) {
        StringBuilder report = CorpusTextView.abstractOf$default(this, document, null, 2, null);
        String filename = AppPaths.fromUri$default((AppPaths)AppPaths.INSTANCE, (String)document.getLocation(), null, null, (int)6, null);
        Path path = directory.resolve("abstract").resolve(filename + ".txt");
        String string = report.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Intrinsics.checkNotNull((Object)path);
        AppFiles.INSTANCE.saveTo(byArray, path, true);
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder abstractOf(VisualDocument doc, StringBuilder sb) {
        String $this$filterTo$iv$iv;
        Iterator it;
        StringBuilder stringBuilder = sb.append("\n== Components ==");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Iterator format = null;
        format = "%10s%10s%60s" + Strings.repeat((String)"%15s", (int)5);
        StringBuilder stringBuilder2 = sb;
        String string = format;
        Object object = new Object[]{"", "sequence", "name", "descend", "caption", "df", "type", "tabular"};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String string3 = string2;
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        format = "%10d%10d%60s%15.2f%15d%15.2f%15s";
        Iterable $this$forEachIndexed$iv = doc.getComponents();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualComponent visualComponent = (VisualComponent)((Object)item$iv);
            int i = n;
            boolean bl = false;
            Element ele = it.getElement();
            Iterator iterator = format;
            Object[] objectArray = new Object[7];
            objectArray[0] = 1 + i;
            objectArray[1] = NodeExtKt.getSequence((Node)((Node)ele));
            objectArray[2] = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)((Node)ele)).getSelector2();
            RealVector realVector = ele.getExtension().getFeatures();
            Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
            objectArray[3] = VectorsKt.get((RealVector)realVector, (int)ai.platon.scent.dom.features.defined.DefinedFeaturesKt.getD());
            objectArray[4] = NodeExtKt.getCaption((Node)((Node)ele)).length();
            objectArray[5] = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)((Node)ele));
            objectArray[6] = ((VisualComponent)((Object)it)).getPattern();
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)((Object)iterator), Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            StringBuilder stringBuilder4 = sb.append(line);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder5 = sb.append("\n== Connected sets ==");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        List list = new ConnectivityInspector((DirectedGraph)new GraphBuilder(doc.getBody(), false, false, false, false, 30, null).build()).connectedSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"connectedSets(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        it = $this$filterTo$iv$iv.iterator();
        while (it.hasNext()) {
            Object element$iv$iv = it.next();
            Set it2 = (Set)element$iv$iv;
            boolean bl = false;
            if (!(it2.size() > 4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List connectedSets = (List)destination$iv$iv;
        Iterable $this$forEach$iv = connectedSets;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            Set vertices = (Set)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)vertices);
            Sequence sorted2 = SequencesKt.sorted((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)vertices), (Function1)abstractOf.10.sorted.1.INSTANCE));
            int size = SequencesKt.count((Sequence)sorted2);
            NodeVertex v1 = (NodeVertex)SequencesKt.first((Sequence)sorted2);
            NodeVertex v2 = (NodeVertex)SequencesKt.last((Sequence)sorted2);
            Node node = v1.getData().getNode();
            Intrinsics.checkNotNull((Object)node);
            Node e1 = node.parent();
            Node node2 = v2.getData().getNode();
            Intrinsics.checkNotNull((Object)node2);
            Node e2 = node2.parent();
            int n = vertices.size();
            Node node3 = e1;
            Intrinsics.checkNotNull((Object)node3);
            String string4 = NodeExtKt.getUniqueName((Node)node3);
            Node node4 = e2;
            Intrinsics.checkNotNull((Object)node4);
            StringBuilder stringBuilder6 = sb.append("Connected set in graph: total " + size + "/" + n + " nodes, " + string4 + ", " + NodeExtKt.getUniqueName((Node)node4));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        }
        Object $i$f$forEach22 = new String[]{"tn", "ctn", "ctr", "tnd", "ctnd", "vtnd", "dvcocd", "dvcovd", "dvcod", "dvcocr", "dvcovr", "dvcor"};
        String[] names2 = $i$f$forEach22;
        StringBuilder stringBuilder7 = sb.append("\n== Induced indicators ==");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        format = "%-40s" + Strings.repeat((String)"%10s", (int)names2.length);
        $i$f$forEach22 = sb;
        Iterator iterator = format;
        Object[] vertices = new SpreadBuilder(2);
        vertices.add((Object)"selector");
        vertices.addSpread((Object)names2);
        vertices = vertices.toArray(new Object[vertices.size()]);
        String string5 = String.format((String)((Object)iterator), Arrays.copyOf(vertices, vertices.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        $this$filterTo$iv$iv = string5;
        StringBuilder stringBuilder8 = ((StringBuilder)$i$f$forEach22).append($this$filterTo$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv2 = doc.getTrackingSelectors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            String selector = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv3 = (Iterable)FeaturedDocument.select$default((FeaturedDocument)doc.getFeaturedDocument(), (String)selector, (int)0, (int)0, (int)6, null);
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                NodeExt ext;
                Element ele = (Element)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)ele.getExtension(), (String)"getExtension(...)");
                Pair[] pairArray = new Pair[12];
                RealVector realVector = ext.getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                pairArray[0] = TuplesKt.to((Object)"tn", (Object)VectorsKt.get((RealVector)realVector, (int)DefinedFeaturesKt.TN));
                RealVector realVector2 = ext.getFeatures();
                Intrinsics.checkNotNullExpressionValue((Object)realVector2, (String)"getFeatures(...)");
                pairArray[1] = TuplesKt.to((Object)"ctn", (Object)VectorsKt.get((RealVector)realVector2, (int)ai.platon.scent.dom.features.defined.DefinedFeaturesKt.getCTN()));
                pairArray[2] = TuplesKt.to((Object)"ctr", ext.getVariables().get("ctr"));
                pairArray[3] = TuplesKt.to((Object)"tnd", ext.getVariables().get("tnd"));
                pairArray[4] = TuplesKt.to((Object)"ctnd", ext.getVariables().get("ctnd"));
                pairArray[5] = TuplesKt.to((Object)"vtnd", ext.getVariables().get("vtnd"));
                pairArray[6] = TuplesKt.to((Object)"dvcocd", ext.getVariables().get("dvcocd"));
                pairArray[7] = TuplesKt.to((Object)"dvcovd", ext.getVariables().get("dvcovd"));
                pairArray[8] = TuplesKt.to((Object)"dvcod", ext.getVariables().get("dvcod"));
                pairArray[9] = TuplesKt.to((Object)"dvcocr", ext.getVariables().get("dvcocr"));
                pairArray[10] = TuplesKt.to((Object)"dvcovr", ext.getVariables().get("dvcovr"));
                pairArray[11] = TuplesKt.to((Object)"dvcor", ext.getVariables().get("dvcor"));
                Map features = MapsKt.mapOf((Pair[])pairArray);
                Iterable $this$map$iv = features.values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void v;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Double d = v;
                    if (d == null) {
                        d = 0.0;
                    }
                    collection.add(d);
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Object[] values = thisCollection$iv.toArray(new Object[0]);
                String s2 = selector.length() > 35 ? StringsKt.substringAfterLast$default((String)selector, (String)" > ", null, (int)2, null) : selector;
                StringBuilder stringBuilder9 = sb.append(s2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
                ArraysKt.joinTo$default((Object[])values, (Appendable)sb, (CharSequence)" ", null, null, (int)0, null, null, (int)124, null);
            }
        }
        return sb;
    }

    static /* synthetic */ StringBuilder abstractOf$default(CorpusTextView corpusTextView, VisualDocument visualDocument, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return corpusTextView.abstractOf(visualDocument, stringBuilder);
    }

    public final void reportIndexDocument(@NotNull FeaturedDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        System.out.println((Object)"== Images report ==");
        String string = "%50s%10s%10s%10s%10s%10s%10s%10s";
        Object[] objectArray = new Object[]{"name", "numImg", "numVisImg", "imgTW", "imgTH", "imgAW", "imgAH", "isHidden"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String string3 = string2;
        System.out.println((Object)string3);
        NodesKt.forEach$default((Node)((Node)doc.getBody()), (boolean)false, (Function1)reportIndexDocument.1.INSTANCE, (int)1, null);
        System.out.println((Object)"== Anchors report ==");
        string = "%50s%10s%10s%10s%10s%10s%10s%10s";
        objectArray = new Object[]{"name", "numA", "numVisA", "aTW", "aTH", "aAW", "aAH", "isHidden"};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        string3 = string4;
        System.out.println((Object)string3);
        NodesKt.forEach$default((Node)((Node)doc.getBody()), (boolean)false, (Function1)reportIndexDocument.2.INSTANCE, (int)1, null);
        Element element = doc.selectFirst("div.content.detail");
        if (element != null) {
            NodesKt.forEach$default((Node)((Node)element), (boolean)false, (Function1)reportIndexDocument.3.INSTANCE, (int)1, null);
        }
        Path path = doc.export();
    }

    private static final void abstractOf$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

