/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.features.defined.DefinedFeaturesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\u001f"}, d2={"Lai/platon/scent/analysis/corpus/TinyNode;", "", "url", "", "features", "Lorg/apache/commons/math3/linear/RealVector;", "(Ljava/lang/String;Lorg/apache/commons/math3/linear/RealVector;)V", "getFeatures", "()Lorg/apache/commons/math3/linear/RealVector;", "height", "", "getHeight", "()D", "left", "getLeft", "sequence", "", "getSequence", "()I", "top", "getTop", "getUrl", "()Ljava/lang/String;", "width", "getWidth", "x", "getX", "y", "getY", "compareTo", "other", "scent-auto-mining"})
public final class TinyNode
implements Comparable<TinyNode> {
    @NotNull
    private final String url;
    @NotNull
    private final RealVector features;

    public TinyNode(@NotNull String url, @NotNull RealVector features) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        this.url = url;
        this.features = features;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final RealVector getFeatures() {
        return this.features;
    }

    public final int getSequence() {
        return (int)VectorsKt.get((RealVector)this.features, (int)DefinedFeaturesKt.SEQ);
    }

    public final double getTop() {
        return VectorsKt.get((RealVector)this.features, (int)DefinedFeaturesKt.TOP);
    }

    public final double getLeft() {
        return VectorsKt.get((RealVector)this.features, (int)DefinedFeaturesKt.LEFT);
    }

    public final double getWidth() {
        return VectorsKt.get((RealVector)this.features, (int)DefinedFeaturesKt.WIDTH);
    }

    public final double getHeight() {
        return VectorsKt.get((RealVector)this.features, (int)DefinedFeaturesKt.HEIGHT);
    }

    public final double getX() {
        return this.getLeft();
    }

    public final double getY() {
        return this.getTop();
    }

    @Override
    public int compareTo(@NotNull TinyNode other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int b = this.url.compareTo(other.url);
        if (b != 0) {
            return b;
        }
        return this.getSequence() - other.getSequence();
    }
}

