/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.ColorFamily;
import ai.platon.pulsar.common.ColorsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.FrequencyManager;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.DomQueriesKt;
import ai.platon.scent.analysis.corpus.OrderedRegionalTile;
import ai.platon.scent.analysis.corpus.OrderedRegionalTileNode;
import ai.platon.scent.analysis.corpus.RegionalTile;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualComponentType;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.analysis.corpus.VisualDocumentKt;
import ai.platon.scent.dom.FeatureValidator;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.features.defined.FF;
import ai.platon.scent.dom.nodes.DocumentFragment;
import ai.platon.scent.dom.nodes.node.ext.NodeCharactersKt;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeFilter;
import org.jsoup.select.NodeTraversor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u001c\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002lmB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0015H\u0002J\u001e\u0010E\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00120F2\u0006\u0010D\u001a\u00020\u0015H\u0002J.\u0010E\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00120F2\u0006\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020\u0003J\u0006\u0010K\u001a\u00020CJ\u001e\u0010L\u001a\u00020C2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0N2\u0006\u0010P\u001a\u00020'H\u0002J\r\u0010Q\u001a\u00020CH\u0000\u00a2\u0006\u0002\bRJ\u0006\u0010S\u001a\u00020CJ\b\u0010T\u001a\u00020CH\u0002J\b\u0010U\u001a\u00020CH\u0002J\u0006\u0010V\u001a\u00020CJ\b\u0010W\u001a\u00020CH\u0002J\u0006\u0010X\u001a\u00020CJ\r\u0010Y\u001a\u00020CH\u0000\u00a2\u0006\u0002\bZJ\u0006\u0010[\u001a\u00020CJ\b\u0010\\\u001a\u00020CH\u0002J$\u0010]\u001a\u0004\u0018\u00010\u00152\u0006\u0010^\u001a\u00020\r2\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020\u0003H\u0002J\u0006\u0010_\u001a\u00020CJ\"\u0010`\u001a\u0004\u0018\u00010\r2\u0006\u0010a\u001a\u00020O2\u0006\u0010b\u001a\u00020O2\u0006\u0010c\u001a\u00020'H\u0002J\b\u0010d\u001a\u00020CH\u0002J\u001a\u0010e\u001a\u0004\u0018\u00010\r2\u0006\u0010a\u001a\u00020O2\u0006\u0010b\u001a\u00020OH\u0002J\b\u0010f\u001a\u00020CH\u0002J\u0016\u0010g\u001a\u00020C2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00030iH\u0002J\u0006\u0010j\u001a\u00020CJ\u0006\u0010k\u001a\u00020CR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u000203X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00108\u001a\b\u0012\u0004\u0012\u00020\u000309\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u000bR\u001a\u0010=\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010A\u00a8\u0006n"}, d2={"Lai/platon/scent/analysis/corpus/VisualDocument;", "", "url", "", "featuredDocument", "Lai/platon/pulsar/dom/FeaturedDocument;", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Ljava/lang/String;Lai/platon/pulsar/dom/FeaturedDocument;Lai/platon/scent/dom/HarvestOptions;)V", "baseURI", "getBaseURI", "()Ljava/lang/String;", "body", "Lorg/jsoup/nodes/Element;", "getBody", "()Lorg/jsoup/nodes/Element;", "componentPredicate", "Lkotlin/Function1;", "", "components", "Ljava/util/TreeSet;", "Lai/platon/scent/analysis/corpus/VisualComponent;", "getComponents", "()Ljava/util/TreeSet;", "document", "Lorg/jsoup/nodes/Document;", "getDocument", "()Lorg/jsoup/nodes/Document;", "getFeaturedDocument", "()Lai/platon/pulsar/dom/FeaturedDocument;", "features", "Lorg/apache/commons/math3/linear/RealVector;", "getFeatures", "()Lorg/apache/commons/math3/linear/RealVector;", "location", "getLocation", "logger", "Lorg/slf4j/Logger;", "maximumComponentHeight", "", "getMaximumComponentHeight", "()I", "minimumComponentWidth", "getMinimumComponentWidth", "naturalComponents", "", "getNaturalComponents", "()Ljava/util/List;", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "temporaryInternalIndexers", "Lai/platon/scent/analysis/corpus/VisualDocument$TemporaryInternalIndexers;", "getTemporaryInternalIndexers$scent_auto_mining", "()Lai/platon/scent/analysis/corpus/VisualDocument$TemporaryInternalIndexers;", "temporaryPrivateIndexers", "Lai/platon/scent/analysis/corpus/VisualDocument$TemporaryPrivateIndexers;", "trackingSelectors", "", "getTrackingSelectors", "()Ljava/util/Set;", "getUrl", "verbose", "getVerbose", "()Z", "setVerbose", "(Z)V", "addComponent", "", "component", "addComponentIfAbsent", "Lkotlin/Pair;", "element", "type", "Lai/platon/scent/analysis/corpus/VisualComponentType;", "memo", "arrangeComponents", "bidirectionalSearchComponent", "nodes", "", "Lorg/jsoup/nodes/Node;", "minDist", "buildCaptionedElementIndexer", "buildCaptionedElementIndexer$scent_auto_mining", "buildComponentTree", "buildRegionalTileNodeIndex", "calculateCategoricalTermFrequency", "calculateCollinearNodeFeatures", "calculateComponentEdges", "calculateFeatures", "calculateTextualFeatures", "calculateTextualFeatures$scent_auto_mining", "clearTemporaryIndexes", "colorComponents", "createComponentIf", "envelop", "findComponents", "findMinimumEnvelop", "v1", "v2", "maxHeight", "findNaiveComponents", "findRowComponent", "findTileAlignedComponent", "findUserDefinedComponents", "selectors", "", "removeIrrelevantNodes", "validateFeatures", "TemporaryInternalIndexers", "TemporaryPrivateIndexers", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nVisualDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualDocument.kt\nai/platon/scent/analysis/corpus/VisualDocument\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,669:1\n1611#2:670\n1855#2:671\n1856#2:674\n1612#2:675\n1864#2,2:676\n2624#2,3:678\n1866#2:681\n1774#2,4:683\n1855#2,2:687\n1855#2,2:690\n1855#2,2:701\n1855#2,2:705\n1855#2:708\n1856#2:711\n1855#2,2:713\n1864#2,3:719\n1549#2:723\n1620#2,3:724\n1855#2,2:727\n1855#2,2:733\n1855#2,2:735\n1855#2,2:737\n1855#2,2:739\n1549#2:741\n1620#2,3:742\n1855#2,2:745\n1549#2:747\n1620#2,3:748\n1#3:672\n1#3:673\n215#4:682\n216#4:689\n215#4:700\n216#4:703\n215#4:704\n216#4:707\n215#4:712\n216#4:715\n215#4,2:716\n215#4:718\n216#4:722\n215#4,2:729\n215#4,2:731\n11065#5:692\n11400#5,3:693\n11065#5:696\n11400#5,3:697\n12474#5,2:709\n*S KotlinDebug\n*F\n+ 1 VisualDocument.kt\nai/platon/scent/analysis/corpus/VisualDocument\n*L\n216#1:670\n216#1:671\n216#1:674\n216#1:675\n222#1:676,2\n224#1:678,3\n222#1:681\n250#1:683,4\n253#1:687,2\n260#1:690,2\n332#1:701,2\n339#1:705,2\n363#1:708\n363#1:711\n393#1:713,2\n417#1:719,3\n451#1:723\n451#1:724,3\n451#1:727,2\n575#1:733,2\n582#1:735,2\n593#1:737,2\n648#1:739,2\n654#1:741\n654#1:742,3\n654#1:745,2\n666#1:747\n666#1:748,3\n216#1:673\n248#1:682\n248#1:689\n331#1:700\n331#1:703\n338#1:704\n338#1:707\n391#1:712\n391#1:715\n409#1:716,2\n416#1:718\n416#1:722\n475#1:729,2\n493#1:731,2\n276#1:692\n276#1:693,3\n288#1:696\n288#1:697,3\n380#1:709,2\n*E\n"})
public final class VisualDocument {
    @NotNull
    private final String url;
    @NotNull
    private final FeaturedDocument featuredDocument;
    @NotNull
    private final HarvestOptions options;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Document document;
    @NotNull
    private final RealVector features;
    @NotNull
    private final String baseURI;
    @NotNull
    private final String location;
    @NotNull
    private final Element body;
    private boolean verbose;
    @NotNull
    private final Set<String> trackingSelectors;
    @NotNull
    private final TemporaryPrivateIndexers temporaryPrivateIndexers;
    @NotNull
    private final TemporaryInternalIndexers temporaryInternalIndexers;
    @NotNull
    private Function1<? super Element, Boolean> componentPredicate;
    @NotNull
    private final TreeSet<VisualComponent> components;
    @NotNull
    private final List<VisualComponent> naturalComponents;

    public VisualDocument(@NotNull String url, @NotNull FeaturedDocument featuredDocument, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)featuredDocument, (String)"featuredDocument");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.url = url;
        this.featuredDocument = featuredDocument;
        this.options = options;
        Logger logger = LoggerFactory.getLogger(VisualDocument.class);
        Intrinsics.checkNotNull((Object)logger);
        this.logger = logger;
        VisualDocumentKt.setVisualDocument(this.featuredDocument.getDocument(), this);
        this.document = this.featuredDocument.unbox();
        RealVector realVector = this.document.getExtension().getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
        this.features = realVector;
        this.baseURI = this.featuredDocument.getBaseURI();
        this.location = this.featuredDocument.getLocation();
        this.body = this.featuredDocument.getBody();
        this.trackingSelectors = new LinkedHashSet();
        this.temporaryPrivateIndexers = new TemporaryPrivateIndexers();
        this.temporaryInternalIndexers = new TemporaryInternalIndexers();
        this.componentPredicate = (Function1)new Function1<Element, Boolean>(this){
            final /* synthetic */ VisualDocument this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)NodeCharactersKt.isRegularComponent((Node)((Node)it), (HarvestOptions)this.this$0.getOptions()).getFirst();
            }
        };
        this.components = new TreeSet(new Comparator(){

            public final int compare(T a, T b) {
                VisualComponent it = (VisualComponent)((Object)b);
                boolean bl = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (VisualComponent)((Object)a);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
            }
        });
        this.naturalComponents = new ArrayList();
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final FeaturedDocument getFeaturedDocument() {
        return this.featuredDocument;
    }

    @NotNull
    public final HarvestOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final RealVector getFeatures() {
        return this.features;
    }

    @NotNull
    public final String getBaseURI() {
        return this.baseURI;
    }

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    @NotNull
    public final Element getBody() {
        return this.body;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    private final int getMinimumComponentWidth() {
        return (int)(this.options.getMinimumComponentWidthPercentile() * (double)NodeExtKt.getWidth((Node)((Node)this.body)));
    }

    private final int getMaximumComponentHeight() {
        return (int)(this.options.getMaximumComponentHeightPercentile() * (double)NodeExtKt.getHeight((Node)((Node)this.body)));
    }

    @NotNull
    public final Set<String> getTrackingSelectors() {
        return this.trackingSelectors;
    }

    @NotNull
    public final TemporaryInternalIndexers getTemporaryInternalIndexers$scent_auto_mining() {
        return this.temporaryInternalIndexers;
    }

    @NotNull
    public final TreeSet<VisualComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public final List<VisualComponent> getNaturalComponents() {
        return this.naturalComponents;
    }

    public final void calculateFeatures() {
        this.calculateCategoricalTermFrequency();
        this.calculateComponentEdges();
        this.buildRegionalTileNodeIndex();
        this.calculateTextualFeatures$scent_auto_mining();
        this.calculateCollinearNodeFeatures();
    }

    /*
     * WARNING - void declaration
     */
    public final void findComponents() {
        void $this$mapNotNullTo$iv;
        Set selectors = CollectionsKt.toSet((Iterable)this.options.getComponentSelectors());
        if (!((Collection)selectors).isEmpty()) {
            this.findUserDefinedComponents(selectors);
            if (!this.options.getAutoPartition()) {
                return;
            }
        }
        this.findTileAlignedComponent();
        this.findNaiveComponents();
        if (this.options.getDiagnose()) {
            this.colorComponents();
        }
        Iterable iterable = this.components;
        Collection destination$iv = this.naturalComponents;
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VisualComponent it$iv;
            VisualComponent visualComponent;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            VisualComponent it = (VisualComponent)((Object)element$iv);
            boolean bl2 = false;
            VisualComponent it2 = visualComponent = it;
            boolean bl3 = false;
            if ((it2.isNatural() ? visualComponent : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeIrrelevantNodes() {
        Element element = this.document.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        Element body = element;
        body.html("");
        Iterable $this$forEachIndexed$iv = this.components;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean bl;
            Element ele;
            block5: {
                void component;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv);
                int i = n;
                boolean bl2 = false;
                ele = component.getElement();
                Elements elements2 = ele.parents();
                Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"parents(...)");
                Iterable $this$none$iv = (Iterable)elements2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Element it = (Element)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)body)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            ele.appendTo(body);
        }
    }

    public final void clearTemporaryIndexes() {
        this.temporaryPrivateIndexers.clear();
        this.temporaryInternalIndexers.clear();
    }

    public final void calculateCollinearNodeFeatures() {
        Map.Entry element$iv;
        NavigableMap navigableMap = this.temporaryPrivateIndexers.getTileLeftIndexer().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Object $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable $this$count$iv = nodes2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    Node it = (Node)element$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            double ctc = n;
            double vtc = (double)nodes2.size() - ctc;
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                Node it = (Node)element$iv3;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setVcConstants((Node)it, (int)((int)ctc));
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setVcVariables((Node)it, (int)((int)vtc));
            }
        }
        Collection collection = this.temporaryPrivateIndexers.getTileLeftIndexer().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Node node = (Node)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)node);
            if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcConstants((Node)node) > 0) {
                NodesKt.forEachAncestor((Node)node, (Function1)calculateCollinearNodeFeatures.2.1.INSTANCE);
            }
            if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcVariables((Node)node) <= 0) continue;
            NodesKt.forEachAncestor((Node)node, (Function1)calculateCollinearNodeFeatures.2.2.INSTANCE);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateCategoricalTermFrequency() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        FrequencyManager<String> termFrequency = this.temporaryInternalIndexers.getTermFrequency$scent_auto_mining();
        FF[] fFArray = new FF[]{FF.TAG, FF.NID, FF.NCS};
        boolean $i$f$map22 = false;
        void var5_5 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv2).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_14 = item$iv$iv = $this$mapTo$iv$iv2[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(termFrequency.computeIfAbsent(it.getAlias()));
        }
        List nominalTFLists = (List)destination$iv$iv;
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>((List<Frequency<String>>)nominalTFLists){
            final /* synthetic */ List<Frequency<String>> $nominalTFLists;
            {
                this.$nominalTFLists = $nominalTFLists;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Element it) {
                void $this$forEachIndexed$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String[] stringArray = new String[]{it.tagName(), it.id(), it.className()};
                List<Frequency<String>> list = this.$nominalTFLists;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (void item$iv : $this$forEachIndexed$iv) {
                    void nominal;
                    int n = index$iv++;
                    void var9_9 = item$iv;
                    int i = n;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)nominal);
                    if (!(!StringsKt.isBlank((CharSequence)((CharSequence)nominal)))) continue;
                    list.get(i).add((Comparable)nominal);
                }
            }
        }), (int)1, null);
        FF[] $i$f$map22 = new FF[]{FF.FTSZ, FF.COLR, FF.BCOLR};
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void bl = item$iv$iv = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(termFrequency.computeIfAbsent(it.getAlias()));
        }
        List computedStyles = (List)destination$iv$iv2;
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>((List<Frequency<String>>)computedStyles){
            final /* synthetic */ List<Frequency<String>> $computedStyles;
            {
                this.$computedStyles = $computedStyles;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Element ele) {
                int n;
                Object object;
                String string;
                Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                Object object2 = ele.attr("cs");
                String it = object2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                String string2 = string = !StringsKt.isBlank((CharSequence)it) ? object2 : null;
                if (string != null && (object2 = (bl2 = new Regex(";")).split((CharSequence)(object = (CharSequence)string), n = 0)) != null) {
                    Object bl2 = object2;
                    List<Frequency<String>> list = this.$computedStyles;
                    Object it2 = bl2;
                    boolean bl3 = false;
                    Object object3 = object = it2.size() == list.size() ? bl2 : null;
                    if (object != null) {
                        void $this$forEachIndexed$iv;
                        bl2 = (Iterable)object;
                        list = this.$computedStyles;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (T item$iv : $this$forEachIndexed$iv) {
                            void style;
                            int n2;
                            if ((n2 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string3 = (String)item$iv;
                            int i = n2;
                            boolean bl4 = false;
                            list.get(i).add((Comparable)((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)style))).toString()));
                        }
                    }
                }
            }
        }), (int)1, null);
    }

    private final void calculateComponentEdges() {
        TreeMultimap<Integer, Element> layoutLeftIndexer = this.temporaryInternalIndexers.getLayoutLeftIndexer$scent_auto_mining();
        NodeTraversor.filter((NodeFilter)new NodeFilter(this, layoutLeftIndexer){
            private final boolean ignoreNonRelevantScreen;
            final /* synthetic */ VisualDocument this$0;
            final /* synthetic */ TreeMultimap<Integer, Element> $layoutLeftIndexer;
            {
                this.this$0 = $receiver;
                this.$layoutLeftIndexer = $layoutLeftIndexer;
            }

            public final boolean getIgnoreNonRelevantScreen() {
                return this.ignoreNonRelevantScreen;
            }

            @NotNull
            public NodeFilter.FilterResult head(@NotNull Node node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return VisualDocumentKt.isComponent(node) || NodeCharactersKt.isSimpleTable((Node)node) || NodeCharactersKt.isSimpleList((Node)node) || NodeCharactersKt.isDenseTextBlock$default((Node)node, (HarvestOptions)this.this$0.getOptions(), (int)0, (int)2, null) ? NodeFilter.FilterResult.SKIP_ENTIRELY : (this.ignoreNonRelevantScreen && ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNthScreen((Node)node) > this.this$0.getOptions().getNScreens() ? NodeFilter.FilterResult.SKIP_ENTIRELY : NodeFilter.FilterResult.CONTINUE);
            }

            @NotNull
            public NodeFilter.FilterResult tail(@NotNull Node node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (NodeCharactersKt.isTile((Node)node)) {
                    VisualDocument.access$getTemporaryPrivateIndexers$p(this.this$0).getTileLeftIndexer().put((Object)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)node), (Object)node);
                    VisualDocument.access$getTemporaryPrivateIndexers$p(this.this$0).getTileCenterYIndexer().put((Object)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedCenterY((Node)node), (Object)node);
                } else if (node instanceof Element && NodeCharactersKt.isLayout((Node)node) && ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNthScreen((Node)node) <= this.this$0.getOptions().getNScreens()) {
                    this.$layoutLeftIndexer.put((Object)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)node), (Object)node);
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
        }, (Node)((Node)this.body));
        if (this.options.getDiagnose()) {
            Integer n;
            String string;
            Map map;
            Node it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Collection nodes2;
            Map.Entry entry;
            Map.Entry element$iv;
            NavigableMap navigableMap = this.temporaryPrivateIndexers.getTileLeftIndexer().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
            Map $this$forEach$iv2 = navigableMap;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                Integer alignedLeft = (Integer)entry.getKey();
                nodes2 = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)nodes2);
                $this$forEach$iv = nodes2;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (Node)element$iv2;
                    boolean bl2 = false;
                    Map map2 = it.getExtension().getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getVariables(...)");
                    map = map2;
                    map.put("al", alignedLeft);
                    Map map3 = it.getExtension().getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getVariables(...)");
                    map = map3;
                    string = "vcol";
                    n = nodes2.size();
                    map.put(string, n);
                }
            }
            NavigableMap navigableMap2 = this.temporaryPrivateIndexers.getTileCenterYIndexer().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap2, (String)"asMap(...)");
            $this$forEach$iv2 = navigableMap2;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                Integer alignedCenterY = (Integer)entry.getKey();
                nodes2 = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)nodes2);
                $this$forEach$iv = nodes2;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    it = (Node)element$iv2;
                    boolean bl3 = false;
                    Map map4 = it.getExtension().getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getVariables(...)");
                    map = map4;
                    map.put("acy", alignedCenterY);
                    Map map5 = it.getExtension().getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)map5, (String)"getVariables(...)");
                    map = map5;
                    string = "hcol";
                    n = nodes2.size();
                    map.put(string, n);
                }
            }
        }
    }

    public final void calculateTextualFeatures$scent_auto_mining() {
        TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer = this.temporaryInternalIndexers.getRegionalTileNodeIndexer$scent_auto_mining();
        Collection collection = regionalTileNodeIndexer.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            block3: {
                Node node = (Node)element$iv;
                boolean bl2 = false;
                if (!(node instanceof TextNode) || StringsKt.isBlank((CharSequence)NodeExtKt.getCleanText((Node)node))) continue;
                boolean indexCategorizedTextNode = LangKt.alwaysFalse();
                CharSequence charSequence = NodeExtKt.getCleanText((Node)node);
                Regex regex = new Regex("\\s+");
                Double[] doubleArray = "_";
                String text = regex.replace(charSequence, (String)doubleArray);
                if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)node)) {
                    NodesKt.forEachAncestor((Node)node, (Function1)((Function1)new Function1<Element, Unit>(text){
                        final /* synthetic */ String $text;
                        {
                            this.$text = $text;
                            super(1);
                        }

                        public final void invoke(@NotNull Element ancestor) {
                            Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                            NodeExtKt.addCaptionWord((Node)((Node)ancestor), (String)this.$text);
                            int n = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNumConstTextNodes((Node)((Node)ancestor));
                            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setNumConstTextNodes((Node)((Node)ancestor), (int)(n + 1));
                        }
                    }));
                    continue;
                }
                if (!indexCategorizedTextNode) continue;
                double df = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)node);
                doubleArray = new Double[]{0.2, 0.25, 0.3333333333333333, 0.5};
                Double[] $this$any$iv = doubleArray;
                boolean $i$f$any = false;
                for (Double element$iv2 : $this$any$iv) {
                    double it = ((Number)element$iv2).doubleValue();
                    boolean bl3 = false;
                    if (!Precision.equals((double)df, (double)it, (int)4)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRegionalTileNodeIndex() {
        RegionalTile regionalText;
        String representation;
        Collection nodes2;
        Map.Entry entry;
        Map.Entry element$iv;
        TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer = this.temporaryInternalIndexers.getRegionalTileNodeIndexer$scent_auto_mining();
        NavigableMap navigableMap = this.temporaryPrivateIndexers.getTileLeftIndexer().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            Integer alignedLeft = (Integer)entry.getKey();
            nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Object object = CollectionsKt.last((Iterable)nodes2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            int n = NodeExtKt.getTop((Node)((Node)object));
            Object object2 = CollectionsKt.first((Iterable)nodes2);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
            if (!(n >= NodeExtKt.getTop((Node)((Node)object2)))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String string;
                Node node = (Node)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)node);
                if (NodeExtKt.isShortText((Node)node)) {
                    string = NodeExtKt.getCleanText((Node)node);
                } else {
                    String string2 = NodeExtKt.getBestElement((Node)node).id();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id(...)");
                    if (!StringsKt.isBlank((CharSequence)string2)) {
                        String string3 = NodeExtKt.getBestElement((Node)node).id();
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id(...)");
                    } else {
                        string = "";
                    }
                }
                if (!(!StringsKt.isBlank((CharSequence)(representation = string)))) continue;
                Intrinsics.checkNotNull((Object)alignedLeft);
                RegionalTile rt = new RegionalTile(alignedLeft, representation, 0.0, 0.0, 12, null);
                regionalTileNodeIndexer.put((Object)rt, (Object)node);
            }
        }
        NavigableMap navigableMap2 = regionalTileNodeIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap2, (String)"asMap(...)");
        $this$forEach$iv = navigableMap2;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            regionalText = (RegionalTile)entry.getKey();
            nodes2 = (Collection)entry.getValue();
            regionalText.setTf(nodes2.size());
        }
        if (LangKt.alwaysFalse()) {
            NavigableMap navigableMap3 = regionalTileNodeIndexer.asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap3, (String)"asMap(...)");
            $this$forEach$iv = navigableMap3;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = element$iv = iterator.next();
                boolean bl = false;
                regionalText = (RegionalTile)entry.getKey();
                nodes2 = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)nodes2);
                Iterable $this$forEachIndexed$iv = nodes2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void node;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    representation = (Node)item$iv;
                    int i = n;
                    boolean bl3 = false;
                    OrderedRegionalTile ort = new OrderedRegionalTile(regionalText.getLocation(), regionalText.getRepresentation(), i, 0.0, 8, null);
                    Map map = this.temporaryPrivateIndexers.getOrderedRegionalTileNodes();
                    Intrinsics.checkNotNull((Object)node);
                    map.put(node, new OrderedRegionalTileNode(ort, (Node)node));
                }
            }
        }
    }

    public final void buildCaptionedElementIndexer$scent_auto_mining() {
        TreeMultimap<Integer, Element> captionedElementIndexer = this.temporaryInternalIndexers.getCaptionedElementIndexer$scent_auto_mining();
        NodeTraversor.filter((NodeFilter)new NodeFilter(this, captionedElementIndexer){
            final /* synthetic */ VisualDocument this$0;
            final /* synthetic */ TreeMultimap<Integer, Element> $captionedElementIndexer;
            {
                this.this$0 = $receiver;
                this.$captionedElementIndexer = $captionedElementIndexer;
            }

            @NotNull
            public NodeFilter.FilterResult head(@NotNull Node node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!(node instanceof Element)) {
                    return NodeFilter.FilterResult.CONTINUE;
                }
                if (NodeCharactersKt.isDenseTextBlock$default((Node)node, (HarvestOptions)this.this$0.getOptions(), (int)0, (int)2, null)) {
                    return NodeFilter.FilterResult.SKIP_ENTIRELY;
                }
                if (NodeExtKt.hasCaption((Node)node)) {
                    String caption = NodeExtKt.getCaption((Node)node) + ";" + NodeExtKt.getName((Node)node);
                    this.$captionedElementIndexer.put((Object)caption.hashCode(), (Object)node);
                }
                return NodeFilter.FilterResult.CONTINUE;
            }
        }, (Node)((Node)this.document.body()));
    }

    /*
     * WARNING - void declaration
     */
    private final void findUserDefinedComponents(Iterable<String> selectors) {
        void $this$mapTo$iv$iv;
        Iterable<String> $this$map$iv = selectors;
        boolean $i$f$map = false;
        Iterable<String> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DomQueriesKt.select2$default((Node)((Node)this.document), (String)it, (int)0, (int)0, (int)6, null));
        }
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            VisualDocument.addComponentIfAbsent$default(this, it, VisualComponentType.USER, null, 4, null);
        }
    }

    private final void findNaiveComponents() {
        NodesKt.forEachElement$default((Node)((Node)this.body), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(this){
            final /* synthetic */ VisualDocument this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Element element) {
                boolean bl;
                block10: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Iterable $this$any$iv = this.this$0.getComponents();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            VisualComponent it = (VisualComponent)((Object)element$iv);
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getElement(), (Object)element)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNthScreen((Node)((Node)element)) > this.this$0.getOptions().getNScreens()) {
                    return;
                }
                String string = element.id();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id(...)");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    this.this$0.addComponentIfAbsent(element, VisualComponentType.NAIVE, "id");
                } else if (NodeExtKt.isTable((Node)((Node)element))) {
                    this.this$0.addComponentIfAbsent(element, VisualComponentType.NAIVE, "table");
                } else if (NodeExtKt.isList((Node)((Node)element))) {
                    this.this$0.addComponentIfAbsent(element, VisualComponentType.NAIVE, "list");
                }
            }
        }), (int)1, null);
    }

    private final void findTileAlignedComponent() {
        Map.Entry entry;
        Map.Entry element$iv;
        NavigableMap navigableMap = this.temporaryPrivateIndexers.getTileLeftIndexer().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            Integer alignedLeft = (Integer)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            if (nodes2.size() == 1) continue;
            if (nodes2.size() == 2) {
                Intrinsics.checkNotNull((Object)nodes2);
                Object object = CollectionsKt.first((Iterable)nodes2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                Node node = (Node)object;
                Object object2 = CollectionsKt.last((Iterable)nodes2);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"last(...)");
                Element component = this.findMinimumEnvelop(node, (Node)object2, this.getMaximumComponentHeight());
                if (component == null) continue;
                this.addComponentIfAbsent(component, VisualComponentType.DUAL, "dual");
                continue;
            }
            int minDist = this.options.getMinimumVerticalCollinearTextNodes();
            Intrinsics.checkNotNull((Object)nodes2);
            this.bidirectionalSearchComponent(CollectionsKt.toList((Iterable)nodes2), minDist);
        }
        NavigableMap navigableMap2 = this.temporaryPrivateIndexers.getTileCenterYIndexer().asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap2, (String)"asMap(...)");
        $this$forEach$iv = navigableMap2;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            Collection nodes3 = (Collection)entry.getValue();
            if (nodes3.size() < 4) continue;
            Intrinsics.checkNotNull((Object)nodes3);
            Object object = CollectionsKt.first((Iterable)nodes3);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            Node node = (Node)object;
            Object object3 = CollectionsKt.last((Iterable)nodes3);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"last(...)");
            Element component = this.findRowComponent(node, (Node)object3);
            if (component == null) continue;
            this.addComponentIfAbsent(component, VisualComponentType.DUAL, "row");
        }
    }

    private final void bidirectionalSearchComponent(List<? extends Node> nodes2, int minDist) {
        Node node;
        if (nodes2.isEmpty()) {
            return;
        }
        int size = nodes2.size();
        if (size != ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcTiles((Node)(node = (Node)CollectionsKt.first(nodes2)))) {
            this.logger.debug("Incorrect vertical collinear tile size " + size + " " + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcTiles((Node)node));
        }
        int alignedLeft = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)node);
        int last = nodes2.size() - 1;
        int maxHeight = this.getMaximumComponentHeight();
        int i = 0;
        if (i <= last) {
            while (true) {
                int j;
                int n;
                if ((n = i + minDist) <= (j = last)) {
                    while (true) {
                        Node v2;
                        Node v1;
                        Element envelop;
                        if ((envelop = this.findMinimumEnvelop(v1 = nodes2.get(i), v2 = nodes2.get(j), maxHeight)) != null) {
                            this.addComponentIfAbsent(envelop, VisualComponentType.COLLINEAR, "col(" + alignedLeft + ")[" + i + ", " + j + "]/" + size);
                        } else {
                            maxHeight = NodeExtKt.getY2((Node)v2) - NodeExtKt.getY((Node)v1);
                        }
                        if (j == n) break;
                        --j;
                    }
                }
                if (i == last) break;
                ++i;
            }
        }
    }

    private final Element findRowComponent(Node v1, Node v2) {
        if (NodeExtKt.getRight((Node)v2) - NodeExtKt.getLeft((Node)v1) < this.getMinimumComponentWidth()) {
            return null;
        }
        Function1 predicate2 = (Function1)new Function1<Element, Boolean>(v1, v2){
            final /* synthetic */ Node $v1;
            final /* synthetic */ Node $v2;
            {
                this.$v1 = $v1;
                this.$v2 = $v2;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = NodeExtKt.getHeight((Node)((Node)it));
                Node node = this.$v1.parent();
                Intrinsics.checkNotNull((Object)node);
                return n <= 4 * NodeExtKt.getHeight((Node)node) && NodeExtKt.getRectangle((Node)((Node)it)).contains(NodeExtKt.getRectangle((Node)this.$v1)) && NodeExtKt.getRectangle((Node)((Node)it)).contains(NodeExtKt.getRectangle((Node)this.$v2));
            }
        };
        return NodesKt.findFirstAncestor((Node)v1, (Function1)((Function1)new Function1<Element, Boolean>((Function1<? super Element, Boolean>)predicate2){
            final /* synthetic */ Function1<Element, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$predicate.invoke((Object)it);
            }
        }));
    }

    private final Element findMinimumEnvelop(Node v1, Node v2, int maxHeight) {
        Node node = v1.getExtension().getOwnerBody();
        if (node == null) {
            return null;
        }
        Node ownerBody = node;
        Function1 stop2 = (Function1)new Function1<Element, Boolean>(ownerBody, maxHeight){
            final /* synthetic */ Node $ownerBody;
            final /* synthetic */ int $maxHeight;
            {
                this.$ownerBody = $ownerBody;
                this.$maxHeight = $maxHeight;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NodeExtKt.getDepth((Node)((Node)it)) <= NodeExtKt.getDepth((Node)this.$ownerBody) || NodeExtKt.getHeight((Node)((Node)it)) > this.$maxHeight;
            }
        };
        Function1 predicate2 = (Function1)new Function1<Element, Boolean>(v1, v2){
            final /* synthetic */ Node $v1;
            final /* synthetic */ Node $v2;
            {
                this.$v1 = $v1;
                this.$v2 = $v2;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NodeExtKt.getRectangle((Node)((Node)it)).contains(NodeExtKt.getRectangle((Node)this.$v1)) && NodeExtKt.getRectangle((Node)((Node)it)).contains(NodeExtKt.getRectangle((Node)this.$v2));
            }
        };
        return NodesKt.findFirstAncestor((Node)v1, (Function1)((Function1)new Function1<Element, Boolean>((Function1<? super Element, Boolean>)stop2){
            final /* synthetic */ Function1<Element, Boolean> $stop;
            {
                this.$stop = $stop;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$stop.invoke((Object)it);
            }
        }), (Function1)((Function1)new Function1<Element, Boolean>((Function1<? super Element, Boolean>)predicate2){
            final /* synthetic */ Function1<Element, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$predicate.invoke((Object)it);
            }
        }));
    }

    public final void buildComponentTree() {
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualComponent child = (VisualComponent)((Object)element$iv);
            boolean bl = false;
            Element parentElement2 = NodesKt.findFirstAncestor((Node)((Node)child.getElement()), (Function1)buildComponentTree.1.parentElement.1.INSTANCE, (Function1)buildComponentTree.1.parentElement.2.INSTANCE);
            Object object = parentElement2;
            if (object == null || (object = VisualDocumentKt.getVisualComponent((Node)object)) == null) continue;
            object.appendChild((DocumentFragment)child);
        }
    }

    public final void arrangeComponents() {
        VisualComponent it;
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualComponent)((Object)element$iv);
            boolean bl = false;
            Element ele = it.getElement();
            it.setEnabled(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNumTiles((Node)((Node)ele)) >= 5);
        }
        $this$forEach$iv = this.components;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double r;
            VisualComponent parentComponent;
            it = (VisualComponent)((Object)element$iv);
            boolean bl = false;
            if (it.getParentComponent() == null) continue;
            Element child = it.getElement();
            Element parent = parentComponent.getElement();
            if (!parentComponent.isEnabled() || !((r = 1.0 * (double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNumTiles((Node)((Node)child)) / (double)ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNumTiles((Node)((Node)parent))) > 0.8)) continue;
            parentComponent.setEnabled(false);
        }
    }

    private final VisualComponent createComponentIf(Element envelop, VisualComponentType type, String memo) {
        VisualComponent visualComponent;
        Element element;
        if (type == VisualComponentType.USER) {
            return new VisualComponent(envelop, type, memo);
        }
        Element it = element = envelop;
        boolean bl = false;
        Object object = (Boolean)this.componentPredicate.invoke((Object)it) != false ? element : null;
        if (object != null) {
            it = object;
            boolean bl2 = false;
            visualComponent = new VisualComponent(it, type, memo);
        } else {
            visualComponent = null;
        }
        return visualComponent;
    }

    static /* synthetic */ VisualComponent createComponentIf$default(VisualDocument visualDocument, Element element, VisualComponentType visualComponentType, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return visualDocument.createComponentIf(element, visualComponentType, string);
    }

    @NotNull
    public final Pair<VisualComponent, Boolean> addComponentIfAbsent(@NotNull Element element, @NotNull VisualComponentType type, @NotNull String memo) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)memo, (String)"memo");
        VisualComponent visualComponent = this.createComponentIf(element, type, memo);
        if (visualComponent == null) {
            return TuplesKt.to(null, (Object)false);
        }
        VisualComponent vc = visualComponent;
        return this.addComponentIfAbsent(vc);
    }

    public static /* synthetic */ Pair addComponentIfAbsent$default(VisualDocument visualDocument, Element element, VisualComponentType visualComponentType, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        return visualDocument.addComponentIfAbsent(element, visualComponentType, string);
    }

    private final Pair<VisualComponent, Boolean> addComponentIfAbsent(VisualComponent component) {
        Object v0;
        block2: {
            Iterable iterable = this.components;
            for (Object t : iterable) {
                VisualComponent it = (VisualComponent)((Object)t);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)it), (Object)((Object)component))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        VisualComponent old = v0;
        if (old == null) {
            this.addComponent(component);
            return TuplesKt.to((Object)((Object)component), (Object)true);
        }
        return TuplesKt.to((Object)((Object)old), (Object)false);
    }

    private final void addComponent(VisualComponent component) {
        VisualDocumentKt.setVisualComponent((Node)component.getElement(), component);
        this.components.add(component);
    }

    /*
     * WARNING - void declaration
     */
    private final void colorComponents() {
        void $this$mapTo$iv$iv;
        Object object;
        String style = "style";
        Collection collection = this.temporaryPrivateIndexers.getTileLeftIndexer().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            List list = ColorFamily.INSTANCE.getBlueColors();
            Intrinsics.checkNotNull((Object)it);
            Color color = (Color)list.get(NodeExtKt.getSequence((Node)it) % ColorFamily.INSTANCE.getBlueColors().size());
            Node node = object = it.parent();
            if (node == null) continue;
            Intrinsics.checkNotNull((Object)node);
            NodeExtKt.addTupleItem((Node)object, (String)style, (Object)("border-left: 1px solid #" + ColorsKt.toHexString((Color)color)));
        }
        Iterable $this$map$iv = this.components;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (VisualComponent)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getElement());
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setColor((Node)((Node)it), (Color)((Color)ColorFamily.INSTANCE.getRedColors3().get(NodeExtKt.getSequence((Node)((Node)it)) % ColorFamily.INSTANCE.getRedColors3().size())));
            Node node = (Node)it;
            Color color = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getColor((Node)((Node)it));
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"<get-color>(...)");
            NodeExtKt.addTupleItem((Node)node, (String)style, (Object)("border: 1px solid #" + ColorsKt.toHexString((Color)color)));
        }
        NodesKt.forEachMatching((Node)((Node)this.body), (Function1)((Function1)new Function1<Node, Boolean>(style){
            final /* synthetic */ String $style;
            {
                this.$style = $style;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NodeExtKt.hasTuple((Node)it, (String)this.$style);
            }
        }), (Function1)((Function1)new Function1<Node, Unit>(style){
            final /* synthetic */ String $style;
            {
                this.$style = $style;
                super(1);
            }

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.attr(this.$style, CollectionsKt.joinToString$default((Iterable)NodeExtKt.getTuple((Node)it, (String)this.$style), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void validateFeatures() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FeatureValidator validator = new FeatureValidator(this.document);
        Iterable iterable = this.components;
        FeatureValidator featureValidator = validator;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualComponent visualComponent = (VisualComponent)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getElement());
        }
        featureValidator.validate((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ TemporaryPrivateIndexers access$getTemporaryPrivateIndexers$p(VisualDocument $this) {
        return $this.temporaryPrivateIndexers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007J\u001e\u0010\u001a\u001a\u00020\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004j\u0002`\u001bJ\u001e\u0010\u001c\u001a\u00020\u00172\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0004j\u0002`\u000fR$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0004j\u0002`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/analysis/corpus/VisualDocument$TemporaryInternalIndexers;", "", "()V", "captionedElementIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "getCaptionedElementIndexer$scent_auto_mining", "()Lcom/google/common/collect/TreeMultimap;", "layoutLeftIndexer", "getLayoutLeftIndexer$scent_auto_mining", "regionalTileNodeIndexer", "Lai/platon/scent/analysis/corpus/RegionalTile;", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/analysis/corpus/RegionalTileNodeIndexer;", "getRegionalTileNodeIndexer$scent_auto_mining", "termFrequency", "Lai/platon/pulsar/common/FrequencyManager;", "", "getTermFrequency$scent_auto_mining", "()Lai/platon/pulsar/common/FrequencyManager;", "clear", "", "moveCaptionedElementIndexerTo", "other", "moveLayoutLeftIndexerTo", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "moveRegionalTileNodeIndexerTo", "scent-auto-mining"})
    @SourceDebugExtension(value={"SMAP\nVisualDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualDocument.kt\nai/platon/scent/analysis/corpus/VisualDocument$TemporaryInternalIndexers\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,669:1\n215#2,2:670\n*S KotlinDebug\n*F\n+ 1 VisualDocument.kt\nai/platon/scent/analysis/corpus/VisualDocument$TemporaryInternalIndexers\n*L\n118#1:670,2\n*E\n"})
    public static final class TemporaryInternalIndexers {
        @NotNull
        private final FrequencyManager<String> termFrequency = new FrequencyManager();
        @NotNull
        private final TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer;
        @NotNull
        private final TreeMultimap<Integer, Element> layoutLeftIndexer;
        @NotNull
        private final TreeMultimap<Integer, Element> captionedElementIndexer;

        public TemporaryInternalIndexers() {
            TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodePositionComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
            this.regionalTileNodeIndexer = treeMultimap;
            TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Element it = (Element)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(NodeExtKt.getTop((Node)((Node)it)));
                    it = (Element)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getTop((Node)((Node)it))));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
            this.layoutLeftIndexer = treeMultimap2;
            TreeMultimap treeMultimap3 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap3, (String)"create(...)");
            this.captionedElementIndexer = treeMultimap3;
        }

        @NotNull
        public final FrequencyManager<String> getTermFrequency$scent_auto_mining() {
            return this.termFrequency;
        }

        @NotNull
        public final TreeMultimap<RegionalTile, Node> getRegionalTileNodeIndexer$scent_auto_mining() {
            return this.regionalTileNodeIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getLayoutLeftIndexer$scent_auto_mining() {
            return this.layoutLeftIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getCaptionedElementIndexer$scent_auto_mining() {
            return this.captionedElementIndexer;
        }

        public final void moveRegionalTileNodeIndexerTo(@NotNull TreeMultimap<RegionalTile, Node> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            NavigableMap navigableMap = this.regionalTileNodeIndexer.asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
            Map $this$forEach$iv = navigableMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                RegionalTile regionalText = (RegionalTile)entry.getKey();
                Collection nodes2 = (Collection)entry.getValue();
                if (!(regionalText.getTf() == (double)nodes2.size())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                other.putAll((Object)regionalText, (Iterable)nodes2);
            }
            this.regionalTileNodeIndexer.clear();
        }

        public final void moveLayoutLeftIndexerTo(@NotNull TreeMultimap<Integer, Node> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            other.putAll((Multimap)this.layoutLeftIndexer);
            this.layoutLeftIndexer.clear();
        }

        public final void moveCaptionedElementIndexerTo(@NotNull TreeMultimap<Integer, Element> other) {
            Intrinsics.checkNotNullParameter(other, (String)"other");
            other.putAll((Multimap)this.captionedElementIndexer);
            this.captionedElementIndexer.clear();
        }

        public final void clear() {
            this.regionalTileNodeIndexer.clear();
            this.layoutLeftIndexer.clear();
            this.captionedElementIndexer.clear();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\nj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\nj\u0002`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lai/platon/scent/analysis/corpus/VisualDocument$TemporaryPrivateIndexers;", "", "()V", "orderedRegionalTileNodes", "Ljava/util/TreeMap;", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/analysis/corpus/OrderedRegionalTileNode;", "getOrderedRegionalTileNodes", "()Ljava/util/TreeMap;", "tileCenterYIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "getTileCenterYIndexer", "()Lcom/google/common/collect/TreeMultimap;", "tileLeftIndexer", "getTileLeftIndexer", "clear", "", "scent-auto-mining"})
    private static final class TemporaryPrivateIndexers {
        @NotNull
        private final TreeMap<Node, OrderedRegionalTileNode> orderedRegionalTileNodes = new TreeMap(NodesKt.getNodePositionComparator());
        @NotNull
        private final TreeMultimap<Integer, Node> tileLeftIndexer;
        @NotNull
        private final TreeMultimap<Integer, Node> tileCenterYIndexer;

        public TemporaryPrivateIndexers() {
            TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(NodeExtKt.getTop((Node)it));
                    it = (Node)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getTop((Node)it)));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
            this.tileLeftIndexer = treeMultimap;
            TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(NodeExtKt.getX((Node)it));
                    it = (Node)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getX((Node)it)));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
            this.tileCenterYIndexer = treeMultimap2;
        }

        @NotNull
        public final TreeMap<Node, OrderedRegionalTileNode> getOrderedRegionalTileNodes() {
            return this.orderedRegionalTileNodes;
        }

        @NotNull
        public final TreeMultimap<Integer, Node> getTileLeftIndexer() {
            return this.tileLeftIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Node> getTileCenterYIndexer() {
            return this.tileCenterYIndexer;
        }

        public final void clear() {
            this.orderedRegionalTileNodes.clear();
            this.tileLeftIndexer.clear();
            this.tileCenterYIndexer.clear();
        }
    }
}

