/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.CorpusTextView;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.analysis.diagnosis.AutoMiningDiagnotor;
import ai.platon.scent.analysis.diagnosis.ClusterTaskDiagnotor;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.unsupervised.ComponentClusterGroup;
import ai.platon.scent.ml.unsupervised.IRMetric;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u0006\u0010!\u001a\u00020\u001bJ\b\u0010\"\u001a\u00020\u001bH\u0002J\u0006\u0010#\u001a\u00020\u001bJ\b\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020\u001bJ\b\u0010'\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lai/platon/scent/analysis/diagnosis/AutoMiningDiagnotor;", "", "corpus", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "clusterer", "Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "miningResult", "Lai/platon/scent/analysis/AutoMiningResult;", "(Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;Lai/platon/scent/ml/semisupervised/NodeClusterRunner;Lai/platon/scent/analysis/AutoMiningResult;)V", "componentDiagnotors", "", "Lai/platon/scent/analysis/diagnosis/ClusterTaskDiagnotor;", "diagnotors", "documents", "Lai/platon/scent/analysis/corpus/VisualDocument;", "expectedComponents", "", "getExpectedComponents", "()Ljava/util/List;", "logger", "Lorg/slf4j/Logger;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "appendComponentReportTo", "", "component", "Lorg/jsoup/nodes/Element;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "diagnose", "estimateSegmentation", "evaluate", "evaluateKMeans", "Lai/platon/scent/ml/unsupervised/IRMetric;", "report", "reportHyperPaths", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nAutoMiningDiagnotor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMiningDiagnotor.kt\nai/platon/scent/analysis/diagnosis/AutoMiningDiagnotor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1620#2,3:215\n1620#2,3:218\n1855#2:221\n1855#2,2:222\n1856#2:224\n1855#2,2:227\n1360#2:230\n1446#2,5:231\n1549#2:236\n1620#2,3:237\n1620#2,3:240\n1360#2:243\n1446#2,5:244\n1477#2:249\n1502#2,3:250\n1505#2,3:260\n1477#2:263\n1502#2,3:264\n1505#2,3:274\n1774#2,4:278\n1324#3,2:225\n1326#3:229\n372#4,7:253\n372#4,7:267\n1#5:277\n*S KotlinDebug\n*F\n+ 1 AutoMiningDiagnotor.kt\nai/platon/scent/analysis/diagnosis/AutoMiningDiagnotor\n*L\n74#1:215,3\n78#1:218,3\n99#1:221\n100#1:222,2\n99#1:224\n115#1:227,2\n139#1:230\n139#1:231,5\n139#1:236\n139#1:237,3\n141#1:240,3\n144#1:243\n144#1:244,5\n147#1:249\n147#1:250,3\n147#1:260,3\n151#1:263\n151#1:264,3\n151#1:274,3\n156#1:278,4\n112#1:225,2\n112#1:229\n147#1:253,7\n151#1:267,7\n*E\n"})
public final class AutoMiningDiagnotor {
    @NotNull
    private final AnalysablePageCorpus corpus;
    @NotNull
    private final NodeClusterRunner clusterer;
    @NotNull
    private final AutoMiningResult miningResult;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<VisualDocument> documents;
    @NotNull
    private final List<String> expectedComponents;
    @NotNull
    private List<ClusterTaskDiagnotor> componentDiagnotors;
    @NotNull
    private final List<ClusterTaskDiagnotor> diagnotors;

    public AutoMiningDiagnotor(@NotNull AnalysablePageCorpus corpus, @NotNull NodeClusterRunner clusterer, @NotNull AutoMiningResult miningResult) {
        Intrinsics.checkNotNullParameter((Object)corpus, (String)"corpus");
        Intrinsics.checkNotNullParameter((Object)clusterer, (String)"clusterer");
        Intrinsics.checkNotNullParameter((Object)miningResult, (String)"miningResult");
        this.corpus = corpus;
        this.clusterer = clusterer;
        this.miningResult = miningResult;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AutoMiningDiagnotor.class));
        this.documents = this.corpus.getQualifiedDocuments$scent_auto_mining();
        this.expectedComponents = new ArrayList();
        this.componentDiagnotors = new ArrayList();
        this.diagnotors = new ArrayList();
    }

    private final Path getReportDirectory() {
        return this.corpus.getReportDirectory().resolve("diagnosis");
    }

    @NotNull
    public final List<String> getExpectedComponents() {
        return this.expectedComponents;
    }

    public final void evaluate() {
    }

    public final void diagnose() {
        TileClusterGroup it;
        Collection collection;
        Iterable $this$mapTo$iv;
        if (this.corpus.getQualifiedDocuments$scent_auto_mining().isEmpty()) {
            return;
        }
        this.logger.info("Diagnose components ...");
        Iterable iterable = this.clusterer.getComponentClusterGroups$scent_auto_mining();
        Collection destination$iv = this.componentDiagnotors;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            ComponentClusterGroup componentClusterGroup = (ComponentClusterGroup)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new ClusterTaskDiagnotor(this.miningResult, it, 0, 4, null));
        }
        this.componentDiagnotors.parallelStream().forEach(arg_0 -> AutoMiningDiagnotor.diagnose$lambda$1(diagnose.2.INSTANCE, arg_0));
        this.logger.info("Diagnose tiles ...");
        $this$mapTo$iv = this.clusterer.getTileClusterGroups$scent_auto_mining();
        destination$iv = this.diagnotors;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (TileClusterGroup)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new ClusterTaskDiagnotor(this.miningResult, it, 0, 4, null));
        }
        this.diagnotors.parallelStream().forEach(arg_0 -> AutoMiningDiagnotor.diagnose$lambda$3(diagnose.4.INSTANCE, arg_0));
    }

    public final void report() {
        try {
            Files.createDirectories(this.getReportDirectory(), new FileAttribute[0]);
            this.reportHyperPaths();
            new CorpusTextView(this.corpus, this.componentDiagnotors).build();
            this.logger.info("Corpus analysis results are saved in {}", (Object)this.corpus.getReportDirectory());
        }
        catch (Exception e) {
            this.logger.warn(ExceptionsKt.stringify$default((Throwable)e, (String)"Failed to report - ", null, (int)2, null));
        }
    }

    private final void estimateSegmentation() {
        Iterable $this$forEach$iv = this.documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.expectedComponents;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String selector = (String)element$iv2;
                boolean bl2 = false;
                Element element = it.getFeaturedDocument().selectFirstOrNull(selector);
                if (element == null) continue;
                element.attr("a-man-label", "component");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportHyperPaths() {
        StringBuilder sb = new StringBuilder();
        Sequence $this$forEachIndexed$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.clusterer.getTileClusterGroups$scent_auto_mining()), (Function1)reportHyperPaths.1.INSTANCE);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Element component;
            void group;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileClusterGroup tileClusterGroup = (TileClusterGroup)item$iv;
            int i = n;
            boolean bl = false;
            if (group.getSampleComponent() == null) continue;
            this.appendComponentReportTo(component, sb);
            Iterable $this$forEach$iv = group.getClusters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TileCluster it = (TileCluster)element$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = sb.append(it.getHyperPath().format());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            }
        }
        Path path = this.getReportDirectory().resolve("hyper-paths.txt");
        Files.writeString(path, (CharSequence)sb.toString(), new OpenOption[0]);
    }

    private final void appendComponentReportTo(Element component, StringBuilder sb) {
        StringBuilder stringBuilder;
        String text = StringUtils.abbreviateMiddle((String)component.text(), (String)"...", (int)1000);
        StringBuilder $this$appendComponentReportTo_u24lambda_u248 = stringBuilder = sb;
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$appendComponentReportTo_u24lambda_u248.append("\n-------------------");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = stringBuilder2.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        StringBuilder stringBuilder4 = stringBuilder3.append(component.baseUri());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        StringBuilder stringBuilder6 = stringBuilder5.append(NodeExtKt.getNamedRect((Node)((Node)component)));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$appendComponentReportTo_u24lambda_u248.append(">>>");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        StringBuilder stringBuilder8 = stringBuilder7.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        StringBuilder stringBuilder9 = stringBuilder8.append(text);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        StringBuilder stringBuilder10 = stringBuilder9.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        StringBuilder stringBuilder11 = stringBuilder10.append("<<<");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder12 = $this$appendComponentReportTo_u24lambda_u248.append(component.cssSelector());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$appendComponentReportTo_u24lambda_u248.append('\n'), (String)"append(...)");
    }

    /*
     * WARNING - void declaration
     */
    private final IRMetric evaluateKMeans() {
        void $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        VisualDocument it;
        Iterable $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$flatMapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (VisualComponent)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getElement());
        }
        List components = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.documents;
        Collection destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            Object item$iv$iv;
            item$iv$iv = (VisualDocument)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it2.getComponents().size());
        }
        Frequency frequency = (Frequency)destination$iv;
        this.logger.info("VisualComponent size frequency: \n" + frequency);
        Iterable $this$flatMap$iv2 = this.clusterer.getTileClusterGroups$scent_auto_mining();
        boolean $i$f$flatMap2 = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TileClusterGroup it3 = (TileClusterGroup)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it3.getClusters();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        List clusters = (List)destination$iv$iv2;
        Iterable $this$groupBy$iv = components;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Element it4 = (Element)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = NodeExtKt.getCaption((Node)((Node)it4));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv3 = (List)object;
            list$iv$iv3.add(element$iv$iv);
        }
        Map expectedClusters = destination$iv$iv3;
        IRMetric metrics = new IRMetric(components.size(), 0, 0, 6, null);
        for (TileCluster cluster2 : clusters) {
            int n;
            void $this$count$iv;
            Map.Entry entry;
            Object object;
            Object v2;
            void $this$groupByTo$iv$iv2;
            Object element$iv$iv;
            Iterable $this$groupBy$iv2 = cluster2.getPoints();
            boolean $i$f$groupBy22 = false;
            element$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv4 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv2) {
                Object object2;
                NodePoint it5 = (NodePoint)((Object)element$iv$iv2);
                boolean bl = false;
                String key$iv$iv = NodeExtKt.getCaption((Node)it5.getNode());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv4 = (List)object2;
                list$iv$iv4.add(element$iv$iv2);
            }
            Iterable $i$f$groupBy22 = destination$iv$iv4.entrySet();
            Iterator iterator = $i$f$groupBy22.iterator();
            if (!iterator.hasNext()) {
                v2 = null;
            } else {
                object = iterator.next();
                if (!iterator.hasNext()) {
                    v2 = object;
                } else {
                    Map.Entry it22 = (Map.Entry)object;
                    boolean bl4 = false;
                    int it22 = ((List)it22.getValue()).size();
                    do {
                        Object bl4 = iterator.next();
                        Map.Entry it32 = (Map.Entry)bl4;
                        boolean $i$a$-maxByOrNull-AutoMiningDiagnotor$evaluateKMeans$entry$3 = false;
                        int it32 = ((List)it32.getValue()).size();
                        if (it22 >= it32) continue;
                        object = bl4;
                        it22 = it32;
                    } while (iterator.hasNext());
                    v2 = object;
                }
            }
            if ((entry = (Map.Entry)v2) == null) continue;
            String caption = (String)entry.getKey();
            List points = (List)entry.getValue();
            metrics.setRetrieved(metrics.getRetrieved() + points.size());
            if ((List)expectedClusters.get(caption) == null) continue;
            Object expectedNodes = object;
            boolean bl = false;
            Iterable it32 = points;
            int n2 = metrics.getHit();
            IRMetric iRMetric = metrics;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    NodePoint it6 = (NodePoint)((Object)element$iv);
                    boolean bl5 = false;
                    if (!CollectionsKt.contains((Iterable)((Iterable)expectedNodes), (Object)it6.getNode()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            iRMetric.setHit(n2 + n3);
        }
        this.logger.info("Cluster evaluation: " + metrics);
        return metrics;
    }

    private static final void diagnose$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void diagnose$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

