/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.diagnosis;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.FrequencyManager;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.diagnosis.ClusterDiagnosor;
import ai.platon.scent.ml.MathsKt;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.CentroidCluster;
import ai.platon.scent.ml.unsupervised.Cluster;
import ai.platon.scent.ml.unsupervised.Measurable;
import com.google.common.collect.Multiset;
import java.awt.Rectangle;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010-\u001a\u00020.H\u0016J \u0010/\u001a\u00020.2\b\b\u0002\u00100\u001a\u00020\u00062\f\b\u0002\u00101\u001a\u000602j\u0002`3H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)\u00a8\u00064"}, d2={"Lai/platon/scent/analysis/diagnosis/ClusterDiagnosor;", "Lai/platon/scent/ml/unsupervised/Measurable;", "cluster", "Lai/platon/scent/ml/unsupervised/Cluster;", "Lai/platon/scent/ml/NodePoint;", "suggestSampleSize", "", "measure", "Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "(Lai/platon/scent/ml/unsupervised/Cluster;ILorg/apache/commons/math3/ml/distance/DistanceMeasure;)V", "getCluster", "()Lai/platon/scent/ml/unsupervised/Cluster;", "diameter", "", "getDiameter", "()D", "frequencies", "Lai/platon/pulsar/common/FrequencyManager;", "", "getFrequencies", "()Lai/platon/pulsar/common/FrequencyManager;", "intraPointsDistancesSummary", "Lorg/apache/commons/math3/stat/descriptive/SummaryStatistics;", "getIntraPointsDistancesSummary", "()Lorg/apache/commons/math3/stat/descriptive/SummaryStatistics;", "logger", "Lorg/slf4j/Logger;", "getMeasure", "()Lorg/apache/commons/math3/ml/distance/DistanceMeasure;", "pairwiseIntraPointsDistances", "Lorg/apache/commons/math3/linear/Array2DRowRealMatrix;", "getPairwiseIntraPointsDistances", "()Lorg/apache/commons/math3/linear/Array2DRowRealMatrix;", "points", "", "getPoints", "()Ljava/util/List;", "samplePoints", "getSamplePoints", "sampleSize", "getSampleSize", "()I", "size", "getSize", "getSuggestSampleSize", "diagnose", "", "show", "n", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClusterTaskDiagnotor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/ClusterDiagnosor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,667:1\n13351#2,2:668\n1620#3,3:670\n1620#3,3:673\n1620#3,3:676\n1864#3,2:679\n1864#3,3:681\n1866#3:684\n*S KotlinDebug\n*F\n+ 1 ClusterTaskDiagnotor.kt\nai/platon/scent/analysis/diagnosis/ClusterDiagnosor\n*L\n94#1:668,2\n97#1:670,3\n98#1:673,3\n99#1:676,3\n114#1:679,2\n116#1:681,3\n114#1:684\n*E\n"})
public class ClusterDiagnosor
implements Measurable {
    @NotNull
    private final Cluster<NodePoint> cluster;
    private final int suggestSampleSize;
    @NotNull
    private final DistanceMeasure measure;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<NodePoint> points;
    private final int sampleSize;
    @NotNull
    private final List<NodePoint> samplePoints;
    private final int size;
    @NotNull
    private final Array2DRowRealMatrix pairwiseIntraPointsDistances;
    @NotNull
    private final SummaryStatistics intraPointsDistancesSummary;
    @NotNull
    private final FrequencyManager<String> frequencies;

    public ClusterDiagnosor(@NotNull Cluster<NodePoint> cluster2, int suggestSampleSize, @NotNull DistanceMeasure measure) {
        Intrinsics.checkNotNullParameter(cluster2, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)measure, (String)"measure");
        this.cluster = cluster2;
        this.suggestSampleSize = suggestSampleSize;
        this.measure = measure;
        this.logger = LogsKt.getLogger((Object)this);
        this.points = this.cluster.getPoints();
        this.sampleSize = Math.min(this.suggestSampleSize, this.points.size());
        this.samplePoints = CollectionsKt.take((Iterable)this.points, (int)this.sampleSize);
        this.size = this.points.size();
        this.pairwiseIntraPointsDistances = new Array2DRowRealMatrix(this.sampleSize, this.sampleSize);
        this.intraPointsDistancesSummary = new SummaryStatistics();
        this.frequencies = new FrequencyManager();
    }

    public /* synthetic */ ClusterDiagnosor(Cluster cluster2, int n, DistanceMeasure distanceMeasure, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 40;
        }
        if ((n2 & 4) != 0) {
            distanceMeasure = (DistanceMeasure)new EuclideanDistance();
        }
        this(cluster2, n, distanceMeasure);
    }

    @NotNull
    public final Cluster<NodePoint> getCluster() {
        return this.cluster;
    }

    public final int getSuggestSampleSize() {
        return this.suggestSampleSize;
    }

    @Override
    @NotNull
    public DistanceMeasure getMeasure() {
        return this.measure;
    }

    @NotNull
    public final List<NodePoint> getPoints() {
        return this.points;
    }

    public final int getSampleSize() {
        return this.sampleSize;
    }

    @NotNull
    public final List<NodePoint> getSamplePoints() {
        return this.samplePoints;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Array2DRowRealMatrix getPairwiseIntraPointsDistances() {
        return this.pairwiseIntraPointsDistances;
    }

    @NotNull
    public final SummaryStatistics getIntraPointsDistancesSummary() {
        return this.intraPointsDistancesSummary;
    }

    public final double getDiameter() {
        return this.intraPointsDistancesSummary.getMax();
    }

    @NotNull
    public final FrequencyManager<String> getFrequencies() {
        return this.frequencies;
    }

    /*
     * WARNING - void declaration
     */
    public void diagnose() {
        void $this$mapTo$iv;
        void $this$mapTo$iv2;
        Collection collection;
        void $this$mapTo$iv3;
        MathsKt.fillSymmetricalMatrix(this.samplePoints, (RealMatrix)this.pairwiseIntraPointsDistances, (Function2<? super RealVector, ? super RealVector, Double>)((Function2)new Function2<RealVector, RealVector, Double>(this){
            final /* synthetic */ ClusterDiagnosor this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Double invoke(@NotNull RealVector p1, @NotNull RealVector p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return this.this$0.distance(p1, p2);
            }
        }));
        int n = this.sampleSize;
        for (int i = 0; i < n; ++i) {
            double[] $this$forEach$iv;
            Intrinsics.checkNotNullExpressionValue((Object)this.pairwiseIntraPointsDistances.getRow(i), (String)"getRow(...)");
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int j = 0; j < n2; ++j) {
                double element$iv;
                double it = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                this.intraPointsDistancesSummary.addValue(it);
            }
        }
        Iterable iterable = this.cluster.getPoints();
        Iterable destination$iv = (Collection)new Frequency("paths");
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv3) {
            void it;
            NodePoint element$iv = (NodePoint)((Object)item$iv);
            collection = destination$iv;
            boolean bl = false;
            collection.add(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getPath((Node)it.getNode()).getSelector3());
        }
        Frequency paths = (Frequency)destination$iv;
        destination$iv = this.cluster.getPoints();
        Iterable destination$iv2 = (Collection)new Frequency("shapes");
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            NodePoint bl = (NodePoint)((Object)item$iv);
            collection = destination$iv2;
            boolean bl2 = false;
            collection.add(GeometricsKt.getStr((Rectangle)NodeExtKt.getRectangle((Node)it.getNode())));
        }
        Frequency shapes = (Frequency)destination$iv2;
        destination$iv2 = this.cluster.getPoints();
        Collection destination$iv3 = (Collection)new Frequency("texts");
        boolean $i$f$mapTo3 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NodePoint bl2 = (NodePoint)((Object)item$iv);
            collection = destination$iv3;
            boolean bl = false;
            collection.add(NodeExtKt.getCleanText((Node)it.getNode()));
        }
        Frequency texts2 = (Frequency)destination$iv3;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"paths", (Object)paths), TuplesKt.to((Object)"shapes", (Object)shapes), TuplesKt.to((Object)"texts", (Object)texts2)};
        MapsKt.toMap((Map)MapsKt.mapOf((Pair[])pairArray), (Map)((Map)this.frequencies));
    }

    /*
     * WARNING - void declaration
     */
    public void show(int n, @NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        StringBuilder stringBuilder = sb.append("Intra-cluster distances");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        StringBuilder stringBuilder2 = stringBuilder.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = stringBuilder2.append(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        StringBuilder stringBuilder4 = stringBuilder3.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        StringBuilder stringBuilder5 = stringBuilder4.append('\n');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        StringBuilder stringBuilder6 = stringBuilder5.append(this.intraPointsDistancesSummary);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        int n2 = Math.min(n, this.sampleSize);
        StringBuilder stringBuilder7 = sb.append("Distance matrix for " + n2 + "/" + this.points.size() + " points: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        String header2 = CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(0, n2 - 1)), (CharSequence)"", null, null, (int)0, null, (Function1)show.header.1.INSTANCE, (int)30, null);
        StringBuilder stringBuilder8 = sb.append(StringsKt.repeat((CharSequence)" ", (int)10) + header2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        List pointsToShow = CollectionsKt.take((Iterable)this.samplePoints, (int)n2);
        Iterable $this$forEachIndexed$iv = pointsToShow;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n3;
            boolean bl = false;
            String string = "%10d";
            Object[] objectArray = new Object[]{i};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2);
            Iterable $this$forEachIndexed$iv2 = pointsToShow;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                Object[] objectArray2;
                String string3;
                int n4;
                if ((n4 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                NodePoint nodePoint2 = (NodePoint)((Object)item$iv2);
                int j = n4;
                boolean bl2 = false;
                if (i < j) {
                    void p2;
                    void p1;
                    string3 = "%10.4f";
                    objectArray2 = new Object[]{this.distance((ArrayRealVector)p1, (ArrayRealVector)p2)};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                    sb.append(string4);
                    continue;
                }
                string3 = "%10s";
                objectArray2 = new Object[]{"-"};
                String string5 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                sb.append(string5);
            }
            Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder9 = sb.append("diameter: " + this.getDiameter() + ", distortion: " + this.cluster.getDistortion());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)sb.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder10 = sb.append("Term frequencies: ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        this.frequencies.forEach((arg_0, arg_1) -> ClusterDiagnosor.show$lambda$6((Function2)new Function2<String, Frequency<String>, Unit>(this, sb){
            final /* synthetic */ ClusterDiagnosor this$0;
            final /* synthetic */ StringBuilder $sb;
            {
                this.this$0 = $receiver;
                this.$sb = $sb;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull Frequency<String> frequency) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(frequency, (String)"frequency");
                String string = CollectionsKt.joinToString$default((Iterable)frequency.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Multiset.Entry<String>, CharSequence>(name, this.this$0){
                    final /* synthetic */ String $name;
                    final /* synthetic */ ClusterDiagnosor this$0;
                    {
                        this.$name = $name;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Multiset.Entry<String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        String string = this.$name + ":\t%d/%.2f\t%s";
                        Object[] objectArray = new Object[]{it.getCount(), 1.0 * (double)it.getCount() / (double)this.this$0.getSize(), it.getElement()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }), (int)30, null);
                StringBuilder stringBuilder = this.$sb;
                String it = string;
                boolean bl = false;
                StringBuilder stringBuilder2 = stringBuilder.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            }
        }, arg_0, arg_1));
    }

    public static /* synthetic */ void show$default(ClusterDiagnosor clusterDiagnosor, int n, StringBuilder stringBuilder, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: show");
        }
        if ((n2 & 1) != 0) {
            n = 20;
        }
        if ((n2 & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        clusterDiagnosor.show(n, stringBuilder);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findClosestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findClosestPoint(this, point, points);
    }

    @Override
    @NotNull
    public IndexedValue<CentroidCluster<NodePoint>> findClosestCluster(int i, @NotNull NodePoint point, @NotNull List<? extends CentroidCluster<NodePoint>> clusters) {
        return Measurable.DefaultImpls.findClosestCluster(this, i, point, clusters);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findClosestCluster(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findClosestCluster(this, cluster2, cluster22);
    }

    @Override
    @NotNull
    public IndexedValue<RealVector> findFarthestPoint(@NotNull RealVector point, @NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoint(this, point, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> points) {
        return Measurable.DefaultImpls.findFarthestPoints(this, points);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> findFarthestPoints(@NotNull List<? extends RealVector> cluster2, @NotNull List<? extends RealVector> cluster22) {
        return Measurable.DefaultImpls.findFarthestPoints(this, cluster2, cluster22);
    }

    @Override
    public double distance(@NotNull RealVector p1, @NotNull RealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    @Override
    public double distance(@NotNull ArrayRealVector p1, @NotNull ArrayRealVector p2) {
        return Measurable.DefaultImpls.distance((Measurable)this, p1, p2);
    }

    private static final void show$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

