/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.gui;

import ai.platon.pulsar.common.ColorFamily;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.math.geometric.GeoIntPoint;
import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.corpus.VisualDocumentKt;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.DirectedGeometricGraph;
import ai.platon.scent.dom.nodes.NodeEdge;
import ai.platon.scent.dom.nodes.NodeVertex;
import ai.platon.scent.dom.nodes.UnitGrid;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J \u0010\u0014\u001a\u00020=2\u0006\u0010B\u001a\u00020\n2\u0006\u0010@\u001a\u00020A2\u0006\u0010C\u001a\u00020\u0006H\u0002J(\u0010D\u001a\u00020=2\u0006\u0010B\u001a\u00020\n2\u0006\u0010E\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u00062\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010F\u001a\u00020=2\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010G\u001a\u00020=2\u0006\u0010C\u001a\u00020\u00062\u0006\u0010@\u001a\u00020AH\u0002J.\u0010H\u001a\u00020=2\u0006\u0010B\u001a\u00020\n2\u0006\u0010E\u001a\u00020\n2\u0006\u0010@\u001a\u00020A2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0JH\u0002J\b\u0010L\u001a\u000205H\u0016J \u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nH\u0016J\b\u0010R\u001a\u00020\u000fH\u0016J\b\u0010S\u001a\u00020\u000fH\u0016J \u0010T\u001a\u00020\n2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020\nH\u0016J\u0010\u0010U\u001a\u00020=2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020=2\u0006\u0010V\u001a\u00020WH\u0016J\u0010\u0010Y\u001a\u00020=2\u0006\u0010Z\u001a\u00020[H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010!\"\u0004\b*\u0010#R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010!\"\u0004\b,\u0010#R\u000e\u0010-\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010!R\u0011\u00102\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010!R\u0019\u00104\u001a\n 6*\u0004\u0018\u00010505\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001a\u00109\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0011\"\u0004\b;\u0010\u0013\u00a8\u0006\\"}, d2={"Lai/platon/scent/gui/ScrollableCanvas;", "Ljavax/swing/JLabel;", "Ljavax/swing/Scrollable;", "Ljava/awt/event/MouseMotionListener;", "graphs", "", "Lai/platon/scent/dom/nodes/DirectedGeometricGraph;", "lines", "Ljava/awt/geom/Line2D;", "maxUnitIncrement", "", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Ljava/lang/Iterable;Ljava/lang/Iterable;ILai/platon/scent/dom/HarvestOptions;)V", "align", "", "getAlign", "()Z", "setAlign", "(Z)V", "drawEdges", "getDrawEdges", "setDrawEdges", "drawNodeName", "getDrawNodeName", "setDrawNodeName", "drawNodeText", "getDrawNodeText", "setDrawNodeText", "getGraphs", "()Ljava/lang/Iterable;", "gridHeight", "getGridHeight", "()I", "setGridHeight", "(I)V", "gridWidth", "getGridWidth", "setGridWidth", "getLines", "maxGraphs", "getMaxGraphs", "setMaxGraphs", "getMaxUnitIncrement", "setMaxUnitIncrement", "missingPicture", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "preferredHeight", "getPreferredHeight", "preferredWidth", "getPreferredWidth", "screenSize", "Ljava/awt/Dimension;", "kotlin.jvm.PlatformType", "getScreenSize", "()Ljava/awt/Dimension;", "showGrid", "getShowGrid", "setShowGrid", "drawColoredElements", "", "doc", "Lorg/jsoup/nodes/Document;", "g", "Ljava/awt/Graphics2D;", "i", "graph", "drawGraph", "nGraphs", "drawGrid", "drawStyledVertices", "drawVertices", "vertices", "", "Lai/platon/scent/dom/nodes/NodeVertex;", "getPreferredScrollableViewportSize", "getScrollableBlockIncrement", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableTracksViewportHeight", "getScrollableTracksViewportWidth", "getScrollableUnitIncrement", "mouseDragged", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "paint", "graphics", "Ljava/awt/Graphics;", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nScollableCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScollableCanvas.kt\nai/platon/scent/gui/ScrollableCanvas\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1855#2,2:252\n1864#2,2:254\n1866#2:257\n1855#2,2:258\n1855#2,2:260\n1855#2,2:262\n766#2:264\n857#2,2:265\n1855#2,2:267\n1#3:256\n*S KotlinDebug\n*F\n+ 1 ScollableCanvas.kt\nai/platon/scent/gui/ScrollableCanvas\n*L\n60#1:252,2\n72#1:254,2\n72#1:257\n77#1:258,2\n107#1:260,2\n148#1:262,2\n186#1:264\n186#1:265,2\n186#1:267,2\n*E\n"})
public final class ScrollableCanvas
extends JLabel
implements Scrollable,
MouseMotionListener {
    @NotNull
    private final Iterable<DirectedGeometricGraph> graphs;
    @NotNull
    private final Iterable<Line2D> lines;
    private int maxUnitIncrement;
    @NotNull
    private final HarvestOptions options;
    private boolean missingPicture;
    private final Dimension screenSize;
    private final int preferredWidth;
    private final int preferredHeight;
    private boolean drawNodeName;
    private boolean drawNodeText;
    private boolean drawEdges;
    private int maxGraphs;
    private boolean showGrid;
    private boolean align;
    private int gridWidth;
    private int gridHeight;

    public ScrollableCanvas(@NotNull Iterable<DirectedGeometricGraph> graphs, @NotNull Iterable<? extends Line2D> lines, int maxUnitIncrement, @NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.graphs = graphs;
        this.lines = lines;
        this.maxUnitIncrement = maxUnitIncrement;
        this.options = options;
        this.missingPicture = true;
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.preferredWidth = this.screenSize.width;
        this.preferredHeight = this.screenSize.height * 2;
        this.drawNodeName = true;
        this.drawEdges = true;
        this.maxGraphs = 100;
        this.showGrid = true;
        this.gridWidth = FeaturedDocument.Companion.getPrimaryGridDimension().width;
        this.gridHeight = FeaturedDocument.Companion.getPrimaryGridDimension().height;
        if (this.getIcon() == null) {
            this.missingPicture = true;
            this.setText("No picture found.");
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
        }
        this.setPreferredSize(new Dimension(this.preferredWidth, this.preferredHeight));
        this.setHorizontalAlignment(4);
        this.setVerticalAlignment(1);
        this.setAutoscrolls(true);
        this.addMouseMotionListener(this);
        Iterable<DirectedGeometricGraph> $this$forEach$iv = this.graphs;
        boolean $i$f$forEach = false;
        Iterator<DirectedGeometricGraph> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            DirectedGeometricGraph element$iv;
            DirectedGeometricGraph it = element$iv = iterator.next();
            boolean bl = false;
            System.out.println((Object)("Drawing graph " + it + ", vertices: " + it.vertexSet().size() + ", edges: " + it.edgeSet().size()));
        }
    }

    public /* synthetic */ ScrollableCanvas(Iterable iterable, Iterable iterable2, int n, HarvestOptions harvestOptions, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            iterable2 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            harvestOptions = HarvestOptions.Companion.create(new VolatileConfig());
        }
        this(iterable, iterable2, n, harvestOptions);
    }

    @NotNull
    public final Iterable<DirectedGeometricGraph> getGraphs() {
        return this.graphs;
    }

    @NotNull
    public final Iterable<Line2D> getLines() {
        return this.lines;
    }

    public final int getMaxUnitIncrement() {
        return this.maxUnitIncrement;
    }

    public final void setMaxUnitIncrement(int n) {
        this.maxUnitIncrement = n;
    }

    @NotNull
    public final HarvestOptions getOptions() {
        return this.options;
    }

    public final Dimension getScreenSize() {
        return this.screenSize;
    }

    public final int getPreferredWidth() {
        return this.preferredWidth;
    }

    public final int getPreferredHeight() {
        return this.preferredHeight;
    }

    public final boolean getDrawNodeName() {
        return this.drawNodeName;
    }

    public final void setDrawNodeName(boolean bl) {
        this.drawNodeName = bl;
    }

    public final boolean getDrawNodeText() {
        return this.drawNodeText;
    }

    public final void setDrawNodeText(boolean bl) {
        this.drawNodeText = bl;
    }

    public final boolean getDrawEdges() {
        return this.drawEdges;
    }

    public final void setDrawEdges(boolean bl) {
        this.drawEdges = bl;
    }

    public final int getMaxGraphs() {
        return this.maxGraphs;
    }

    public final void setMaxGraphs(int n) {
        this.maxGraphs = n;
    }

    public final boolean getShowGrid() {
        return this.showGrid;
    }

    public final void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    public final boolean getAlign() {
        return this.align;
    }

    public final void setAlign(boolean bl) {
        this.align = bl;
    }

    public final int getGridWidth() {
        return this.gridWidth;
    }

    public final void setGridWidth(int n) {
        this.gridWidth = n;
    }

    public final int getGridHeight() {
        return this.gridHeight;
    }

    public final void setGridHeight(int n) {
        this.gridHeight = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(@NotNull Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Graphics2D g = (Graphics2D)graphics;
        if (this.showGrid) {
            this.drawGrid(g);
        }
        Iterable $this$forEachIndexed$iv = CollectionsKt.take(this.graphs, (int)this.maxGraphs);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            NodeVertex nodeVertex;
            void graph;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DirectedGeometricGraph directedGeometricGraph = (DirectedGeometricGraph)item$iv;
            int index = n;
            boolean bl = false;
            this.drawGraph(index, CollectionsKt.count(this.graphs), (DirectedGeometricGraph)graph, g);
            NodeVertex nodeVertex2 = graph.getSource();
            if (nodeVertex2 == null || (nodeVertex2 = nodeVertex2.getData()) == null || (nodeVertex2 = nodeVertex2.getNode()) == null || (nodeVertex2 = nodeVertex2.ownerDocument()) == null) continue;
            NodeVertex it = nodeVertex = nodeVertex2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            this.drawColoredElements((Document)it, g);
        }
        Iterable<Line2D> $this$forEach$iv = this.lines;
        boolean $i$f$forEach = false;
        Iterator<Line2D> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Line2D element$iv;
            Line2D it = element$iv = iterator.next();
            boolean bl = false;
            g.draw(it);
        }
    }

    private final void drawGrid(Graphics2D g) {
        if (this.gridWidth <= 1 || this.gridHeight <= 1) {
            return;
        }
        g.setColor(new Color(0xFFFAF0));
        g.setStroke(new BasicStroke());
        int n = this.getWidth();
        int n2 = this.gridWidth;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + n2 + ".");
        }
        int x = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)n2);
        int n4 = n2;
        if (x <= n3) {
            while (true) {
                int n5 = this.getHeight();
                int n6 = this.gridHeight;
                if (n6 <= 0) {
                    throw new IllegalArgumentException("Step must be positive, was: " + n6 + ".");
                }
                int y = 0;
                int n7 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n5, (int)n6);
                int n8 = n6;
                if (y <= n7) {
                    while (true) {
                        g.drawLine(x, y, x + this.gridWidth, y);
                        g.drawLine(x, y, x, y + this.gridHeight);
                        if (y == n7) break;
                        y += n8;
                    }
                }
                if (x == n3) break;
                x += n4;
            }
        }
    }

    private final void drawGraph(int i, int nGraphs, DirectedGeometricGraph graph, Graphics2D g) {
        g.setColor(Color.DARK_GRAY);
        Set vertices = graph.vertexSet();
        Intrinsics.checkNotNull((Object)vertices);
        this.drawVertices(i, nGraphs, g, vertices);
        if (this.drawEdges) {
            this.drawEdges(i, g, graph);
        }
    }

    private final void drawVertices(int i, int nGraphs, Graphics2D g, Collection<NodeVertex> vertices) {
        Iterable $this$forEach$iv = vertices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeVertex it = (NodeVertex)element$iv;
            boolean bl = false;
            int x = it.getData().x;
            int y = it.getData().y;
            Object label = "";
            Node node = it.getData().getNode();
            if (i == 0 && node != null) {
                if (this.drawNodeName) {
                    Object object = label = node instanceof TextNode ? String.valueOf(NodeExtKt.getSequence((Node)node)) : NodeExtKt.getName((Node)node);
                    if (it.getData().getNodes().size() > 1) {
                        label = (String)label + "(" + it.getData().getNodes().size() + ")";
                    }
                }
                if (this.drawNodeText) {
                    if (!StringsKt.isBlank((CharSequence)((CharSequence)label))) {
                        label = (String)label + " ";
                    }
                    label = (String)label + StringsKt.take((String)NodeExtKt.getCleanText((Node)node), (int)10);
                    double df = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)node);
                    if (0.0 <= df && df <= 10000.0) {
                        label = (String)label + "(" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)node) + ")";
                    }
                }
            }
            if (it.isNil()) {
                label = ".";
            }
            g.setFont(new Font("Serif", 0, 12));
            g.drawString((String)label, x, y);
        }
    }

    private final void drawEdges(int i, Graphics2D g, DirectedGeometricGraph graph) {
        Color edgeColor = (Color)ColorFamily.INSTANCE.getGreenColors().get(i % ColorFamily.INSTANCE.getGreenColors().size());
        g.setColor(edgeColor);
        Stroke stoke = g.getStroke();
        Set set = graph.edgeSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"edgeSet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int y2;
            int x2;
            int y;
            int x;
            block5: {
                block4: {
                    NodeEdge it = (NodeEdge)element$iv;
                    boolean bl = false;
                    NodeVertex s2 = (NodeVertex)graph.getEdgeSource((Object)it);
                    NodeVertex t = (NodeVertex)graph.getEdgeTarget((Object)it);
                    Point point = s2.getData().getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocation(...)");
                    GeoIntPoint position1 = GeometricsKt.toIntPoint((Point)point);
                    Point point2 = t.getData().getLocation();
                    Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"getLocation(...)");
                    GeoIntPoint position2 = GeometricsKt.toIntPoint((Point)point2);
                    GeoIntPoint geoIntPoint = this.align ? position1.align(this.gridWidth, this.gridHeight) : position1;
                    x = geoIntPoint.component1();
                    y = geoIntPoint.component2();
                    GeoIntPoint geoIntPoint2 = this.align ? position2.align(this.gridWidth, this.gridHeight) : position2;
                    x2 = geoIntPoint2.component1();
                    y2 = geoIntPoint2.component2();
                    g.setColor(edgeColor);
                    Node node = s2.getData().getNode();
                    if (node != null && ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)node)) break block4;
                    Intrinsics.checkNotNull((Object)s2);
                    NodeVertex nodeVertex = graph.getVerticalSource(s2);
                    if (nodeVertex != null && (nodeVertex = nodeVertex.getData()) != null && (nodeVertex = nodeVertex.getNode()) != null ? ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)nodeVertex) : false) break block4;
                    NodeVertex nodeVertex2 = graph.getHorizontalSource(s2);
                    boolean bl2 = nodeVertex2 != null && (nodeVertex2 = nodeVertex2.getData()) != null && (nodeVertex2 = nodeVertex2.getNode()) != null ? ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isLocallyConstant((Node)nodeVertex2) : false;
                    if (!bl2) break block5;
                }
                g.setColor(Color.LIGHT_GRAY);
            }
            g.drawLine(x, y, x2, y2);
            g.setStroke(stoke);
        }
    }

    private final void drawColoredElements(Document doc, Graphics2D g) {
        Element element = doc.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        NodesKt.forEach$default((Node)((Node)element), (boolean)false, (Function1)((Function1)new Function1<Node, Unit>(g){
            final /* synthetic */ Graphics2D $g;
            {
                this.$g = $g;
                super(1);
            }

            public final void invoke(@NotNull Node it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isColored((Node)it)) {
                    this.$g.setColor(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getColor((Node)it));
                    this.$g.drawRect(NodeExtKt.getX((Node)it), NodeExtKt.getY((Node)it), NodeExtKt.getWidth((Node)it), NodeExtKt.getHeight((Node)it));
                    if (VisualDocumentKt.isComponent(it)) {
                        double df = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getCaptionDocFrequency((Node)it);
                        String s2 = NodeExtKt.getName((Node)it) + " (tn:" + NodeExtKt.getNumTextNodes((Node)it) + " cdf:" + df + " len:" + NodeExtKt.getCaption((Node)it).length() + ")";
                        this.$g.drawString(s2, NodeExtKt.getX((Node)it), NodeExtKt.getY((Node)it));
                    }
                }
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawStyledVertices(DirectedGeometricGraph graph, Graphics2D g) {
        void $this$filterTo$iv$iv;
        Set set = graph.vertexSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"vertexSet(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeVertex it = (NodeVertex)element$iv$iv;
            boolean bl = false;
            Node node = it.getData().getNode();
            if (!((node != null ? ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getColor((Node)node) : null) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeVertex it = (NodeVertex)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            UnitGrid grid = graph.getGeneratedUnitGrid(it);
            if (grid == null) continue;
            Object object = it.getData().getNode();
            if (object == null || (object = ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getColor((Node)object)) == null) {
                object = Color.LIGHT_GRAY;
            }
            g.setColor((Color)object);
            int x = grid.getV1().getData().x;
            int y = grid.getV1().getData().y;
            int w = grid.getV2().getData().x - x;
            int h = grid.getV3().getData().y - y;
            g.drawRect(x, y, w, h);
        }
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
        this.scrollRectToVisible(r);
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = this.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        int currentPosition;
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        int n = currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return orientation == 0 ? visibleRect.width - this.maxUnitIncrement : visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

