/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.scent.ml.AffineTransformer;
import ai.platon.scent.ml.Bucketizer;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.EraseTransformer;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.HyperParametersKt;
import ai.platon.scent.ml.InsignificantFeatureRemover;
import ai.platon.scent.ml.NGramNodeEncoderBase;
import ai.platon.scent.ml.NGramTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.OneHotEncoder;
import ai.platon.scent.ml.ReversedOneHotIsolateTransformer;
import ai.platon.scent.ml.RowFormatter;
import ai.platon.scent.ml.SigmoidTransformer;
import ai.platon.scent.ml.Standardizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/ml/ClusterSensitiveNodeEncoder;", "Lai/platon/scent/ml/NGramNodeEncoderBase;", "options", "Lai/platon/scent/ml/EncodeOptions;", "pcaRate", "", "dimension", "", "(Lai/platon/scent/ml/EncodeOptions;DI)V", "getPcaRate", "()D", "removeInsignificantFeatures", "", "getRemoveInsignificantFeatures", "()Z", "setRemoveInsignificantFeatures", "(Z)V", "encode", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "Lkotlin/collections/ArrayList;", "nodes", "", "Lorg/jsoup/nodes/Node;", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nNodePointEncoders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/ClusterSensitiveNodeEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1864#2,3:361\n*S KotlinDebug\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/ClusterSensitiveNodeEncoder\n*L\n282#1:361,3\n*E\n"})
public class ClusterSensitiveNodeEncoder
extends NGramNodeEncoderBase {
    private final double pcaRate;
    private boolean removeInsignificantFeatures;

    public ClusterSensitiveNodeEncoder(@NotNull EncodeOptions options, double pcaRate, int dimension) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options, dimension);
        this.pcaRate = pcaRate;
        this.removeInsignificantFeatures = true;
    }

    public /* synthetic */ ClusterSensitiveNodeEncoder(EncodeOptions encodeOptions, double d, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        if ((n2 & 4) != 0) {
            n = FeatureRegistry.INSTANCE.getFeatureNames().size();
        }
        this(encodeOptions, d, n);
    }

    public final double getPcaRate() {
        return this.pcaRate;
    }

    public final boolean getRemoveInsignificantFeatures() {
        return this.removeInsignificantFeatures;
    }

    public final void setRemoveInsignificantFeatures(boolean bl) {
        this.removeInsignificantFeatures = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ArrayList<NodePoint> encode(@NotNull List<? extends Node> nodes2) {
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        if (nodes2.isEmpty()) {
            return new ArrayList<NodePoint>();
        }
        ArrayList<NodePoint> xs = null;
        xs = super.encode(nodes2);
        int nTrace = HyperParametersKt.getTraceNFeatureLines();
        if (nTrace > 0) {
            RowFormatter.show$default(new RowFormatter(0, 0, 0, true, null, null, 55, null), xs, nTrace, false, null, 12, null);
        }
        int[] nArray = HyperParametersKt.getIgnoredFeatures();
        EraseTransformer eraser = new EraseTransformer(Arrays.copyOf(nArray, nArray.length), false, 2, null);
        Bucketizer bucketizer = new Bucketizer(false, 1, null);
        Iterable $this$forEachIndexed$iv = xs;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void x;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl = false;
            NodePoint x1 = x;
            x1 = eraser.transform(x1);
            eraser.show(x1);
            x1 = bucketizer.transform(x1);
            bucketizer.show(x1);
            xs.set(i, x1);
        }
        if (!(HyperParametersKt.getReversedOneHotIsolateFeatures().length == 0)) {
            int[] $i$f$forEachIndexed2 = HyperParametersKt.getReversedOneHotIsolateFeatures();
            ReversedOneHotIsolateTransformer isolateEncoder = new ReversedOneHotIsolateTransformer(Arrays.copyOf($i$f$forEachIndexed2, $i$f$forEachIndexed2.length), this.getSchema(), false);
            isolateEncoder.fit((List<? extends NodePoint>)xs);
            this.setSchema(isolateEncoder.transformSchema());
            xs = isolateEncoder.transform((List<? extends NodePoint>)xs);
            isolateEncoder.show((List<? extends NodePoint>)xs, nTrace, true);
        }
        if (!(HyperParametersKt.getNominalFeatures().length == 0)) {
            int[] $i$f$forEachIndexed2 = HyperParametersKt.getNominalFeatures();
            OneHotEncoder hotEncoder = new OneHotEncoder(Arrays.copyOf($i$f$forEachIndexed2, $i$f$forEachIndexed2.length), this.getSchema(), 0.0, false, 4, null);
            hotEncoder.fit((List<? extends NodePoint>)xs);
            this.setSchema(hotEncoder.transformSchema());
            xs = hotEncoder.transform((List<? extends NodePoint>)xs);
            hotEncoder.show((List<? extends NodePoint>)xs, nTrace, true);
        }
        if (this.removeInsignificantFeatures) {
            InsignificantFeatureRemover featureRemover = new InsignificantFeatureRemover(this.getSchema(), false);
            featureRemover.fit((List<? extends NodePoint>)xs);
            this.setSchema(featureRemover.transformSchema());
            xs = featureRemover.transform((List<? extends NodePoint>)xs);
            FeatureTransformer.show$default(featureRemover, xs, nTrace, false, 4, null);
        }
        if (xs.size() > 2) {
            Standardizer standardizer = new Standardizer();
            standardizer.fit((List<? extends NodePoint>)xs);
            xs = standardizer.transform((List<? extends NodePoint>)xs);
        }
        SigmoidTransformer sigmoid = new SigmoidTransformer(false);
        xs = sigmoid.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(sigmoid, xs, nTrace, false, 4, null);
        if (HyperParametersKt.getApplyAffineTransform()) {
            AffineTransformer affine = new AffineTransformer(this.getSchema(), false);
            affine.fit((List<? extends NodePoint>)xs);
            xs = affine.transform((List<? extends NodePoint>)xs);
            FeatureTransformer.show$default(affine, xs, nTrace, false, 4, null);
        }
        int nGram = this.getOptions().getNGram();
        NGramTransformer nGramTransformer = new NGramTransformer(nGram, this.getSchema(), false);
        this.setSchema(nGramTransformer.transformSchema());
        xs = nGramTransformer.transform((List<? extends NodePoint>)xs);
        FeatureTransformer.show$default(nGramTransformer, xs, nTrace, false, 4, null);
        if (!(this.pcaRate > 0.0) || this.pcaRate < 1.0) {
            // empty if block
        }
        return xs;
    }
}

