/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.MathsKt;
import ai.platon.scent.ml.NodePoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/scent/ml/Standardizer;", "Lai/platon/scent/ml/FeatureTransformer;", "()V", "mu", "Lorg/apache/commons/math3/linear/ArrayRealVector;", "std", "fit", "", "xs", "", "Lai/platon/scent/ml/NodePoint;", "transform", "x", "scent-auto-mining"})
public class Standardizer
extends FeatureTransformer {
    private ArrayRealVector mu;
    private ArrayRealVector std;

    public Standardizer() {
        super(null, false, 3, null);
    }

    @Override
    public void fit(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        this.mu = MathsKt.colMeans2(xs);
        this.std = MathsKt.colSds(xs);
        int j = 0;
        ArrayRealVector arrayRealVector = this.std;
        if (arrayRealVector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"std");
            arrayRealVector = null;
        }
        int n = arrayRealVector.getDataRef().length;
        while (j < n) {
            ArrayRealVector arrayRealVector2 = this.std;
            if (arrayRealVector2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"std");
                arrayRealVector2 = null;
            }
            if (Precision.equals((double)VectorsKt.get((RealVector)((RealVector)arrayRealVector2), (int)j), (double)0.0, (double)1.0E-9)) {
                ArrayRealVector arrayRealVector3 = this.std;
                if (arrayRealVector3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"std");
                    arrayRealVector3 = null;
                }
                VectorsKt.set((RealVector)((RealVector)arrayRealVector3), (int)j, (double)1.0);
            }
            ++j;
        }
    }

    @Override
    @NotNull
    public NodePoint transform(@NotNull NodePoint x) {
        Intrinsics.checkNotNullParameter((Object)((Object)x), (String)"x");
        int n = x.getDataRef().length;
        for (int j = 0; j < n; ++j) {
            RealVector realVector = (RealVector)x;
            double d = VectorsKt.get((RealVector)((RealVector)x), (int)j);
            ArrayRealVector arrayRealVector = this.mu;
            if (arrayRealVector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mu");
                arrayRealVector = null;
            }
            double d2 = d - VectorsKt.get((RealVector)((RealVector)arrayRealVector), (int)j);
            ArrayRealVector arrayRealVector2 = this.std;
            if (arrayRealVector2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"std");
                arrayRealVector2 = null;
            }
            VectorsKt.set((RealVector)realVector, (int)j, (double)(d2 / VectorsKt.get((RealVector)((RealVector)arrayRealVector2), (int)j)));
        }
        return x;
    }
}

