/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.semisupervised;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.CheckState;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.analysis.DomNodesEncoder;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.dom.CalculatorUtils;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.entities.ClusterTaskStatus;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.entities.DataTypeStatistics;
import ai.platon.scent.entities.NodeClusterGroupMetrics;
import ai.platon.scent.ml.ClusterSensitiveComponentEncoder;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.semisupervised.ConstraintViolationPolicy;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.semisupervised.SKMOptions;
import ai.platon.scent.ml.semisupervised.SemiKMeans;
import ai.platon.scent.ml.unsupervised.ComponentCluster;
import ai.platon.scent.ml.unsupervised.ComponentClusterGroup;
import ai.platon.scent.ml.unsupervised.NodeClusterGroup;
import ai.platon.scent.ml.unsupervised.TileCluster;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.collect.TreeMultimap;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020.J\b\u00100\u001a\u00020.H\u0002J$\u00100\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J\b\u00104\u001a\u00020.H\u0002J\u001e\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00072\f\u00107\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J:\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00072\f\u00107\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002080\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u0002080\u0003H\u0002J\b\u00109\u001a\u00020.H\u0002J$\u0010:\u001a\u0012\u0012\u0004\u0012\u00020<0;j\b\u0012\u0004\u0012\u00020<`=2\f\u00103\u001a\b\u0012\u0004\u0012\u0002080\u0003J\u0018\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u001e\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00032\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0002J\u0016\u0010E\u001a\u00020F2\f\u00107\u001a\b\u0012\u0004\u0012\u0002020\u0003H\u0002J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\u00070H2\u0006\u0010J\u001a\u00020\bH\u0002J\u0010\u0010K\u001a\u00020.2\u0006\u0010L\u001a\u00020\u0007H\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010/\u001a\u00020NH\u0002J\u001e\u0010O\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u0002020\u00032\u0006\u0010P\u001a\u00020\u0010H\u0002J\b\u0010Q\u001a\u00020.H\u0002J4\u0010R\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00072\f\u00103\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00032\u0006\u0010S\u001a\u00020AH\u0002JH\u0010T\u001a\u00020)2\u0006\u00106\u001a\u00020\u00072\f\u00107\u001a\b\u0012\u0004\u0012\u0002020\u00032\f\u00103\u001a\b\u0012\u0004\u0012\u0002080\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u0002080\u00032\f\u0010U\u001a\b\u0012\u0004\u0012\u00020A0\u0003H\u0002R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0012R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006V"}, d2={"Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "Ljava/lang/AutoCloseable;", "documents", "", "Lai/platon/scent/analysis/corpus/VisualDocument;", "uniquePathComponents", "Lcom/google/common/collect/TreeMultimap;", "", "Lai/platon/scent/analysis/corpus/VisualComponent;", "encodeOptions", "Lai/platon/scent/ml/EncodeOptions;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/util/List;Lcom/google/common/collect/TreeMultimap;Lai/platon/scent/ml/EncodeOptions;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "componentClusterGroups", "", "Lai/platon/scent/ml/unsupervised/ComponentClusterGroup;", "getComponentClusterGroups$scent_auto_mining", "()Ljava/util/List;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getDocuments", "getEncodeOptions", "()Lai/platon/scent/ml/EncodeOptions;", "logger", "Lorg/slf4j/Logger;", "options", "Lai/platon/scent/dom/HarvestOptions;", "predictionSupplier", "Ljava/util/concurrent/atomic/AtomicInteger;", "reportPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "reportWriter", "Ljava/io/BufferedWriter;", "status", "Lai/platon/scent/entities/ClusterTaskStatus;", "getStatus", "()Lai/platon/scent/entities/ClusterTaskStatus;", "taskLogger", "tileClusterGroups", "Lai/platon/scent/ml/unsupervised/TileClusterGroup;", "getTileClusterGroups$scent_auto_mining", "getUniquePathComponents", "()Lcom/google/common/collect/TreeMultimap;", "close", "", "cluster", "clusterComponents", "seedNodes", "Lorg/jsoup/nodes/Element;", "nodes", "clusterNonUniquePathComponents", "clusterTiles", "taskName", "components", "Lorg/jsoup/nodes/Node;", "clusterTilesInUniquePathComponentSets", "encode", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "Lkotlin/collections/ArrayList;", "encodePredictions", "group", "generateParameterGrid", "Lai/platon/scent/ml/semisupervised/SKMOptions;", "numSeeds", "", "maxEpochs", "hasAcceptableRecall", "Lai/platon/pulsar/common/CheckState;", "isRelevant", "Lkotlin/Pair;", "", "component", "log", "message", "removePolysemousPoints", "Lai/platon/scent/ml/unsupervised/TileCluster;", "reportComponentClusters", "clusterGroup", "reportTileClusterGroups", "runKmeansForComponents", "skmOptions", "runSemiKmeansForTiles", "parameterGrid", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nNodeClusterRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeClusterRunner.kt\nai/platon/scent/ml/semisupervised/NodeClusterRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 DomQueries.kt\nai/platon/pulsar/dom/select/DomQueriesKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,627:1\n1855#2,2:628\n1864#2,2:630\n1855#2,2:632\n1866#2:634\n1611#2:636\n1855#2:637\n1856#2:640\n1612#2:641\n1549#2:642\n1620#2,3:643\n1963#2,5:647\n1774#2,4:652\n1969#2,2:656\n1774#2,4:658\n1971#2,6:662\n766#2:668\n857#2,2:669\n1549#2:671\n1620#2,3:672\n1360#2:675\n1446#2,2:676\n766#2:678\n857#2,2:679\n1549#2:681\n1620#2,3:682\n1448#2,3:685\n1549#2:688\n1620#2,2:689\n2634#2:697\n1622#2:699\n1855#2,2:700\n1963#2,14:702\n1855#2,2:724\n766#2:726\n857#2,2:727\n766#2:729\n857#2,2:730\n1855#2,2:732\n1620#2,3:734\n1549#2:737\n1620#2,3:738\n1054#2:741\n215#3:635\n216#3:646\n1#4:638\n1#4:639\n1#4:698\n56#5,6:691\n13309#6:716\n13309#6:717\n13309#6:718\n13309#6,2:719\n13310#6:721\n13310#6:722\n13310#6:723\n*S KotlinDebug\n*F\n+ 1 NodeClusterRunner.kt\nai/platon/scent/ml/semisupervised/NodeClusterRunner\n*L\n105#1:628,2\n118#1:630,2\n120#1:632,2\n118#1:634\n171#1:636\n171#1:637\n171#1:640\n171#1:641\n190#1:642\n190#1:643,3\n203#1:647,5\n203#1:652,4\n203#1:656,2\n203#1:658,4\n203#1:662,6\n204#1:668\n204#1:669,2\n204#1:671\n204#1:672,3\n205#1:675\n205#1:676,2\n205#1:678\n205#1:679,2\n205#1:681\n205#1:682,3\n205#1:685,3\n313#1:688\n313#1:689,2\n314#1:697\n313#1:699\n322#1:700,2\n327#1:702,14\n377#1:724,2\n394#1:726\n394#1:727,2\n422#1:729\n422#1:730,2\n550#1:732,2\n552#1:734,3\n590#1:737\n590#1:738,3\n590#1:741\n170#1:635\n170#1:646\n171#1:639\n314#1:698\n314#1:691,6\n363#1:716\n364#1:717\n365#1:718\n366#1:719,2\n365#1:721\n364#1:722\n363#1:723\n*E\n"})
public final class NodeClusterRunner
implements AutoCloseable {
    @NotNull
    private final List<VisualDocument> documents;
    @NotNull
    private final TreeMultimap<String, VisualComponent> uniquePathComponents;
    @NotNull
    private final EncodeOptions encodeOptions;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger taskLogger;
    @NotNull
    private final HarvestOptions options;
    @NotNull
    private final AtomicInteger predictionSupplier;
    @NotNull
    private final List<ComponentClusterGroup> componentClusterGroups;
    @NotNull
    private final List<TileClusterGroup> tileClusterGroups;
    private final Path reportPath;
    @NotNull
    private final BufferedWriter reportWriter;
    @NotNull
    private final ClusterTaskStatus status;

    public NodeClusterRunner(@NotNull List<VisualDocument> documents, @NotNull TreeMultimap<String, VisualComponent> uniquePathComponents, @NotNull EncodeOptions encodeOptions, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Intrinsics.checkNotNullParameter(uniquePathComponents, (String)"uniquePathComponents");
        Intrinsics.checkNotNullParameter((Object)encodeOptions, (String)"encodeOptions");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.documents = documents;
        this.uniquePathComponents = uniquePathComponents;
        this.encodeOptions = encodeOptions;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(NodeClusterRunner.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(NodeClusterRunner.class), (String)".Task");
        VisualDocument visualDocument = (VisualDocument)CollectionsKt.firstOrNull(this.documents);
        if (visualDocument == null || (visualDocument = visualDocument.getOptions()) == null) {
            visualDocument = HarvestOptions.Companion.create(this.conf.toVolatileConfig());
        }
        this.options = visualDocument;
        this.predictionSupplier = new AtomicInteger();
        this.componentClusterGroups = new ArrayList();
        this.tileClusterGroups = new ArrayList();
        this.reportPath = AppPaths.INSTANCE.getREPORT_DIR().resolve("harvest/corpus/clustering-result.log");
        this.status = new ClusterTaskStatus(0, null, 0, 0, 0, 0, 0.0, null, 255, null);
        Files.createDirectories(this.reportPath.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        BufferedWriter bufferedWriter = Files.newBufferedWriter(this.reportPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(...)");
        this.reportWriter = bufferedWriter;
    }

    @NotNull
    public final List<VisualDocument> getDocuments() {
        return this.documents;
    }

    @NotNull
    public final TreeMultimap<String, VisualComponent> getUniquePathComponents() {
        return this.uniquePathComponents;
    }

    @NotNull
    public final EncodeOptions getEncodeOptions() {
        return this.encodeOptions;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final List<ComponentClusterGroup> getComponentClusterGroups$scent_auto_mining() {
        return this.componentClusterGroups;
    }

    @NotNull
    public final List<TileClusterGroup> getTileClusterGroups$scent_auto_mining() {
        return this.tileClusterGroups;
    }

    @NotNull
    public final ClusterTaskStatus getStatus() {
        return this.status;
    }

    public final void cluster() {
        if (this.documents.isEmpty()) {
            return;
        }
        this.clusterComponents();
        Iterable $this$forEach$iv = this.componentClusterGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentClusterGroup group = (ComponentClusterGroup)element$iv;
            boolean bl = false;
            group.forEach((Function1)new Function1<ComponentCluster, Unit>(this){
                final /* synthetic */ NodeClusterRunner this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ComponentCluster cluster2) {
                    Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
                    NodeClusterRunner.access$getLogger$p(this.this$0).info("Clustering {} tiles in component {}", (Object)cluster2.getElements().size(), (Object)cluster2.getDisplay());
                    NodeClusterRunner.access$clusterTiles(this.this$0, cluster2.getDisplay(), cluster2.getElements());
                    System.gc();
                }
            });
        }
        this.reportTileClusterGroups();
    }

    /*
     * WARNING - void declaration
     */
    private final void encodePredictions(TileClusterGroup group, EncodeOptions options) {
        DomNodesEncoder encoder = new DomNodesEncoder();
        Iterable $this$forEachIndexed$iv = group.getClusters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cluster2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TileCluster tileCluster = (TileCluster)item$iv;
            int i = n;
            boolean bl = false;
            int prediction = this.predictionSupplier.incrementAndGet();
            Iterable $this$forEach$iv = cluster2.getNodes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl2 = false;
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setPrediction((Node)it, (int)prediction);
            }
            encoder.encodeNodes(cluster2.getNodes(), options);
        }
    }

    private final void clusterComponents() {
        this.logger.debug("Clustering tiles in unique path component sets");
        this.clusterTilesInUniquePathComponentSets();
        System.gc();
        this.logger.debug("Clustering non-unique path components");
        this.clusterNonUniquePathComponents();
        System.gc();
    }

    private final Pair<Boolean, String> isRelevant(VisualComponent component) {
        Element ele = component.getElement();
        VisualComponent c = component;
        return ai.platon.scent.dom.nodes.node.ext.NodeExtKt.isGrouped((Node)((Node)ele)) ? TuplesKt.to((Object)false, (Object)"GROUPED") : (c.isDisabled() ? TuplesKt.to((Object)false, (Object)"DISABLED") : (this.options.getNoSubTable() && c.hasParent() ? TuplesKt.to((Object)false, (Object)"SUB_TABLE") : TuplesKt.to((Object)true, (Object)"")));
    }

    private final CheckState hasAcceptableRecall(List<? extends Element> components) {
        int n;
        int a = components.size();
        double r = 1.0 * (double)a / (double)(n = this.documents.size());
        int code = r >= 0.5 && r < 2.0 ? 0 : 1;
        return new CheckState(code, String.valueOf(r), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterTilesInUniquePathComponentSets() {
        this.logger.debug("Clustering tiles in {} component sets with unique paths ...", (Object)this.uniquePathComponents.size());
        NavigableMap navigableMap = this.uniquePathComponents.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            void $this$mapNotNullTo$iv;
            Map.Entry element$iv2;
            Map.Entry entry = element$iv2 = iterator.next();
            boolean bl = false;
            String path = (String)entry.getKey();
            Collection components = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)components);
            Iterable iterable = components;
            Collection destination$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Element it$iv;
                Element element;
                Object element$iv$iv;
                element$iv = element$iv$iv = iterator2.next();
                boolean bl2 = false;
                VisualComponent c = (VisualComponent)((Object)element$iv);
                boolean bl3 = false;
                Element it = element = c.getElement();
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)((Object)c));
                if ((((Boolean)this.isRelevant(c).getFirst()).booleanValue() ? element : null) == null) continue;
                it$iv = it$iv;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            ArrayList relevant = (ArrayList)destination$iv;
            if (this.hasAcceptableRecall(relevant).isOK()) {
                int sz = relevant.size();
                Element sample = (Element)CollectionsKt.first((List)relevant);
                String name = NodeExtKt.getName((Node)((Node)sample)) + "[" + sz + "][U]";
                String string = sample.nodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nodeName(...)");
                if (!StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                    name = sample.nodeName() + name;
                }
                String taskName = StringUtils.abbreviateMiddle((String)name, (String)"..", (int)30);
                Intrinsics.checkNotNull((Object)taskName);
                this.clusterTiles(taskName, relevant);
                continue;
            }
            if (!this.taskLogger.isInfoEnabled()) continue;
            Object[] sz = new Object[]{path, relevant.size(), components.size(), this.documents.size()};
            this.taskLogger.info("Path component set {{}} is ill-analysable, {}/{}/{} (relevant/components/documents)", sz);
            Iterable $this$map$iv = components;
            boolean $i$f$map = false;
            Iterable name = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                element$iv = (VisualComponent)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(TuplesKt.to((Object)it, this.isRelevant((VisualComponent)it)));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        this.logger.info("There are {} cluster groups", (Object)this.componentClusterGroups.size());
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterNonUniquePathComponents() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Object v0;
        Function1 predicate2 = (Function1)new Function1<VisualComponent, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VisualComponent it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return !it.getHasUniquePath() && (Boolean)NodeClusterRunner.access$isRelevant(this.this$0, it).getFirst() != false;
            }
        };
        Iterable $this$maxByOrNull$iv = this.documents;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                int n;
                VisualDocument it = (VisualDocument)maxElem$iv;
                boolean bl = false;
                Iterable $this$count$iv = it.getComponents();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        if (!((Boolean)predicate2.invoke(element$iv)).booleanValue() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int maxValue$iv = n;
                do {
                    int v$iv;
                    int n2;
                    Iterator<Object> e$iv = iterator$iv.next();
                    VisualDocument it2 = (VisualDocument)((Object)e$iv);
                    visualComponent = false;
                    Iterable $this$count$iv2 = it2.getComponents();
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        n2 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            if (!((Boolean)predicate2.invoke(element$iv)).booleanValue() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n2 = count$iv;
                    }
                    if (maxValue$iv >= (v$iv = n2)) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        VisualDocument visualDocument = v0;
        if (visualDocument == null) {
            return;
        }
        VisualDocument seedDocument = visualDocument;
        Iterable $this$filter$iv = seedDocument.getComponents();
        boolean $i$f$filter = false;
        iterator$iv = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualComponent visualComponent = (VisualComponent)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getElement());
        }
        List seedNodes = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv2;
            Object element$iv;
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv2 = it.getComponents();
            boolean $i$f$filter2 = false;
            element$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                if (!((Boolean)predicate2.invoke(element$iv$iv2)).booleanValue()) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv$iv);
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(it3.getElement());
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List nodes2 = (List)destination$iv$iv2;
        this.logger.debug("Clustering {} nodes in {} component sets without unique path ...", (Object)nodes2.size(), (Object)seedNodes.size());
        CheckState status = this.hasAcceptableRecall(nodes2);
        if (status.isNotOK()) {
            this.logger.info("No acceptable recall (" + status.getMessage() + ")");
        }
        NodeClusterGroup clusterGroup = this.clusterComponents(seedNodes, nodes2);
        this.reportComponentClusters(nodes2, (ComponentClusterGroup)clusterGroup);
        clusterGroup = ((ComponentClusterGroup)clusterGroup).filter((Function1)new Function1<ComponentCluster, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ComponentCluster it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isNotEmpty() && it.getPointRecall() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPointRecall();
            }
        });
        if (clusterGroup.isNotEmpty()) {
            this.componentClusterGroups.add((ComponentClusterGroup)clusterGroup);
        }
        this.logger.info("There are {} cluster groups", (Object)this.componentClusterGroups.size());
    }

    private final ComponentClusterGroup clusterComponents(List<? extends Element> seedNodes, List<? extends Element> nodes2) {
        Function2 mustLink2 = clusterComponents.mustLink.1.INSTANCE;
        Function2 cannotLink2 = clusterComponents.cannotLink.1.INSTANCE;
        int n = this.documents.size();
        ConstraintViolationPolicy constraintViolationPolicy = ConstraintViolationPolicy.ABANDON;
        int n2 = this.conf.getInt("scent.cluster.page.component.nodes.max.iteration", 5);
        SKMOptions skmOptions = new SKMOptions(false, false, n, constraintViolationPolicy, false, mustLink2, cannotLink2, n2, 0, 1, null, 1296, null);
        ComponentClusterGroup clusterGroup = this.runKmeansForComponents("(Root)", nodes2, seedNodes, skmOptions);
        if (!this.options.getAllowOutliers()) {
            clusterGroup = clusterGroup.removeOutliers();
        }
        return clusterGroup;
    }

    private final void reportComponentClusters(List<? extends Element> nodes2, ComponentClusterGroup clusterGroup) {
        if (clusterGroup.isEmpty()) {
            this.logger.info("The cluster group is empty");
            return;
        }
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = "Total " + nodes2.size() + " components are clustered into " + clusterGroup.getSize() + " clusters: ";
        this.log((String)message.element);
        clusterGroup.forEach((Function1)new Function1<ComponentCluster, Unit>(this, (Ref.ObjectRef<String>)message){
            final /* synthetic */ NodeClusterRunner this$0;
            final /* synthetic */ Ref.ObjectRef<String> $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull ComponentCluster cluster2) {
                Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
                boolean ignore = cluster2.getPointRecall() < NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPointRecall();
                String mark = ignore ? "\u2718" : "\u2714";
                String string = "%-2s%3d(%-3d estimated) components are grouped into cluster #%-3d, names: %s";
                Object[] objectArray = new Object[]{mark, cluster2.getPoints().size(), cluster2.getEstimatedNodes().size(), cluster2.getLabel(), cluster2.getNames()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                this.$message.element = string2;
                NodeClusterRunner.access$log(this.this$0, (String)this.$message.element);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void clusterTiles(String taskName, List<? extends Element> components) {
        Object v0;
        Iterator $this$mapTo$iv$iv;
        Function1 predicate2 = clusterTiles.predicate.1.INSTANCE;
        Iterable $this$map$iv = components;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$onEach$iv;
            void $this$collectIfTo$iv$iv;
            void destination$iv$iv2;
            void component;
            Object item$iv$iv = iterator.next();
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object $this$collectIf$iv = (Node)component;
            boolean $i$f$collectIf = false;
            Node node = $this$collectIf$iv;
            Collection collection2 = new ArrayList();
            boolean $i$f$collectIfTo = false;
            NodeTraversor.traverse((NodeVisitor)new NodeVisitor((Collection)destination$iv$iv2, predicate2){
                final /* synthetic */ Collection $destination;
                final /* synthetic */ Function1 $predicate$inlined;
                {
                    this.$destination = $destination;
                    this.$predicate$inlined = function1;
                }

                public final void head(@NotNull Node node, int n) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Node it = node;
                    boolean bl = false;
                    if (((Boolean)this.$predicate$inlined.invoke((Object)it)).booleanValue()) {
                        this.$destination.add(node);
                    }
                }
            }, (Node)$this$collectIfTo$iv$iv);
            $this$collectIf$iv = (List)destination$iv$iv2;
            boolean $i$f$onEach = false;
            Node $this$onEach_u24lambda_u2416$iv = node = $this$onEach$iv;
            boolean bl2 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                Node it = (Node)element$iv;
                boolean bl3 = false;
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setOwnerComponent((Node)it, (Element)component);
                CalculatorUtils.INSTANCE.updateRegionalFeatures(it);
            }
            collection.add((List)node);
        }
        List nodeFamilies = (List)destination$iv$iv;
        if (this.options.getDiagnose()) {
            Iterable $this$forEach$iv = components;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it = (Element)element$iv;
                boolean bl = false;
            }
        }
        Iterable $this$maxByOrNull$iv = nodeFamilies;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                List it = (List)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.size();
                do {
                    Object e$iv = iterator$iv.next();
                    List it2 = (List)e$iv;
                    $i$a$-maxByOrNull-NodeClusterRunner$clusterTiles$seedNodes$1 = false;
                    int v$iv = it2.size();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        List list = v0;
        if (list == null) {
            return;
        }
        List seedNodes = list;
        List nodes2 = CollectionsKt.flatten((Iterable)nodeFamilies);
        this.clusterTiles(taskName, components, seedNodes, nodes2);
    }

    private final void clusterTiles(String taskName, List<? extends Element> components, List<? extends Node> seedNodes, List<? extends Node> nodes2) {
        int maxEpochs = this.conf.getInt("scent.cluster.nodes.max.iteration", 5);
        List<SKMOptions> parameterGrid = this.generateParameterGrid(seedNodes.size(), maxEpochs);
        Object[] objectArray = new Object[]{taskName, nodes2.size(), components.size(), seedNodes.size()};
        this.logger.info("Running semi-kmeans task {} to cluster {} tile nodes in {} components into {} groups", objectArray);
        TileClusterGroup clusterGroups = this.runSemiKmeansForTiles(taskName, components, nodes2, seedNodes, parameterGrid);
        if (clusterGroups.isNotEmpty()) {
            this.tileClusterGroups.add(clusterGroups);
            this.encodePredictions(clusterGroups, this.encodeOptions);
        }
    }

    private final List<SKMOptions> generateParameterGrid(int numSeeds, int maxEpochs) {
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        List grid = new ArrayList();
        if (this.options.getSearchParameterSpace()) {
            Boolean[] booleanArray = new Boolean[]{false, true};
            $this$forEach$iv = booleanArray;
            $i$f$forEach = false;
            for (Boolean element$iv : $this$forEach$iv) {
                boolean mustLink2 = element$iv;
                boolean bl = false;
                Boolean[] booleanArray2 = new Boolean[]{false, true};
                Boolean[] $this$forEach$iv2 = booleanArray2;
                boolean $i$f$forEach2 = false;
                for (Boolean element$iv2 : $this$forEach$iv2) {
                    boolean cannotLink2 = element$iv2;
                    boolean bl2 = false;
                    Integer[] integerArray = new Integer[]{numSeeds * 10, numSeeds};
                    Integer[] $this$forEach$iv3 = integerArray;
                    boolean $i$f$forEach3 = false;
                    for (Integer element$iv3 : $this$forEach$iv3) {
                        int capacity = ((Number)element$iv3).intValue();
                        boolean bl3 = false;
                        ConstraintViolationPolicy[] constraintViolationPolicyArray = new ConstraintViolationPolicy[]{ConstraintViolationPolicy.ABANDON, ConstraintViolationPolicy.DECAY};
                        ConstraintViolationPolicy[] $this$forEach$iv4 = constraintViolationPolicyArray;
                        boolean $i$f$forEach4 = false;
                        int n = $this$forEach$iv4.length;
                        for (int i = 0; i < n; ++i) {
                            ConstraintViolationPolicy element$iv4;
                            ConstraintViolationPolicy violation = element$iv4 = $this$forEach$iv4[i];
                            boolean bl4 = false;
                            SKMOptions opt = new SKMOptions(mustLink2, cannotLink2, capacity, violation, false, null, null, 0, 0, 0, null, 2032, null);
                            grid.add(opt);
                        }
                    }
                }
            }
        } else {
            grid.add(new SKMOptions(false, false, numSeeds * 10, ConstraintViolationPolicy.ABANDON, false, null, null, 0, 0, 0, null, 2032, null));
        }
        $this$forEach$iv = grid;
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            SKMOptions it = (SKMOptions)element$iv;
            boolean bl = false;
            it.setMaxEpochs(maxEpochs);
            it.setPolysemous(this.options.getPolysemous());
        }
        return grid;
    }

    /*
     * WARNING - void declaration
     */
    private final ComponentClusterGroup runKmeansForComponents(String taskName, List<? extends Element> nodes2, List<? extends Element> seedNodes, SKMOptions skmOptions) {
        void $this$filterTo$iv$iv;
        EncodeOptions encodeOptions = new EncodeOptions(null, false, null, skmOptions.getNGram(), 0, 23, null);
        ClusterSensitiveComponentEncoder encoder = new ClusterSensitiveComponentEncoder(encodeOptions, this.options.getPcaRate(), 0, 4, null);
        ArrayList<NodePoint> points = encoder.encode(nodes2);
        Iterable $this$filter$iv = points;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodePoint it = (NodePoint)((Object)element$iv$iv);
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)seedNodes, (Object)it.getNode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initCenters = (List)destination$iv$iv;
        SemiKMeans clusterer = new SemiKMeans(points, initCenters, Reflection.getOrCreateKotlinClass(ComponentCluster.class), null, skmOptions, 8, null);
        ComponentClusterGroup clusterGroup = new ComponentClusterGroup(taskName, clusterer.cluster(), this.documents, this.options);
        return clusterGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final TileClusterGroup runSemiKmeansForTiles(String taskName, List<? extends Element> components, List<? extends Node> nodes2, List<? extends Node> seedNodes, List<SKMOptions> parameterGrid) {
        TileClusterGroup group;
        void $this$filterTo$iv$iv;
        if (parameterGrid.isEmpty() || components.isEmpty() || nodes2.isEmpty() || seedNodes.isEmpty()) {
            return TileClusterGroup.Companion.getEMPTY();
        }
        Instant start = Instant.now();
        ArrayList<NodePoint> points = this.encode(nodes2);
        Iterable $this$filter$iv = points;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodePoint it = (NodePoint)((Object)element$iv$iv);
            boolean bl = false;
            if (!seedNodes.contains(it.getNode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initCenters = (List)destination$iv$iv;
        SemiKMeans clusterer = null;
        NodeClusterGroup clusterGroup = TileClusterGroup.Companion.getEMPTY();
        double minDistortion = Double.MAX_VALUE;
        double minPathDistortion = Double.MAX_VALUE;
        double minPidDistortion = Double.MAX_VALUE;
        List distortions = new ArrayList();
        SKMOptions bestOptions = SKMOptions.Companion.getDefault();
        boolean preferPathDistortion = LangKt.alwaysFalse();
        boolean moreDistortion = LangKt.alwaysFalse();
        Iterator<SKMOptions> it = parameterGrid.iterator();
        do {
            double pidDistortion2;
            clusterer = new SemiKMeans(points, initCenters, Reflection.getOrCreateKotlinClass(TileCluster.class), null, it.next(), 8, null);
            List clusters = clusterer.cluster();
            group = new TileClusterGroup(taskName, clusters, this.documents, components, this.options);
            double distortion2 = group.getDistortion();
            distortions.add(distortion2);
            if (distortion2 < minDistortion) {
                minDistortion = distortion2;
                bestOptions = clusterer.getOptions();
                clusterGroup = group;
            }
            if (!moreDistortion) continue;
            double pathDistortion2 = group.getPathDistortion();
            if (pathDistortion2 < minPathDistortion) {
                minPathDistortion = pathDistortion2;
                if (preferPathDistortion) {
                    bestOptions = clusterer.getOptions();
                    clusterGroup = group;
                }
            }
            if (!(minPidDistortion < (pidDistortion2 = group.getPidDistortion()))) continue;
            minPidDistortion = pidDistortion2;
        } while (it.hasNext());
        if (!this.options.getPolysemous()) {
            clusterGroup = ((TileClusterGroup)clusterGroup).removePolysemousPoints();
        }
        clusterGroup.estimate();
        clusterGroup = ((TileClusterGroup)clusterGroup).filter((Function1)new Function1<TileCluster, Boolean>(this){
            final /* synthetic */ NodeClusterRunner this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileCluster it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getConfuseMatrix().getRecall() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumRecall() && it.getConfuseMatrix().getPrecision() >= NodeClusterRunner.access$getOptions$p(this.this$0).getMinimumPrecision();
            }
        });
        if (clusterGroup.isEmpty()) {
            this.taskLogger.warn(taskName + " has no proper clusters");
            return clusterGroup;
        }
        Set locations2 = new LinkedHashSet();
        ((TileClusterGroup)clusterGroup).forEach((Function1<? super TileCluster, Unit>)((Function1)new Function1<TileCluster, Unit>((Set<String>)locations2){
            final /* synthetic */ Set<String> $locations;
            {
                this.$locations = $locations;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull TileCluster cluster2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)cluster2, (String)"cluster");
                Iterable iterable = cluster2.getPoints();
                Set<String> set = this.$locations;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NodePoint it = (NodePoint)((Object)element$iv);
                    boolean bl = false;
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setPrediction((Node)it.getNode(), (int)cluster2.getLabel());
                    set.add(NodeExtKt.getLocation((Node)it.getNode()));
                }
            }
        }));
        clusterGroup.estimate();
        this.status.setTotalDocuments(this.documents.size());
        this.status.setTotalDocumentRecall(locations2.size());
        group = this.status;
        group.setTotalNodes(group.getTotalNodes() + nodes2.size());
        group = this.status;
        group.setTotalEpochs(group.getTotalEpochs() + clusterer.getEpochs());
        group = this.status;
        group.setTotalClusters(group.getTotalClusters() + clusterGroup.getSize());
        group = this.status;
        group.setTotalDistortion(group.getTotalDistortion() + minDistortion);
        ConfuseMatrix metrics = clusterGroup.getConfuseMatrix();
        this.status.getConfuseMatrix().accumulate(clusterGroup.getConfuseMatrix());
        clusterGroup.setClusterTaskStatus(this.status);
        Rectangle rectangle = NodeExtKt.getRectangle((Node)((Node)CollectionsKt.first(components)));
        int x = GeometricsKt.component1((Rectangle)rectangle);
        int y = GeometricsKt.component2((Rectangle)rectangle);
        int w = GeometricsKt.component3((Rectangle)rectangle);
        int h = GeometricsKt.component4((Rectangle)rectangle);
        Duration elapsed = Duration.between(start, Instant.now());
        String mark = clusterGroup.isConstant() ? "\u2716" : (clusterGroup.getNumFineVariables() >= 5 && clusterGroup.getFineVariableRate() > 0.9 ? "\u2714\u2714\u2714\u2714\u2714 \ud83d\udcaf" : (clusterGroup.getNumFineVariables() >= 5 && clusterGroup.getFineVariableRate() > 0.8 ? "\u2714\u2714\u2714\u2714" : (clusterGroup.getNumFineVariables() > 0 && metrics.getF1() > 0.9 ? "\u2714\u2714\u2714" : (clusterGroup.getNumFineVariables() > 0 && metrics.getF1() > 0.8 ? "\u2714\u2714" : (metrics.getF1() > 0.8 ? "\u2714" : " ")))));
        DataTypeStatistics ds = clusterGroup.getDataTypeStatistics();
        String string = StringUtils.abbreviateMiddle((String)taskName, (String)"..", (int)35);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abbreviateMiddle(...)");
        int n = (int)((TileClusterGroup)clusterGroup).getSqrtArea();
        int n2 = seedNodes.size();
        int n3 = points.size();
        int n4 = ds.getNumLazy();
        int n5 = ds.getNumImages();
        int n6 = clusterer.getEpochs();
        Intrinsics.checkNotNull((Object)elapsed);
        double d = metrics.getRecall();
        double d2 = metrics.getPrecision();
        double d3 = metrics.getF1();
        String string2 = ((TileClusterGroup)clusterGroup).getScore().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        clusterGroup.setMetrics(new NodeClusterGroupMetrics(string, x, y, w, h, n, n2, n3, n4, n5, n6, elapsed, minDistortion, d, d2, d3, string2, clusterGroup.getNumFields(), clusterGroup.getNumFineFields(), clusterGroup.getFineFieldRate(), ds.getNumConstants(), ds.getNumVariables(), clusterGroup.getNumFineVariables(), clusterGroup.getFineVariableRate(), mark));
        if (parameterGrid.size() > 1) {
            SKMOptions op = bestOptions;
            String distortionString2 = CollectionsKt.joinToString$default((Iterable)distortions, null, null, null, (int)0, null, (Function1)runSemiKmeansForTiles.distortionString.1.INSTANCE, (int)31, null);
            String string3 = "%-15s- distortions: %s\tbest options: (m:%b, c:%b, cap:%d, %s)";
            Object[] objectArray = new Object[]{taskName, distortionString2, op.getEnableMustLinks(), op.getEnableCannotLinks(), op.getCapacity(), op.getConstraintViolationPolicy()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            String message = string4;
            this.log(message);
        }
        if (LangKt.alwaysTrue() && this.taskLogger.isDebugEnabled()) {
            void $this$mapTo$iv;
            Iterable $this$forEach$iv = ((TileClusterGroup)clusterGroup).getComponents();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Element it2 = (Element)element$iv;
                boolean bl = false;
                this.taskLogger.debug("Components in tile cluster group: " + NodeExtKt.getNamedRect((Node)((Node)it2)));
            }
            Iterable $i$f$forEach22 = clusterGroup.getConfuseMatrices();
            Collection destination$iv = (Collection)new Frequency(null, 1, null);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it3;
                ConfuseMatrix confuseMatrix2 = (ConfuseMatrix)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(MathKt.roundToLong((double)(it3.getF1() * (double)100)) / (long)5 * (long)5);
            }
            Frequency f1s = (Frequency)destination$iv;
            this.taskLogger.debug(Frequency.toPString$default((Frequency)f1s, (String)"probabilities of f1 values:\t", null, null, (int)6, null));
        }
        return clusterGroup;
    }

    @NotNull
    public final ArrayList<NodePoint> encode(@NotNull List<? extends Node> nodes2) {
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        if (nodes2.isEmpty()) {
            return new ArrayList<NodePoint>();
        }
        Instant start = Instant.now();
        List distinctNodes = CollectionsKt.distinct((Iterable)nodes2);
        int numDuplicateNodes = nodes2.size() - distinctNodes.size();
        if (numDuplicateNodes > 0) {
            this.taskLogger.debug(numDuplicateNodes + " duplicate nodes are removed before clustering");
        }
        EncodeOptions encodeOptions = new EncodeOptions(null, false, null, this.options.getNGram(), 0, 23, null);
        ClusterSensitiveComponentEncoder encoder = new ClusterSensitiveComponentEncoder(encodeOptions, this.options.getPcaRate(), 0, 4, null);
        return encoder.encode(distinctNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Closeable closeable = this.reportWriter;
        Throwable throwable = null;
        try {
            Object object;
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            it.newLine();
            it.flush();
            Object object2 = it;
            try {
                BufferedWriter $this$close_u24lambda_u2427_u24lambda_u2425 = object2;
                boolean bl2 = false;
                it.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable2 != null) {
                Object it2 = object = throwable2;
                boolean bl3 = false;
                LogsKt.warnForClose((Object)this, (Throwable)it2);
            }
            Object object3 = object2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.componentClusterGroups.clear();
        this.tileClusterGroups.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportTileClusterGroups() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tileClusterGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileClusterGroup tileClusterGroup = (TileClusterGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMetrics());
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List metrics = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NodeClusterGroupMetrics it = (NodeClusterGroupMetrics)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getScore());
                it = (NodeClusterGroupMetrics)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getScore())));
            }
        });
        SimpleResultSet rs = NodeClusterGroupMetrics.Companion.toResultSet(metrics);
        this.log(this.status + "\n" + new ResultSetFormatter((ResultSet)rs, false, true, 0, null, 26, null));
    }

    private final void log(String message) {
        this.reportWriter.write(message);
        this.reportWriter.newLine();
        this.taskLogger.info(message);
    }

    private final TileCluster removePolysemousPoints(TileCluster cluster2) {
        List uniquePoints = new ArrayList();
        cluster2.getPagePoints().forEach((arg_0, arg_1) -> NodeClusterRunner.removePolysemousPoints$lambda$30((Function2)new Function2<Integer, List<? extends NodePoint>, Unit>((List<NodePoint>)uniquePoints){
            final /* synthetic */ List<NodePoint> $uniquePoints;
            {
                this.$uniquePoints = $uniquePoints;
                super(2);
            }

            public final void invoke(@NotNull Integer pid, @NotNull List<? extends NodePoint> points) {
                Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
                Intrinsics.checkNotNullParameter(points, (String)"points");
                if (points.size() > 1) {
                    Iterable $this$sortedBy$iv = points;
                    boolean $i$f$sortedBy = false;
                    List sortedPoints = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            NodePoint it = (NodePoint)((Object)a);
                            boolean bl = false;
                            Comparable comparable = Double.valueOf(it.getCentroidDistance());
                            it = (NodePoint)((Object)b);
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getCentroidDistance()));
                        }
                    });
                    this.$uniquePoints.add((NodePoint)((Object)CollectionsKt.first((List)sortedPoints)));
                } else {
                    this.$uniquePoints.add((NodePoint)((Object)CollectionsKt.first(points)));
                }
            }
        }, arg_0, arg_1));
        cluster2.getPoints().clear();
        cluster2.getPoints().addAll(uniquePoints);
        return cluster2;
    }

    private static final void removePolysemousPoints$lambda$30(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Pair access$isRelevant(NodeClusterRunner $this, VisualComponent component) {
        return $this.isRelevant(component);
    }

    public static final /* synthetic */ HarvestOptions access$getOptions$p(NodeClusterRunner $this) {
        return $this.options;
    }

    public static final /* synthetic */ void access$log(NodeClusterRunner $this, String message) {
        $this.log(message);
    }

    public static final /* synthetic */ Logger access$getLogger$p(NodeClusterRunner $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$clusterTiles(NodeClusterRunner $this, String taskName, List components) {
        $this.clusterTiles(taskName, components);
    }
}

