/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.unsupervised;

import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.entities.ConfuseMatrix;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.unsupervised.NodeCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/ml/unsupervised/TileCluster;", "Lai/platon/scent/ml/unsupervised/NodeCluster;", "centroid", "Lorg/apache/commons/math3/linear/RealVector;", "seed", "Lai/platon/scent/ml/NodePoint;", "label", "", "(Lorg/apache/commons/math3/linear/RealVector;Lai/platon/scent/ml/NodePoint;I)V", "components", "", "Lorg/jsoup/nodes/Element;", "getComponents", "()Ljava/util/List;", "setComponents", "(Ljava/util/List;)V", "sampleComponent", "getSampleComponent", "()Lorg/jsoup/nodes/Element;", "estimate", "", "estimateIfLabeled", "Lai/platon/scent/entities/ConfuseMatrix;", "matchAll", "", "removePolysemousPoints", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nClustering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/TileCluster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1141:1\n1855#2:1142\n1855#2,2:1143\n1856#2:1145\n1726#2,3:1146\n1726#2,3:1149\n*S KotlinDebug\n*F\n+ 1 Clustering.kt\nai/platon/scent/ml/unsupervised/TileCluster\n*L\n490#1:1142\n512#1:1143,2\n490#1:1145\n538#1:1146,3\n546#1:1149,3\n*E\n"})
public class TileCluster
extends NodeCluster {
    @NotNull
    private List<? extends Element> components;

    public TileCluster(@NotNull RealVector centroid2, @NotNull NodePoint seed, int label) {
        Intrinsics.checkNotNullParameter((Object)centroid2, (String)"centroid");
        Intrinsics.checkNotNullParameter((Object)((Object)seed), (String)"seed");
        super(centroid2, seed, label);
        this.components = CollectionsKt.emptyList();
    }

    public /* synthetic */ TileCluster(RealVector realVector, NodePoint nodePoint, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(realVector, nodePoint, n);
    }

    @NotNull
    public final List<Element> getComponents() {
        return this.components;
    }

    public final void setComponents(@NotNull List<? extends Element> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.components = list;
    }

    @Nullable
    public final Element getSampleComponent() {
        return (Element)CollectionsKt.firstOrNull(this.components);
    }

    @NotNull
    public final ConfuseMatrix estimateIfLabeled() {
        return new ConfuseMatrix(0, 0, 0, 0, 15, null);
    }

    @Override
    public void estimate() {
        if (this.getPoints().isEmpty()) {
            return;
        }
        super.estimate();
        if (this.matchAll()) {
            int tp = this.getPoints().size();
            this.setConfuseMatrix(ConfuseMatrix.Companion.estimate(tp, 0, 0, 0));
            return;
        }
        int tp = 0;
        int fp = 0;
        int fn = 0;
        int tn = 0;
        String selector = this.getMostSelector();
        Intrinsics.checkNotNull((Object)selector);
        if (((CharSequence)selector).length() == 0) {
            return;
        }
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List expectations;
            Element component = (Element)element$iv;
            boolean bl = false;
            int pid = NodeExtKt.getPid((Node)((Node)component));
            List list = expectations = StringsKt.startsWith$default((String)selector, (String)"html", (boolean)false, (int)2, null) ? NodeExtKt.nodeSelect((Node)((Node)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getOwnerDocument((Node)((Node)component))), (String)selector) : NodeExtKt.nodeSelect((Node)((Node)component), (String)selector);
            if (expectations.isEmpty()) {
                int predicated;
                List<NodePoint> list2 = this.getPagePoints().get(pid);
                int n = predicated = list2 != null ? list2.size() : 0;
                if (predicated > 0) {
                    fp += predicated;
                    continue;
                }
                ++tn;
                continue;
            }
            List<NodePoint> list3 = this.getPagePoints().get(pid);
            if (list3 == null) continue;
            Iterable $this$forEach$iv2 = list3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                NodePoint it = (NodePoint)((Object)element$iv2);
                boolean bl2 = false;
                if (expectations.contains(it.getNode()) || expectations.contains(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getBestElement((Node)it.getNode()))) {
                    ++tp;
                    continue;
                }
                ++fn;
            }
        }
        this.setConfuseMatrix(ConfuseMatrix.Companion.estimate(tp, fp, fn, tn));
    }

    private final boolean matchAll() {
        Node next;
        int documentSize = this.getDocuments().size();
        if (this.getPids().entrySet().size() == documentSize && this.getPoints().size() == documentSize && this.getRelativePaths().entrySet().size() == 1) {
            return true;
        }
        Node prev = this.getFirstNode().previousSibling();
        if (prev != null && NodeExtKt.isLocallyConstant((Node)prev)) {
            boolean bl;
            block11: {
                String constant = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)prev);
                Iterable $this$all$iv = this.getPoints();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        NodePoint it = (NodePoint)((Object)element$iv);
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)it.getNode().previousSibling()), (Object)constant)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return true;
            }
        }
        if ((next = this.getFirstNode().nextSibling()) != null && NodeExtKt.isLocallyConstant((Node)next)) {
            boolean bl;
            block12: {
                String constant = ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)next);
                Iterable $this$all$iv = this.getPoints();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        NodePoint it = (NodePoint)((Object)element$iv);
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCleanText((Node)it.getNode().nextSibling()), (Object)constant)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public final void removePolysemousPoints() {
        List uniquePoints = new ArrayList();
        this.getPagePoints().forEach((arg_0, arg_1) -> TileCluster.removePolysemousPoints$lambda$4((Function2)new Function2<Integer, List<? extends NodePoint>, Unit>((List<NodePoint>)uniquePoints){
            final /* synthetic */ List<NodePoint> $uniquePoints;
            {
                this.$uniquePoints = $uniquePoints;
                super(2);
            }

            public final void invoke(@NotNull Integer pid, @NotNull List<? extends NodePoint> points) {
                Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
                Intrinsics.checkNotNullParameter(points, (String)"points");
                if (points.size() > 1) {
                    Iterable $this$sortedBy$iv = points;
                    boolean $i$f$sortedBy = false;
                    List sortedPoints = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            NodePoint it = (NodePoint)((Object)a);
                            boolean bl = false;
                            Comparable comparable = Double.valueOf(it.getCentroidDistance());
                            it = (NodePoint)((Object)b);
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getCentroidDistance()));
                        }
                    });
                    this.$uniquePoints.add((NodePoint)((Object)CollectionsKt.first((List)sortedPoints)));
                } else {
                    this.$uniquePoints.add((NodePoint)((Object)CollectionsKt.first(points)));
                }
            }
        }, arg_0, arg_1));
        this.getPoints().clear();
        this.getPoints().addAll(uniquePoints);
    }

    private static final void removePolysemousPoints$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

