/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.segment;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.ql.common.ResultSets;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.nodes.AnchorGroup;
import ai.platon.scent.dom.nodes.NavigateComponent;
import ai.platon.scent.dom.nodes.NavigateDocument;
import ai.platon.scent.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.segment.AnchorFrameLocator;
import ai.platon.scent.segment.BlockLocator;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lai/platon/scent/segment/NavigationLocator;", "Lai/platon/scent/segment/AnchorFrameLocator;", "options", "Lai/platon/scent/dom/HarvestOptions;", "(Lai/platon/scent/dom/HarvestOptions;)V", "anchorGroups", "Lcom/google/common/collect/TreeMultimap;", "", "Lai/platon/scent/dom/nodes/AnchorGroup;", "getAnchorGroups", "()Lcom/google/common/collect/TreeMultimap;", "documents", "", "Lai/platon/scent/dom/nodes/NavigateDocument;", "getDocuments", "()Ljava/util/List;", "locate", "", "Lorg/jsoup/nodes/Element;", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "docs", "toReport", "prefix", "postfix", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nBlockLocators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockLocators.kt\nai/platon/scent/segment/NavigationLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1620#2,3:136\n2634#2:139\n1360#2:141\n1446#2,2:142\n1360#2:144\n1446#2,2:145\n766#2:147\n857#2,2:148\n1448#2,3:150\n1855#2,2:153\n1603#2,9:156\n1855#2:165\n1856#2:167\n1612#2:168\n1360#2:170\n1446#2,5:171\n1054#2:176\n1864#2,3:177\n1#3:140\n1#3:155\n1#3:166\n1#3:169\n*S KotlinDebug\n*F\n+ 1 BlockLocators.kt\nai/platon/scent/segment/NavigationLocator\n*L\n70#1:136,3\n71#1:139\n72#1:141\n72#1:142,2\n72#1:144\n72#1:145,2\n72#1:147\n72#1:148,2\n72#1:150,3\n73#1:153,2\n88#1:156,9\n88#1:165\n88#1:167\n88#1:168\n113#1:170\n113#1:171,5\n113#1:176\n113#1:177,3\n71#1:140\n88#1:166\n*E\n"})
public class NavigationLocator
extends AnchorFrameLocator {
    @NotNull
    private final List<NavigateDocument> documents;
    @NotNull
    private final TreeMultimap<String, AnchorGroup> anchorGroups;

    public NavigationLocator(@NotNull HarvestOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options);
        this.documents = new ArrayList();
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)ComparisonsKt.reverseOrder());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        this.anchorGroups = treeMultimap;
    }

    @NotNull
    public final List<NavigateDocument> getDocuments() {
        return this.documents;
    }

    @NotNull
    public final TreeMultimap<String, AnchorGroup> getAnchorGroups() {
        return this.anchorGroups;
    }

    @Override
    @NotNull
    public List<Element> locate(@NotNull FeaturedDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        if (!ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.isInitialized((Document)doc.getDocument()).get()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.locate(CollectionsKt.listOf((Object)doc));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Element> locate(@NotNull List<? extends FeaturedDocument> docs) {
        void $this$mapNotNullTo$iv$iv;
        Iterator $this$flatMapTo$iv$iv3;
        NavigateDocument it;
        Iterator it2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        Iterable iterable = docs;
        Collection destination$iv = this.documents;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            FeaturedDocument featuredDocument = (FeaturedDocument)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new NavigateDocument((FeaturedDocument)it2));
        }
        Iterable $this$onEach$iv = this.documents;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $i$f$mapTo22 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (NavigateDocument)element$iv;
            boolean bl2 = false;
            it.partition(this.getOptions());
        }
        Iterable $this$flatMap$iv = $i$f$mapTo22;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        it2 = $this$flatMapTo$iv$iv3.iterator();
        while (it2.hasNext()) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv$iv = it2.next();
            it = (NavigateDocument)element$iv$iv;
            boolean bl3 = false;
            Iterable $this$flatMap$iv2 = it.getAnchorGroups();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$filterTo$iv$iv;
                AnchorGroup it3 = (AnchorGroup)element$iv$iv2;
                boolean bl4 = false;
                Iterable $this$filter$iv = it3.leafNodes();
                boolean $i$f$filter = false;
                Iterable iterable3 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                    AnchorGroup it4 = (AnchorGroup)element$iv$iv3;
                    boolean bl5 = false;
                    if (!(it4.getSize() >= 5)) continue;
                    destination$iv$iv3.add(element$iv$iv3);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AnchorGroup it5 = (AnchorGroup)element$iv;
            boolean bl6 = false;
            this.anchorGroups.put((Object)it5.getPath(), (Object)it5);
        }
        if (this.getLog().isInfoEnabled()) {
            Object element$iv;
            Iterable $i$f$forEach2 = this.documents;
            int $this$flatMapTo$iv$iv3 = 0;
            for (Object it5 : $i$f$forEach2) {
                NavigateDocument bl6 = (NavigateDocument)it5;
                int n = $this$flatMapTo$iv$iv3;
                boolean bl7 = false;
                int n2 = it.getComponents().size();
                $this$flatMapTo$iv$iv3 = n + n2;
            }
            int numComponents = $this$flatMapTo$iv$iv3;
            element$iv = "Found %d anchor groups from %d navigate components";
            Object[] it5 = new Object[]{this.anchorGroups.size(), numComponents};
            String string = String.format((String)element$iv, Arrays.copyOf(it5, it5.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            String message = string;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(BlockLocator.toReport$default(this, message, null, 2, null));
            } else {
                this.getLog().info(message);
            }
        }
        Collection collection = this.anchorGroups.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable $this$flatMapTo$iv$iv3 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl8 = false;
            AnchorGroup it6 = (AnchorGroup)element$iv$iv;
            boolean bl9 = false;
            NavigateComponent navigateComponent = it6.getComponent();
            if ((navigateComponent != null ? navigateComponent.getElement() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toReport(@NotNull String prefix, @NotNull String postfix) {
        void $this$sortedByDescending$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        StringBuilder sb = new StringBuilder(prefix);
        SimpleResultSet rs = null;
        rs = ResultSets.newSimpleResultSet();
        String[] stringArray = new String[]{" ", "Name", "X", "Y", "W", "H", "E C", "AnchorImgs", "Anchors", "Child Widths", "Child Heights", "Sqr Areas", "Memo", "Score"};
        String[] it = stringArray;
        boolean $i$a$-let-NavigationLocator$toReport$22 = false;
        ResultSets.addColumns((SimpleResultSet)rs, (String[])Arrays.copyOf(it, it.length));
        Iterable $this$flatMap$iv = this.documents;
        boolean $i$f$flatMap = false;
        Iterable $i$a$-let-NavigationLocator$toReport$22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NavigateDocument it2 = (NavigateDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NavigateComponent it = (NavigateComponent)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (NavigateComponent)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
            }
        }), (int)100);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String sqrtArea2;
            Comparable[] comparableArray;
            Frequency frequency;
            void component;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (NavigateComponent)item$iv;
            int i = n;
            boolean bl = false;
            Element e = component.getElement();
            String name = StringUtils.abbreviateMiddle((String)ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getCanonicalName((Node)((Node)e)), (String)"..", (int)40);
            Frequency it3 = frequency = NodeExtKt.getChildrenWidths((Node)((Node)e));
            boolean bl2 = false;
            Object object = !((Collection)it3).isEmpty() ? frequency : null;
            Multiset.Entry widths = object != null ? object.getMostEntry() : null;
            Object it4 = comparableArray = NodeExtKt.getChildrenHeights((Node)((Node)e));
            boolean $i$a$-takeIf-NavigationLocator$toReport$4$heights$22 = false;
            Object object2 = !((Collection)it4).isEmpty() ? comparableArray : null;
            Multiset.Entry heights = object2 != null ? object2.getMostEntry() : null;
            it4 = "%.0f / %d";
            Object[] $i$a$-takeIf-NavigationLocator$toReport$4$heights$22 = new Object[]{NodeExtKt.getSqrtArea((Node)((Node)e)), NodeExtKt.getChildrenAreas((Node)((Node)e)).size()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format((String)it4, Arrays.copyOf($i$a$-takeIf-NavigationLocator$toReport$4$heights$22, $i$a$-takeIf-NavigationLocator$toReport$4$heights$22.length)), (String)"format(...)");
            comparableArray = new Comparable[]{Integer.valueOf(i + 1), name, Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getX((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getY((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getWidth((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getHeight((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumChildren((Node)((Node)e))), Integer.valueOf(NodeExtKt.getNumAnchorImages((Node)((Node)e))), Integer.valueOf(ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt.getNumAnchors((Node)((Node)e))), "m" + widths + " / " + NodeExtKt.getChildrenWidths((Node)((Node)e)).size(), "m" + heights + " / " + NodeExtKt.getChildrenHeights((Node)((Node)e)).size(), sqrtArea2, component.getMemo(), component.getScore()};
            it4 = comparableArray;
            boolean bl3 = false;
            rs.addRow((Object[])Arrays.copyOf(it4, ((Comparable[])it4).length));
        }
        StringBuilder stringBuilder = sb.append('\n');
        SimpleResultSet simpleResultSet = rs;
        Intrinsics.checkNotNullExpressionValue((Object)simpleResultSet, (String)"element");
        stringBuilder.append(new ResultSetFormatter((ResultSet)simpleResultSet, false, false, 0, null, 30, null).toString());
        Collection collection = this.anchorGroups.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        SimpleResultSet rs2 = AnchorGroup.Companion.toResultSet((Iterable)collection);
        String string = sb.append('\n').append(new ResultSetFormatter((ResultSet)rs2, false, false, 0, null, 30, null).toString()).append(postfix).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

