/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis;

import ai.platon.pulsar.skeleton.common.urls.NormURL;
import ai.platon.scent.common.Auth;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.entities.HarvestTaskStatus;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005J\"\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0005J\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/analysis/HarvestTaskTracker;", "", "()V", "activeTaskStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lai/platon/scent/entities/HarvestTaskStatus;", "computeIfAbsent", "normUrl", "Lai/platon/pulsar/skeleton/common/urls/NormURL;", "configuredUrl", "mappingFunction", "Lkotlin/Function1;", "findByUuid", "uuid", "get", "getIfActive", "Lai/platon/scent/dom/HNormUrl;", "remove", "set", "", "task", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nHarvestTaskTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HarvestTaskTracker.kt\nai/platon/scent/analysis/HarvestTaskTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class HarvestTaskTracker {
    @NotNull
    private final ConcurrentHashMap<String, HarvestTaskStatus> activeTaskStatus = new ConcurrentHashMap();

    @Nullable
    public final HarvestTaskStatus get(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.get(configuredUrl);
    }

    @Nullable
    public final HarvestTaskStatus getIfActive(@NotNull HNormUrl normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        HarvestTaskStatus activeTask = this.activeTaskStatus.get(normUrl.getConfiguredUrl());
        if (activeTask != null && activeTask.getStatusCode() == 200) {
            if (!activeTask.getHasResult()) {
                this.remove(normUrl.getConfiguredUrl());
            } else {
                Duration duration = normUrl.getOptions().getExpires();
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-expires>(...)");
                if (!activeTask.isExpired(duration)) {
                    return activeTask;
                }
            }
        }
        return null;
    }

    public final void set(@NotNull String configuredUrl, @NotNull HarvestTaskStatus task) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ((Map)this.activeTaskStatus).put(configuredUrl, task);
    }

    @Nullable
    public final HarvestTaskStatus remove(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        return this.activeTaskStatus.remove(configuredUrl);
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull NormURL normUrl) {
        Intrinsics.checkNotNullParameter((Object)normUrl, (String)"normUrl");
        return this.computeIfAbsent(normUrl.getConfiguredUrl());
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull String configuredUrl) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        HarvestTaskStatus harvestTaskStatus = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestTaskTracker.computeIfAbsent$lambda$0((Function1)new Function1<String, HarvestTaskStatus>(configuredUrl){
            final /* synthetic */ String $configuredUrl;
            {
                this.$configuredUrl = $configuredUrl;
                super(1);
            }

            @NotNull
            public final HarvestTaskStatus invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new HarvestTaskStatus(Auth.INSTANCE.getSYSTEM_AUTH(), this.$configuredUrl, 0, null, null, 0, 0, 0, 0, 0, 0.0, 0, 0, null, null, 32764, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestTaskStatus, (String)"computeIfAbsent(...)");
        return harvestTaskStatus;
    }

    @NotNull
    public final HarvestTaskStatus computeIfAbsent(@NotNull String configuredUrl, @NotNull Function1<? super String, HarvestTaskStatus> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)configuredUrl, (String)"configuredUrl");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        HarvestTaskStatus harvestTaskStatus = this.activeTaskStatus.computeIfAbsent(configuredUrl, arg_0 -> HarvestTaskTracker.computeIfAbsent$lambda$1(mappingFunction, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)harvestTaskStatus, (String)"computeIfAbsent(...)");
        return harvestTaskStatus;
    }

    @Nullable
    public final HarvestTaskStatus findByUuid(@NotNull String uuid) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Collection<HarvestTaskStatus> collection = this.activeTaskStatus.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                HarvestTaskStatus it = (HarvestTaskStatus)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final HarvestTaskStatus computeIfAbsent$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HarvestTaskStatus)$tmp0.invoke(p0);
    }

    private static final HarvestTaskStatus computeIfAbsent$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HarvestTaskStatus)$tmp0.invoke(p0);
    }
}

