/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.FrequencyManager;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.DomQueriesKt;
import ai.platon.scent.analysis.AutoMiningResult;
import ai.platon.scent.analysis.corpus.AnalysablePageCorpus;
import ai.platon.scent.analysis.corpus.FullFeaturedDocumentKt;
import ai.platon.scent.analysis.corpus.OrderedRegionalTileNode;
import ai.platon.scent.analysis.corpus.PageCorpusTabulator;
import ai.platon.scent.analysis.corpus.RegionalTile;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualComponentType;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.analysis.corpus.VisualDocumentKt;
import ai.platon.scent.analysis.diagnosis.AutoMiningDiagnotor;
import ai.platon.scent.analysis.view.CorpusVisualizer;
import ai.platon.scent.common.MLPaths;
import ai.platon.scent.common.Systems;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.features.defined.FF;
import ai.platon.scent.entities.ColumnData;
import ai.platon.scent.entities.PageTableGroup;
import ai.platon.scent.entities.PageTableKt;
import ai.platon.scent.entities.RowData;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.semisupervised.NodeClusterRunner;
import ai.platon.scent.ml.unsupervised.TileClusterGroup;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import java.io.Closeable;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u0088\u00012\u00020\u0001:\u0006\u0088\u0001\u0089\u0001\u008a\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010I\u001a\u00020JH\u0002J\u0006\u0010K\u001a\u00020LJ\b\u0010M\u001a\u00020JH\u0002J\u0010\u0010M\u001a\u00020J2\u0006\u0010N\u001a\u00020\u0007H\u0002J\b\u0010O\u001a\u00020JH\u0002J\b\u0010P\u001a\u00020JH\u0002J\b\u0010Q\u001a\u00020JH\u0002J\b\u0010R\u001a\u00020JH\u0002J\b\u0010S\u001a\u00020JH\u0002J\b\u0010T\u001a\u00020JH\u0002J\u0006\u0010U\u001a\u00020JJ\b\u0010V\u001a\u00020JH\u0002J\b\u0010W\u001a\u00020JH\u0002J\b\u0010X\u001a\u00020JH\u0002J\b\u0010Y\u001a\u00020JH\u0002J\b\u0010Z\u001a\u00020JH\u0002J\b\u0010[\u001a\u00020JH\u0016J \u0010\\\u001a\u00020]2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020]0_2\b\b\u0002\u0010`\u001a\u00020\u0006H\u0002J\u0018\u0010a\u001a\u00020J2\u0006\u0010b\u001a\u00020;2\u0006\u0010c\u001a\u00020dH\u0002J\b\u0010e\u001a\u00020JH\u0002J\u0010\u0010f\u001a\u00020L2\u0006\u0010g\u001a\u00020hH\u0002J\n\u0010i\u001a\u0004\u0018\u00010;H\u0002J\u0010\u0010j\u001a\u00020J2\u0006\u0010k\u001a\u00020LH\u0002J\u0010\u0010l\u001a\u00020\r2\u0006\u0010m\u001a\u00020 H\u0002J\b\u0010n\u001a\u00020JH\u0002J\u001e\u0010o\u001a\u00020J2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00070_2\u0006\u0010q\u001a\u00020rH\u0002J*\u0010s\u001a\u00020J2\u0006\u0010m\u001a\u00020 2\u0006\u0010t\u001a\u00020u2\u0006\u0010q\u001a\u00020r2\b\b\u0002\u0010v\u001a\u00020\u0006H\u0002J\u001c\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00070_2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00070_H\u0002J\b\u0010y\u001a\u00020JH\u0002J\b\u0010z\u001a\u00020JH\u0002J\f\u0010{\u001a\b\u0012\u0004\u0012\u00020\u00070_J\b\u0010|\u001a\u00020JH\u0002J\u0006\u0010}\u001a\u00020JJ\b\u0010~\u001a\u00020JH\u0002J\b\u0010\u007f\u001a\u00020JH\u0002J\u0017\u0010\u0080\u0001\u001a\u00020J2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\t\u0010\u0081\u0001\u001a\u00020JH\u0002J\t\u0010\u0082\u0001\u001a\u00020JH\u0002J\t\u0010\u0083\u0001\u001a\u00020JH\u0002J\u001a\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010g\u001a\u00020h2\u0006\u0010&\u001a\u00020'H\u0002J\t\u0010\u0086\u0001\u001a\u00020JH\u0002J\t\u0010\u0087\u0001\u001a\u00020JH\u0002R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 0\fj\u0002`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013R\u001a\u0010.\u001a\u00020/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00188\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b6\u00107R\u001e\u00108\u001a\u0012\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020 0\fj\u0002`9X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010:\u001a\n <*\u0004\u0018\u00010;0;8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\n <*\u0004\u0018\u00010@0@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "Ljava/lang/AutoCloseable;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "samples", "", "", "Lai/platon/scent/analysis/corpus/VisualDocument;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/dom/HNormUrl;Ljava/util/Map;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "captionedElementIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "componentElements", "", "getComponentElements$scent_auto_mining", "()Ljava/util/List;", "components", "Lai/platon/scent/analysis/corpus/VisualComponent;", "getComponents$scent_auto_mining", "dff", "Lai/platon/pulsar/common/Frequency;", "documentFrequency", "Lai/platon/pulsar/common/FrequencyManager;", "documentUrls", "", "getDocumentUrls$scent_auto_mining", "()Ljava/util/Set;", "layoutLeftIndexer", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "logger", "Lorg/slf4j/Logger;", "naturalComponents", "getNaturalComponents$scent_auto_mining", "options", "Lai/platon/scent/dom/HarvestOptions;", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "getPortalUrl", "()Lai/platon/scent/dom/HNormUrl;", "qualifiedDocuments", "getQualifiedDocuments$scent_auto_mining", "recoverableConfidence", "", "getRecoverableConfidence$scent_auto_mining", "()D", "setRecoverableConfidence$scent_auto_mining", "(D)V", "regionalTileFrequency", "Lai/platon/scent/analysis/corpus/RegionalTile;", "getRegionalTileFrequency$annotations", "()V", "regionalTileNodeIndexer", "Lai/platon/scent/analysis/corpus/RegionalTileNodeIndexer;", "reportDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getReportDirectory", "()Ljava/nio/file/Path;", "startTime", "Ljava/time/OffsetDateTime;", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "taskLogger", "uniquePathComponents", "getUniquePathComponents$scent_auto_mining", "()Lcom/google/common/collect/TreeMultimap;", "unusedData", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$UnusedData;", "addLabeledDocuments", "", "analyse", "Lai/platon/scent/analysis/AutoMiningResult;", "analysisVariables", "doc", "annotateNodes", "arrangeComponents", "assembleCaptionedElementIndexer", "assembleLayoutLeftIndexer", "assembleRegionalTextNodeIndex", "calculateCaptionDocFrequency", "calculateCorpusFeatures", "calculateCorpusFeatures0", "calculateDocumentFrequency", "calculateMoreCorpusFeatures", "calculateTextNodeDocFrequency", "chooseQualifiedDocuments", "close", "combineTables", "Lai/platon/pulsar/common/OpenMapTable;", "tables", "", "uniqueKeyColumn", "createInfoFile", "datasetPath", "encodeOptions", "Lai/platon/scent/ml/EncodeOptions;", "divideDistricts", "doAutoMining", "clusterer", "Lai/platon/scent/ml/semisupervised/NodeClusterRunner;", "doEncodeToDataset", "drawIfNecessary", "result", "encodeLabel", "node", "enhancePartition", "exportAllElements", "documents", "pw", "Ljava/io/PrintWriter;", "exportNode", "features", "Lorg/apache/commons/math3/linear/RealVector;", "separator", "filterByUris", "docs", "findComponents", "findLayoutComponents", "findQualifiedDocuments", "nominalFeaturesToIndex", "removeIrregularNodes", "reportComponents", "reportCorpusFeatures", "reportDff", "simplifyAnnotations", "styleFeaturesToIndex", "supplementComponents", "tabulate", "Lai/platon/scent/entities/PageTableGroup;", "traceCorpus", "validateFeatures", "Companion", "FreeCell", "UnusedData", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nAnalysablePageCorpus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysablePageCorpus.kt\nai/platon/scent/analysis/corpus/AnalysablePageCorpus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1251:1\n1855#2:1252\n1855#2,2:1253\n1856#2:1255\n1855#2,2:1256\n1855#2,2:1258\n1855#2,2:1260\n1446#2,5:1262\n1446#2,5:1267\n1620#2,3:1272\n1855#2,2:1275\n1855#2,2:1277\n1054#2:1279\n1579#2:1280\n1864#2,2:1281\n1866#2:1285\n1580#2:1286\n766#2:1287\n857#2,2:1288\n1360#2:1290\n1446#2,2:1291\n1448#2,3:1297\n1864#2,2:1303\n1855#2:1311\n1856#2:1315\n1866#2:1316\n1620#2,3:1319\n766#2:1322\n857#2,2:1323\n1549#2:1325\n1620#2,3:1326\n1855#2,2:1329\n766#2:1331\n857#2,2:1332\n1864#2,3:1338\n1864#2,3:1345\n1855#2,2:1348\n1855#2,2:1350\n1620#2,3:1353\n1855#2,2:1356\n1611#2:1359\n1855#2:1360\n1620#2,3:1361\n1856#2:1365\n1612#2:1366\n1855#2,2:1367\n1855#2,2:1369\n288#2,2:1371\n1611#2:1373\n1855#2:1374\n1856#2:1376\n1612#2:1377\n1611#2:1378\n1855#2:1379\n1856#2:1381\n1612#2:1382\n1855#2,2:1383\n1855#2,2:1386\n1620#2,3:1390\n1855#2,2:1393\n1446#2,2:1396\n1549#2:1398\n1620#2,3:1399\n1448#2,3:1402\n1179#2,2:1405\n1253#2,2:1407\n1620#2,3:1409\n1256#2:1412\n1271#2,2:1413\n1285#2,4:1415\n1855#2,2:1420\n1855#2,2:1423\n1549#2:1425\n1620#2,3:1426\n766#2:1429\n857#2,2:1430\n1360#2:1432\n1446#2,5:1433\n1620#2,3:1438\n1855#2,2:1441\n1855#2:1443\n1856#2:1448\n766#2:1449\n857#2,2:1450\n1855#2,2:1452\n766#2:1454\n857#2,2:1455\n1855#2,2:1457\n766#2:1459\n857#2,2:1460\n1855#2,2:1462\n1#3:1283\n1#3:1284\n1#3:1364\n1#3:1375\n1#3:1380\n11065#4:1293\n11400#4,3:1294\n13374#4,3:1300\n1627#4,6:1305\n13374#4,3:1312\n11065#4:1334\n11400#4,3:1335\n11065#4:1341\n11400#4,3:1342\n215#5,2:1317\n215#5:1352\n216#5:1358\n215#5:1385\n216#5:1388\n215#5:1389\n216#5:1395\n215#5:1419\n216#5:1422\n125#5:1444\n152#5,3:1445\n*S KotlinDebug\n*F\n+ 1 AnalysablePageCorpus.kt\nai/platon/scent/analysis/corpus/AnalysablePageCorpus\n*L\n369#1:1252\n376#1:1253,2\n369#1:1255\n391#1:1256,2\n461#1:1258,2\n478#1:1260,2\n488#1:1262,5\n490#1:1267,5\n492#1:1272,3\n496#1:1275,2\n572#1:1277,2\n611#1:1279\n612#1:1280\n612#1:1281,2\n612#1:1285\n612#1:1286\n622#1:1287\n622#1:1288,2\n635#1:1290\n635#1:1291,2\n635#1:1297,3\n650#1:1303,2\n653#1:1311\n653#1:1315\n650#1:1316\n710#1:1319,3\n713#1:1322\n713#1:1323,2\n717#1:1325\n717#1:1326,3\n717#1:1329,2\n720#1:1331\n720#1:1332,2\n735#1:1338,3\n775#1:1345,3\n827#1:1348,2\n857#1:1350,2\n893#1:1353,3\n897#1:1356,2\n909#1:1359\n909#1:1360\n910#1:1361,3\n909#1:1365\n909#1:1366\n919#1:1367,2\n928#1:1369,2\n942#1:1371,2\n943#1:1373\n943#1:1374\n943#1:1376\n943#1:1377\n944#1:1378\n944#1:1379\n944#1:1381\n944#1:1382\n990#1:1383,2\n1005#1:1386,2\n1046#1:1390,3\n1051#1:1393,2\n1080#1:1396,2\n1081#1:1398\n1081#1:1399,3\n1080#1:1402,3\n1084#1:1405,2\n1084#1:1407,2\n1084#1:1409,3\n1084#1:1412\n1096#1:1413,2\n1096#1:1415,4\n1131#1:1420,2\n1157#1:1423,2\n1164#1:1425\n1164#1:1426,3\n1168#1:1429\n1168#1:1430,2\n1168#1:1432\n1168#1:1433,5\n1175#1:1438,3\n1183#1:1441,2\n1187#1:1443\n1187#1:1448\n1199#1:1449\n1199#1:1450,2\n1199#1:1452,2\n1205#1:1454\n1205#1:1455,2\n1205#1:1457,2\n1241#1:1459\n1241#1:1460,2\n1241#1:1462,2\n612#1:1284\n909#1:1364\n943#1:1375\n944#1:1380\n635#1:1293\n635#1:1294,3\n638#1:1300,3\n652#1:1305,6\n661#1:1312,3\n731#1:1334\n731#1:1335,3\n770#1:1341\n770#1:1342,3\n675#1:1317,2\n891#1:1352\n891#1:1358\n1004#1:1385\n1004#1:1388\n1045#1:1389\n1045#1:1395\n1127#1:1419\n1127#1:1422\n1191#1:1444\n1191#1:1445,3\n*E\n"})
public final class AnalysablePageCorpus
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HNormUrl portalUrl;
    @NotNull
    private final Map<String, VisualDocument> samples;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger taskLogger;
    private final OffsetDateTime startTime;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private final Set<String> documentUrls;
    @NotNull
    private final List<VisualDocument> qualifiedDocuments;
    @NotNull
    private final FrequencyManager<String> documentFrequency;
    @NotNull
    private final Frequency<Integer> dff;
    @NotNull
    private final TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer;
    @NotNull
    private final Frequency<RegionalTile> regionalTileFrequency;
    @NotNull
    private final TreeMultimap<Integer, Element> captionedElementIndexer;
    @NotNull
    private final UnusedData unusedData;
    private double recoverableConfidence;
    @NotNull
    private final TreeMultimap<Integer, Node> layoutLeftIndexer;
    @NotNull
    private final List<VisualComponent> components;
    @NotNull
    private final TreeMultimap<String, VisualComponent> uniquePathComponents;
    @NotNull
    private final List<VisualComponent> naturalComponents;
    @NotNull
    private final List<Element> componentElements;
    @NotNull
    private static final AnalysablePageCorpus EMPTY = new AnalysablePageCorpus(HNormUrl.Companion.getNIL(), new LinkedHashMap(), ImmutableConfig.Companion.getEMPTY());

    public AnalysablePageCorpus(@NotNull HNormUrl portalUrl, @NotNull Map<String, VisualDocument> samples, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.portalUrl = portalUrl;
        this.samples = samples;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AnalysablePageCorpus.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AnalysablePageCorpus.class), (String)".Task");
        this.startTime = OffsetDateTime.now();
        this.stopWatch = new Slf4JStopWatch();
        this.documentUrls = new LinkedHashSet();
        this.qualifiedDocuments = new ArrayList();
        this.documentFrequency = new FrequencyManager();
        this.dff = new Frequency(null, 1, null);
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodePositionComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        this.regionalTileNodeIndexer = treeMultimap;
        this.regionalTileFrequency = new Frequency(null, 1, null);
        TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
        this.captionedElementIndexer = treeMultimap2;
        this.unusedData = new UnusedData();
        TreeMultimap treeMultimap3 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Node it = (Node)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NodeExtKt.getTop((Node)it));
                it = (Node)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getTop((Node)it)));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap3, (String)"create(...)");
        this.layoutLeftIndexer = treeMultimap3;
        this.components = new ArrayList();
        TreeMultimap treeMultimap4 = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap4, (String)"create(...)");
        this.uniquePathComponents = treeMultimap4;
        this.naturalComponents = new ArrayList();
        this.componentElements = new ArrayList();
    }

    @NotNull
    public final HNormUrl getPortalUrl() {
        return this.portalUrl;
    }

    public final Path getReportDirectory() {
        return AppPaths.INSTANCE.getREPORT_DIR().resolve("harvest/corpus").resolve(AppPaths.INSTANCE.fromHost(this.portalUrl.getUrl()));
    }

    private final HarvestOptions getOptions() {
        return this.portalUrl.getHOptions();
    }

    @NotNull
    public final Set<String> getDocumentUrls$scent_auto_mining() {
        return this.documentUrls;
    }

    @NotNull
    public final List<VisualDocument> getQualifiedDocuments$scent_auto_mining() {
        return this.qualifiedDocuments;
    }

    @Deprecated(message="Used to calculate node.district, but not used currently")
    private static /* synthetic */ void getRegionalTileFrequency$annotations() {
    }

    public final double getRecoverableConfidence$scent_auto_mining() {
        return this.recoverableConfidence;
    }

    public final void setRecoverableConfidence$scent_auto_mining(double d) {
        this.recoverableConfidence = d;
    }

    @NotNull
    public final List<VisualComponent> getComponents$scent_auto_mining() {
        return this.components;
    }

    @NotNull
    public final TreeMultimap<String, VisualComponent> getUniquePathComponents$scent_auto_mining() {
        return this.uniquePathComponents;
    }

    @NotNull
    public final List<VisualComponent> getNaturalComponents$scent_auto_mining() {
        return this.naturalComponents;
    }

    @NotNull
    public final List<Element> getComponentElements$scent_auto_mining() {
        return this.componentElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void calculateCorpusFeatures() {
        block8: {
            if (!((Collection)this.qualifiedDocuments).isEmpty()) {
                return;
            }
            if (this.samples.size() < 5) {
                this.logger.warn("Too few samples: " + this.samples.size());
                return;
            }
            this.logger.info("Corpus feature calculation start - {}", (Object)Systems.INSTANCE.getHeapMessage());
            try {
                this.calculateCorpusFeatures0();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace(System.err);
                return;
            }
            finally {
                this.logger.info("Corpus feature calculation finished - {}", (Object)Systems.INSTANCE.getHeapMessage());
            }
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch == null) break block8;
            slf4JStopWatch.lap("detectRecoverableDocuments");
        }
    }

    @NotNull
    public final List<VisualDocument> findQualifiedDocuments() {
        if (this.qualifiedDocuments.isEmpty()) {
            this.chooseQualifiedDocuments();
        }
        return this.qualifiedDocuments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AutoMiningResult analyse() {
        AutoMiningResult autoMiningResult;
        this.logger.info("Analysis start - {}", (Object)Systems.INSTANCE.getHeapMessage());
        this.calculateMoreCorpusFeatures();
        boolean encodeOnly = LangKt.alwaysFalse();
        if (!encodeOnly) {
            this.findComponents();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("findComponents");
            }
        }
        if (this.taskLogger.isInfoEnabled()) {
            this.reportComponents();
        }
        String projectId = this.portalUrl.getHOptions().getProjectId();
        Path datasetPath = MLPaths.INSTANCE.getHarvestResultBaseDir().resolve(projectId).resolve("dataset-" + projectId + ".csv");
        Files.createDirectories(datasetPath.getParent(), new FileAttribute[0]);
        EncodeOptions encodeOptions = new EncodeOptions(datasetPath, true, null, 0, 0, 28, null);
        AutoCloseable autoCloseable = new NodeClusterRunner(this.qualifiedDocuments, this.uniquePathComponents, encodeOptions, this.conf);
        Throwable throwable = null;
        try {
            NodeClusterRunner it = (NodeClusterRunner)autoCloseable;
            boolean bl = false;
            autoMiningResult = this.doAutoMining(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        AutoMiningResult result = autoMiningResult;
        Intrinsics.checkNotNull((Object)datasetPath);
        this.createInfoFile(datasetPath, encodeOptions);
        this.logger.info("Analysis finished - {}", (Object)Systems.INSTANCE.getHeapMessage());
        this.drawIfNecessary(result);
        return result;
    }

    private final void reportCorpusFeatures() {
        StringBuilder sb = new StringBuilder();
        this.samples.size();
        this.qualifiedDocuments.size();
        this.captionedElementIndexer.size();
        this.layoutLeftIndexer.size();
        this.uniquePathComponents.size();
        this.naturalComponents.size();
        this.componentElements.size();
        this.components.size();
        this.documentFrequency.size();
        this.documentFrequency.forEach((arg_0, arg_1) -> AnalysablePageCorpus.reportCorpusFeatures$lambda$2((Function2)new Function2<String, Frequency<String>, Unit>(sb){
            final /* synthetic */ StringBuilder $sb;
            {
                this.$sb = $sb;
                super(2);
            }

            public final void invoke(@NotNull String t, @NotNull Frequency<String> u) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                Intrinsics.checkNotNullParameter(u, (String)"u");
                this.$sb.append(t + ": " + u + "\n");
            }
        }, arg_0, arg_1));
    }

    private final void createInfoFile(Path datasetPath, EncodeOptions encodeOptions) {
        String encodeInfo = StringsKt.trimMargin$default((String)("\n            |Portal URL: " + this.portalUrl + "\n            |\n            |Dataset path: " + datasetPath + "\n            |\n            |Encode options:\n            |" + encodeOptions + "\n            |\n            |"), null, (int)1, null);
        Files.writeString(datasetPath.resolveSibling("encodeInfo.txt"), (CharSequence)encodeInfo, new OpenOption[0]);
    }

    private final void calculateCorpusFeatures0() {
        block3: {
            if (this.samples.isEmpty()) {
                this.logger.warn("No sample in the corpus");
                return;
            }
            this.calculateDocumentFrequency();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("buildDocumentFrequency");
            }
            this.assembleRegionalTextNodeIndex();
            Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
            if (slf4JStopWatch2 != null) {
                slf4JStopWatch2.lap("buildRegionalTextNodeIndex");
            }
            this.calculateTextNodeDocFrequency();
            Slf4JStopWatch slf4JStopWatch3 = this.stopWatch;
            if (slf4JStopWatch3 == null) break block3;
            slf4JStopWatch3.lap("calculateTextNodeDocFrequency");
        }
    }

    public final void removeIrregularNodes() {
        int nScreens = this.getOptions().getNScreens();
        if (nScreens > 0) {
            Iterable $this$forEach$iv = this.samples.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VisualDocument document = (VisualDocument)element$iv;
                boolean bl = false;
                List removal = new ArrayList();
                NodesKt.forEachElement$default((Node)((Node)document.getBody()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(nScreens, (List<Element>)removal){
                    final /* synthetic */ int $nScreens;
                    final /* synthetic */ List<Element> $removal;
                    {
                        this.$nScreens = $nScreens;
                        this.$removal = $removal;
                        super(1);
                    }

                    public final void invoke(@NotNull Element it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getNthScreen((Node)((Node)it)) > this.$nScreens) {
                            this.$removal.add(it);
                        }
                    }
                }), (int)1, null);
                Iterable $this$forEach$iv2 = removal;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Element it = (Element)element$iv2;
                    boolean bl2 = false;
                    Elements elements2 = it.children();
                    Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"children(...)");
                    Iterable $this$forEach$iv3 = (Iterable)elements2;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        Element it2 = (Element)element$iv3;
                        boolean bl3 = false;
                        it2.remove();
                    }
                }
            }
        }
    }

    private final void calculateMoreCorpusFeatures() {
        block4: {
            if (this.qualifiedDocuments.isEmpty()) {
                return;
            }
            if (this.getOptions().getDiagnose() && this.getOptions().getNVerbose() > 0) {
                Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)new IntRange(0, this.qualifiedDocuments.size() - 1))), (int)this.getOptions().getNVerbose());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.qualifiedDocuments.get(it).setVerbose(true);
                }
            }
            this.assembleLayoutLeftIndexer();
            this.assembleCaptionedElementIndexer();
            this.styleFeaturesToIndex();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("styleFeaturesToIndex");
            }
            this.nominalFeaturesToIndex();
            Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
            if (slf4JStopWatch2 == null) break block4;
            slf4JStopWatch2.lap("nominalFeaturesToIndex");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findComponents() {
        void $this$mapTo$iv;
        Iterable $this$flatMapTo$iv;
        VisualDocument it;
        if (this.qualifiedDocuments.isEmpty()) {
            this.logger.warn("No qualified documents, do not find any component");
            return;
        }
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
            it.findComponents();
        }
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("findComponents");
        }
        this.findLayoutComponents();
        Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
        if (slf4JStopWatch2 != null) {
            slf4JStopWatch2.lap("findLayoutComponents");
        }
        $this$forEach$iv = this.qualifiedDocuments;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VisualDocument)element$iv;
            boolean bl = false;
        }
        this.arrangeComponents();
        Slf4JStopWatch slf4JStopWatch3 = this.stopWatch;
        if (slf4JStopWatch3 != null) {
            slf4JStopWatch3.lap("arrangeComponents");
        }
        $this$forEach$iv = this.qualifiedDocuments;
        Collection destination$iv = this.components;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it2 = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it2.getComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.qualifiedDocuments;
        destination$iv = this.naturalComponents;
        $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it3 = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it3.getNaturalComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.components;
        destination$iv = this.componentElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            VisualComponent list$iv = (VisualComponent)((Object)item$iv);
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it4.getElement());
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            VisualDocumentKt.setVisualDocument(it.getDocument(), null);
        }
        this.documentUrls.clear();
        this.unusedData.clear();
        this.qualifiedDocuments.clear();
        this.documentFrequency.clear();
        this.regionalTileNodeIndexer.clear();
        this.regionalTileFrequency.clear();
        if (!this.captionedElementIndexer.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.layoutLeftIndexer.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.components.clear();
        this.uniquePathComponents.clear();
        this.naturalComponents.clear();
        this.componentElements.clear();
    }

    private final void drawIfNecessary(AutoMiningResult result) {
        boolean draw = this.portalUrl.getHOptions().getDraw();
        if (!draw) {
            return;
        }
        boolean drawTiles = true;
        boolean drawLeafElements = true;
        boolean drawComponents = true;
        new CorpusVisualizer(result, this.qualifiedDocuments, drawTiles, drawLeafElements, drawComponents).draw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path doEncodeToDataset() {
        this.logger.info("Encoding {} documents", (Object)this.qualifiedDocuments.size());
        Path path = Files.createTempFile("dataset-", ".csv", new FileAttribute[0]);
        Closeable closeable = new PrintWriter(path.toFile());
        Throwable throwable = null;
        try {
            PrintWriter pw = (PrintWriter)closeable;
            boolean bl = false;
            this.exportAllElements(this.qualifiedDocuments, pw);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return path;
    }

    private final AutoMiningResult doAutoMining(NodeClusterRunner clusterer) {
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("cluster");
        }
        clusterer.cluster();
        if (this.taskLogger.isTraceEnabled()) {
            this.traceCorpus();
        }
        PageTableGroup pageTableGroup = this.tabulate(clusterer, this.getOptions());
        AutoMiningResult result = new AutoMiningResult(this.portalUrl, this.documentUrls, pageTableGroup);
        if (this.getOptions().getDiagnose()) {
            AutoMiningDiagnotor diagnotor = new AutoMiningDiagnotor(this, clusterer, result);
            this.logger.info("Start diagnosing ...");
            diagnotor.diagnose();
            this.logger.info("Diagnosing finished, reporting ...");
            diagnotor.report();
        }
        return result;
    }

    private final void exportAllElements(List<VisualDocument> documents, PrintWriter pw) {
        int counter = 0;
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument document = (VisualDocument)element$iv;
            boolean bl = false;
            NodesKt.forEachElement$default((Node)((Node)document.getDocument()), (boolean)false, (Function1)((Function1)new Function1<Element, Unit>(this, pw){
                final /* synthetic */ AnalysablePageCorpus this$0;
                final /* synthetic */ PrintWriter $pw;
                {
                    this.this$0 = $receiver;
                    this.$pw = $pw;
                    super(1);
                }

                public final void invoke(@NotNull Element ele) {
                    Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
                    int n = NodeExtKt.getLeft((Node)((Node)ele));
                    boolean bl = 0 <= n ? n < 501 : false;
                    if (bl) {
                        n = NodeExtKt.getWidth((Node)((Node)ele));
                        boolean bl2 = 200 <= n ? n < 1101 : false;
                        if (bl2) {
                            n = NodeExtKt.getTop((Node)((Node)ele));
                            boolean bl3 = 100 <= n ? n < 501 : false;
                            if (bl3 && NodeExtKt.getBottom((Node)((Node)ele)) > 200) {
                                Node node = (Node)ele;
                                RealVector realVector = ele.getExtension().getFeatures();
                                Intrinsics.checkNotNullExpressionValue((Object)realVector, (String)"getFeatures(...)");
                                AnalysablePageCorpus.exportNode$default(this.this$0, node, realVector, this.$pw, null, 8, null);
                                this.$pw.println();
                            }
                        }
                    }
                }
            }), (int)1, null);
            if (++counter % 100 != 0) continue;
            this.logger.info("Encoded {} documents", (Object)counter);
        }
    }

    private final void exportNode(Node node, RealVector features, PrintWriter pw, String separator) {
        pw.print(this.encodeLabel(node));
        int n = features.getDimension();
        for (int j = 0; j < n; ++j) {
            pw.print(separator);
            pw.print(VectorsKt.get((RealVector)features, (int)j));
        }
    }

    static /* synthetic */ void exportNode$default(AnalysablePageCorpus analysablePageCorpus, Node node, RealVector realVector, PrintWriter printWriter, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = ",";
        }
        analysablePageCorpus.exportNode(node, realVector, printWriter, string);
    }

    private final int encodeLabel(Node node) {
        List labels = NodeExtKt.getMlLabels((Node)node);
        return labels.contains("Title") ? 1 : (labels.contains("Meta") ? 2 : (labels.contains("Content") ? 3 : 0));
    }

    /*
     * WARNING - void declaration
     */
    private final PageTableGroup tabulate(NodeClusterRunner clusterer, HarvestOptions options) {
        PageTableGroup pageTableGroup;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable destination$iv;
        void $this$mapIndexedNotNullTo$iv;
        Iterable $this$sortedByDescending$iv;
        Iterable iterable = clusterer.getTileClusterGroups$scent_auto_mining();
        boolean $i$f$sortedByDescending22 = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TileClusterGroup it = (TileClusterGroup)b;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getScore();
                it = (TileClusterGroup)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getScore()));
            }
        });
        Collection $i$f$sortedByDescending22 = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv = $this$mapIndexedNotNullTo$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            OpenMapTable it$iv;
            void group;
            OpenMapTable openMapTable;
            void element$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl = false;
            TileClusterGroup tileClusterGroup = (TileClusterGroup)element$iv;
            int i = index$iv;
            boolean bl2 = false;
            OpenMapTable it = openMapTable = new PageCorpusTabulator(this, (TileClusterGroup)group, 1 + i, options.getCellType()).tabulate();
            boolean bl3 = false;
            if ((it.isNotEmpty() ? openMapTable : null) == null) continue;
            it$iv = it$iv;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        List tables = (List)destination$iv;
        if (options.getShowCombinedTable()) {
            tables.add(0, AnalysablePageCorpus.combineTables$default(this, tables, null, 2, null));
        }
        destination$iv = tables;
        boolean $i$f$filter = false;
        $this$forEachIndexed$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OpenMapTable it = (OpenMapTable)element$iv$iv;
            boolean bl = false;
            if (!(it.getNumColumns() >= options.getMinimumColumnCount())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTables = (List)destination$iv$iv;
        PageTableGroup $this$tabulate_u24lambda_u2419 = pageTableGroup = new PageTableGroup(this.portalUrl, null, filteredTables, 2, null);
        boolean bl = false;
        $this$tabulate_u24lambda_u2419.setSorted(true);
        return pageTableGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final OpenMapTable combineTables(List<OpenMapTable> tables, String uniqueKeyColumn) {
        int i;
        Iterable list$iv$iv;
        OpenMapTable.Column it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = tables;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$flatMapTo = 0;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            OpenMapTable table = (OpenMapTable)element$iv$iv;
            boolean bl = false;
            OpenMapTable.Column[] $this$map$iv = table.getColumns();
            boolean $i$f$map = false;
            OpenMapTable.Column[] columnArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void item$iv$iv;
                void var21_46 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)table.getIdent(), (Object)it));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List combinedColumns = (List)destination$iv$iv;
        OpenMapTable combinedTable = new OpenMapTable(combinedColumns.size(), 0);
        PageTableKt.getData((OpenMapTable)combinedTable).setCombined(true);
        OpenMapTable.Column[] $this$forEachIndexed$iv = combinedTable.getColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (OpenMapTable.Column item$iv : $this$forEachIndexed$iv) {
            Integer it2;
            void c;
            String $i$f$mapTo;
            int n = index$iv++;
            list$iv$iv = item$iv;
            i = n;
            boolean bl = false;
            Pair $i$f$map = (Pair)combinedColumns.get(i);
            int tableId = ((Number)$i$f$map.component1()).intValue();
            OpenMapTable.Column prototype = (OpenMapTable.Column)$i$f$map.component2();
            String string = $i$f$mapTo = prototype.getName();
            void var19_39 = c;
            boolean bl3 = false;
            Object object = Boolean.valueOf(new Regex("T\\d+C\\d+").matches((CharSequence)((Object)it2))) != false ? $i$f$mapTo : null;
            if (object == null) {
                object = "T" + tableId + prototype.getName();
            }
            var19_39.setName((String)object);
            PageTableKt.setData((OpenMapTable.Column)c, (ColumnData)PageTableKt.getData((OpenMapTable.Column)prototype));
            c.getAttributes().putAll(prototype.getAttributes());
            it2 = tableId;
            c.getAttributes().put("tableId", it2);
            it2 = i;
            c.getAttributes().put("natualOrder", it2);
        }
        Map combinedRows = new LinkedHashMap();
        int cellIndexBase = 0;
        Iterable $this$forEachIndexed$iv2 = tables;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            int n;
            int columnCount;
            void table;
            block11: {
                if ((i = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                OpenMapTable bl = (OpenMapTable)item$iv;
                int i2 = i;
                boolean bl4 = false;
                columnCount = table.getNumColumns();
                OpenMapTable.Column[] $this$indexOfFirst$iv = table.getColumns();
                boolean $i$f$indexOfFirst = false;
                int bl3 = $this$indexOfFirst$iv.length;
                for (int index$iv3 = 0; index$iv3 < bl3; ++index$iv3) {
                    it = $this$indexOfFirst$iv[index$iv3];
                    boolean bl5 = false;
                    if (!StringsKt.equals((String)it.getName(), (String)uniqueKeyColumn, (boolean)true)) continue;
                    n = index$iv3;
                    break block11;
                }
                n = -1;
            }
            int keyIndex = n;
            Iterable $this$forEach$iv = table.getRows();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                String key;
                OpenMapTable.Row row = (OpenMapTable.Row)element$iv;
                boolean bl = false;
                if (row.getCells().length != columnCount) {
                    this.logger.warn("Row value count does not match column count | " + row.getCells().length + " <- " + columnCount);
                }
                if ((key = (object = row.get(keyIndex)) != null && (object = object.getValue()) != null ? object.toString() : null) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)combinedRows.computeIfAbsent(key, arg_0 -> AnalysablePageCorpus.combineTables$lambda$28$lambda$27$lambda$25((Function1)new Function1<String, FreeCell[]>((List<Pair<Integer, OpenMapTable.Column>>)combinedColumns){
                    final /* synthetic */ List<Pair<Integer, OpenMapTable.Column>> $combinedColumns;
                    {
                        this.$combinedColumns = $combinedColumns;
                        super(1);
                    }

                    @NotNull
                    public final FreeCell[] invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new FreeCell[this.$combinedColumns.size()];
                    }
                }, arg_0)), (String)"computeIfAbsent(...)");
                OpenMapTable.Cell[] $this$forEachIndexed$iv3 = row.getCells();
                boolean $i$f$forEachIndexed3 = false;
                int index$iv4 = 0;
                for (OpenMapTable.Cell item$iv2 : $this$forEachIndexed$iv3) {
                    void cell;
                    int n2 = index$iv4++;
                    OpenMapTable.Cell cell2 = item$iv2;
                    int j = n2;
                    boolean bl6 = false;
                    int newCellIndex = cellIndexBase + j;
                    void v5 = cell;
                    combinedRowValues[newCellIndex] = new FreeCell(newCellIndex, v5 != null ? v5.getValue() : null, (OpenMapTable.Cell)cell, row);
                }
            }
            cellIndexBase += table.getColumns().length;
        }
        Map $this$forEach$iv = combinedRows;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            FreeCell[] freeCells = (FreeCell[])entry.getValue();
            combinedTable.computeIfAbsent(key, (Function1)new Function1<OpenMapTable.Row, Unit>(freeCells){
                final /* synthetic */ FreeCell[] $freeCells;
                {
                    this.$freeCells = $freeCells;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull OpenMapTable.Row row) {
                    RowData data;
                    Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                    FreeCell freeCell = (FreeCell)ArraysKt.firstOrNull((Object[])this.$freeCells);
                    RowData rowData = freeCell != null && (freeCell = freeCell.getOriginalRow()) != null ? PageTableKt.getData((OpenMapTable.Row)freeCell) : (data = null);
                    if (data != null) {
                        PageTableKt.setData((OpenMapTable.Row)row, (RowData)data);
                    }
                    FreeCell[] $this$forEachIndexed$iv = this.$freeCells;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (FreeCell item$iv : $this$forEachIndexed$iv) {
                        void cell;
                        int n = index$iv++;
                        FreeCell freeCell2 = item$iv;
                        int j = n;
                        boolean bl = false;
                        void v3 = cell;
                        row.setValue(j, v3 != null ? v3.getValue() : null);
                        void v4 = cell;
                        if ((v4 != null ? v4.getOriginalCell() : null) == null) continue;
                        OpenMapTable.Cell cell2 = row.get(j);
                        Intrinsics.checkNotNull((Object)cell2);
                        cell2.getAttributes().putAll(cell.getOriginalCell().getAttributes());
                    }
                }
            });
        }
        return combinedTable;
    }

    static /* synthetic */ OpenMapTable combineTables$default(AnalysablePageCorpus analysablePageCorpus, List list, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Url";
        }
        return analysablePageCorpus.combineTables(list, string);
    }

    private final void traceCorpus() {
        if (this.taskLogger.isTraceEnabled()) {
            this.validateFeatures();
            this.annotateNodes();
            this.simplifyAnnotations();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VisualDocument> filterByUris(List<VisualDocument> docs) {
        void $this$filterTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable destination$iv$iv;
        Collection collection;
        void $this$mapTo$iv;
        Iterable iterable = docs;
        Collection destination$iv = (Collection)new Frequency(null, 1, null);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it.getLocation().length());
        }
        Frequency frequency = (Frequency)destination$iv;
        Integer length = (Integer)frequency.getMostEntry().getElement();
        Intrinsics.checkNotNull((Object)length);
        if (length < 20) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = docs;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                VisualDocument it = (VisualDocument)element$iv$iv;
                boolean bl = false;
                Integer n = length;
                if (!(n != null && it.getLocation().length() == n.intValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        DescriptiveStatistics ds = new DescriptiveStatistics();
        Iterable $this$map$iv = docs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator element$iv$iv = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv.next();
            VisualDocument bl = (VisualDocument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(Double.valueOf(it.getLocation().length()));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double it = ((Number)element$iv).doubleValue();
            boolean bl = false;
            ds.addValue(it);
        }
        int q1 = (int)ds.getPercentile(0.25);
        int q3 = (int)ds.getPercentile(0.75);
        Iterable $this$filter$iv = docs;
        boolean $i$f$filter = false;
        Iterable it = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            VisualDocument it2 = (VisualDocument)element$iv$iv2;
            boolean bl = false;
            int n = it2.getLocation().length();
            boolean bl3 = q1 <= n ? n <= q3 : false;
            if (!bl3) continue;
            destination$iv$iv3.add(element$iv$iv2);
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    private final void nominalFeaturesToIndex() {
        int n;
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.TAG, FF.NID, FF.NCS};
        FF[] nominalFeatures = fFArray;
        Function1 nominalExtractors2 = nominalFeaturesToIndex.nominalExtractors.1.INSTANCE;
        FF[] $this$map$iv = nominalFeatures;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[n];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.documentFrequency.computeIfAbsent(it.getAlias()).ordinalMap());
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n;
            boolean bl = false;
            NodesKt.forEach((Node)((Node)doc.getBody()), (boolean)true, (Function1)((Function1)new Function1<Node, Unit>(pid){
                final /* synthetic */ int $pid;
                {
                    this.$pid = $pid;
                    super(1);
                }

                public final void invoke(@NotNull Node it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setPid((Node)it, (int)(1 + this.$pid));
                }
            }));
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)nominalFeaturesToIndex.1.2.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, String[]>)nominalExtractors2, nominalFeatures, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, String[]> $nominalExtractors;
                final /* synthetic */ FF[] $nominalFeatures;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$nominalExtractors = $nominalExtractors;
                    this.$nominalFeatures = $nominalFeatures;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Object[] objectArray = (Object[])this.$nominalExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$nominalFeatures;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (void item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n = index$iv++;
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        if (!(!StringsKt.isBlank((CharSequence)((CharSequence)nominal)))) continue;
                        int key = fFArray[i].getKey();
                        Integer value = list.get(i).get(nominal);
                        if (value == null) continue;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + value));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void styleFeaturesToIndex() {
        int n;
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.FTSZ, FF.COLR, FF.BCOLR};
        FF[] styles = fFArray;
        Function1 styleExtractors2 = (Function1)new Function1<Element, List<? extends String>>(styles){
            final /* synthetic */ FF[] $styles;
            {
                this.$styles = $styles;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = NodeExtKt.getBestElement((Node)((Node)it)).attr("cs");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                Object object = string;
                FF[] fFArray = new Regex(";\\s*");
                int n = 0;
                object = fFArray.split((CharSequence)object, n);
                fFArray = this.$styles;
                Object it2 = object;
                boolean bl = false;
                Object object2 = it2.size() == fFArray.length ? object : null;
                if (object2 == null) {
                    object2 = CollectionsKt.emptyList();
                }
                return object2;
            }
        };
        FF[] $this$map$iv = styles;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[n];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.documentFrequency.computeIfAbsent(it.getAlias()).ordinalMap());
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n;
            boolean bl = false;
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)styleFeaturesToIndex.1.1.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, ? extends List<String>>)styleExtractors2, styles, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, List<String>> $styleExtractors;
                final /* synthetic */ FF[] $styles;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$styleExtractors = $styleExtractors;
                    this.$styles = $styles;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Iterable iterable = (Iterable)this.$styleExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$styles;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        int key = fFArray[i].getKey();
                        Integer ordinal = list.get(i).get(nominal);
                        if (ordinal == null) continue;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + ordinal));
                    }
                }
            }));
        }
    }

    private final void divideDistricts() {
    }

    private final void calculateDocumentFrequency() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            if (!(!doc.getTemporaryInternalIndexers$scent_auto_mining().getTermFrequency$scent_auto_mining().isEmpty())) {
                boolean bl2 = false;
                String string = "Doc.termFrequency is required to calculate document frequency";
                throw new IllegalArgumentException(string.toString());
            }
            doc.getTemporaryInternalIndexers$scent_auto_mining().getTermFrequency$scent_auto_mining().forEach((arg_0, arg_1) -> AnalysablePageCorpus.calculateDocumentFrequency$lambda$41$lambda$40((Function2)new Function2<String, Frequency<String>, Unit>(this){
                final /* synthetic */ AnalysablePageCorpus this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull String name, @NotNull Frequency<String> tf) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter(tf, (String)"tf");
                    Frequency df = AnalysablePageCorpus.access$getDocumentFrequency$p(this.this$0).computeIfAbsent(name);
                    Iterable $this$forEach$iv = tf.elementSet();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        df.add((Comparable)((Object)it));
                    }
                }
            }, arg_0, arg_1));
        }
    }

    private final void assembleRegionalTextNodeIndex() {
        for (VisualDocument doc : this.samples.values()) {
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveRegionalTileNodeIndexerTo(this.regionalTileNodeIndexer);
        }
    }

    private final void addLabeledDocuments() {
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
            return;
        }
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument sample = (VisualDocument)element$iv;
            boolean bl = false;
            boolean labeled2 = DomQueriesKt.any((Node)((Node)sample.getDocument()), (Function1)addLabeledDocuments.1.labeled.1.INSTANCE);
            if (!labeled2) continue;
            this.qualifiedDocuments.add(sample);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTextNodeDocFrequency() {
        Object destination$iv;
        Object it;
        Object regionalText;
        Map.Entry element$iv;
        if (this.regionalTileNodeIndexer.isEmpty()) {
            this.logger.warn("No regional text node in the indexer, we can not calculate the text node doc frequency");
            return;
        }
        if (!(this.regionalTileNodeIndexer.size() > this.qualifiedDocuments.size())) {
            boolean bl = false;
            String string = "RegionalTileNodeIndexer size " + this.regionalTileNodeIndexer.size() + ", document size: " + this.qualifiedDocuments.size();
            throw new IllegalArgumentException(string.toString());
        }
        double dfRate = 0.8;
        double minDf = Math.min(5.0, dfRate * (double)this.samples.size());
        NavigableMap navigableMap = this.regionalTileNodeIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Object $this$forEach$iv = navigableMap;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            regionalText = (RegionalTile)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable iterable = nodes2;
            Collection destination$iv2 = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                Node node = (Node)item$iv;
                Collection collection = destination$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                collection.add(NodeExtKt.getLocation((Node)((Node)NodeExtKt.getOwnerDocument((Node)it2))));
            }
            int df = ((HashSet)destination$iv2).size();
            ((RegionalTile)regionalText).setDf(df);
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Node)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)it, (double)df);
            }
            if (!((double)df >= minDf)) continue;
            this.dff.add((Comparable)Integer.valueOf(df));
        }
        if (this.dff.isEmpty()) {
            this.logger.warn("!!! No regional texts shared by " + this.samples.size() + " sample documents (df rate: " + dfRate + ") !!!");
            if (this.logger.isInfoEnabled()) {
                void $this$mapNotNullTo$iv;
                Collection collection = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $i$f$forEach3 = collection;
                destination$iv = new TreeSet(ComparisonsKt.reverseOrder());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach4 = false;
                regionalText = $this$forEach$iv$iv.iterator();
                while (regionalText.hasNext()) {
                    Integer it$iv;
                    void $this$mapTo$iv;
                    Object element$iv$iv;
                    Object element$iv3 = element$iv$iv = regionalText.next();
                    boolean bl = false;
                    Collection it3 = (Collection)element$iv3;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it3);
                    it = it3;
                    Collection destination$iv3 = new HashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        String string;
                        void it4;
                        Document document;
                        Node node = (Node)item$iv;
                        Collection collection2 = destination$iv3;
                        boolean bl5 = false;
                        Document document2 = document = it4.ownerDocument();
                        if (document2 != null) {
                            Intrinsics.checkNotNull((Object)document2);
                            string = NodeExtKt.getLocation((Node)((Node)document));
                        } else {
                            string = null;
                        }
                        collection2.add(string);
                    }
                    Integer n = ((HashSet)destination$iv3).size();
                    int it5 = ((Number)n).intValue();
                    boolean bl6 = false;
                    if ((it5 > 1 ? n : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl7 = false;
                    destination$iv.add(it$iv);
                }
                TreeSet dfs = (TreeSet)destination$iv;
                String s2 = CollectionsKt.joinToString$default((Iterable)dfs, null, null, null, (int)0, null, (Function1)calculateTextNodeDocFrequency.s.1.INSTANCE, (int)31, null);
                this.logger.info("Document frequency of regional texts: " + s2);
            }
            return;
        }
        $this$forEach$iv = this.qualifiedDocuments;
        $i$f$forEach3 = false;
        destination$iv = $this$forEach$iv.iterator();
        while (destination$iv.hasNext()) {
            element$iv = destination$iv.next();
            VisualDocument it6 = (VisualDocument)((Object)element$iv);
            boolean bl = false;
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setCorpusSize((Document)it6.getDocument(), (int)this.qualifiedDocuments.size());
            Node node = it6.getDocument().getExtension().getOwnerBody();
            if (node != null) {
                node.attr("a-corpus-time", this.startTime.toString());
            }
            Node node2 = it6.getDocument().getExtension().getOwnerBody();
            if (node2 == null) continue;
            node2.attr("a-corpus-size", String.valueOf(this.qualifiedDocuments.size()));
        }
        int documentSize = ((Number)((Object)this.dff.getMode())).intValue();
        Collection collection = this.regionalTileNodeIndexer.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv3 = collection;
        boolean $i$f$forEach5 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            Node it7 = (Node)element$iv4;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it7);
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)it7, (double)(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it7) / (double)documentSize));
        }
        this.reportDff(this.dff);
    }

    /*
     * WARNING - void declaration
     */
    private final void chooseQualifiedDocuments() {
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
        } else if (!((Collection)this.dff).isEmpty()) {
            void $this$mapNotNullTo$iv;
            Object v1;
            Iterable $this$firstOrNull$iv;
            block9: {
                int documentSize = ((Number)((Object)this.dff.getMode())).intValue();
                Collection collection = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Collection it = (Collection)element$iv;
                    boolean bl = false;
                    if (!(it.size() == documentSize)) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            Iterable iterable = v1;
            if (iterable != null) {
                void $this$mapNotNullTo$iv2;
                $this$firstOrNull$iv = iterable;
                Collection destination$iv = this.documentUrls;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach = false;
                Iterator bl = $this$forEach$iv$iv.iterator();
                while (bl.hasNext()) {
                    String string;
                    Document document;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = bl.next();
                    boolean bl2 = false;
                    Node it = (Node)element$iv;
                    boolean bl3 = false;
                    Document document2 = document = it.ownerDocument();
                    if (document2 != null) {
                        Intrinsics.checkNotNull((Object)document2);
                        string = NodeExtKt.getLocation((Node)((Node)document));
                    } else {
                        string = null;
                    }
                    if (string == null) continue;
                    String it$iv = string;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                Set cfr_ignored_0 = (Set)destination$iv;
            }
            iterable = this.samples.values();
            Collection destination$iv = this.qualifiedDocuments;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                VisualDocument it$iv;
                VisualDocument visualDocument;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl5 = false;
                VisualDocument it2 = visualDocument = it;
                boolean bl6 = false;
                if ((this.documentUrls.contains(NodeExtKt.getLocation((Node)((Node)it2.getDocument()))) ? visualDocument : null) == null) continue;
                it$iv = it$iv;
                boolean bl7 = false;
                destination$iv.add(it$iv);
            }
        }
        this.samples.clear();
    }

    private final void reportDff(Frequency<Integer> dff) {
        Object[] objectArray;
        Object object;
        double p;
        Multiset.Entry mostEntry = dff.getMostEntry();
        Integer mode = (Integer)mostEntry.getElement();
        int termCount = mostEntry.getCount();
        this.recoverableConfidence = p = dff.getModePercentage();
        Logger it = object = this.logger;
        boolean bl = false;
        Object object2 = it.isInfoEnabled() ? object : null;
        if (object2 != null) {
            objectArray = "Total %d documents share %d terms out of %d counted (%4.2f%%)";
            Object[] objectArray2 = new Object[]{mode, termCount, dff.getTotalFrequency(), (double)100 * p};
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            object2.info(string);
        }
        if (!((Collection)this.qualifiedDocuments).isEmpty()) {
            object = "Find %d/%d recoverable documents with confidence %4.2f%%";
            objectArray = new Object[]{this.qualifiedDocuments.size(), this.samples.size(), (double)100 * p};
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            this.logger.info(string);
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        } else {
            this.logger.warn("No recoverable documents after pre-processing !!");
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        }
    }

    private final void assembleLayoutLeftIndexer() {
        for (VisualDocument doc : this.qualifiedDocuments) {
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveLayoutLeftIndexerTo(this.layoutLeftIndexer);
        }
    }

    private final void assembleCaptionedElementIndexer() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            doc.buildCaptionedElementIndexer$scent_auto_mining();
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveCaptionedElementIndexerTo(this.captionedElementIndexer);
        }
    }

    private final void calculateCaptionDocFrequency() {
        NavigableMap navigableMap = this.captionedElementIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Integer captionHashCode = (Integer)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Element node = (Element)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)node);
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setCaptionDocFrequency((Node)((Node)node), (double)((double)nodes2.size() / (double)this.qualifiedDocuments.size()));
            }
        }
        this.captionedElementIndexer.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void findLayoutComponents() {
        if (this.qualifiedDocuments.isEmpty()) {
            return;
        }
        if (!(!this.layoutLeftIndexer.isEmpty())) {
            boolean $i$a$-require-AnalysablePageCorpus$findLayoutComponents$22 = false;
            String $i$a$-require-AnalysablePageCorpus$findLayoutComponents$22 = "LayoutLeftIndexer should not be empty.";
            throw new IllegalArgumentException($i$a$-require-AnalysablePageCorpus$findLayoutComponents$22.toString());
        }
        NavigableMap navigableMap = this.layoutLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Integer alignedLeft = (Integer)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable iterable = nodes2;
            Collection destination$iv = (Collection)new Frequency(null, 1, null);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Node node = (Node)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getRelativePath((Node)it));
            }
            Frequency relativePaths2 = (Frequency)destination$iv;
            Multiset.Entry mostEntry = relativePaths2.getMostEntry();
            String relativePath = (String)mostEntry.getElement();
            double recall = (double)mostEntry.getCount() / (double)this.qualifiedDocuments.size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node it = (Node)element$iv2;
                boolean bl3 = false;
                String memo = "lay(" + alignedLeft + ")";
                Pair<VisualComponent, Boolean> pair = it.ownerDocument();
                Object object = pair;
                if (object == null) continue;
                Intrinsics.checkNotNull((Object)object);
                object = VisualDocumentKt.getVisualDocument((Document)pair);
                if (object == null) {
                    continue;
                }
                Object visualDocument = object;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jsoup.nodes.Element");
                pair = ((VisualDocument)visualDocument).addComponentIfAbsent((Element)it, VisualComponentType.LAYOUT, memo);
                VisualComponent vc = (VisualComponent)((Object)pair.component1());
                boolean created = (Boolean)pair.component2();
                if (vc == null || !created) continue;
                Intrinsics.checkNotNull((Object)relativePath);
                vc.setUniquePath(relativePath);
                this.uniquePathComponents.put((Object)relativePath, (Object)vc);
            }
        }
        this.layoutLeftIndexer.clear();
    }

    private final void enhancePartition() {
    }

    /*
     * WARNING - void declaration
     */
    private final void supplementComponents() {
        void $this$associateTo$iv$iv;
        String it;
        Object item$iv$iv;
        Object object;
        Object $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.qualifiedDocuments;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv2 : $this$flatMapTo$iv) {
            VisualDocument it2 = (VisualDocument)element$iv2;
            boolean bl = false;
            Iterable $this$map$iv = it2.getComponents();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                item$iv$iv = object.next();
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((VisualComponent)((Object)it)).getRelativePath());
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet relativePaths2 = (HashSet)destination$iv;
        Iterable $this$associate$iv = this.qualifiedDocuments;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        element$iv2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void destination$iv2;
            void $this$mapTo$iv;
            $this$mapTo$iv$iv = destination$iv$iv;
            VisualDocument it3 = (VisualDocument)element$iv$iv;
            boolean bl = false;
            object = it3.getComponents();
            item$iv$iv = new HashSet();
            it = it3.getBaseURI();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it4;
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv);
                void var21_38 = destination$iv2;
                boolean bl3 = false;
                var21_38.add(it4.getRelativePath());
            }
            it3 = TuplesKt.to((Object)it, (Object)destination$iv2);
            $this$mapTo$iv$iv.put(it3.getFirst(), it3.getSecond());
        }
        Map existPaths = destination$iv$iv;
        this.logger.info("There are {} relative paths in {} qualified documents", (Object)relativePaths2.size(), (Object)this.qualifiedDocuments.size());
        Iterable $this$associateWith$iv = relativePaths2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void path;
            $this$mapTo$iv$iv = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.qualifiedDocuments), (Function1)((Function1)new Function1<VisualDocument, Boolean>((Map<String, ? extends HashSet<String>>)existPaths, (String)path){
                final /* synthetic */ Map<String, HashSet<String>> $existPaths;
                final /* synthetic */ String $path;
                {
                    this.$existPaths = $existPaths;
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VisualDocument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    HashSet<String> hashSet = this.$existPaths.get(it.getBaseURI());
                    return hashSet != null ? !hashSet.contains(this.$path) : false;
                }
            })), (Function1)((Function1)new Function1<VisualDocument, Element>((String)path){
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @Nullable
                public final Element invoke(@NotNull VisualDocument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return DomQueriesKt.selectFirstOrNull((Node)((Node)it.getDocument()), (String)this.$path);
                }
            })));
            map.put(t, list);
        }
        Map componentCandidateGroups2 = result$iv;
        this.logger.info("There are {} node groups across the corpus, grouped by relative path", (Object)componentCandidateGroups2.size());
        AtomicInteger addedComponentCount = new AtomicInteger();
        Map $this$forEach$iv = componentCandidateGroups2;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv3 : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv3;
            boolean bl = false;
            String relativePath = (String)entry.getKey();
            List elements2 = (List)entry.getValue();
            double recall = (double)elements2.size() / (double)this.qualifiedDocuments.size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = elements2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv2) {
                Element ele = (Element)element$iv4;
                boolean bl4 = false;
                String memo = "sup(" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)((Node)ele)) + ")/" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcTiles((Node)((Node)ele));
                Pair<VisualComponent, Boolean> pair = ele.ownerDocument();
                Object object2 = pair;
                if (object2 == null) continue;
                Intrinsics.checkNotNull((Object)object2);
                object2 = VisualDocumentKt.getVisualDocument((Document)pair);
                if (object2 == null) {
                    continue;
                }
                Object visualDocument = object2;
                pair = ((VisualDocument)visualDocument).addComponentIfAbsent(ele, VisualComponentType.SUPPLEMENT, memo);
                VisualComponent visualComponent = (VisualComponent)((Object)pair.component1());
                boolean created = (Boolean)pair.component2();
                if (visualComponent != null) {
                    addedComponentCount.incrementAndGet();
                    visualComponent.setUniquePath(relativePath);
                    this.uniquePathComponents.put((Object)relativePath, (Object)visualComponent);
                }
                if (created) continue;
            }
        }
        this.logger.info("Supplemented {} components", (Object)addedComponentCount);
    }

    private final void arrangeComponents() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            it.buildComponentTree();
            it.arrangeComponents();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportComponents() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.qualifiedDocuments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getComponents().size());
        }
        String counts = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
        this.logger.info("Recognized components in each document: " + counts);
        this.taskLogger.info("Recognized components in each document: " + counts);
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List samples = (List)destination$iv$iv2;
        ResultSet rs = VisualComponent.Companion.toResultSet(samples, this.getOptions());
        StringBuilder buffer = new StringBuilder("Show " + samples.size() + " sample components:\n");
        new ResultSetFormatter(rs, false, true, 0, buffer, 10, null).format();
        this.taskLogger.info(buffer.toString());
        if (!((Collection)this.naturalComponents).isEmpty()) {
            void $this$mapTo$iv;
            destination$iv$iv2 = this.naturalComponents;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                VisualComponent bl = (VisualComponent)((Object)item$iv);
                collection = destination$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            HashSet names2 = (HashSet)destination$iv;
            this.logger.info("Total {} natural components: {}", (Object)this.naturalComponents.size(), (Object)names2);
        } else {
            this.logger.info("No natural components");
        }
    }

    private final void analysisVariables() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            this.analysisVariables(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analysisVariables(VisualDocument doc) {
        Iterable $this$forEach$iv = doc.getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            void $this$mapTo$iv$iv;
            VisualComponent component = (VisualComponent)((Object)element$iv);
            boolean bl = false;
            component.findVariables();
            if (!doc.getVerbose() || !this.taskLogger.isDebugEnabled()) continue;
            NavigableMap navigableMap = component.getVariables().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
            Map $this$map$iv = navigableMap;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Node keyNode = (Node)entry.getKey();
                Collection valueNodes = (Collection)entry.getValue();
                String string2 = NodeExtKt.getCleanText((Node)keyNode);
                Intrinsics.checkNotNull((Object)valueNodes);
                collection.add("<" + string2 + " : " + CollectionsKt.joinToString$default((Iterable)valueNodes, null, null, null, (int)0, null, (Function1)analysisVariables.2.1.1.INSTANCE, (int)31, null) + ">");
            }
            String it = string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            boolean bl3 = false;
            String string3 = !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string3 == null) continue;
            it = string3;
            boolean bl4 = false;
            this.taskLogger.debug(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void annotateNodes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.annotateNodes(doc.getFeaturedDocument(), this.getOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void simplifyAnnotations() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.simplifyAnnotations(it.getFeaturedDocument(), this.getOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFeatures() {
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.qualifiedDocuments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VisualDocument it = (VisualDocument)element$iv$iv;
                boolean bl = false;
                if (!it.getVerbose()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl = false;
                it.validateFeatures();
            }
        }
        catch (Exception e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
    }

    private static final void reportCorpusFeatures$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final FreeCell[] combineTables$lambda$28$lambda$27$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FreeCell[])$tmp0.invoke(p0);
    }

    private static final void calculateDocumentFrequency$lambda$41$lambda$40(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ FrequencyManager access$getDocumentFrequency$p(AnalysablePageCorpus $this) {
        return $this.documentFrequency;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "getEMPTY", "()Lai/platon/scent/analysis/corpus/AnalysablePageCorpus;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnalysablePageCorpus getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$FreeCell;", "", "order", "", "value", "originalCell", "Lai/platon/pulsar/common/OpenMapTable$Cell;", "originalRow", "Lai/platon/pulsar/common/OpenMapTable$Row;", "(ILjava/lang/Object;Lai/platon/pulsar/common/OpenMapTable$Cell;Lai/platon/pulsar/common/OpenMapTable$Row;)V", "getOrder", "()I", "getOriginalCell", "()Lai/platon/pulsar/common/OpenMapTable$Cell;", "getOriginalRow", "()Lai/platon/pulsar/common/OpenMapTable$Row;", "getValue", "()Ljava/lang/Object;", "scent-auto-mining"})
    private static final class FreeCell {
        private final int order;
        @Nullable
        private final Object value;
        @Nullable
        private final OpenMapTable.Cell originalCell;
        @Nullable
        private final OpenMapTable.Row originalRow;

        public FreeCell(int order2, @Nullable Object value, @Nullable OpenMapTable.Cell originalCell, @Nullable OpenMapTable.Row originalRow) {
            this.order = order2;
            this.value = value;
            this.originalCell = originalCell;
            this.originalRow = originalRow;
        }

        public /* synthetic */ FreeCell(int n, Object object, OpenMapTable.Cell cell, OpenMapTable.Row row, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                cell = null;
            }
            if ((n2 & 8) != 0) {
                row = null;
            }
            this(n, object, cell, row);
        }

        public final int getOrder() {
            return this.order;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        @Nullable
        public final OpenMapTable.Cell getOriginalCell() {
            return this.originalCell;
        }

        @Nullable
        public final OpenMapTable.Row getOriginalRow() {
            return this.originalRow;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/analysis/corpus/AnalysablePageCorpus$UnusedData;", "", "()V", "categorizedTextNodeIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/TextNode;", "Lai/platon/scent/dom/nodes/TextNodeIndexer;", "getCategorizedTextNodeIndexer", "()Lcom/google/common/collect/TreeMultimap;", "constantCaptionedElementIndexer", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "getConstantCaptionedElementIndexer", "orderedRegionalTextNodeIndexer", "Ljava/util/TreeMap;", "Lai/platon/scent/analysis/corpus/OrderedRegionalTileNode;", "getOrderedRegionalTextNodeIndexer", "()Ljava/util/TreeMap;", "pseudoConstantTextBlockIndexer", "getPseudoConstantTextBlockIndexer", "clear", "", "scent-auto-mining"})
    private static final class UnusedData {
        @NotNull
        private final TreeMap<TextNode, OrderedRegionalTileNode> orderedRegionalTextNodeIndexer = new TreeMap(NodesKt.getNodePositionComparator());
        @NotNull
        private final TreeMultimap<Integer, Element> constantCaptionedElementIndexer;
        @NotNull
        private final TreeMultimap<Integer, Element> pseudoConstantTextBlockIndexer;
        @NotNull
        private final TreeMultimap<String, TextNode> categorizedTextNodeIndexer;

        public UnusedData() {
            TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
            this.constantCaptionedElementIndexer = treeMultimap;
            TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
            this.pseudoConstantTextBlockIndexer = treeMultimap2;
            TreeMultimap treeMultimap3 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap3, (String)"create(...)");
            this.categorizedTextNodeIndexer = treeMultimap3;
        }

        @NotNull
        public final TreeMap<TextNode, OrderedRegionalTileNode> getOrderedRegionalTextNodeIndexer() {
            return this.orderedRegionalTextNodeIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getConstantCaptionedElementIndexer() {
            return this.constantCaptionedElementIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getPseudoConstantTextBlockIndexer() {
            return this.pseudoConstantTextBlockIndexer;
        }

        @NotNull
        public final TreeMultimap<String, TextNode> getCategorizedTextNodeIndexer() {
            return this.categorizedTextNodeIndexer;
        }

        public final void clear() {
            this.orderedRegionalTextNodeIndexer.clear();
            this.constantCaptionedElementIndexer.clear();
            this.pseudoConstantTextBlockIndexer.clear();
            this.categorizedTextNodeIndexer.clear();
        }
    }
}

