/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.analysis.corpus;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.FrequencyManager;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.sql.ResultSetFormatter;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.dom.select.DomQueriesKt;
import ai.platon.scent.analysis.corpus.FullFeaturedDocumentKt;
import ai.platon.scent.analysis.corpus.LimitedPageCorpus;
import ai.platon.scent.analysis.corpus.OrderedRegionalTileNode;
import ai.platon.scent.analysis.corpus.RegionalTile;
import ai.platon.scent.analysis.corpus.VisualComponent;
import ai.platon.scent.analysis.corpus.VisualComponentType;
import ai.platon.scent.analysis.corpus.VisualDocument;
import ai.platon.scent.analysis.corpus.VisualDocumentKt;
import ai.platon.scent.common.Systems;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.features.defined.FF;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\n\b\u0000\u0018\u0000 b2\u00020\u0001:\u0002bcB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010E\u001a\u00020FH\u0002J\u0006\u0010G\u001a\u00020FJ\b\u0010H\u001a\u00020FH\u0002J\u0010\u0010H\u001a\u00020F2\u0006\u0010I\u001a\u00020\u0007H\u0002J\b\u0010J\u001a\u00020FH\u0002J\b\u0010K\u001a\u00020FH\u0002J\b\u0010L\u001a\u00020FH\u0002J\b\u0010M\u001a\u00020FH\u0002J\b\u0010N\u001a\u00020FH\u0002J\u0006\u0010O\u001a\u00020FJ\b\u0010P\u001a\u00020FH\u0002J\b\u0010Q\u001a\u00020FH\u0002J\b\u0010R\u001a\u00020FH\u0002J\b\u0010S\u001a\u00020FH\u0002J\b\u0010T\u001a\u00020FH\u0002J\b\u0010U\u001a\u00020FH\u0016J\b\u0010V\u001a\u00020FH\u0002J\b\u0010W\u001a\u00020FH\u0002J\b\u0010X\u001a\u00020FH\u0002J\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00070ZJ\b\u0010[\u001a\u00020FH\u0002J\b\u0010\\\u001a\u00020FH\u0002J\u0016\u0010]\u001a\u00020F2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\b\u0010^\u001a\u00020FH\u0002J\b\u0010_\u001a\u00020FH\u0002J\b\u0010`\u001a\u00020FH\u0002J\b\u0010a\u001a\u00020FH\u0002R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 0\fj\u0002`!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013R\u001a\u0010.\u001a\u00020/X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00188\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b6\u00107R\u001e\u00108\u001a\u0012\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020 0\fj\u0002`9X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\n <*\u0004\u0018\u00010;0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lai/platon/scent/analysis/corpus/LimitedPageCorpus;", "Ljava/lang/AutoCloseable;", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "samples", "", "", "Lai/platon/scent/analysis/corpus/VisualDocument;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/dom/HNormUrl;Ljava/util/Map;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "captionedElementIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "componentElements", "", "getComponentElements$scent_auto_mining", "()Ljava/util/List;", "components", "Lai/platon/scent/analysis/corpus/VisualComponent;", "getComponents$scent_auto_mining", "dff", "Lai/platon/pulsar/common/Frequency;", "documentFrequency", "Lai/platon/pulsar/common/FrequencyManager;", "documentUrls", "", "getDocumentUrls$scent_auto_mining", "()Ljava/util/Set;", "layoutLeftIndexer", "Lorg/jsoup/nodes/Node;", "Lai/platon/scent/dom/nodes/IntNodeIndexer;", "logger", "Lorg/slf4j/Logger;", "naturalComponents", "getNaturalComponents$scent_auto_mining", "options", "Lai/platon/scent/dom/HarvestOptions;", "getOptions", "()Lai/platon/scent/dom/HarvestOptions;", "getPortalUrl", "()Lai/platon/scent/dom/HNormUrl;", "qualifiedDocuments", "getQualifiedDocuments$scent_auto_mining", "recoverableConfidence", "", "getRecoverableConfidence$scent_auto_mining", "()D", "setRecoverableConfidence$scent_auto_mining", "(D)V", "regionalTileFrequency", "Lai/platon/scent/analysis/corpus/RegionalTile;", "getRegionalTileFrequency$annotations", "()V", "regionalTileNodeIndexer", "Lai/platon/scent/analysis/corpus/RegionalTileNodeIndexer;", "startTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "stopWatch", "Lorg/perf4j/slf4j/Slf4JStopWatch;", "taskLogger", "uniquePathComponents", "getUniquePathComponents$scent_auto_mining", "()Lcom/google/common/collect/TreeMultimap;", "unusedData", "Lai/platon/scent/analysis/corpus/LimitedPageCorpus$UnusedData;", "addLabeledDocuments", "", "analyse", "analysisVariables", "doc", "annotateNodes", "arrangeComponents", "assembleCaptionedElementIndexer", "assembleLayoutLeftIndexer", "assembleRegionalTextNodeIndex", "calculateCorpusFeatures", "calculateCorpusFeatures0", "calculateDocumentFrequency", "calculateMoreCorpusFeatures", "calculateTextNodeDocFrequency", "chooseQualifiedDocuments", "close", "divideDistricts", "findComponents", "findLayoutComponents", "findQualifiedDocuments", "", "nominalFeaturesToIndex", "reportComponents", "reportDff", "simplifyAnnotations", "styleFeaturesToIndex", "supplementComponents", "validateFeatures", "Companion", "UnusedData", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nLimitedPageCorpus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedPageCorpus.kt\nai/platon/scent/analysis/corpus/LimitedPageCorpus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,920:1\n1855#2,2:921\n1855#2,2:923\n1446#2,5:925\n1446#2,5:930\n1620#2,3:935\n1855#2,2:938\n1864#2,3:944\n1864#2,3:951\n1855#2,2:954\n1855#2,2:956\n1620#2,3:959\n1855#2,2:962\n1611#2:965\n1855#2:966\n1620#2,3:967\n1856#2:972\n1612#2:973\n1855#2,2:974\n1855#2,2:976\n288#2,2:978\n1611#2:980\n1855#2:981\n1856#2:983\n1612#2:984\n1611#2:985\n1855#2:986\n1856#2:988\n1612#2:989\n1855#2,2:990\n1620#2,3:993\n1855#2,2:996\n1446#2,2:999\n1549#2:1001\n1620#2,3:1002\n1448#2,3:1005\n1179#2,2:1008\n1253#2,2:1010\n1620#2,3:1012\n1256#2:1015\n1271#2,2:1016\n1285#2,4:1018\n1855#2,2:1023\n1855#2,2:1026\n1549#2:1028\n1620#2,3:1029\n766#2:1032\n857#2,2:1033\n1360#2:1035\n1446#2,5:1036\n1620#2,3:1041\n1855#2,2:1044\n1855#2:1046\n1856#2:1051\n766#2:1052\n857#2,2:1053\n1855#2,2:1055\n766#2:1057\n857#2,2:1058\n1855#2,2:1060\n766#2:1062\n857#2,2:1063\n1855#2,2:1065\n11065#3:940\n11400#3,3:941\n11065#3:947\n11400#3,3:948\n215#4:958\n216#4:964\n215#4:992\n216#4:998\n215#4:1022\n216#4:1025\n125#4:1047\n152#4,3:1048\n1#5:970\n1#5:971\n1#5:982\n1#5:987\n*S KotlinDebug\n*F\n+ 1 LimitedPageCorpus.kt\nai/platon/scent/analysis/corpus/LimitedPageCorpus\n*L\n309#1:921,2\n379#1:923,2\n402#1:925,5\n404#1:930,5\n406#1:935,3\n410#1:938,2\n446#1:944,3\n486#1:951,3\n538#1:954,2\n568#1:956,2\n604#1:959,3\n608#1:962,2\n620#1:965\n620#1:966\n621#1:967,3\n620#1:972\n620#1:973\n630#1:974,2\n639#1:976,2\n653#1:978,2\n654#1:980\n654#1:981\n654#1:983\n654#1:984\n655#1:985\n655#1:986\n655#1:988\n655#1:989\n701#1:990,2\n723#1:993,3\n728#1:996,2\n749#1:999,2\n750#1:1001\n750#1:1002,3\n749#1:1005,3\n753#1:1008,2\n753#1:1010,2\n753#1:1012,3\n753#1:1015\n765#1:1016,2\n765#1:1018,4\n800#1:1023,2\n826#1:1026,2\n833#1:1028\n833#1:1029,3\n837#1:1032\n837#1:1033,2\n837#1:1035\n837#1:1036,5\n844#1:1041,3\n852#1:1044,2\n856#1:1046\n856#1:1051\n868#1:1052\n868#1:1053,2\n868#1:1055,2\n874#1:1057\n874#1:1058,2\n874#1:1060,2\n910#1:1062\n910#1:1063,2\n910#1:1065,2\n442#1:940\n442#1:941,3\n481#1:947\n481#1:948,3\n602#1:958\n602#1:964\n722#1:992\n722#1:998\n796#1:1022\n796#1:1025\n860#1:1047\n860#1:1048,3\n620#1:971\n654#1:982\n655#1:987\n*E\n"})
public final class LimitedPageCorpus
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HNormUrl portalUrl;
    @NotNull
    private final Map<String, VisualDocument> samples;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger taskLogger;
    private final Instant startTime;
    @Nullable
    private final Slf4JStopWatch stopWatch;
    @NotNull
    private final Set<String> documentUrls;
    @NotNull
    private final List<VisualDocument> qualifiedDocuments;
    @NotNull
    private final FrequencyManager<String> documentFrequency;
    @NotNull
    private final Frequency<Integer> dff;
    @NotNull
    private final TreeMultimap<RegionalTile, Node> regionalTileNodeIndexer;
    @NotNull
    private final Frequency<RegionalTile> regionalTileFrequency;
    @NotNull
    private final TreeMultimap<Integer, Element> captionedElementIndexer;
    @NotNull
    private final UnusedData unusedData;
    private double recoverableConfidence;
    @NotNull
    private final TreeMultimap<Integer, Node> layoutLeftIndexer;
    @NotNull
    private final List<VisualComponent> components;
    @NotNull
    private final TreeMultimap<String, VisualComponent> uniquePathComponents;
    @NotNull
    private final List<VisualComponent> naturalComponents;
    @NotNull
    private final List<Element> componentElements;
    @NotNull
    private static final LimitedPageCorpus EMPTY = new LimitedPageCorpus(HNormUrl.Companion.getNIL(), new LinkedHashMap(), ImmutableConfig.Companion.getEMPTY());

    public LimitedPageCorpus(@NotNull HNormUrl portalUrl, @NotNull Map<String, VisualDocument> samples, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.portalUrl = portalUrl;
        this.samples = samples;
        this.conf = conf;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(LimitedPageCorpus.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(LimitedPageCorpus.class), (String)".Task");
        this.startTime = Instant.now();
        this.stopWatch = new Slf4JStopWatch();
        this.documentUrls = new LinkedHashSet();
        this.qualifiedDocuments = new ArrayList();
        this.documentFrequency = new FrequencyManager();
        this.dff = new Frequency(null, 1, null);
        TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodePositionComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        this.regionalTileNodeIndexer = treeMultimap;
        this.regionalTileFrequency = new Frequency(null, 1, null);
        TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
        this.captionedElementIndexer = treeMultimap2;
        this.unusedData = new UnusedData();
        TreeMultimap treeMultimap3 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Node it = (Node)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NodeExtKt.getTop((Node)it));
                it = (Node)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(NodeExtKt.getTop((Node)it)));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap3, (String)"create(...)");
        this.layoutLeftIndexer = treeMultimap3;
        this.components = new ArrayList();
        TreeMultimap treeMultimap4 = TreeMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap4, (String)"create(...)");
        this.uniquePathComponents = treeMultimap4;
        this.naturalComponents = new ArrayList();
        this.componentElements = new ArrayList();
    }

    @NotNull
    public final HNormUrl getPortalUrl() {
        return this.portalUrl;
    }

    private final HarvestOptions getOptions() {
        return this.portalUrl.getHOptions();
    }

    @NotNull
    public final Set<String> getDocumentUrls$scent_auto_mining() {
        return this.documentUrls;
    }

    @NotNull
    public final List<VisualDocument> getQualifiedDocuments$scent_auto_mining() {
        return this.qualifiedDocuments;
    }

    @Deprecated(message="Used to calculate node.district, but not used currently")
    private static /* synthetic */ void getRegionalTileFrequency$annotations() {
    }

    public final double getRecoverableConfidence$scent_auto_mining() {
        return this.recoverableConfidence;
    }

    public final void setRecoverableConfidence$scent_auto_mining(double d) {
        this.recoverableConfidence = d;
    }

    @NotNull
    public final List<VisualComponent> getComponents$scent_auto_mining() {
        return this.components;
    }

    @NotNull
    public final TreeMultimap<String, VisualComponent> getUniquePathComponents$scent_auto_mining() {
        return this.uniquePathComponents;
    }

    @NotNull
    public final List<VisualComponent> getNaturalComponents$scent_auto_mining() {
        return this.naturalComponents;
    }

    @NotNull
    public final List<Element> getComponentElements$scent_auto_mining() {
        return this.componentElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void calculateCorpusFeatures() {
        block8: {
            if (!((Collection)this.qualifiedDocuments).isEmpty()) {
                return;
            }
            if (this.samples.size() < 5) {
                this.logger.warn("Too few samples: " + this.samples.size());
                return;
            }
            this.logger.info("Corpus feature calculation start - {}", (Object)Systems.INSTANCE.getHeapMessage());
            try {
                this.calculateCorpusFeatures0();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace(System.err);
                return;
            }
            finally {
                this.logger.info("Corpus feature calculation finished - {}", (Object)Systems.INSTANCE.getHeapMessage());
            }
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch == null) break block8;
            slf4JStopWatch.lap("detectRecoverableDocuments");
        }
    }

    @NotNull
    public final List<VisualDocument> findQualifiedDocuments() {
        if (this.qualifiedDocuments.isEmpty()) {
            this.chooseQualifiedDocuments();
        }
        return this.qualifiedDocuments;
    }

    public final void analyse() {
        this.logger.info("Analysis start - {}", (Object)Systems.INSTANCE.getHeapMessage());
        this.calculateMoreCorpusFeatures();
        boolean encodeOnly = LangKt.alwaysFalse();
        if (!encodeOnly) {
            this.findComponents();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("partition");
            }
        }
        if (this.taskLogger.isInfoEnabled()) {
            this.reportComponents();
        }
    }

    private final void calculateCorpusFeatures0() {
        block3: {
            if (this.samples.isEmpty()) {
                this.logger.warn("No sample in the corpus");
                return;
            }
            this.calculateDocumentFrequency();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("buildDocumentFrequency");
            }
            this.assembleRegionalTextNodeIndex();
            Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
            if (slf4JStopWatch2 != null) {
                slf4JStopWatch2.lap("buildRegionalTextNodeIndex");
            }
            this.calculateTextNodeDocFrequency();
            Slf4JStopWatch slf4JStopWatch3 = this.stopWatch;
            if (slf4JStopWatch3 == null) break block3;
            slf4JStopWatch3.lap("calculateTextNodeDocFrequency");
        }
    }

    private final void calculateMoreCorpusFeatures() {
        block4: {
            if (this.qualifiedDocuments.isEmpty()) {
                return;
            }
            if (this.getOptions().getDiagnose() && this.getOptions().getNVerbose() > 0) {
                Iterable $this$forEach$iv = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)((Iterable)new IntRange(0, this.qualifiedDocuments.size() - 1))), (int)this.getOptions().getNVerbose());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.qualifiedDocuments.get(it).setVerbose(true);
                }
            }
            this.assembleLayoutLeftIndexer();
            this.assembleCaptionedElementIndexer();
            this.styleFeaturesToIndex();
            Slf4JStopWatch slf4JStopWatch = this.stopWatch;
            if (slf4JStopWatch != null) {
                slf4JStopWatch.lap("styleFeaturesToIndex");
            }
            this.nominalFeaturesToIndex();
            Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
            if (slf4JStopWatch2 == null) break block4;
            slf4JStopWatch2.lap("nominalFeaturesToIndex");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findComponents() {
        void $this$mapTo$iv;
        Iterable $this$flatMapTo$iv;
        if (this.qualifiedDocuments.isEmpty()) {
            this.logger.warn("No qualified documents, do not find any component");
            return;
        }
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            it.findComponents();
        }
        Slf4JStopWatch slf4JStopWatch = this.stopWatch;
        if (slf4JStopWatch != null) {
            slf4JStopWatch.lap("findComponents");
        }
        this.findLayoutComponents();
        Slf4JStopWatch slf4JStopWatch2 = this.stopWatch;
        if (slf4JStopWatch2 != null) {
            slf4JStopWatch2.lap("findLayoutComponents");
        }
        this.arrangeComponents();
        Slf4JStopWatch slf4JStopWatch3 = this.stopWatch;
        if (slf4JStopWatch3 != null) {
            slf4JStopWatch3.lap("arrangeComponents");
        }
        $this$forEach$iv = this.qualifiedDocuments;
        Collection destination$iv = this.components;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.qualifiedDocuments;
        destination$iv = this.naturalComponents;
        $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getNaturalComponents();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        $this$flatMapTo$iv = this.components;
        destination$iv = this.componentElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VisualComponent list$iv = (VisualComponent)((Object)item$iv);
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getElement());
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            VisualDocumentKt.setVisualDocument(it.getDocument(), null);
        }
        this.documentUrls.clear();
        this.unusedData.clear();
        this.qualifiedDocuments.clear();
        this.documentFrequency.clear();
        this.regionalTileNodeIndexer.clear();
        this.regionalTileFrequency.clear();
        if (!this.captionedElementIndexer.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.layoutLeftIndexer.isEmpty()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.components.clear();
        this.uniquePathComponents.clear();
        this.naturalComponents.clear();
        this.componentElements.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void nominalFeaturesToIndex() {
        int n;
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.TAG, FF.NID, FF.NCS};
        FF[] nominalFeatures = fFArray;
        Function1 nominalExtractors2 = nominalFeaturesToIndex.nominalExtractors.1.INSTANCE;
        FF[] $this$map$iv = nominalFeatures;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[n];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.documentFrequency.computeIfAbsent(it.getAlias()).ordinalMap());
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n;
            boolean bl = false;
            NodesKt.forEach((Node)((Node)doc.getBody()), (boolean)true, (Function1)((Function1)new Function1<Node, Unit>(pid){
                final /* synthetic */ int $pid;
                {
                    this.$pid = $pid;
                    super(1);
                }

                public final void invoke(@NotNull Node it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setPid((Node)it, (int)(1 + this.$pid));
                }
            }));
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)nominalFeaturesToIndex.1.2.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, String[]>)nominalExtractors2, nominalFeatures, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, String[]> $nominalExtractors;
                final /* synthetic */ FF[] $nominalFeatures;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$nominalExtractors = $nominalExtractors;
                    this.$nominalFeatures = $nominalFeatures;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Object[] objectArray = (Object[])this.$nominalExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$nominalFeatures;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (void item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n = index$iv++;
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        if (!(!StringsKt.isBlank((CharSequence)((CharSequence)nominal)))) continue;
                        int key = fFArray[i].getKey();
                        Integer value = list.get(i).get(nominal);
                        if (value == null) continue;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + value));
                    }
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void styleFeaturesToIndex() {
        int n;
        void $this$mapTo$iv$iv;
        FF[] fFArray = new FF[]{FF.FTSZ, FF.COLR, FF.BCOLR};
        FF[] styles = fFArray;
        Function1 styleExtractors2 = (Function1)new Function1<Element, List<? extends String>>(styles){
            final /* synthetic */ FF[] $styles;
            {
                this.$styles = $styles;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = NodeExtKt.getBestElement((Node)((Node)it)).attr("cs");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr(...)");
                Object object = string;
                FF[] fFArray = new Regex(";\\s*");
                int n = 0;
                object = fFArray.split((CharSequence)object, n);
                fFArray = this.$styles;
                Object it2 = object;
                boolean bl = false;
                Object object2 = it2.size() == fFArray.length ? object : null;
                if (object2 == null) {
                    object2 = CollectionsKt.emptyList();
                }
                return object2;
            }
        };
        FF[] $this$map$iv = styles;
        boolean $i$f$map = false;
        FF[] fFArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void it;
            void item$iv$iv;
            void var12_15 = item$iv$iv = $this$mapTo$iv$iv[n];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.documentFrequency.computeIfAbsent(it.getAlias()).ordinalMap());
        }
        List ordinalLists = (List)destination$iv$iv;
        Iterable $this$forEachIndexed$iv = this.qualifiedDocuments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void doc;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VisualDocument visualDocument = (VisualDocument)item$iv;
            int pid = n;
            boolean bl = false;
            NodesKt.forEachMatching((Node)((Node)doc.getBody()), (Function1)styleFeaturesToIndex.1.1.INSTANCE, (Function1)((Function1)new Function1<Node, Unit>((Function1<? super Element, ? extends List<String>>)styleExtractors2, styles, (List<? extends Map<String, Integer>>)ordinalLists){
                final /* synthetic */ Function1<Element, List<String>> $styleExtractors;
                final /* synthetic */ FF[] $styles;
                final /* synthetic */ List<Map<String, Integer>> $ordinalLists;
                {
                    this.$styleExtractors = $styleExtractors;
                    this.$styles = $styles;
                    this.$ordinalLists = $ordinalLists;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Node node) {
                    void $this$forEachIndexed$iv;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Iterable iterable = (Iterable)this.$styleExtractors.invoke((Object)NodeExtKt.getBestElement((Node)node));
                    FF[] fFArray = this.$styles;
                    List<Map<String, Integer>> list = this.$ordinalLists;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void nominal;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        int key = fFArray[i].getKey();
                        Integer ordinal = list.get(i).get(nominal);
                        if (ordinal == null) continue;
                        NodeExtKt.setFeature((Node)((Node)NodeExtKt.getBestElement((Node)node)), (int)key, (int)(1 + ordinal));
                    }
                }
            }));
        }
    }

    private final void divideDistricts() {
    }

    private final void calculateDocumentFrequency() {
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            if (!(!doc.getTemporaryInternalIndexers$scent_auto_mining().getTermFrequency$scent_auto_mining().isEmpty())) {
                boolean bl2 = false;
                String string = "Doc.termFrequency is required to calculate document frequency";
                throw new IllegalArgumentException(string.toString());
            }
            doc.getTemporaryInternalIndexers$scent_auto_mining().getTermFrequency$scent_auto_mining().forEach((arg_0, arg_1) -> LimitedPageCorpus.calculateDocumentFrequency$lambda$13$lambda$12((Function2)new Function2<String, Frequency<String>, Unit>(this){
                final /* synthetic */ LimitedPageCorpus this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull String name, @NotNull Frequency<String> tf) {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter(tf, (String)"tf");
                    Frequency df = LimitedPageCorpus.access$getDocumentFrequency$p(this.this$0).computeIfAbsent(name);
                    Iterable $this$forEach$iv = tf.elementSet();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        df.add((Comparable)((Object)it));
                    }
                }
            }, arg_0, arg_1));
        }
    }

    private final void assembleRegionalTextNodeIndex() {
        for (VisualDocument doc : this.samples.values()) {
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveRegionalTileNodeIndexerTo(this.regionalTileNodeIndexer);
        }
    }

    private final void addLabeledDocuments() {
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
            return;
        }
        Iterable $this$forEach$iv = this.samples.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument sample = (VisualDocument)element$iv;
            boolean bl = false;
            boolean labeled2 = DomQueriesKt.any((Node)((Node)sample.getDocument()), (Function1)addLabeledDocuments.1.labeled.1.INSTANCE);
            if (!labeled2) continue;
            this.qualifiedDocuments.add(sample);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTextNodeDocFrequency() {
        Object destination$iv;
        Object it;
        Object regionalText;
        Map.Entry element$iv;
        if (this.regionalTileNodeIndexer.isEmpty()) {
            this.logger.warn("No regional text node in the indexer, we can not calculate the text node doc frequency");
            return;
        }
        if (!(this.regionalTileNodeIndexer.size() > this.qualifiedDocuments.size())) {
            boolean bl = false;
            String string = "RegionalTileNodeIndexer size " + this.regionalTileNodeIndexer.size() + ", document size: " + this.qualifiedDocuments.size();
            throw new IllegalArgumentException(string.toString());
        }
        double dfRate = 0.8;
        double minDf = Math.min(5.0, dfRate * (double)this.samples.size());
        NavigableMap navigableMap = this.regionalTileNodeIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Object $this$forEach$iv = navigableMap;
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            regionalText = (RegionalTile)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable iterable = nodes2;
            Collection destination$iv2 = new HashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it2;
                Node node = (Node)item$iv;
                Collection collection = destination$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it2);
                collection.add(NodeExtKt.getLocation((Node)((Node)NodeExtKt.getOwnerDocument((Node)it2))));
            }
            int df = ((HashSet)destination$iv2).size();
            ((RegionalTile)regionalText).setDf(df);
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (Node)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)it, (double)df);
            }
            if (!((double)df >= minDf)) continue;
            this.dff.add((Comparable)Integer.valueOf(df));
        }
        if (this.dff.isEmpty()) {
            this.logger.warn("!!! No regional texts shared by " + this.samples.size() + " sample documents (df rate: " + dfRate + ") !!!");
            if (this.logger.isInfoEnabled()) {
                void $this$mapNotNullTo$iv;
                Collection collection = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $i$f$forEach3 = collection;
                destination$iv = new TreeSet(ComparisonsKt.reverseOrder());
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach4 = false;
                regionalText = $this$forEach$iv$iv.iterator();
                while (regionalText.hasNext()) {
                    Integer it$iv;
                    void $this$mapTo$iv;
                    Object element$iv$iv;
                    Object element$iv3 = element$iv$iv = regionalText.next();
                    boolean bl = false;
                    Collection it3 = (Collection)element$iv3;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it3);
                    it = it3;
                    Collection destination$iv3 = new HashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        String string;
                        void it4;
                        Document document;
                        Node node = (Node)item$iv;
                        Collection collection2 = destination$iv3;
                        boolean bl5 = false;
                        Document document2 = document = it4.ownerDocument();
                        if (document2 != null) {
                            Intrinsics.checkNotNull((Object)document2);
                            string = NodeExtKt.getLocation((Node)((Node)document));
                        } else {
                            string = null;
                        }
                        collection2.add(string);
                    }
                    Integer n = ((HashSet)destination$iv3).size();
                    int it5 = ((Number)n).intValue();
                    boolean bl6 = false;
                    if ((it5 > 1 ? n : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl7 = false;
                    destination$iv.add(it$iv);
                }
                TreeSet dfs = (TreeSet)destination$iv;
                String s2 = CollectionsKt.joinToString$default((Iterable)dfs, null, null, null, (int)0, null, (Function1)calculateTextNodeDocFrequency.s.1.INSTANCE, (int)31, null);
                this.logger.info("Document frequency of regional texts: " + s2);
            }
            return;
        }
        $this$forEach$iv = this.qualifiedDocuments;
        $i$f$forEach3 = false;
        destination$iv = $this$forEach$iv.iterator();
        while (destination$iv.hasNext()) {
            element$iv = destination$iv.next();
            VisualDocument it6 = (VisualDocument)((Object)element$iv);
            boolean bl = false;
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setCorpusSize((Document)it6.getDocument(), (int)this.qualifiedDocuments.size());
            Node node = it6.getDocument().getExtension().getOwnerBody();
            if (node != null) {
                node.attr("a-corpus-time", this.startTime.toString());
            }
            Node node2 = it6.getDocument().getExtension().getOwnerBody();
            if (node2 == null) continue;
            node2.attr("a-corpus-size", String.valueOf(this.qualifiedDocuments.size()));
        }
        int documentSize = ((Number)((Object)this.dff.getMode())).intValue();
        Collection collection = this.regionalTileNodeIndexer.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        Iterable $this$forEach$iv3 = collection;
        boolean $i$f$forEach5 = false;
        for (Object element$iv4 : $this$forEach$iv3) {
            Node it7 = (Node)element$iv4;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it7);
            ai.platon.scent.dom.nodes.node.ext.NodeExtKt.setTextDocFrequency((Node)it7, (double)(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getTextDocFrequency((Node)it7) / (double)documentSize));
        }
        this.reportDff(this.dff);
    }

    /*
     * WARNING - void declaration
     */
    private final void chooseQualifiedDocuments() {
        if (this.getOptions().getTrustSamples()) {
            this.qualifiedDocuments.addAll(this.samples.values());
        } else if (!((Collection)this.dff).isEmpty()) {
            void $this$mapNotNullTo$iv;
            Object v1;
            Iterable $this$firstOrNull$iv;
            block9: {
                int documentSize = ((Number)((Object)this.dff.getMode())).intValue();
                Collection collection = this.regionalTileNodeIndexer.asMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Collection it = (Collection)element$iv;
                    boolean bl = false;
                    if (!(it.size() == documentSize)) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            Iterable iterable = v1;
            if (iterable != null) {
                void $this$mapNotNullTo$iv2;
                $this$firstOrNull$iv = iterable;
                Collection destination$iv = this.documentUrls;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach = false;
                Iterator bl = $this$forEach$iv$iv.iterator();
                while (bl.hasNext()) {
                    String string;
                    Document document;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = bl.next();
                    boolean bl2 = false;
                    Node it = (Node)element$iv;
                    boolean bl3 = false;
                    Document document2 = document = it.ownerDocument();
                    if (document2 != null) {
                        Intrinsics.checkNotNull((Object)document2);
                        string = NodeExtKt.getLocation((Node)((Node)document));
                    } else {
                        string = null;
                    }
                    if (string == null) continue;
                    String it$iv = string;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                Set cfr_ignored_0 = (Set)destination$iv;
            }
            iterable = this.samples.values();
            Collection destination$iv = this.qualifiedDocuments;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                VisualDocument it$iv;
                VisualDocument visualDocument;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl5 = false;
                VisualDocument it2 = visualDocument = it;
                boolean bl6 = false;
                if ((this.documentUrls.contains(NodeExtKt.getLocation((Node)((Node)it2.getDocument()))) ? visualDocument : null) == null) continue;
                it$iv = it$iv;
                boolean bl7 = false;
                destination$iv.add(it$iv);
            }
        }
        this.samples.clear();
    }

    private final void reportDff(Frequency<Integer> dff) {
        Object[] objectArray;
        Object object;
        double p;
        Multiset.Entry mostEntry = dff.getMostEntry();
        Integer mode = (Integer)mostEntry.getElement();
        int termCount = mostEntry.getCount();
        this.recoverableConfidence = p = dff.getModePercentage();
        Logger it = object = this.logger;
        boolean bl = false;
        Object object2 = it.isInfoEnabled() ? object : null;
        if (object2 != null) {
            objectArray = "Total %d documents share %d terms out of %d counted (%4.2f%%)";
            Object[] objectArray2 = new Object[]{mode, termCount, dff.getTotalFrequency(), (double)100 * p};
            String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            object2.info(string);
        }
        if (!((Collection)this.qualifiedDocuments).isEmpty()) {
            object = "Find %d/%d recoverable documents with confidence %4.2f%%";
            objectArray = new Object[]{this.qualifiedDocuments.size(), this.samples.size(), (double)100 * p};
            String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            this.logger.info(string);
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        } else {
            this.logger.warn("No recoverable documents after pre-processing !!");
            this.logger.info(Frequency.toReport$default(dff, (String)"Term frequency of df report, `dff = tf(df, <df>)`:\n", null, (int)2, null));
        }
    }

    private final void assembleLayoutLeftIndexer() {
        for (VisualDocument doc : this.qualifiedDocuments) {
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveLayoutLeftIndexerTo(this.layoutLeftIndexer);
        }
    }

    private final void assembleCaptionedElementIndexer() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            doc.buildCaptionedElementIndexer$scent_auto_mining();
            doc.getTemporaryInternalIndexers$scent_auto_mining().moveCaptionedElementIndexerTo(this.captionedElementIndexer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findLayoutComponents() {
        if (this.qualifiedDocuments.isEmpty()) {
            return;
        }
        if (!(!this.layoutLeftIndexer.isEmpty())) {
            boolean $i$a$-require-LimitedPageCorpus$findLayoutComponents$22 = false;
            String $i$a$-require-LimitedPageCorpus$findLayoutComponents$22 = "LayoutLeftIndexer should not be empty.";
            throw new IllegalArgumentException($i$a$-require-LimitedPageCorpus$findLayoutComponents$22.toString());
        }
        NavigableMap navigableMap = this.layoutLeftIndexer.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        Map $this$forEach$iv = navigableMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Integer alignedLeft = (Integer)entry.getKey();
            Collection nodes2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)nodes2);
            Iterable iterable = nodes2;
            Collection destination$iv = (Collection)new Frequency(null, 1, null);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                Node node = (Node)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getRelativePath((Node)it));
            }
            Frequency relativePaths2 = (Frequency)destination$iv;
            Multiset.Entry mostEntry = relativePaths2.getMostEntry();
            String relativePath = (String)mostEntry.getElement();
            double recall = (double)mostEntry.getCount() / (double)this.qualifiedDocuments.size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = nodes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Node it = (Node)element$iv2;
                boolean bl3 = false;
                String memo = "lay(" + alignedLeft + ")";
                Pair<VisualComponent, Boolean> pair = it.ownerDocument();
                Object object = pair;
                if (object == null) continue;
                Intrinsics.checkNotNull((Object)object);
                object = VisualDocumentKt.getVisualDocument((Document)pair);
                if (object == null) {
                    continue;
                }
                Object visualDocument = object;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jsoup.nodes.Element");
                pair = ((VisualDocument)visualDocument).addComponentIfAbsent((Element)it, VisualComponentType.LAYOUT, memo);
                VisualComponent vc = (VisualComponent)((Object)pair.component1());
                boolean created = (Boolean)pair.component2();
                if (vc == null || !created) continue;
                Intrinsics.checkNotNull((Object)relativePath);
                vc.setUniquePath(relativePath);
                this.uniquePathComponents.put((Object)relativePath, (Object)vc);
            }
        }
        this.layoutLeftIndexer.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void supplementComponents() {
        void $this$associateTo$iv$iv;
        String it;
        Object item$iv$iv;
        Object object;
        Object $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.qualifiedDocuments;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv2 : $this$flatMapTo$iv) {
            VisualDocument it2 = (VisualDocument)element$iv2;
            boolean bl = false;
            Iterable $this$map$iv = it2.getComponents();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                item$iv$iv = object.next();
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((VisualComponent)((Object)it)).getRelativePath());
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet relativePaths2 = (HashSet)destination$iv;
        Iterable $this$associate$iv = this.qualifiedDocuments;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        element$iv2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void destination$iv2;
            void $this$mapTo$iv;
            $this$mapTo$iv$iv = destination$iv$iv;
            VisualDocument it3 = (VisualDocument)element$iv$iv;
            boolean bl = false;
            object = it3.getComponents();
            item$iv$iv = new HashSet();
            it = it3.getBaseURI();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it4;
                VisualComponent visualComponent = (VisualComponent)((Object)item$iv);
                void var21_38 = destination$iv2;
                boolean bl3 = false;
                var21_38.add(it4.getRelativePath());
            }
            it3 = TuplesKt.to((Object)it, (Object)destination$iv2);
            $this$mapTo$iv$iv.put(it3.getFirst(), it3.getSecond());
        }
        Map existPaths = destination$iv$iv;
        this.logger.info("There are {} relative paths in {} qualified documents", (Object)relativePaths2.size(), (Object)this.qualifiedDocuments.size());
        Iterable $this$associateWith$iv = relativePaths2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void path;
            $this$mapTo$iv$iv = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.qualifiedDocuments), (Function1)((Function1)new Function1<VisualDocument, Boolean>((Map<String, ? extends HashSet<String>>)existPaths, (String)path){
                final /* synthetic */ Map<String, HashSet<String>> $existPaths;
                final /* synthetic */ String $path;
                {
                    this.$existPaths = $existPaths;
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull VisualDocument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    HashSet<String> hashSet = this.$existPaths.get(it.getBaseURI());
                    return hashSet != null ? !hashSet.contains(this.$path) : false;
                }
            })), (Function1)((Function1)new Function1<VisualDocument, Element>((String)path){
                final /* synthetic */ String $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @Nullable
                public final Element invoke(@NotNull VisualDocument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return DomQueriesKt.selectFirstOrNull((Node)((Node)it.getDocument()), (String)this.$path);
                }
            })));
            map.put(t, list);
        }
        Map componentCandidateGroups2 = result$iv;
        this.logger.info("There are {} node groups across the corpus, grouped by relative path", (Object)componentCandidateGroups2.size());
        AtomicInteger addedComponentCount = new AtomicInteger();
        Map $this$forEach$iv = componentCandidateGroups2;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv3 : $this$forEach$iv.entrySet()) {
            Map.Entry entry = element$iv3;
            boolean bl = false;
            String relativePath = (String)entry.getKey();
            List elements2 = (List)entry.getValue();
            double recall = (double)elements2.size() / (double)this.qualifiedDocuments.size();
            if (!(recall >= 0.8)) continue;
            Iterable $this$forEach$iv2 = elements2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv4 : $this$forEach$iv2) {
                Element ele = (Element)element$iv4;
                boolean bl4 = false;
                String memo = "sup(" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getAlignedLeft((Node)((Node)ele)) + ")/" + ai.platon.scent.dom.nodes.node.ext.NodeExtKt.getVcTiles((Node)((Node)ele));
                Pair<VisualComponent, Boolean> pair = ele.ownerDocument();
                Object object2 = pair;
                if (object2 == null) continue;
                Intrinsics.checkNotNull((Object)object2);
                object2 = VisualDocumentKt.getVisualDocument((Document)pair);
                if (object2 == null) {
                    continue;
                }
                Object visualDocument = object2;
                pair = ((VisualDocument)visualDocument).addComponentIfAbsent(ele, VisualComponentType.SUPPLEMENT, memo);
                VisualComponent visualComponent = (VisualComponent)((Object)pair.component1());
                boolean created = (Boolean)pair.component2();
                if (visualComponent != null) {
                    addedComponentCount.incrementAndGet();
                    visualComponent.setUniquePath(relativePath);
                    this.uniquePathComponents.put((Object)relativePath, (Object)visualComponent);
                }
                if (created) continue;
            }
        }
        this.logger.info("Supplemented {} components", (Object)addedComponentCount);
    }

    private final void arrangeComponents() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            it.buildComponentTree();
            it.arrangeComponents();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportComponents() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.qualifiedDocuments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VisualDocument visualDocument = (VisualDocument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getComponents().size());
        }
        String counts = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
        this.logger.info("Recognized components in each document: " + counts);
        this.taskLogger.info("Recognized components in each document: " + counts);
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List samples = (List)destination$iv$iv2;
        ResultSet rs = VisualComponent.Companion.toResultSet(samples, this.getOptions());
        StringBuilder buffer = new StringBuilder("Show " + samples.size() + " sample components:\n");
        new ResultSetFormatter(rs, false, true, 0, buffer, 10, null).format();
        this.taskLogger.info(buffer.toString());
        if (!((Collection)this.naturalComponents).isEmpty()) {
            void $this$mapTo$iv;
            destination$iv$iv2 = this.naturalComponents;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                VisualComponent bl = (VisualComponent)((Object)item$iv);
                collection = destination$iv;
                boolean bl2 = false;
                collection.add(it.getName());
            }
            HashSet names2 = (HashSet)destination$iv;
            this.logger.info("Total {} natural components: {}", (Object)this.naturalComponents.size(), (Object)names2);
        } else {
            this.logger.info("No natural components");
        }
    }

    private final void analysisVariables() {
        Iterable $this$forEach$iv = this.qualifiedDocuments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            this.analysisVariables(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analysisVariables(VisualDocument doc) {
        Iterable $this$forEach$iv = doc.getComponents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            void $this$mapTo$iv$iv;
            VisualComponent component = (VisualComponent)((Object)element$iv);
            boolean bl = false;
            component.findVariables();
            if (!doc.getVerbose() || !this.taskLogger.isDebugEnabled()) continue;
            NavigableMap navigableMap = component.getVariables().asMap();
            Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
            Map $this$map$iv = navigableMap;
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Node keyNode = (Node)entry.getKey();
                Collection valueNodes = (Collection)entry.getValue();
                String string2 = NodeExtKt.getCleanText((Node)keyNode);
                Intrinsics.checkNotNull((Object)valueNodes);
                collection.add("<" + string2 + " : " + CollectionsKt.joinToString$default((Iterable)valueNodes, null, null, null, (int)0, null, (Function1)analysisVariables.2.1.1.INSTANCE, (int)31, null) + ">");
            }
            String it = string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            boolean bl3 = false;
            String string3 = !StringsKt.isBlank((CharSequence)it) ? string : null;
            if (string3 == null) continue;
            it = string3;
            boolean bl4 = false;
            this.taskLogger.debug(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void annotateNodes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument doc = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.annotateNodes(doc.getFeaturedDocument(), this.getOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void simplifyAnnotations() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.qualifiedDocuments;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VisualDocument it = (VisualDocument)element$iv$iv;
            boolean bl = false;
            if (!it.getVerbose()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VisualDocument it = (VisualDocument)element$iv;
            boolean bl = false;
            FullFeaturedDocumentKt.simplifyAnnotations(it.getFeaturedDocument(), this.getOptions());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateFeatures() {
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.qualifiedDocuments;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VisualDocument it = (VisualDocument)element$iv$iv;
                boolean bl = false;
                if (!it.getVerbose()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VisualDocument it = (VisualDocument)element$iv;
                boolean bl = false;
                it.validateFeatures();
            }
        }
        catch (Exception e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
    }

    private static final void calculateDocumentFrequency$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ FrequencyManager access$getDocumentFrequency$p(LimitedPageCorpus $this) {
        return $this.documentFrequency;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/analysis/corpus/LimitedPageCorpus$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/analysis/corpus/LimitedPageCorpus;", "getEMPTY", "()Lai/platon/scent/analysis/corpus/LimitedPageCorpus;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LimitedPageCorpus getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/analysis/corpus/LimitedPageCorpus$UnusedData;", "", "()V", "categorizedTextNodeIndexer", "Lcom/google/common/collect/TreeMultimap;", "", "Lorg/jsoup/nodes/TextNode;", "Lai/platon/scent/dom/nodes/TextNodeIndexer;", "getCategorizedTextNodeIndexer", "()Lcom/google/common/collect/TreeMultimap;", "constantCaptionedElementIndexer", "", "Lorg/jsoup/nodes/Element;", "Lai/platon/scent/dom/nodes/IntElementIndexer;", "getConstantCaptionedElementIndexer", "orderedRegionalTextNodeIndexer", "Ljava/util/TreeMap;", "Lai/platon/scent/analysis/corpus/OrderedRegionalTileNode;", "getOrderedRegionalTextNodeIndexer", "()Ljava/util/TreeMap;", "pseudoConstantTextBlockIndexer", "getPseudoConstantTextBlockIndexer", "clear", "", "scent-auto-mining"})
    private static final class UnusedData {
        @NotNull
        private final TreeMap<TextNode, OrderedRegionalTileNode> orderedRegionalTextNodeIndexer = new TreeMap(NodesKt.getNodePositionComparator());
        @NotNull
        private final TreeMultimap<Integer, Element> constantCaptionedElementIndexer;
        @NotNull
        private final TreeMultimap<Integer, Element> pseudoConstantTextBlockIndexer;
        @NotNull
        private final TreeMultimap<String, TextNode> categorizedTextNodeIndexer;

        public UnusedData() {
            TreeMultimap treeMultimap = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
            this.constantCaptionedElementIndexer = treeMultimap;
            TreeMultimap treeMultimap2 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap2, (String)"create(...)");
            this.pseudoConstantTextBlockIndexer = treeMultimap2;
            TreeMultimap treeMultimap3 = TreeMultimap.create((Comparator)ComparisonsKt.naturalOrder(), (Comparator)NodesKt.getNodeComparator());
            Intrinsics.checkNotNullExpressionValue((Object)treeMultimap3, (String)"create(...)");
            this.categorizedTextNodeIndexer = treeMultimap3;
        }

        @NotNull
        public final TreeMap<TextNode, OrderedRegionalTileNode> getOrderedRegionalTextNodeIndexer() {
            return this.orderedRegionalTextNodeIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getConstantCaptionedElementIndexer() {
            return this.constantCaptionedElementIndexer;
        }

        @NotNull
        public final TreeMultimap<Integer, Element> getPseudoConstantTextBlockIndexer() {
            return this.pseudoConstantTextBlockIndexer;
        }

        @NotNull
        public final TreeMultimap<String, TextNode> getCategorizedTextNodeIndexer() {
            return this.categorizedTextNodeIndexer;
        }

        public final void clear() {
            this.orderedRegionalTextNodeIndexer.clear();
            this.constantCaptionedElementIndexer.clear();
            this.pseudoConstantTextBlockIndexer.clear();
            this.categorizedTextNodeIndexer.clear();
        }
    }
}

