/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.NodePointEncoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/ml/NGramNodeEncoderBase;", "Lai/platon/scent/ml/NodePointEncoder;", "options", "Lai/platon/scent/ml/EncodeOptions;", "dimension", "", "(Lai/platon/scent/ml/EncodeOptions;I)V", "encode", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "Lkotlin/collections/ArrayList;", "nodes", "", "Lorg/jsoup/nodes/Node;", "encodeNode", "", "node", "points", "", "encodeTextNode", "Lorg/jsoup/nodes/TextNode;", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nNodePointEncoders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/NGramNodeEncoderBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1864#2,3:361\n*S KotlinDebug\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/NGramNodeEncoderBase\n*L\n83#1:361,3\n*E\n"})
public class NGramNodeEncoderBase
extends NodePointEncoder {
    public NGramNodeEncoderBase(@NotNull EncodeOptions options, int dimension) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options, dimension);
    }

    public /* synthetic */ NGramNodeEncoderBase(EncodeOptions encodeOptions, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = FeatureRegistry.INSTANCE.getFeatureNames().size();
        }
        this(encodeOptions, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ArrayList<NodePoint> encode(@NotNull List<? extends Node> nodes2) {
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        if (nodes2.isEmpty()) {
            return new ArrayList<NodePoint>();
        }
        int nGram = this.getOptions().getNGram();
        ArrayList<NodePoint> points = new ArrayList<NodePoint>(nGram * nodes2.size());
        Iterable $this$forEachIndexed$iv = nodes2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void node;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Node node2 = (Node)item$iv;
            int i = n;
            boolean bl = false;
            if (node instanceof TextNode) {
                this.encodeTextNode((TextNode)node, (List<NodePoint>)points);
                continue;
            }
            this.encodeNode((Node)node, (List<NodePoint>)points);
        }
        return points;
    }

    private final void encodeNode(Node node, List<NodePoint> points) {
        ArrayRealVector curr = this.featuresOrEmpty(node);
        NodePoint point = new NodePoint(node, curr, true);
        points.add(point);
        this.addLabel(node);
        int nGram = this.getOptions().getNGram();
        Node parent = node.parent();
        if (nGram > 1) {
            ArrayRealVector par = this.featuresOrEmpty(parent);
            points.add(new NodePoint(node, par, true));
        }
        if (nGram > 2) {
            Node node2 = parent;
            Node prevNode = node2 != null ? node2.previousSibling() : null;
            ArrayRealVector prev = this.featuresOrEmpty(prevNode);
            points.add(new NodePoint(node, prev, true));
        }
        if (nGram > 3) {
            Node node3 = parent;
            Node nextNode = node3 != null ? node3.nextSibling() : null;
            ArrayRealVector next = this.featuresOrEmpty(nextNode);
            points.add(new NodePoint(node, next, true));
        }
    }

    private final void encodeTextNode(TextNode node, List<NodePoint> points) {
        this.encodeNode((Node)node, points);
    }
}

