/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.scent.ml.FeatureTransformer;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/ml/NGramTransformerV110;", "Lai/platon/scent/ml/FeatureTransformer;", "nGram", "", "schema", "Lai/platon/scent/ml/Schema;", "verbose", "", "(ILai/platon/scent/ml/Schema;Z)V", "getNGram", "()I", "transform", "Ljava/util/ArrayList;", "Lai/platon/scent/ml/NodePoint;", "xs", "", "transformSchema", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nNodePointEncoders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/NGramTransformerV110\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1855#2:361\n1856#2:363\n1#3:362\n*S KotlinDebug\n*F\n+ 1 NodePointEncoders.kt\nai/platon/scent/ml/NGramTransformerV110\n*L\n225#1:361\n225#1:363\n*E\n"})
public final class NGramTransformerV110
extends FeatureTransformer {
    private final int nGram;

    public NGramTransformerV110(int nGram, @NotNull Schema schema, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(schema, verbose);
        this.nGram = nGram;
    }

    public /* synthetic */ NGramTransformerV110(int n, Schema schema, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, schema, bl);
    }

    public final int getNGram() {
        return this.nGram;
    }

    @Override
    @NotNull
    public Schema transformSchema() {
        List outputColumns = new ArrayList();
        int j = 0;
        Iterable $this$forEach$iv = this.getSchema().getColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Schema.Column it = (Schema.Column)element$iv;
            boolean bl = false;
            int n = this.nGram;
            for (int p = 0; p < n; ++p) {
                Schema.Column column;
                int n2 = j;
                j = n2 + 1;
                Schema.Column it2 = column = new Schema.Column(n2, it.getName() + "-g" + p, 0, 4, null);
                boolean bl2 = false;
                outputColumns.add(it2);
            }
        }
        this.setOutputSchema(new Schema(outputColumns));
        return this.getOutputSchema();
    }

    @Override
    @NotNull
    public ArrayList<NodePoint> transform(@NotNull List<? extends NodePoint> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        int n = (int)((double)xs.size() / (double)this.nGram);
        if (!(n * this.nGram == xs.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.getOutputSchema().getDimension() == this.nGram * this.getSchema().getDimension())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ArrayList<NodePoint> ys = new ArrayList<NodePoint>(n);
        for (int k = 0; k < n; ++k) {
            double[] y = new double[this.getOutputSchema().getDimension()];
            Node node = xs.get(k * this.nGram).getNode();
            int n2 = this.nGram;
            for (int g = 0; g < n2; ++g) {
                int i = k * this.nGram + g;
                if (!(xs.get(i).getNode() == node)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                System.arraycopy(xs.get(i).getDataRef(), 0, y, g * this.getSchema().getDimension(), this.getSchema().getDimension());
            }
            ys.add(new NodePoint(node, y, false, 4, null));
        }
        return ys;
    }
}

