/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.data;

import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J*\u0010\u001f\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001dR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lai/platon/scent/ml/data/FrameNode;", "", "schema", "Lai/platon/scent/ml/Schema;", "options", "Lai/platon/scent/ml/EncodeOptions;", "points", "", "Lai/platon/scent/ml/NodePoint;", "(Lai/platon/scent/ml/Schema;Lai/platon/scent/ml/EncodeOptions;Ljava/util/List;)V", "<set-?>", "", "lastSize", "getLastSize", "()I", "getOptions", "()Lai/platon/scent/ml/EncodeOptions;", "getPoints", "()Ljava/util/List;", "getSchema", "()Lai/platon/scent/ml/Schema;", "clear", "", "encodeLabel", "", "node", "Lorg/jsoup/nodes/Node;", "exportHeader", "pr", "Lorg/apache/commons/csv/CSVPrinter;", "exportHeaderCSV", "exportNodeCSV", "point", "label", "features", "Lorg/apache/commons/math3/linear/RealVector;", "exportTo", "path", "Ljava/nio/file/Path;", "printer", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nDataFrames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/FrameNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1864#2,3:178\n1855#2,2:181\n*S KotlinDebug\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/FrameNode\n*L\n34#1:178,3\n68#1:181,2\n*E\n"})
public final class FrameNode {
    @NotNull
    private final Schema schema;
    @NotNull
    private final EncodeOptions options;
    @NotNull
    private final List<NodePoint> points;
    private int lastSize;

    public FrameNode(@NotNull Schema schema, @NotNull EncodeOptions options, @NotNull List<NodePoint> points) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.schema = schema;
        this.options = options;
        this.points = points;
        this.lastSize = this.points.size();
    }

    public /* synthetic */ FrameNode(Schema schema, EncodeOptions encodeOptions, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        this(schema, encodeOptions, list);
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final EncodeOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final List<NodePoint> getPoints() {
        return this.points;
    }

    public final int getLastSize() {
        return this.lastSize;
    }

    /*
     * WARNING - void declaration
     */
    public final void exportTo(@NotNull Path path, @NotNull CSVPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        if (!Files.exists(path, new LinkOption[0]) || 0L == Files.size(path)) {
            this.exportHeader(this.schema, printer);
        }
        Iterable $this$forEachIndexed$iv = this.points;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void point;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            NodePoint nodePoint = (NodePoint)((Object)item$iv);
            int i = n;
            boolean bl = false;
            this.exportNodeCSV((NodePoint)point, printer);
            printer.println();
        }
        printer.flush();
        this.clear();
    }

    public final void clear() {
        this.lastSize = this.points.size();
        this.points.clear();
    }

    private final void exportHeader(Schema schema, CSVPrinter pr) {
        this.exportHeaderCSV(schema, pr);
    }

    private final void exportNodeCSV(NodePoint point, CSVPrinter pr) {
        Node node = point.getNode();
        String label = this.encodeLabel(node);
        this.exportNodeCSV(label, (RealVector)point, point, pr);
    }

    private final String encodeLabel(Node node) {
        return (String)CollectionsKt.firstOrNull((List)NodeExtKt.getMlLabels((Node)node));
    }

    private final void exportHeaderCSV(Schema schema, CSVPrinter pr) {
        NodePoint nodePoint = (NodePoint)((Object)CollectionsKt.firstOrNull(this.points));
        if (nodePoint == null) {
            return;
        }
        nodePoint.getDimension();
        pr.print((Object)"label");
        Iterable $this$forEach$iv = schema.getColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Schema.Column it = (Schema.Column)element$iv;
            boolean bl = false;
            pr.print((Object)it);
        }
        pr.print((Object)"tag");
        pr.print((Object)"id");
        pr.print((Object)"class");
        pr.print((Object)"color");
        pr.print((Object)"bg-color");
        pr.print((Object)"font");
        pr.print((Object)"text");
        pr.print((Object)"url");
        pr.println();
    }

    private final void exportNodeCSV(String label, RealVector features, NodePoint point, CSVPrinter pr) {
        Node node = point.getNode();
        Element ele = NodeExtKt.getBestElement((Node)node);
        String text = StringsKt.take((String)NodeExtKt.getCleanText((Node)node), (int)this.options.getMaxTextLength());
        String url = NodeExtKt.getNormalizedURI((Document)NodeExtKt.getOwnerDocument((Node)node));
        pr.print((Object)label);
        int n = features.getDimension();
        for (int j = 0; j < n; ++j) {
            pr.print((Object)VectorsKt.get((RealVector)features, (int)j));
        }
        pr.print((Object)ele.tagName());
        pr.print((Object)ele.id());
        pr.print((Object)ele.className());
        pr.print((Object)"");
        pr.print((Object)"");
        pr.print((Object)"");
        pr.print((Object)text);
        pr.print((Object)url);
    }
}

