/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.data;

import ai.platon.scent.ml.EncodeOptions;
import ai.platon.scent.ml.NodePoint;
import ai.platon.scent.ml.Schema;
import ai.platon.scent.ml.data.FrameNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\rJ\u000e\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020$H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0006\u0010*\u001a\u00020$J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,R2\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013\u00a8\u0006/"}, d2={"Lai/platon/scent/ml/data/SimpleDataFrame;", "Ljava/lang/AutoCloseable;", "schema", "Lai/platon/scent/ml/Schema;", "options", "Lai/platon/scent/ml/EncodeOptions;", "points", "", "Lai/platon/scent/ml/NodePoint;", "(Lai/platon/scent/ml/Schema;Lai/platon/scent/ml/EncodeOptions;Ljava/util/List;)V", "(Lai/platon/scent/ml/Schema;Lai/platon/scent/ml/EncodeOptions;)V", "_nodes", "", "Lai/platon/scent/ml/data/FrameNode;", "kotlin.jvm.PlatformType", "csvFormat", "Lorg/apache/commons/csv/CSVFormat;", "head", "getHead", "()Lai/platon/scent/ml/data/FrameNode;", "nodes", "getNodes", "()Ljava/util/List;", "getOptions", "()Lai/platon/scent/ml/EncodeOptions;", "recordCount", "", "getRecordCount", "()I", "getSchema", "()Lai/platon/scent/ml/Schema;", "size", "getSize", "tail", "getTail", "addLast", "", "node", "frame", "close", "createWriterIfNecessary", "Lorg/apache/commons/csv/CSVPrinter;", "export", "isEmpty", "", "isNotEmpty", "Companion", "scent-auto-mining"})
@SourceDebugExtension(value={"SMAP\nDataFrames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/SimpleDataFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1855#3,2:179\n*S KotlinDebug\n*F\n+ 1 DataFrames.kt\nai/platon/scent/ml/data/SimpleDataFrame\n*L\n161#1:179,2\n*E\n"})
public class SimpleDataFrame
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Schema schema;
    @NotNull
    private final EncodeOptions options;
    private final CSVFormat csvFormat;
    private final List<FrameNode> _nodes;

    public SimpleDataFrame(@NotNull Schema schema, @NotNull EncodeOptions options) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.schema = schema;
        this.options = options;
        this.csvFormat = CSVFormat.EXCEL;
        this._nodes = Collections.synchronizedList(new ArrayList());
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final EncodeOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final List<FrameNode> getNodes() {
        List<FrameNode> list = this._nodes;
        Intrinsics.checkNotNullExpressionValue(list, (String)"_nodes");
        return list;
    }

    @NotNull
    public final FrameNode getHead() {
        return (FrameNode)CollectionsKt.first(this.getNodes());
    }

    @NotNull
    public final FrameNode getTail() {
        return (FrameNode)CollectionsKt.last(this.getNodes());
    }

    public final int getSize() {
        return this.getNodes().size();
    }

    /*
     * WARNING - void declaration
     */
    public final int getRecordCount() {
        Iterable iterable = this.getNodes();
        int n = 0;
        for (Object t : iterable) {
            void it;
            FrameNode frameNode = (FrameNode)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getLastSize();
            n = n2 + n3;
        }
        return n;
    }

    public SimpleDataFrame(@NotNull Schema schema, @NotNull EncodeOptions options, @NotNull List<? extends NodePoint> points) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this(schema, options);
        FrameNode node = new FrameNode(schema, options, CollectionsKt.toMutableList((Collection)points));
        this._nodes.add(node);
    }

    public final boolean isEmpty() {
        return this.getNodes().isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final void addLast(@NotNull FrameNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this._nodes.add(node);
    }

    public final void addLast(@NotNull SimpleDataFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        List<FrameNode> list = frame._nodes;
        Intrinsics.checkNotNullExpressionValue(list, (String)"_nodes");
        this._nodes.addAll((Collection<FrameNode>)list);
    }

    public final void export() {
        if (this.isEmpty()) {
            return;
        }
        Path path = this.options.getDatasetPath();
        if (path == null) {
            return;
        }
        Path path2 = path;
        CSVPrinter cSVPrinter = this.createWriterIfNecessary();
        if (cSVPrinter == null) {
            return;
        }
        CSVPrinter pr = cSVPrinter;
        List<FrameNode> list = this._nodes;
        Intrinsics.checkNotNullExpressionValue(list, (String)"_nodes");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FrameNode it = (FrameNode)element$iv;
            boolean bl = false;
            it.exportTo(path2, pr);
        }
        pr.flush();
        pr.close();
    }

    @Override
    public void close() {
    }

    private final CSVPrinter createWriterIfNecessary() {
        Path path = this.options.getDatasetPath();
        if (path == null) {
            return null;
        }
        Path path2 = path;
        Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        BufferedWriter writer = new BufferedWriter(new FileWriter(path2.toFile(), true));
        CSVPrinter printer = new CSVPrinter((Appendable)writer, this.csvFormat);
        return printer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/ml/data/SimpleDataFrame$Companion;", "", "()V", "emptyDataFrame", "Lai/platon/scent/ml/data/SimpleDataFrame;", "scent-auto-mining"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleDataFrame emptyDataFrame() {
            return new SimpleDataFrame(new Schema(null, 1, null), new EncodeOptions(null, false, null, 0, 0, 31, null), CollectionsKt.emptyList());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

