/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.common;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.pulsar.common.collect.UrlCache;
import ai.platon.pulsar.common.collect.UrlPool;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.GlobalCacheFactory;
import ai.platon.scent.ScentSession;
import ai.platon.scent.boot.autoconfigure.common.ScrapeMetrics;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.executors.AsyncApiSinkCommitter;
import java.time.Duration;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 =2\u00020\u0001:\u0001=B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\tH\u0004J\u0018\u00107\u001a\u0002082\u0006\u00106\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0004J\u0018\u0010<\u001a\u0002082\u0006\u00106\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001b\u0010&\u001a\u00020'8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020-X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u0002018DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006>"}, d2={"Lai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler;", "", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "globalCacheFactory", "Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "ident", "", "(Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/pulsar/crawl/common/GlobalCacheFactory;Lorg/springframework/data/mongodb/core/MongoTemplate;Ljava/lang/String;)V", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "dataCollector", "Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "getDataCollector", "()Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCacheFactory", "()Lai/platon/pulsar/crawl/common/GlobalCacheFactory;", "getIdent", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "metrics", "Lai/platon/scent/boot/autoconfigure/common/ScrapeMetrics;", "getMetrics", "()Lai/platon/scent/boot/autoconfigure/common/ScrapeMetrics;", "getMongoTemplate", "()Lorg/springframework/data/mongodb/core/MongoTemplate;", "responseCacheTTL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getResponseCacheTTL", "()Ljava/time/Duration;", "session", "Lai/platon/scent/ScentSession;", "getSession", "()Lai/platon/scent/ScentSession;", "session$delegate", "Lkotlin/Lazy;", "sinkCommitter", "Lai/platon/scent/executors/AsyncApiSinkCommitter;", "getSinkCommitter", "()Lai/platon/scent/executors/AsyncApiSinkCommitter;", "urlPool", "Lai/platon/pulsar/common/collect/UrlPool;", "getUrlPool", "()Lai/platon/pulsar/common/collect/UrlPool;", "parsePriority", "Lai/platon/pulsar/common/Priority13;", "priority", "submitFetchUrl", "", "", "url", "Lai/platon/pulsar/common/urls/UrlAware;", "submitFetchUrlOrThrow", "Companion", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nScrapeTaskHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrapeTaskHandler.kt\nai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n223#2,2:73\n1#3:75\n*S KotlinDebug\n*F\n+ 1 ScrapeTaskHandler.kt\nai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler\n*L\n46#1:73,2\n*E\n"})
public abstract class ScrapeTaskHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final GlobalCacheFactory globalCacheFactory;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final String ident;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy session$delegate;
    private final Duration responseCacheTTL;
    @NotNull
    private final AsyncApiSinkCommitter sinkCommitter;
    @NotNull
    private final ScrapeMetrics metrics;
    @NotNull
    public static final String TASK_NAME = "SCRAPE";
    @NotNull
    private static final Priority13 DEFAULT_TASK_PRIORITY = Priority13.HIGHER2;

    public ScrapeTaskHandler(@NotNull ScentCrawlLoop crawlLoop, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull MongoTemplate mongoTemplate, @NotNull String ident) {
        Intrinsics.checkNotNullParameter((Object)((Object)crawlLoop), (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
        this.crawlLoop = crawlLoop;
        this.globalCacheFactory = globalCacheFactory;
        this.mongoTemplate = mongoTemplate;
        this.ident = ident;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeTaskHandler.class));
        this.session$delegate = LazyKt.lazy((Function0)session.2.INSTANCE);
        this.responseCacheTTL = Duration.ofSeconds(5L);
        this.sinkCommitter = new AsyncApiSinkCommitter();
        this.metrics = new ScrapeMetrics(this.ident);
    }

    @NotNull
    protected final ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    protected final GlobalCacheFactory getGlobalCacheFactory() {
        return this.globalCacheFactory;
    }

    @NotNull
    protected final MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @NotNull
    protected final String getIdent() {
        return this.ident;
    }

    @NotNull
    public final ScentSession getSession() {
        Lazy lazy = this.session$delegate;
        return (ScentSession)lazy.getValue();
    }

    protected final Duration getResponseCacheTTL() {
        return this.responseCacheTTL;
    }

    @NotNull
    protected final GlobalCache getGlobalCache() {
        return this.globalCacheFactory.getGlobalCache();
    }

    @NotNull
    protected final UrlPool getUrlPool() {
        return this.getGlobalCache().getUrlPool();
    }

    @NotNull
    protected final AsyncApiSinkCommitter getSinkCommitter() {
        return this.sinkCommitter;
    }

    @NotNull
    protected final ScrapeMetrics getMetrics() {
        return this.metrics;
    }

    @NotNull
    protected final UrlCacheCollector getDataCollector() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.crawlLoop.getUrlFeeder().getOpenCollectors();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PriorityDataCollector it = (PriorityDataCollector)element$iv2;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)TASK_NAME, (boolean)false, (int)2, null)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type ai.platon.pulsar.common.collect.collector.UrlCacheCollector");
        return (UrlCacheCollector)t;
    }

    @NotNull
    protected final Priority13 parsePriority(@NotNull String priority) throws IllegalArgumentException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        try {
            boolean bl = false;
            String string = priority;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            object = Result.constructor-impl((Object)Priority13.valueOf((String)string2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new IllegalArgumentException("Bad priority " + priority);
        }
        return (Priority13)object;
    }

    protected final boolean submitFetchUrl(int priority, @NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (priority == DEFAULT_TASK_PRIORITY.getValue()) {
            return this.getDataCollector().getUrlCache().getReentrantQueue().add(url);
        }
        UrlCache urlCache = (UrlCache)this.getUrlPool().getOrderedCaches().get(priority);
        if (urlCache == null) {
            urlCache = this.getUrlPool().getNormalCache();
        }
        UrlCache cache = urlCache;
        return cache.getReentrantQueue().add(url);
    }

    protected final boolean submitFetchUrlOrThrow(int priority, @NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (priority == DEFAULT_TASK_PRIORITY.getValue()) {
            return this.getDataCollector().getUrlCache().getReentrantQueue().add(url);
        }
        UrlCache urlCache = (UrlCache)this.getUrlPool().getOrderedCaches().get(priority);
        if (urlCache == null) {
            throw new IllegalArgumentException("Bad priority " + priority);
        }
        UrlCache cache = urlCache;
        return cache.getReentrantQueue().add(url);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler$Companion;", "", "()V", "DEFAULT_TASK_PRIORITY", "Lai/platon/pulsar/common/Priority13;", "getDEFAULT_TASK_PRIORITY", "()Lai/platon/pulsar/common/Priority13;", "TASK_NAME", "", "scent-boot"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Priority13 getDEFAULT_TASK_PRIORITY() {
            return DEFAULT_TASK_PRIORITY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

