/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.component;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.JvmTimedValue;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.collect.queue.AbstractLoadingQueue;
import ai.platon.pulsar.common.urls.Hyperlink;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import ai.platon.pulsar.skeleton.common.collect.LocalFileHyperlinkCollector;
import ai.platon.scent.boot.autoconfigure.component.LoadingSeedsGenerator;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.common.WebDbLongTimeTask;
import ai.platon.scent.crawl.CollectedResidentTask;
import ai.platon.scent.crawl.ResidentTask;
import ai.platon.scent.crawl.ResidentTaskKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020,0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0\u0003H\u0002J\b\u0010/\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020)H\u0002J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0018J\u0018\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00105\u001a\u00020\u0018J\u0016\u00109\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00107\u001a\u00020\u0004H\u0002J\u000e\u0010:\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u0004J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002030\u00032\u0006\u00107\u001a\u00020\u0004H\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00060\u00060\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006<"}, d2={"Lai/platon/scent/boot/autoconfigure/component/LoadingSeedsGenerator;", "", "tasks", "", "Lai/platon/scent/crawl/ResidentTask;", "searchDirectories", "", "urlFeederHelper", "Lai/platon/pulsar/common/collect/UrlFeederHelper;", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "(Ljava/util/List;Ljava/util/List;Lai/platon/pulsar/common/collect/UrlFeederHelper;Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/persist/WebDb;)V", "collectedTasks", "", "Lai/platon/scent/crawl/CollectedResidentTask;", "getCollectedTasks", "()Ljava/util/List;", "fields", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "isDev", "", "logger", "Lorg/slf4j/Logger;", "getSearchDirectories", "taskId", "taskTime", "Ljava/time/Instant;", "getTasks", "getUrlFeederHelper", "()Lai/platon/pulsar/common/collect/UrlFeederHelper;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "collectHyperlinks", "", "path", "Ljava/nio/file/Path;", "hyperlinks", "", "Lai/platon/pulsar/common/urls/Hyperlink;", "", "paths", "collectLoadingTasks", "collectLoadingTasksInDirectory", "directory", "createCollector", "Lai/platon/pulsar/common/collect/collector/UrlCacheCollector;", "collectedTask", "refresh", "createFetchCacheCollector", "task", "generate", "getRelevantCollectors", "isSupervisor", "removeOldCollectors", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nLoadingSeedsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadingSeedsGenerator.kt\nai/platon/scent/boot/autoconfigure/component/LoadingSeedsGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 DateTimes.kt\nai/platon/pulsar/common/DateTimesKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1549#2:182\n1620#2,3:183\n1855#2,2:188\n766#2:190\n857#2:191\n1549#2:192\n1620#2,3:193\n858#2:196\n766#2:197\n857#2,2:198\n1620#2,3:200\n766#2:210\n857#2,2:211\n800#2,11:213\n2634#2:224\n1603#2,9:226\n1855#2:235\n1856#2:237\n1612#2:238\n1855#2,2:239\n766#2:241\n857#2,2:242\n766#2:244\n857#2,2:245\n1603#2,9:247\n1855#2:256\n766#2:257\n857#2,2:258\n1856#2:262\n1612#2:263\n1549#2:264\n1620#2,3:265\n1855#2,2:268\n37#3,2:186\n15#4,2:203\n17#4,2:208\n1155#5,3:205\n1#6:225\n1#6:236\n1#6:260\n1#6:261\n*S KotlinDebug\n*F\n+ 1 LoadingSeedsGenerator.kt\nai/platon/scent/boot/autoconfigure/component/LoadingSeedsGenerator\n*L\n40#1:182\n40#1:183,3\n50#1:188,2\n56#1:190\n56#1:191\n56#1:192\n56#1:193,3\n56#1:196\n57#1:197\n57#1:198,2\n58#1:200,3\n111#1:210\n111#1:211,2\n112#1:213,11\n117#1:224\n136#1:226,9\n136#1:235\n136#1:237\n136#1:238\n138#1:239,2\n144#1:241\n144#1:242,2\n145#1:244\n145#1:245,2\n146#1:247,9\n146#1:256\n147#1:257\n147#1:258,2\n146#1:262\n146#1:263\n150#1:264\n150#1:265,3\n157#1:268,2\n40#1:186,2\n91#1:203,2\n91#1:208,2\n94#1:205,3\n117#1:225\n136#1:236\n146#1:261\n*E\n"})
public final class LoadingSeedsGenerator {
    @NotNull
    private final List<ResidentTask> tasks;
    @NotNull
    private final List<String> searchDirectories;
    @NotNull
    private final UrlFeederHelper urlFeederHelper;
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Instant taskTime;
    @NotNull
    private final String taskId;
    private final boolean isDev;
    @NotNull
    private final List<CollectedResidentTask> collectedTasks;
    @NotNull
    private final String[] fields;

    /*
     * WARNING - void declaration
     */
    public LoadingSeedsGenerator(@NotNull List<ResidentTask> tasks, @NotNull List<String> searchDirectories, @NotNull UrlFeederHelper urlFeederHelper, @NotNull ExternalUrlLoader urlLoader, @NotNull WebDb webDb) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter(searchDirectories, (String)"searchDirectories");
        Intrinsics.checkNotNullParameter((Object)urlFeederHelper, (String)"urlFeederHelper");
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        this.tasks = tasks;
        this.searchDirectories = searchDirectories;
        this.urlFeederHelper = urlFeederHelper;
        this.urlLoader = urlLoader;
        this.webDb = webDb;
        this.logger = LogsKt.getLogger((Object)this);
        this.taskTime = DateTimes.INSTANCE.startOfDay();
        String string = this.taskTime.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.taskId = string;
        this.isDev = Runtimes.INSTANCE.isDevInstance();
        this.collectedTasks = new ArrayList();
        Object object = new GWebPage.Field[]{GWebPage.Field.PREV_FETCH_TIME, GWebPage.Field.PREV_CRAWL_TIME1};
        object = CollectionsKt.listOf((Object[])object);
        LoadingSeedsGenerator loadingSeedsGenerator = this;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GWebPage.Field field = (GWebPage.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        loadingSeedsGenerator.fields = thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final List<ResidentTask> getTasks() {
        return this.tasks;
    }

    @NotNull
    public final List<String> getSearchDirectories() {
        return this.searchDirectories;
    }

    @NotNull
    public final UrlFeederHelper getUrlFeederHelper() {
        return this.urlFeederHelper;
    }

    @NotNull
    public final ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final List<CollectedResidentTask> getCollectedTasks() {
        return this.collectedTasks;
    }

    public final boolean isSupervisor(@NotNull ResidentTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.isDev || ResidentTaskKt.isSupervised((ResidentTask)task);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UrlCacheCollector> generate(boolean refresh) {
        ResidentTask it;
        Iterable $this$filterTo$iv$iv;
        this.collectLoadingTasks();
        this.logger.info("Collected tasks: " + CollectionsKt.joinToString$default((Iterable)this.collectedTasks, null, null, null, (int)0, null, (Function1)generate.1.INSTANCE, (int)31, null));
        List collectors = new ArrayList();
        Iterable $this$forEach$iv = this.collectedTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CollectedResidentTask task = (CollectedResidentTask)element$iv;
            boolean bl = false;
            collectors.add(this.createCollector(task, refresh));
            LangKt.sleepSeconds((long)15L);
        }
        Iterable $this$filter$iv = this.tasks;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            void $this$mapTo$iv$iv;
            it = (ResidentTask)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.collectedTasks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                CollectedResidentTask collectedResidentTask = (CollectedResidentTask)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it2.getTask());
            }
            if (!(!((List)destination$iv$iv2).contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResidentTask)element$iv$iv;
            boolean bl = false;
            if (!(!this.urlFeederHelper.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            ResidentTask $i$f$filterTo2 = (ResidentTask)item$iv;
            Collection collection = collectors;
            boolean bl = false;
            collection.add(this.createFetchCacheCollector((ResidentTask)it3, this.urlLoader));
        }
        return collectors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final UrlCacheCollector createCollector(@NotNull CollectedResidentTask collectedTask, boolean refresh) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)collectedTask, (String)"collectedTask");
        ResidentTask task = collectedTask.getTask();
        this.removeOldCollectors(task);
        UrlCacheCollector collector = this.createFetchCacheCollector(task, this.urlLoader);
        if (refresh) {
            collector.deepClear();
        }
        if (collector.getExternalSize() > 0) {
            this.logger.info("There are still {} tasks in collector {}, do not generate", (Object)collector.getEstimatedSize(), (Object)collector.getName());
            return collector;
        }
        Set links2 = collectedTask.getHyperlinks();
        if (links2.isEmpty()) {
            return collector;
        }
        Queue queue = collector.getUrlCache().getNonReentrantQueue();
        Intrinsics.checkNotNull((Object)queue, (String)"null cannot be cast to non-null type ai.platon.pulsar.common.collect.queue.AbstractLoadingQueue");
        AbstractLoadingQueue readyQueue = (AbstractLoadingQueue)queue;
        this.logger.info("Checking {} links for task <{}> in database", (Object)links2.size(), (Object)task.getName());
        boolean $i$f$measureTimedValueJvm = false;
        Instant startTime$iv = Instant.now();
        boolean bl = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)new WebDbLongTimeTask(this.webDb, task.getName(), null, 4, null).getAll((Iterable)links2, this.fields), (Function1)((Function1)new Function1<WebPage, Boolean>(task){
            final /* synthetic */ ResidentTask $task;
            {
                this.$task = $task;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WebPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getPrevFetchTime().compareTo((Instant)this.$task.getStartTime().invoke()) >= 0;
            }
        }));
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            WebPage webPage = (WebPage)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(it.getUrl());
        }
        HashSet value$iv = (HashSet)destination$iv;
        Duration elapsedTime$iv = Duration.between(startTime$iv, Instant.now());
        Intrinsics.checkNotNull((Object)elapsedTime$iv);
        JvmTimedValue jvmTimedValue = new JvmTimedValue((Object)value$iv, elapsedTime$iv);
        HashSet fetchedUrls = (HashSet)jvmTimedValue.component1();
        Duration time = jvmTimedValue.component2();
        SequencesKt.toCollection((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)links2), (Function1)((Function1)new Function1<Hyperlink, Boolean>((HashSet<String>)fetchedUrls){
            final /* synthetic */ HashSet<String> $fetchedUrls;
            {
                this.$fetchedUrls = $fetchedUrls;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$fetchedUrls.contains(it.getUrl());
            }
        })), (Function1)((Function1)new Function1<Hyperlink, Unit>(task, this){
            final /* synthetic */ ResidentTask $task;
            final /* synthetic */ LoadingSeedsGenerator this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Hyperlink it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setArgs(ResidentTaskKt.createArgs((ResidentTask)this.$task, (String)LoadingSeedsGenerator.access$getTaskId$p(this.this$0), (Instant)LoadingSeedsGenerator.access$getTaskTime$p(this.this$0)).toString());
            }
        })), (Collection)((Collection)readyQueue));
        Object[] objectArray = new Object[]{readyQueue.size(), readyQueue.getExternalSize(), task.getName(), collector.getName(), time, fetchedUrls.size()};
        this.logger.info("Generated {}/{} {} tasks with collector {} in {}, with {} ones removed(fetched)", objectArray);
        return collector;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlCacheCollector> getRelevantCollectors(ResidentTask task) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.urlFeederHelper.getFeeder().getCollectors();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PriorityDataCollector it = (PriorityDataCollector)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it.getName(), (CharSequence)task.getName(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<UrlCacheCollector> removeOldCollectors(ResidentTask task) {
        Iterable iterable;
        Iterable $this$onEach$iv = this.getRelevantCollectors(task);
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            UrlCacheCollector it = (UrlCacheCollector)element$iv;
            boolean bl2 = false;
            this.urlFeederHelper.removeAllLike(task.getName());
        }
        return (List)iterable;
    }

    private final UrlCacheCollector createFetchCacheCollector(ResidentTask task, ExternalUrlLoader urlLoader) {
        UrlCacheCollector urlCacheCollector;
        int priority = task.getPriority().getValue();
        this.urlFeederHelper.remove(task.getName());
        this.logger.info("Creating collector for {}", (Object)task.getName());
        UrlCacheCollector it = urlCacheCollector = this.urlFeederHelper.create(task.getName(), priority, urlLoader);
        boolean bl = false;
        it.setDeadTime((Instant)task.getDeadTime().invoke());
        it.getLabels().add(task.getName());
        return urlCacheCollector;
    }

    /*
     * WARNING - void declaration
     */
    private final void collectLoadingTasks() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.searchDirectories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (ResourceLoader.INSTANCE.getPathOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            this.collectLoadingTasksInDirectory(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectLoadingTasksInDirectory(Path directory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        ResidentTask task;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<Object> candidates2 = Files.list(directory).filter(arg_0 -> LoadingSeedsGenerator.collectLoadingTasksInDirectory$lambda$13(collectLoadingTasksInDirectory.candidates.1.INSTANCE, arg_0)).toList();
        Iterable iterable = this.tasks;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            task = (ResidentTask)element$iv$iv;
            boolean bl = false;
            if (!this.isSupervisor(task)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            task = (ResidentTask)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = task.getFileName();
            boolean bl2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair pair2;
            List paths2;
            List list;
            void $this$filterTo$iv$iv2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            ResidentTask task2 = (ResidentTask)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull(candidates2);
            Iterable $this$filter$iv2 = candidates2;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                Path it = (Path)element$iv$iv2;
                boolean bl4 = false;
                CharSequence charSequence = ((Object)it).toString();
                String string = task2.getFileName();
                Intrinsics.checkNotNull((Object)string);
                if (!new Regex(string).containsMatchIn(charSequence)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List it = list = (paths2 = (List)destination$iv$iv2);
            boolean bl5 = false;
            List list2 = !((Collection)it).isEmpty() ? list : null;
            if (list2 != null) {
                it = list2;
                boolean bl6 = false;
                pair2 = TuplesKt.to((Object)task2, (Object)it);
            } else {
                pair2 = null;
            }
            if (pair2 == null) continue;
            Pair it$iv$iv = pair2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ResidentTask task3 = (ResidentTask)pair.component1();
            List paths3 = (List)pair.component2();
            collection.add(new CollectedResidentTask(task3, this.collectHyperlinks(paths3)));
        }
        List collectedResidentTasks = (List)destination$iv$iv;
        this.collectedTasks.addAll(collectedResidentTasks);
    }

    private final Set<Hyperlink> collectHyperlinks(List<? extends Path> paths2) {
        Set hyperlinks = new LinkedHashSet();
        Iterable $this$forEach$iv = paths2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            this.collectHyperlinks(it, hyperlinks);
        }
        return hyperlinks;
    }

    private final void collectHyperlinks(Path path, Set<Hyperlink> hyperlinks) {
        LocalFileHyperlinkCollector collector = new LocalFileHyperlinkCollector(path, 0, 2, null);
        List links2 = this.isDev ? CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)100) : collector.getHyperlinks();
        boolean isMaster = Runtimes.INSTANCE.isMaster();
        boolean isCluster = Runtimes.INSTANCE.isCluster();
        if (isCluster) {
            collector.getHyperlinks();
        } else if (isMaster && StringsKt.contains$default((CharSequence)((Object)path).toString(), (CharSequence)"best-sellers", (boolean)false, (int)2, null)) {
            collector.getHyperlinks();
        } else if (isMaster) {
            CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)5000);
        } else {
            CollectionsKt.take((Iterable)collector.getHyperlinks(), (int)100);
        }
        String message = this.isDev ? " (dev mode)" : "";
        this.logger.info("Loaded {} links" + message + " | {}", (Object)links2.size(), (Object)path);
        hyperlinks.addAll(links2);
    }

    private static final boolean collectLoadingTasksInDirectory$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getTaskId$p(LoadingSeedsGenerator $this) {
        return $this.taskId;
    }

    public static final /* synthetic */ Instant access$getTaskTime$p(LoadingSeedsGenerator $this) {
        return $this.taskTime;
    }
}

