/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.tools;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.ProcessLauncher;
import ai.platon.pulsar.common.Runtimes;
import ai.platon.pulsar.common.browser.Browsers;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.common.urls.NormURL;
import ai.platon.pulsar.skeleton.context.PulsarContext;
import ai.platon.pulsar.skeleton.crawl.filter.ChainedUrlNormalizer;
import ai.platon.pulsar.skeleton.crawl.filter.ScopedUrlNormalizer;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.ScentSQLContexts;
import ai.platon.scent.skeleton.ScentSession;
import ai.platon.scent.tools.SimpleCrawler;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020 J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020 J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020 0-2\u0006\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lai/platon/scent/tools/SimpleCrawler;", "Ljava/lang/AutoCloseable;", "context", "Lai/platon/pulsar/skeleton/context/PulsarContext;", "normalizer", "Lai/platon/pulsar/skeleton/crawl/filter/ScopedUrlNormalizer;", "(Lai/platon/pulsar/skeleton/context/PulsarContext;Lai/platon/pulsar/skeleton/crawl/filter/ScopedUrlNormalizer;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getContext", "()Lai/platon/pulsar/skeleton/context/PulsarContext;", "isActive", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getNormalizer", "()Lai/platon/pulsar/skeleton/crawl/filter/ScopedUrlNormalizer;", "session", "Lai/platon/scent/BasicScentSession;", "getSession", "()Lai/platon/scent/BasicScentSession;", "sqlContext", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/ScentSQLContext;", "addUrlNormalizer", "", "close", "load", "url", "", "options", "Lai/platon/pulsar/skeleton/common/options/LoadOptions;", "args", "loadOutPages", "", "Lai/platon/pulsar/persist/WebPage;", "portalUrl", "openBrowser", "path", "Ljava/nio/file/Path;", "openExplorer", "parseOutLinks", "", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nSimpleCrawler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleCrawler.kt\nai/platon/scent/tools/SimpleCrawler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1155#2,3:126\n1155#2,3:129\n766#3:132\n857#3,2:133\n1620#3,3:136\n1549#3:139\n1620#3,3:140\n1549#3:143\n1620#3,3:144\n1#4:135\n*S KotlinDebug\n*F\n+ 1 SimpleCrawler.kt\nai/platon/scent/tools/SimpleCrawler\n*L\n52#1:126,3\n55#1:129,3\n56#1:132\n56#1:133,2\n82#1:136,3\n83#1:139\n83#1:140,3\n97#1:143\n97#1:144,3\n*E\n"})
public class SimpleCrawler
implements AutoCloseable {
    @NotNull
    private final PulsarContext context;
    @Nullable
    private final ScopedUrlNormalizer normalizer;
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final BasicScentSession session;

    public SimpleCrawler(@NotNull PulsarContext context, @Nullable ScopedUrlNormalizer normalizer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.normalizer = normalizer;
        this.logger = LoggerFactory.getLogger(SimpleCrawler.class);
        this.closed = new AtomicBoolean();
        this.session = this.getSqlContext().createSession();
        if (this.normalizer != null) {
            ChainedUrlNormalizer.add$default((ChainedUrlNormalizer)this.session.getContext().getUrlNormalizer(), (ScopedUrlNormalizer)this.normalizer, null, (int)2, null);
        }
    }

    public /* synthetic */ SimpleCrawler(PulsarContext pulsarContext, ScopedUrlNormalizer scopedUrlNormalizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pulsarContext = (PulsarContext)ScentSQLContexts.INSTANCE.create();
        }
        if ((n & 2) != 0) {
            scopedUrlNormalizer = null;
        }
        this(pulsarContext, scopedUrlNormalizer);
    }

    @NotNull
    public final PulsarContext getContext() {
        return this.context;
    }

    @Nullable
    public final ScopedUrlNormalizer getNormalizer() {
        return this.normalizer;
    }

    public boolean isActive() {
        return !this.closed.get() && this.session.isActive();
    }

    @NotNull
    public ScentSQLContext getSqlContext() {
        PulsarContext pulsarContext = this.context;
        Intrinsics.checkNotNull((Object)pulsarContext, (String)"null cannot be cast to non-null type ai.platon.scent.ql.h2.context.ScentSQLContext");
        return (ScentSQLContext)pulsarContext;
    }

    @NotNull
    public final BasicScentSession getSession() {
        return this.session;
    }

    public final void addUrlNormalizer(@NotNull ScopedUrlNormalizer normalizer) {
        Intrinsics.checkNotNullParameter((Object)normalizer, (String)"normalizer");
        ChainedUrlNormalizer.add$default((ChainedUrlNormalizer)this.session.getContext().getUrlNormalizer(), (ScopedUrlNormalizer)normalizer, null, (int)2, null);
    }

    public final void load(@NotNull String url, @NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.load(url, (LoadOptions)this.session.options(args));
    }

    /*
     * WARNING - void declaration
     */
    public final void load(@NotNull String url, @NotNull LoadOptions options) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv;
        String it;
        Collection collection;
        Object $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WebPage page = this.session.load(url);
        FeaturedDocument doc = this.session.parse(page);
        doc.absoluteLinks();
        doc.stripScripts();
        Sequence sequence2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FeaturedDocument.select$default((FeaturedDocument)doc, (String)options.getOutLinkSelector(), (int)0, (int)0, (Function1)load.1.INSTANCE, (int)6, null)), (Function1)load.2.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(StringsKt.substringBefore$default((String)it, (String)".com", null, (int)2, null));
        }
        $this$mapTo$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)destination$iv), (Function1)load.4.INSTANCE);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(it + ".com");
        }
        $this$mapTo$iv = destination$iv;
        boolean $i$f$filter = false;
        void $i$f$mapTo2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl = false;
            if (!NetUtil.testHttpNetwork((URL)new URL(it2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String it3 = $this$filter$iv = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)10), (CharSequence)"\n", null, null, (int)0, null, (Function1)load.7.INSTANCE, (int)30, null);
        boolean bl = false;
        System.out.println((Object)it3);
        Path path = this.session.export(doc);
        this.logger.info("Export to: {}", (Object)path.toUri());
    }

    @NotNull
    public final Collection<WebPage> loadOutPages(@NotNull String portalUrl, @NotNull String args) {
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.loadOutPages(portalUrl, (LoadOptions)this.session.options(args));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<WebPage> loadOutPages(@NotNull String portalUrl, @NotNull LoadOptions options) {
        LoadOptions loadOptions;
        void $this$mapTo$iv$iv;
        Collection collection;
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WebPage page = this.session.load(portalUrl, options);
        if (!page.getProtocolStatus().isSuccess()) {
            this.logger.warn("Failed to load page | {}", (Object)portalUrl);
        }
        FeaturedDocument document = this.session.parse(page);
        document.absoluteLinks();
        document.stripScripts();
        Path path = this.session.export(document);
        this.logger.info("Portal page is exported to: " + path.toUri());
        Iterable iterable = FeaturedDocument.select$default((FeaturedDocument)document, (String)options.getOutLinkSelector(), (int)0, (int)0, (Function1)loadOutPages.links.1.INSTANCE, (int)6, null);
        Collection collection2 = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            collection = destination$iv;
            boolean bl = false;
            PulsarSession pulsarSession = (PulsarSession)this.session;
            Intrinsics.checkNotNull((Object)it);
            collection.add(PulsarSession.DefaultImpls.normalize$default((PulsarSession)pulsarSession, (String)it, (LoadOptions)options, (boolean)false, (int)4, null));
        }
        Iterable $this$map$iv = CollectionsKt.take((Iterable)((Iterable)destination$iv), (int)options.getTopLinks());
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NormURL normURL = (NormURL)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSpec());
        }
        List links2 = (List)destination$iv$iv;
        this.logger.info("Total {} items to load", (Object)links2.size());
        LoadOptions $this$loadOutPages_u24lambda_u246 = loadOptions = options.createItemOptions();
        boolean bl = false;
        $this$loadOutPages_u24lambda_u246.setParse(true);
        LoadOptions itemOptions = loadOptions;
        return this.session.loadAll((Iterable)links2, itemOptions);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> parseOutLinks(@NotNull String portalUrl, @NotNull String args) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        HNormUrl normUrl = ScentSession.DefaultImpls.normalize$default((ScentSession)((ScentSession)this.session), (String)portalUrl, (HarvestOptions)this.session.options(args), (boolean)false, (int)4, null);
        HarvestOptions options = normUrl.getHOptions();
        WebPage portalPage = this.session.load(normUrl);
        FeaturedDocument portalDocument = this.session.parse(portalPage);
        Iterable iterable = CollectionsKt.take((Iterable)((Iterable)FeaturedDocument.select$default((FeaturedDocument)portalDocument, (String)options.getOutLinkSelector(), (int)0, (int)0, (int)6, null)), (int)options.getTopLinks());
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.attr("abs:href"));
        }
        return (List)destination$iv$iv;
    }

    public final void openExplorer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Runtimes.INSTANCE.exec("explorer.exe " + path);
    }

    public final void openBrowser(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.openBrowser(((Object)path).toString());
    }

    public final void openBrowser(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Path chromeBinary = Browsers.INSTANCE.searchChromeBinary();
        Path dataDir = AppPaths.INSTANCE.getTmp("exotic-chrome", new String[0]);
        Object[] objectArray = new String[]{url, "--user-data-dir=" + dataDir, "--no-first-run", "--no-default-browser-check"};
        List args = CollectionsKt.listOf((Object[])objectArray);
        ProcessLauncher.INSTANCE.launch(String.valueOf(chromeBinary), args);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            // empty if block
        }
    }

    public SimpleCrawler() {
        this(null, null, 3, null);
    }
}

