/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.protocol.browser.emulator.IncognitoBrowserFetcher;
import ai.platon.pulsar.skeleton.crawl.CrawlLoops;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCache;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.boot.autoconfigure.ScentContextConfiguration;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.component.ScentGlobalCache;
import ai.platon.scent.ql.h2.context.ScentSQLContext;
import ai.platon.scent.ql.h2.context.ScentSQLContexts;
import jakarta.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Scope;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@EnableMongoRepositories(value={"ai.platon.scent.boot.autoconfigure.persist"})
@ImportResource(value={"classpath:config/app/app-beans/app-context.xml"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0017J\b\u0010#\u001a\u00020$H\u0017J\b\u0010%\u001a\u00020&H\u0017J\b\u0010'\u001a\u00020\"H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lai/platon/scent/boot/autoconfigure/ScentContextConfiguration;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "realGlobalCache", "Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "crawlLoops", "Lai/platon/pulsar/skeleton/crawl/CrawlLoops;", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "browserFetcher", "Lai/platon/pulsar/protocol/browser/emulator/IncognitoBrowserFetcher;", "unmodifiedConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/pulsar/skeleton/crawl/CrawlLoops;Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/pulsar/protocol/browser/emulator/IncognitoBrowserFetcher;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getBrowserFetcher", "()Lai/platon/pulsar/protocol/browser/emulator/IncognitoBrowserFetcher;", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "getCrawlLoops", "()Lai/platon/pulsar/skeleton/crawl/CrawlLoops;", "logger", "Lorg/slf4j/Logger;", "getRealGlobalCache", "()Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;", "getUnmodifiedConfig", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "activateScentSQLContext", "", "getScentContext", "Lai/platon/scent/ql/h2/context/ScentSQLContext;", "getScentSession", "Lai/platon/scent/BasicScentSession;", "startCrawlLoops", "scent-boot"})
public class ScentContextConfiguration {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScentGlobalCache realGlobalCache;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final CrawlLoops crawlLoops;
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final IncognitoBrowserFetcher browserFetcher;
    @NotNull
    private final ImmutableConfig unmodifiedConfig;
    @NotNull
    private final Logger logger;

    public ScentContextConfiguration(@NotNull ApplicationContext applicationContext, @NotNull ScentGlobalCache realGlobalCache, @NotNull ScentCrawlLoop crawlLoop, @NotNull CrawlLoops crawlLoops, @NotNull ExternalUrlLoader urlLoader, @NotNull IncognitoBrowserFetcher browserFetcher, @NotNull ImmutableConfig unmodifiedConfig) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)realGlobalCache), (String)"realGlobalCache");
        Intrinsics.checkNotNullParameter((Object)((Object)crawlLoop), (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)crawlLoops, (String)"crawlLoops");
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)browserFetcher, (String)"browserFetcher");
        Intrinsics.checkNotNullParameter((Object)unmodifiedConfig, (String)"unmodifiedConfig");
        this.applicationContext = applicationContext;
        this.realGlobalCache = realGlobalCache;
        this.crawlLoop = crawlLoop;
        this.crawlLoops = crawlLoops;
        this.urlLoader = urlLoader;
        this.browserFetcher = browserFetcher;
        this.unmodifiedConfig = unmodifiedConfig;
        this.logger = LogsKt.getLogger(ScentContextConfiguration.class);
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScentGlobalCache getRealGlobalCache() {
        return this.realGlobalCache;
    }

    @NotNull
    public ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    public CrawlLoops getCrawlLoops() {
        return this.crawlLoops;
    }

    @NotNull
    public ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public IncognitoBrowserFetcher getBrowserFetcher() {
        return this.browserFetcher;
    }

    @NotNull
    public ImmutableConfig getUnmodifiedConfig() {
        return this.unmodifiedConfig;
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public ScentSQLContext getScentContext() {
        return ScentSQLContexts.INSTANCE.create(this.getApplicationContext());
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public BasicScentSession getScentSession() {
        return this.getScentContext().createSession();
    }

    @PostConstruct
    public void activateScentSQLContext() {
        this.logger.info("Activating scent SQL context ...");
        ScentSQLContext context = ScentSQLContexts.INSTANCE.create(this.getApplicationContext());
        this.logger.info("Scent SQL context is activated: {}", (Object)context);
    }

    @PostConstruct
    public void startCrawlLoops() {
        GlobalCacheFactory.Companion.setGlobalCache((GlobalCache)this.getRealGlobalCache());
        this.logger.info("Starting crawl loops ...");
        this.getCrawlLoops().stop();
        this.getCrawlLoops().getLoops().clear();
        this.getCrawlLoops().getLoops().add(this.getCrawlLoop());
        this.getCrawlLoops().start();
        String crawlLoopDisplay2 = CollectionsKt.joinToString$default((Iterable)this.getCrawlLoops().getLoops(), null, null, null, (int)0, null, (Function1)startCrawlLoops.crawlLoopDisplay.1.INSTANCE, (int)31, null);
        this.logger.info("Crawl loops are started: {}", (Object)crawlLoopDisplay2);
        if (!this.getCrawlLoop().isRunning()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

