/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.component;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.JvmTimedValue;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.QueueCollector;
import ai.platon.pulsar.common.urls.PlainUrl;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.persist.WebDb;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.gora.generated.GWebPage;
import ai.platon.scent.boot.autoconfigure.persist.WebNodeRepository;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.common.WebDbLongTimeTask;
import ai.platon.scent.common.web.GeoAnchor;
import ai.platon.scent.crawl.ResidentTask;
import ai.platon.scent.crawl.ResidentTaskKt;
import ai.platon.scent.persist.WebNodePersistable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.data.domain.PageRequest;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00104\u001a\u000205H\u0002J\u0006\u00106\u001a\u000205R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020 0\u001f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u00067"}, d2={"Lai/platon/scent/boot/autoconfigure/component/DendriticSeedsGenerator;", "", "task", "Lai/platon/scent/crawl/ResidentTask;", "urlFeederHelper", "Lai/platon/pulsar/common/collect/UrlFeederHelper;", "webDb", "Lai/platon/pulsar/persist/WebDb;", "webNodeRepository", "Lai/platon/scent/boot/autoconfigure/persist/WebNodeRepository;", "(Lai/platon/scent/crawl/ResidentTask;Lai/platon/pulsar/common/collect/UrlFeederHelper;Lai/platon/pulsar/persist/WebDb;Lai/platon/scent/boot/autoconfigure/persist/WebNodeRepository;)V", "<set-?>", "Lai/platon/pulsar/common/collect/collector/QueueCollector;", "collector", "getCollector", "()Lai/platon/pulsar/common/collect/collector/QueueCollector;", "fields", "", "", "kotlin.jvm.PlatformType", "[Ljava/lang/String;", "isDev", "", "logger", "Lorg/slf4j/Logger;", "maxTaskCount", "", "getMaxTaskCount", "()I", "setMaxTaskCount", "(I)V", "", "Lai/platon/scent/persist/WebNodePersistable;", "nodes", "getNodes", "()Ljava/util/List;", "readyQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/platon/pulsar/common/urls/UrlAware;", "getReadyQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "getTask", "()Lai/platon/scent/crawl/ResidentTask;", "taskId", "taskTime", "Ljava/time/Instant;", "getUrlFeederHelper", "()Lai/platon/pulsar/common/collect/UrlFeederHelper;", "getWebDb", "()Lai/platon/pulsar/persist/WebDb;", "getWebNodeRepository", "()Lai/platon/scent/boot/autoconfigure/persist/WebNodeRepository;", "createCollector", "", "generate", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nDendriticSeedsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DendriticSeedsGenerator.kt\nai/platon/scent/boot/autoconfigure/component/DendriticSeedsGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 DateTimes.kt\nai/platon/pulsar/common/DateTimesKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,82:1\n1549#2:83\n1620#2,3:84\n1446#2,2:89\n1549#2:91\n1620#2,3:92\n1448#2,3:95\n847#2,2:105\n37#3,2:87\n15#4,2:98\n17#4,2:103\n1155#5,3:100\n*S KotlinDebug\n*F\n+ 1 DendriticSeedsGenerator.kt\nai/platon/scent/boot/autoconfigure/component/DendriticSeedsGenerator\n*L\n42#1:83\n42#1:84,3\n58#1:89,2\n59#1:91\n59#1:92,3\n58#1:95,3\n70#1:105,2\n42#1:87,2\n63#1:98,2\n63#1:103,2\n66#1:100,3\n*E\n"})
public final class DendriticSeedsGenerator {
    @NotNull
    private final ResidentTask task;
    @NotNull
    private final UrlFeederHelper urlFeederHelper;
    @NotNull
    private final WebDb webDb;
    @NotNull
    private final WebNodeRepository webNodeRepository;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Instant taskTime;
    @NotNull
    private final String taskId;
    private final boolean isDev;
    @NotNull
    private final ConcurrentLinkedQueue<UrlAware> readyQueue;
    private int maxTaskCount;
    private List<WebNodePersistable> nodes;
    private QueueCollector collector;
    @NotNull
    private final String[] fields;

    /*
     * WARNING - void declaration
     */
    public DendriticSeedsGenerator(@NotNull ResidentTask task, @NotNull UrlFeederHelper urlFeederHelper, @NotNull WebDb webDb, @NotNull WebNodeRepository webNodeRepository) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)urlFeederHelper, (String)"urlFeederHelper");
        Intrinsics.checkNotNullParameter((Object)webDb, (String)"webDb");
        Intrinsics.checkNotNullParameter((Object)webNodeRepository, (String)"webNodeRepository");
        this.task = task;
        this.urlFeederHelper = urlFeederHelper;
        this.webDb = webDb;
        this.webNodeRepository = webNodeRepository;
        this.logger = LogsKt.getLogger((Object)this);
        this.taskTime = DateTimes.INSTANCE.startOfDay();
        String string = this.taskTime.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.taskId = string;
        this.isDev = Runtimes.INSTANCE.isDevInstance();
        this.readyQueue = new ConcurrentLinkedQueue();
        this.maxTaskCount = this.isDev ? 100 : Integer.MAX_VALUE;
        Object object = new GWebPage.Field[]{GWebPage.Field.PREV_FETCH_TIME, GWebPage.Field.PREV_CRAWL_TIME1};
        object = CollectionsKt.listOf((Object[])object);
        DendriticSeedsGenerator dendriticSeedsGenerator = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GWebPage.Field field = (GWebPage.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        dendriticSeedsGenerator.fields = thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public final ResidentTask getTask() {
        return this.task;
    }

    @NotNull
    public final UrlFeederHelper getUrlFeederHelper() {
        return this.urlFeederHelper;
    }

    @NotNull
    public final WebDb getWebDb() {
        return this.webDb;
    }

    @NotNull
    public final WebNodeRepository getWebNodeRepository() {
        return this.webNodeRepository;
    }

    @NotNull
    public final ConcurrentLinkedQueue<UrlAware> getReadyQueue() {
        return this.readyQueue;
    }

    public final int getMaxTaskCount() {
        return this.maxTaskCount;
    }

    public final void setMaxTaskCount(int n) {
        this.maxTaskCount = n;
    }

    @NotNull
    public final List<WebNodePersistable> getNodes() {
        List<WebNodePersistable> list = this.nodes;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nodes");
        return null;
    }

    @NotNull
    public final QueueCollector getCollector() {
        QueueCollector queueCollector = this.collector;
        if (queueCollector != null) {
            return queueCollector;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"collector");
        return null;
    }

    public final void generate() {
        List list;
        if (this.maxTaskCount != Integer.MAX_VALUE) {
            PageRequest pageRequest = PageRequest.of((int)0, (int)this.maxTaskCount);
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            PageRequest pageable = pageRequest;
            List list2 = this.webNodeRepository.findAllByTopic(this.task.getLabel(), pageable).getContent();
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            list = this.webNodeRepository.findAllByTopic(this.task.getLabel());
        }
        this.nodes = list;
        this.createCollector();
    }

    /*
     * WARNING - void declaration
     */
    private final void createCollector() {
        void $this$filterNotTo$iv;
        PlainUrl it;
        Iterable $this$mapTo$iv;
        WebPage $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        Object element$iv2;
        void $this$flatMapTo$iv;
        int priority = this.task.getPriority().getValue();
        Iterable iterable = this.getNodes();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv2 : $this$flatMapTo$iv) {
            WebNodePersistable it2 = (WebNodePersistable)element$iv2;
            boolean bl = false;
            Iterable $this$map$iv = it2.getNode().getChildAnchors();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                GeoAnchor geoAnchor = (GeoAnchor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new PlainUrl(it3.getUrl(), null, null, 6, null));
            }
            Iterable list$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)new PlainUrl(it2.getNode().getAnchor().getUrl(), null, null, 6, null));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet links2 = (HashSet)destination$iv;
        this.logger.info("Checking {} links for task <{}> from database", (Object)links2.size(), (Object)this.task.getName());
        boolean $i$f$measureTimedValueJvm = false;
        Instant startTime$iv = Instant.now();
        boolean bl = false;
        element$iv2 = SequencesKt.filter((Sequence)new WebDbLongTimeTask(this.webDb, this.task.getName(), null, 4, null).getAll((Iterable)links2, this.fields), (Function1)((Function1)new Function1<WebPage, Boolean>(this){
            final /* synthetic */ DendriticSeedsGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WebPage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getPrevFetchTime().compareTo((Instant)this.this$0.getTask().getStartTime().invoke()) >= 0;
            }
        }));
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            $this$mapTo$iv$iv = (WebPage)item$iv;
            destination$iv$iv = destination$iv2;
            boolean bl3 = false;
            destination$iv$iv.add(it.getUrl());
        }
        HashSet value$iv = (HashSet)destination$iv2;
        Duration elapsedTime$iv = Duration.between(startTime$iv, Instant.now());
        Intrinsics.checkNotNull((Object)elapsedTime$iv);
        iterable = new JvmTimedValue((Object)value$iv, elapsedTime$iv);
        HashSet fetchedUrls = (HashSet)iterable.component1();
        Duration time = iterable.component2();
        String collectorName = "QC@" + this.task.getName();
        $this$mapTo$iv = links2;
        destination$iv2 = this.readyQueue;
        boolean $i$f$filterNotTo = false;
        for (Object element$iv3 : $this$filterNotTo$iv) {
            it = (PlainUrl)element$iv3;
            boolean bl4 = false;
            if (fetchedUrls.contains(it.getUrl())) continue;
            destination$iv2.add(element$iv3);
        }
        this.urlFeederHelper.removeAllLike(this.task.getName());
        this.collector = this.urlFeederHelper.create(collectorName, priority, (Queue)this.readyQueue);
        this.getCollector().setLoadArgs(ResidentTaskKt.createArgs((ResidentTask)this.task, (String)this.taskId, (Instant)this.taskTime).toString());
        this.getCollector().getLabels().add(this.task.getName());
        Object[] objectArray = new Object[]{this.readyQueue.size(), this.task.getName(), this.getCollector().getName(), time, fetchedUrls.size()};
        this.logger.info("Generated {} {} tasks with collector {} in {}, with {} ones removed(fetched)", objectArray);
    }
}

