/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.boot.autoconfigure.component;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.common.sql.NormXSQL;
import ai.platon.scent.crawl.sql.ScrapeAPIUtils;
import ai.platon.scent.crawl.urls.DegenerateScrapeHyperlink;
import ai.platon.scent.crawl.urls.ScrapeHyperlinkVS;
import ai.platon.scent.executors.SinkCommitter;
import ai.platon.scent.persist.mongo.v1.ScrapeTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "Lai/platon/scent/boot/autoconfigure/common/ScrapeTaskHandler;", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "logger", "Lorg/slf4j/Logger;", "createDegenerateScrapeHyperlink", "Lai/platon/scent/crawl/urls/ScrapeHyperlinkVS;", "task", "Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "createHyperlink", "createHyperlinkOrNull", "createHyperlinkWithSQLNormalized", "update", "", "scent-boot"})
public class ScrapeTaskV1Handler
extends ScrapeTaskHandler {
    @NotNull
    private final Logger logger;

    public ScrapeTaskV1Handler(@NotNull GlobalCacheFactory globalCacheFactory, @NotNull ScentCrawlLoop crawlLoop, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)crawlLoop), (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        super(crawlLoop, globalCacheFactory, mongoTemplate, "v1");
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeTaskV1Handler.class));
    }

    @Nullable
    public ScrapeHyperlinkVS createHyperlinkOrNull(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            return this.createHyperlink(task);
        }
        catch (Exception e) {
            task.setStatusCode(400);
            return null;
        }
    }

    @NotNull
    public ScrapeHyperlinkVS createHyperlink(@NotNull ScrapeTask task) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getMetrics().getScrapes().mark();
        task.setCrawler(ClusterTools.INSTANCE.getInstancePartition());
        String string = task.getSql();
        if (string == null) {
            throw new IllegalArgumentException("SQL is required >>>\n" + task.getSql() + "\n<<<");
        }
        String rawSql = string;
        ScrapeHyperlinkVS hyperlink = ScrapeAPIUtils.INSTANCE.isScrapeUDF(rawSql) ? this.createHyperlinkWithSQLNormalized(task) : this.createDegenerateScrapeHyperlink(task);
        return hyperlink;
    }

    private final ScrapeHyperlinkVS createDegenerateScrapeHyperlink(ScrapeTask task) {
        String degenerateUrl = "http://internal.pulsar.platon.ai/" + task.getId();
        return (ScrapeHyperlinkVS)new DegenerateScrapeHyperlink(degenerateUrl, task, this.getSession(), (SinkCommitter)this.getSinkCommitter(), (Function1)new Function1<ScrapeTask, Unit>((Object)this){

            public final void invoke(@NotNull ScrapeTask p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ScrapeTaskV1Handler)this.receiver).update(p0);
            }
        }, this.getGlobalCacheFactory());
    }

    private final ScrapeHyperlinkVS createHyperlinkWithSQLNormalized(ScrapeTask task) throws IllegalArgumentException {
        String rawSQL = task.getSql();
        NormXSQL normXSQL = ScrapeAPIUtils.normalizeSQL$default((ScrapeAPIUtils)ScrapeAPIUtils.INSTANCE, (String)rawSQL, null, null, (boolean)false, (int)14, null);
        task.setUrl(normXSQL.getUrl());
        String fetchUrl = normXSQL.getConfiguredUrl();
        return new ScrapeHyperlinkVS(fetchUrl, task, this.getSession(), (SinkCommitter)this.getSinkCommitter(), (Function1)new Function1<ScrapeTask, Unit>((Object)this){

            public final void invoke(@NotNull ScrapeTask p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((ScrapeTaskV1Handler)this.receiver).update(p0);
            }
        }, this.getGlobalCacheFactory());
    }

    public void update(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(task.getId() != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (task.getSyncStatusCode() == 201) {
            if (task.getStatusCode() == 200) {
                this.getMetrics().getSuccessScrapes().mark();
            } else {
                this.getMetrics().getFailedScrapes().mark();
            }
        }
    }
}

