/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.tools;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.common.ScentWebPageExtKt;
import ai.platon.scent.ml.clustering.ClusteringProject;
import ai.platon.scent.ql.h2.context.ScentSQLContexts;
import ai.platon.scent.skeleton.ScentSession;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.MonthDay;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lai/platon/scent/tools/HarvestTaskExecutor;", "", "session", "Lai/platon/scent/skeleton/ScentSession;", "(Lai/platon/scent/skeleton/ScentSession;)V", "getSession", "()Lai/platon/scent/skeleton/ScentSession;", "buildDatasetViews", "Ljava/nio/file/Path;", "clusteringResultBaseDir", "clearAnnotations", "", "urls", "Lkotlin/sequences/Sequence;", "", "Companion", "scent-boot"})
@SourceDebugExtension(value={"SMAP\nHarvestTaskExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HarvestTaskExecutor.kt\nai/platon/scent/tools/HarvestTaskExecutor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,64:1\n1324#2,3:65\n*S KotlinDebug\n*F\n+ 1 HarvestTaskExecutor.kt\nai/platon/scent/tools/HarvestTaskExecutor\n*L\n58#1:65,3\n*E\n"})
public class HarvestTaskExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScentSession session;
    @NotNull
    private static final Logger logger = LogsKt.getLogger((Object)Companion);

    public HarvestTaskExecutor(@NotNull ScentSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    public /* synthetic */ HarvestTaskExecutor(ScentSession scentSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            scentSession = (ScentSession)ScentSQLContexts.INSTANCE.createSession();
        }
        this(scentSession);
    }

    @NotNull
    public final ScentSession getSession() {
        return this.session;
    }

    @NotNull
    public final Path buildDatasetViews(@NotNull Path clusteringResultBaseDir) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)clusteringResultBaseDir, (String)"clusteringResultBaseDir");
        if (!Files.exists(clusteringResultBaseDir, new LinkOption[0])) {
            throw new FileNotFoundException("The clustering result base directory does not exist: " + clusteringResultBaseDir);
        }
        ClusteringProject project = ClusteringProject.Companion.fromPath(clusteringResultBaseDir);
        ClusteringProject.buildViews$default((ClusteringProject)project, (boolean)false, (int)1, null);
        Path path = project.getViewBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-viewBaseDir>(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    public final void clearAnnotations(@NotNull Sequence<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Sequence $this$forEachIndexed$iv = SequencesKt.map(urls, (Function1)((Function1)new Function1<String, WebPage>(this){
            final /* synthetic */ HarvestTaskExecutor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final WebPage invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getSession().load(it);
            }
        }));
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void page;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WebPage webPage = (WebPage)item$iv;
            int i = n;
            boolean bl = false;
            ScentWebPageExtKt.clearMLLabels((WebPage)page);
            this.session.persist((WebPage)page);
        }
    }

    public HarvestTaskExecutor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/platon/scent/tools/HarvestTaskExecutor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "createDatasetPath", "Ljava/nio/file/Path;", "start", "", "limit", "ident", "", "scent-boot"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path createDatasetPath(@NotNull String ident) {
            Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
            int monthValue = MonthDay.now().getMonthValue();
            int dayOfMonth = MonthDay.now().getDayOfMonth();
            Object prefix = ((CharSequence)ident).length() == 0 ? "dataset." : "dataset." + ident + ".";
            String fileName = (String)prefix + monthValue + "." + dayOfMonth + ".csv";
            String[] stringArray = new String[]{fileName};
            return AppPaths.INSTANCE.getProcTmpTmp("ml", stringArray);
        }

        public static /* synthetic */ Path createDatasetPath$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.createDatasetPath(string);
        }

        @NotNull
        public final Path createDatasetPath(int start, int limit, @NotNull String ident) {
            Intrinsics.checkNotNullParameter((Object)ident, (String)"ident");
            int monthValue = MonthDay.now().getMonthValue();
            int dayOfMonth = MonthDay.now().getDayOfMonth();
            Object prefix = ((CharSequence)ident).length() == 0 ? "dataset." : "dataset." + ident + ".";
            String fileName = (String)prefix + monthValue + "." + dayOfMonth + "." + start + "-" + limit + ".csv";
            String[] stringArray = new String[]{fileName};
            return AppPaths.INSTANCE.getProcTmpTmp("ml", stringArray);
        }

        public static /* synthetic */ Path createDatasetPath$default(Companion companion, int n, int n2, String string, int n3, Object object) {
            if ((n3 & 4) != 0) {
                string = "";
            }
            return companion.createDatasetPath(n, n2, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

