/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.llm;

import ai.platon.scent.llm.local.LocalDataExpertAnswer;
import ai.platon.scent.llm.response.DataExpertAnswerV4;
import ai.platon.scent.ml.clustering.AnswerFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/llm/DatasetAnalysisLoader;", "", "projectId", "", "answerBaseDir", "Ljava/nio/file/Path;", "clusteringResultXLSXViewPath", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "loadClusteringResultXLSXView", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "loadDataExpertAnswerOrNull", "Lai/platon/scent/llm/response/DataExpertAnswerV4;", "Lai/platon/scent/llm/response/DataExpertAnswer;", "prediction", "", "loadLocalDataExpertAnswer", "Lai/platon/scent/llm/local/LocalDataExpertAnswer;", "answerFile", "Ljava/io/File;", "loadLocalDataExpertAnswers", "", "scent-build"})
@SourceDebugExtension(value={"SMAP\nDatasetAnalysisLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasetAnalysisLoader.kt\nai/platon/scent/llm/DatasetAnalysisLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n766#2:60\n857#2,2:61\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 DatasetAnalysisLoader.kt\nai/platon/scent/llm/DatasetAnalysisLoader\n*L\n33#1:60\n33#1:61,2\n34#1:63\n34#1:64,3\n*E\n"})
public final class DatasetAnalysisLoader {
    @NotNull
    private final String projectId;
    @NotNull
    private final Path answerBaseDir;
    @NotNull
    private final Path clusteringResultXLSXViewPath;

    public DatasetAnalysisLoader(@NotNull String projectId, @NotNull Path answerBaseDir, @NotNull Path clusteringResultXLSXViewPath) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)answerBaseDir, (String)"answerBaseDir");
        Intrinsics.checkNotNullParameter((Object)clusteringResultXLSXViewPath, (String)"clusteringResultXLSXViewPath");
        this.projectId = projectId;
        this.answerBaseDir = answerBaseDir;
        this.clusteringResultXLSXViewPath = clusteringResultXLSXViewPath;
    }

    @NotNull
    public final XSSFWorkbook loadClusteringResultXLSXView() {
        return new XSSFWorkbook(this.clusteringResultXLSXViewPath.toFile());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalDataExpertAnswer> loadLocalDataExpertAnswers() {
        void $this$mapTo$iv$iv;
        Path it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries((Path)this.answerBaseDir, (String)"prompt.*.answer.json");
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            if (!AnswerFile.Companion.matches(file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            collection.add(this.loadLocalDataExpertAnswer(file));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final DataExpertAnswerV4 loadDataExpertAnswerOrNull(int prediction) {
        Path path = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)this.answerBaseDir, (String)("prompt." + this.projectId + "." + prediction + ".*.answer.json")));
        if (path == null) {
            return null;
        }
        Path answerFile = path;
        String json = PathsKt.readText$default((Path)answerFile, null, (int)1, null);
        return DataExpertAnswerV4.Companion.fromJsonOrNull(json);
    }

    @NotNull
    public final LocalDataExpertAnswer loadLocalDataExpertAnswer(@NotNull File answerFile) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)answerFile, (String)"answerFile");
        String string = answerFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        AnswerFile fileName = AnswerFile.Companion.fromFileName(string);
        if (!Intrinsics.areEqual((Object)fileName.getProjectId(), (Object)this.projectId)) {
            boolean $i$a$-require-DatasetAnalysisLoader$loadLocalDataExpertAnswer$22 = false;
            String $i$a$-require-DatasetAnalysisLoader$loadLocalDataExpertAnswer$22 = "Invalid project id: " + fileName.getProjectId() + ", expected: " + this.projectId;
            throw new IllegalArgumentException($i$a$-require-DatasetAnalysisLoader$loadLocalDataExpertAnswer$22.toString());
        }
        if (!answerFile.exists()) {
            throw new FileNotFoundException("File not found: " + answerFile);
        }
        String json = FilesKt.readText$default((File)answerFile, null, (int)1, null);
        DataExpertAnswerV4 answer = DataExpertAnswerV4.Companion.fromJsonOrNull(json);
        return new LocalDataExpertAnswer(fileName, this.answerBaseDir, answer, this.clusteringResultXLSXViewPath);
    }
}

