/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.browser.common.BrowserSettings;
import ai.platon.pulsar.common.LangKt;
import ai.platon.scent.common.ScentStringUtils;
import ai.platon.scent.ml.MLResultTable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0007\u0002\u0003\u0004\u0005\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lai/platon/scent/ml/ML;", "", "BuilderStrategy", "Column", "ColumnDescription", "ColumnList", "ContextualColumnDescription", "Record", "RecordList", "scent-build"})
public interface ML {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/platon/scent/ml/ML$BuilderStrategy;", "", "filter", "Lai/platon/scent/ml/MLResultTable$Filter;", "identifier", "", "(Lai/platon/scent/ml/MLResultTable$Filter;Ljava/lang/String;)V", "getFilter", "()Lai/platon/scent/ml/MLResultTable$Filter;", "getIdentifier", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "scent-build"})
    public static final class BuilderStrategy {
        @NotNull
        private final MLResultTable.Filter filter;
        @NotNull
        private final String identifier;

        public BuilderStrategy(@NotNull MLResultTable.Filter filter, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            this.filter = filter;
            this.identifier = identifier;
        }

        @NotNull
        public final MLResultTable.Filter getFilter() {
            return this.filter;
        }

        @NotNull
        public final String getIdentifier() {
            return this.identifier;
        }

        @NotNull
        public final MLResultTable.Filter component1() {
            return this.filter;
        }

        @NotNull
        public final String component2() {
            return this.identifier;
        }

        @NotNull
        public final BuilderStrategy copy(@NotNull MLResultTable.Filter filter, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            return new BuilderStrategy(filter, identifier);
        }

        public static /* synthetic */ BuilderStrategy copy$default(BuilderStrategy builderStrategy, MLResultTable.Filter filter, String string, int n, Object object) {
            if ((n & 1) != 0) {
                filter = builderStrategy.filter;
            }
            if ((n & 2) != 0) {
                string = builderStrategy.identifier;
            }
            return builderStrategy.copy(filter, string);
        }

        @NotNull
        public String toString() {
            return "BuilderStrategy(filter=" + this.filter + ", identifier=" + this.identifier + ")";
        }

        public int hashCode() {
            int result = this.filter.hashCode();
            result = result * 31 + this.identifier.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BuilderStrategy)) {
                return false;
            }
            BuilderStrategy builderStrategy = (BuilderStrategy)other;
            if (this.filter != builderStrategy.filter) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.identifier, (Object)builderStrategy.identifier);
        }
    }

    @JsonIgnoreProperties(value={"previous", "next", "screenHeight", "order", "allNullOrBlank", "anyNonNullOrBlank", "allSame", "averageLeft", "averageTop", "averageWidth", "averageHeight", "averageRectangle", "screen", "isConstant"})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\bA\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0000\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u00109\u001a\u00020\u0003H\u0002J\b\u0010:\u001a\u00020\u0003H\u0002J\b\u0010;\u001a\u00020\u0003H\u0002J\u0006\u0010<\u001a\u00020\u0003J\u0010\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0003H\u0002J\b\u0010?\u001a\u00020\u0003H\u0002J\b\u0010@\u001a\u00020\u0003H\u0002J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010C\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003JE\u0010F\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010G\u001a\u00020\r2\b\u0010H\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010I\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010J\u001a\u00020\rJ\u0006\u0010K\u001a\u00020\rJ\u0006\u0010L\u001a\u00020\rJ\u0006\u0010M\u001a\u00020\u0003J\u0006\u0010N\u001a\u00020OJ\t\u0010P\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010%R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u0011\u0010*\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001bR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010-\"\u0004\b4\u0010/R\u0011\u00105\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0016R\u0011\u00107\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0016\u00a8\u0006Q"}, d2={"Lai/platon/scent/ml/ML$Column;", "", "prediction", "", "label", "", "cells", "", "Lai/platon/scent/ml/ML$Record;", "previous", "next", "(ILjava/lang/String;Ljava/util/List;Lai/platon/scent/ml/ML$Column;Lai/platon/scent/ml/ML$Column;)V", "allNullOrBlank", "", "getAllNullOrBlank", "()Z", "allSame", "getAllSame", "anyNonNullOrBlank", "getAnyNonNullOrBlank", "averageHeight", "getAverageHeight", "()I", "averageLeft", "getAverageLeft", "averageRectangle", "getAverageRectangle", "()Ljava/lang/String;", "averageSeq", "getAverageSeq", "averageTop", "getAverageTop", "averageWidth", "getAverageWidth", "block", "getBlock", "setBlock", "(I)V", "getCells", "()Ljava/util/List;", "importance", "getImportance", "isConstant", "getLabel", "getNext", "()Lai/platon/scent/ml/ML$Column;", "setNext", "(Lai/platon/scent/ml/ML$Column;)V", "order", "getOrder", "getPrediction", "getPrevious", "setPrevious", "screen", "getScreen", "screenHeight", "getScreenHeight", "calculateBlock", "calculateGeoOrder", "calculateGeoOrder2", "calculateImportance", "calculateImportanceOrder", "importance0", "calculateOrder", "calculateSeqOrder", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "isEmpty", "isNotEmpty", "isWorthless", "size", "toColumnDescription", "Lai/platon/scent/ml/ML$ColumnDescription;", "toString", "scent-build"})
    @SourceDebugExtension(value={"SMAP\nML.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ML.kt\nai/platon/scent/ml/ML$Column\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,383:1\n1726#2,3:384\n1747#2,3:387\n1549#2:390\n1620#2,3:391\n1774#2,4:394\n1774#2,4:399\n1774#2,4:403\n1774#2,4:407\n1774#2,4:411\n1774#2,4:415\n1774#2,4:419\n1549#2:423\n1620#2,3:424\n1963#2,14:427\n1774#2,4:441\n1#3:398\n*S KotlinDebug\n*F\n+ 1 ML.kt\nai/platon/scent/ml/ML$Column\n*L\n165#1:384,3\n170#1:387,3\n175#1:390\n175#1:391,3\n179#1:394,4\n185#1:399,4\n191#1:403,4\n197#1:407,4\n203#1:411,4\n212#1:415,4\n217#1:419,4\n273#1:423\n273#1:424,3\n277#1:427,14\n310#1:441,4\n*E\n"})
    public static final class Column {
        private final int prediction;
        @NotNull
        private final String label;
        @NotNull
        private final List<Record> cells;
        @Nullable
        private Column previous;
        @Nullable
        private Column next;
        private final int screenHeight;
        private int block;

        public Column(int prediction, @NotNull String label, @NotNull List<Record> cells2, @Nullable Column previous, @Nullable Column next) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            this.prediction = prediction;
            this.label = label;
            this.cells = cells2;
            this.previous = previous;
            this.next = next;
            this.screenHeight = BrowserSettings.Companion.getSCREEN_VIEWPORT().height;
            this.block = this.calculateBlock();
        }

        public /* synthetic */ Column(int n, String string, List list, Column column2, Column column3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                column2 = null;
            }
            if ((n2 & 0x10) != 0) {
                column3 = null;
            }
            this(n, string, list, column2, column3);
        }

        public final int getPrediction() {
            return this.prediction;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final List<Record> getCells() {
            return this.cells;
        }

        @Nullable
        public final Column getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Column column2) {
            this.previous = column2;
        }

        @Nullable
        public final Column getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Column column2) {
            this.next = column2;
        }

        public final int getScreenHeight() {
            return this.screenHeight;
        }

        public final int getBlock() {
            return this.block;
        }

        public final void setBlock(int n) {
            this.block = n;
        }

        public final int getOrder() {
            return this.calculateOrder();
        }

        public final boolean getAllNullOrBlank() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.cells;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Record it = (Record)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence = it.getText();
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final boolean getAnyNonNullOrBlank() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.cells;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Record it = (Record)element$iv;
                        boolean bl2 = false;
                        CharSequence charSequence = it.getText();
                        boolean bl3 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
                        if (!bl3) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getAllSame() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.cells;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Record record = (Record)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            return CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size() == 1;
        }

        /*
         * WARNING - void declaration
         */
        public final int getAverageTop() {
            int n;
            int b;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getTop() > 0.0f) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = b = count$iv;
            }
            if (b <= 0) {
                n = 0;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = (int)it.getTop();
                    n2 = n3 + n4;
                }
                n = n2 / b;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final int getAverageLeft() {
            int n;
            int b;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getLeft() > 0.0f) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = b = count$iv;
            }
            if (b <= 0) {
                n = 0;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = (int)it.getLeft();
                    n2 = n3 + n4;
                }
                n = n2 / b;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final int getAverageWidth() {
            int n;
            int b;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getWidth() > 0.0f) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = b = count$iv;
            }
            if (b <= 0) {
                n = 0;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = (int)it.getWidth();
                    n2 = n3 + n4;
                }
                n = n2 / b;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final int getAverageHeight() {
            int n;
            int b;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getHeight() > 0.0f) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = b = count$iv;
            }
            if (b <= 0) {
                n = 0;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = (int)it.getHeight();
                    n2 = n3 + n4;
                }
                n = n2 / b;
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public final int getAverageSeq() {
            int n;
            int b;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getSeq() > 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = b = count$iv;
            }
            if (b <= 0) {
                n = 0;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = it.getSeq();
                    n2 = n3 + n4;
                }
                n = n2 / b;
            }
            return n;
        }

        @NotNull
        public final String getAverageRectangle() {
            return this.getAverageLeft() + " " + this.getAverageTop() + " " + this.getAverageWidth() + " " + this.getAverageHeight();
        }

        public final int getImportance() {
            return this.calculateImportance();
        }

        public final int calculateImportance() {
            int numberCount;
            int priceCount;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!ScentStringUtils.INSTANCE.isPriceLike(it.getText()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = priceCount = count$iv;
            }
            if ((double)priceCount > 0.5 * (double)this.cells.size()) {
                return 10 * priceCount;
            }
            Iterable $this$count$iv2 = this.cells;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                v1 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv2) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!ScentStringUtils.INSTANCE.isNumberLike(it.getText()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v1 = numberCount = count$iv;
            }
            if ((double)numberCount > 0.5 * (double)this.cells.size()) {
                return numberCount;
            }
            return 0;
        }

        public final int getScreen() {
            return (this.getAverageTop() + this.screenHeight) / this.screenHeight;
        }

        public final boolean isConstant() {
            return this.getAllSame();
        }

        public final int size() {
            return this.cells.size();
        }

        public final boolean isEmpty() {
            return this.cells.isEmpty();
        }

        public final boolean isNotEmpty() {
            return !((Collection)this.cells).isEmpty();
        }

        public final boolean isWorthless() {
            if (!this.getAllSame()) {
                return false;
            }
            if (this.getAllNullOrBlank()) {
                return true;
            }
            if (this.previous == null) {
                Column column2 = this.next;
                boolean bl = column2 != null ? column2.getAllSame() : false;
                if (bl) {
                    return true;
                }
            }
            Column column3 = this.previous;
            boolean bl = column3 != null ? column3.getAllSame() : false;
            if (bl && this.next == null) {
                return true;
            }
            Column column4 = this.previous;
            boolean bl2 = column4 != null ? column4.getAllSame() : false;
            if (bl2) {
                Column column5 = this.next;
                boolean bl3 = column5 != null ? column5.getAllSame() : false;
                if (bl3) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ColumnDescription toColumnDescription() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.cells;
            int n = this.getAverageHeight();
            int n2 = this.getAverageWidth();
            int n3 = this.getAverageTop();
            int n4 = this.getAverageLeft();
            int n5 = this.getScreen();
            String string = this.label;
            int n6 = this.prediction;
            boolean $i$f$map = false;
            void var3_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Record record = (Record)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getText());
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n7 = 256;
            String string2 = null;
            Collection<String> collection2 = collection;
            int n8 = n;
            int n9 = n2;
            int n10 = n3;
            int n11 = n4;
            int n12 = n5;
            String string3 = string;
            int n13 = n6;
            return new ColumnDescription(n13, string3, n12, n11, n10, n9, n8, (List)collection2, string2, n7, defaultConstructorMarker);
        }

        private final int calculateBlock() {
            Object v0;
            Iterable $this$maxByOrNull$iv = this.cells;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Record it = (Record)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getBlock();
                    do {
                        Object e$iv = iterator$iv.next();
                        Record it2 = (Record)e$iv;
                        $i$a$-maxByOrNull-ML$Column$calculateBlock$1 = false;
                        int v$iv = it2.getBlock();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Record record = v0;
            return record != null ? record.getBlock() : 0;
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateOrder() {
            int n;
            if (this.cells.isEmpty()) {
                return 10000000;
            }
            if (LangKt.alwaysFalse()) {
                n = -1;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Object t : iterable) {
                    void it;
                    Record record = (Record)t;
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = it.getLabelOrder();
                    n2 = n3 + n4;
                }
                n = n2 / this.cells.size();
            }
            int labelOrder = n;
            int importance0 = this.getImportance();
            return labelOrder >= 0 ? labelOrder : (importance0 > 0 ? this.calculateImportanceOrder(importance0) : (this.getAverageSeq() > 0 ? this.getAverageSeq() : this.calculateGeoOrder()));
        }

        private final int calculateSeqOrder() {
            return this.getAverageSeq();
        }

        private final int calculateGeoOrder() {
            return this.getAverageTop() * 1000 + this.getAverageLeft();
        }

        private final int calculateImportanceOrder(int importance0) {
            return -importance0 * 1000 + this.calculateSeqOrder();
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateGeoOrder2() {
            int n;
            int positiveCount;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Record it = (Record)element$iv;
                    boolean bl = false;
                    if (!(it.getGeoOrder() > 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = positiveCount = count$iv;
            }
            if (positiveCount == 0) {
                n = 10000000;
            } else {
                Iterable iterable = this.cells;
                int n2 = 0;
                for (Iterator iterator : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (Record)((Object)iterator);
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = it.getGeoOrder();
                    n2 = n3 + n4;
                }
                n = n2 / positiveCount * this.cells.size();
            }
            return n;
        }

        public final int component1() {
            return this.prediction;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        @NotNull
        public final List<Record> component3() {
            return this.cells;
        }

        @Nullable
        public final Column component4() {
            return this.previous;
        }

        @Nullable
        public final Column component5() {
            return this.next;
        }

        @NotNull
        public final Column copy(int prediction, @NotNull String label, @NotNull List<Record> cells2, @Nullable Column previous, @Nullable Column next) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            return new Column(prediction, label, cells2, previous, next);
        }

        public static /* synthetic */ Column copy$default(Column column2, int n, String string, List list, Column column3, Column column4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = column2.prediction;
            }
            if ((n2 & 2) != 0) {
                string = column2.label;
            }
            if ((n2 & 4) != 0) {
                list = column2.cells;
            }
            if ((n2 & 8) != 0) {
                column3 = column2.previous;
            }
            if ((n2 & 0x10) != 0) {
                column4 = column2.next;
            }
            return column2.copy(n, string, list, column3, column4);
        }

        @NotNull
        public String toString() {
            return "Column(prediction=" + this.prediction + ", label=" + this.label + ", cells=" + this.cells + ", previous=" + this.previous + ", next=" + this.next + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.prediction);
            result = result * 31 + this.label.hashCode();
            result = result * 31 + ((Object)this.cells).hashCode();
            result = result * 31 + (this.previous == null ? 0 : this.previous.hashCode());
            result = result * 31 + (this.next == null ? 0 : this.next.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Column)) {
                return false;
            }
            Column column2 = (Column)other;
            if (this.prediction != column2.prediction) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)column2.label)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cells, column2.cells)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.previous, (Object)column2.previous)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.next, (Object)column2.next);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\fH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003Jk\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f2\b\b\u0002\u0010\r\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006*"}, d2={"Lai/platon/scent/ml/ML$ColumnDescription;", "", "prediction", "", "label", "", "screen", "left", "top", "width", "height", "cells", "", "comment", "(ILjava/lang/String;IIIIILjava/util/List;Ljava/lang/String;)V", "getCells", "()Ljava/util/List;", "getComment", "()Ljava/lang/String;", "getHeight", "()I", "getLabel", "getLeft", "getPrediction", "getScreen", "getTop", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "scent-build"})
    public static final class ColumnDescription {
        private final int prediction;
        @NotNull
        private final String label;
        private final int screen;
        private final int left;
        private final int top;
        private final int width;
        private final int height;
        @NotNull
        private final List<String> cells;
        @NotNull
        private final String comment;

        public ColumnDescription(int prediction, @NotNull String label, int screen, int left, int top, int width, int height, @NotNull List<String> cells2, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            this.prediction = prediction;
            this.label = label;
            this.screen = screen;
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.cells = cells2;
            this.comment = comment;
        }

        public /* synthetic */ ColumnDescription(int n, String string, int n2, int n3, int n4, int n5, int n6, List list, String string2, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 0x100) != 0) {
                string2 = "";
            }
            this(n, string, n2, n3, n4, n5, n6, list, string2);
        }

        public final int getPrediction() {
            return this.prediction;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final int getScreen() {
            return this.screen;
        }

        public final int getLeft() {
            return this.left;
        }

        public final int getTop() {
            return this.top;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final List<String> getCells() {
            return this.cells;
        }

        @NotNull
        public final String getComment() {
            return this.comment;
        }

        public final int component1() {
            return this.prediction;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        public final int component3() {
            return this.screen;
        }

        public final int component4() {
            return this.left;
        }

        public final int component5() {
            return this.top;
        }

        public final int component6() {
            return this.width;
        }

        public final int component7() {
            return this.height;
        }

        @NotNull
        public final List<String> component8() {
            return this.cells;
        }

        @NotNull
        public final String component9() {
            return this.comment;
        }

        @NotNull
        public final ColumnDescription copy(int prediction, @NotNull String label, int screen, int left, int top, int width, int height, @NotNull List<String> cells2, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            return new ColumnDescription(prediction, label, screen, left, top, width, height, cells2, comment);
        }

        public static /* synthetic */ ColumnDescription copy$default(ColumnDescription columnDescription, int n, String string, int n2, int n3, int n4, int n5, int n6, List list, String string2, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = columnDescription.prediction;
            }
            if ((n7 & 2) != 0) {
                string = columnDescription.label;
            }
            if ((n7 & 4) != 0) {
                n2 = columnDescription.screen;
            }
            if ((n7 & 8) != 0) {
                n3 = columnDescription.left;
            }
            if ((n7 & 0x10) != 0) {
                n4 = columnDescription.top;
            }
            if ((n7 & 0x20) != 0) {
                n5 = columnDescription.width;
            }
            if ((n7 & 0x40) != 0) {
                n6 = columnDescription.height;
            }
            if ((n7 & 0x80) != 0) {
                list = columnDescription.cells;
            }
            if ((n7 & 0x100) != 0) {
                string2 = columnDescription.comment;
            }
            return columnDescription.copy(n, string, n2, n3, n4, n5, n6, list, string2);
        }

        @NotNull
        public String toString() {
            return "ColumnDescription(prediction=" + this.prediction + ", label=" + this.label + ", screen=" + this.screen + ", left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + ", cells=" + this.cells + ", comment=" + this.comment + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.prediction);
            result = result * 31 + this.label.hashCode();
            result = result * 31 + Integer.hashCode(this.screen);
            result = result * 31 + Integer.hashCode(this.left);
            result = result * 31 + Integer.hashCode(this.top);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + ((Object)this.cells).hashCode();
            result = result * 31 + this.comment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnDescription)) {
                return false;
            }
            ColumnDescription columnDescription = (ColumnDescription)other;
            if (this.prediction != columnDescription.prediction) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)columnDescription.label)) {
                return false;
            }
            if (this.screen != columnDescription.screen) {
                return false;
            }
            if (this.left != columnDescription.left) {
                return false;
            }
            if (this.top != columnDescription.top) {
                return false;
            }
            if (this.width != columnDescription.width) {
                return false;
            }
            if (this.height != columnDescription.height) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cells, columnDescription.cells)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comment, (Object)columnDescription.comment);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/ml/ML$ColumnList;", "", "columns", "", "Lai/platon/scent/ml/ML$Column;", "(Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "size", "", "getSize", "()I", "isEmpty", "", "isNotEmpty", "scent-build"})
    public static final class ColumnList {
        @NotNull
        private final List<Column> columns;

        public ColumnList(@NotNull List<Column> columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            this.columns = columns;
        }

        public /* synthetic */ ColumnList(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<Column> getColumns() {
            return this.columns;
        }

        public final int getSize() {
            return this.columns.size();
        }

        public final boolean isEmpty() {
            return this.columns.isEmpty();
        }

        public final boolean isNotEmpty() {
            return !((Collection)this.columns).isEmpty();
        }

        public ColumnList() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b'\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000fH\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\u0011\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\fH\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\u0087\u0001\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f2\b\b\u0002\u0010\r\u001a\u00020\u00032\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0005H\u00c6\u0001J\u0013\u00104\u001a\u00020\u00132\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u0012\u00107\u001a\u00020\u00132\b\u00108\u001a\u0004\u0018\u00010\u0005H\u0002J\t\u00109\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010 \u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0011\u0010!\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001e\u00a8\u0006:"}, d2={"Lai/platon/scent/ml/ML$ContextualColumnDescription;", "", "prediction", "", "label", "", "screen", "left", "top", "width", "height", "cells", "", "contextWindow", "cellContexts", "", "comment", "(ILjava/lang/String;IIIIILjava/util/List;ILjava/util/List;Ljava/lang/String;)V", "allSame", "", "getAllSame", "()Z", "getCellContexts", "()Ljava/util/List;", "getCells", "getComment", "()Ljava/lang/String;", "setComment", "(Ljava/lang/String;)V", "getContextWindow", "()I", "getHeight", "isNumberLike", "isPriceLike", "getLabel", "getLeft", "getPrediction", "getScreen", "getTop", "getWidth", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "isPriceLike0", "text", "toString", "scent-build"})
    @SourceDebugExtension(value={"SMAP\nML.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ML.kt\nai/platon/scent/ml/ML$ContextualColumnDescription\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,383:1\n1726#2,3:384\n1747#2,3:387\n1774#2,4:390\n1083#3,2:394\n*S KotlinDebug\n*F\n+ 1 ML.kt\nai/platon/scent/ml/ML$ContextualColumnDescription\n*L\n342#1:384,3\n343#1:387,3\n343#1:390,4\n351#1:394,2\n*E\n"})
    public static final class ContextualColumnDescription {
        private final int prediction;
        @NotNull
        private final String label;
        private final int screen;
        private final int left;
        private final int top;
        private final int width;
        private final int height;
        @NotNull
        private final List<String> cells;
        private final int contextWindow;
        @NotNull
        private final List<String> cellContexts;
        @NotNull
        private String comment;

        public ContextualColumnDescription(int prediction, @NotNull String label, int screen, int left, int top, int width, int height, @NotNull List<String> cells2, int contextWindow, @NotNull List<String> cellContexts, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            Intrinsics.checkNotNullParameter(cellContexts, (String)"cellContexts");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            this.prediction = prediction;
            this.label = label;
            this.screen = screen;
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.cells = cells2;
            this.contextWindow = contextWindow;
            this.cellContexts = cellContexts;
            this.comment = comment;
        }

        public /* synthetic */ ContextualColumnDescription(int n, String string, int n2, int n3, int n4, int n5, int n6, List list, int n7, List list2, String string2, int n8, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n8 & 0x100) != 0) {
                n7 = 0;
            }
            if ((n8 & 0x200) != 0) {
                list2 = new ArrayList();
            }
            if ((n8 & 0x400) != 0) {
                string2 = "";
            }
            this(n, string, n2, n3, n4, n5, n6, list, n7, list2, string2);
        }

        public final int getPrediction() {
            return this.prediction;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final int getScreen() {
            return this.screen;
        }

        public final int getLeft() {
            return this.left;
        }

        public final int getTop() {
            return this.top;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final List<String> getCells() {
            return this.cells;
        }

        public final int getContextWindow() {
            return this.contextWindow;
        }

        @NotNull
        public final List<String> getCellContexts() {
            return this.cellContexts;
        }

        @NotNull
        public final String getComment() {
            return this.comment;
        }

        public final void setComment(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.comment = string;
        }

        public final boolean getAllSame() {
            return CollectionsKt.distinct((Iterable)this.cellContexts).size() == 1;
        }

        public final boolean isNumberLike() {
            boolean bl;
            block3: {
                Iterable $this$all$iv = this.cells;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CharSequence charSequence;
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (it != null && new Regex("\\d+").matches(charSequence = (CharSequence)it)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPriceLike() {
            boolean bl;
            String it;
            Iterable $this$any$iv = this.cells;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl2 = false;
            } while (!this.isPriceLike0(it));
            boolean bl3 = true;
            if (!bl3) return false;
            Iterable $this$count$iv = this.cells;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                bl = false;
            } else {
                void var3_4;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it2 = (String)element$iv;
                    boolean bl4 = false;
                    if (!this.isPriceLike0(it2) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                bl = var3_4;
            }
            if (!((double)bl > 0.5 * (double)this.cells.size())) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isPriceLike0(String text) {
            CharSequence charSequence = text;
            if (charSequence == null) return false;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            boolean bl = false;
            if (bl) {
                return false;
            }
            Regex currencySymbols = new Regex("[\u00a5\uffe5$\u20ac\u00a3\u20b9\u20bd]");
            if (!currencySymbols.containsMatchIn((CharSequence)text)) return false;
            CharSequence $this$any$iv = text;
            boolean $i$f$any = false;
            int n = 0;
            while (n < $this$any$iv.length()) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(n);
                boolean bl2 = false;
                if (Character.isDigit(it)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public final int component1() {
            return this.prediction;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        public final int component3() {
            return this.screen;
        }

        public final int component4() {
            return this.left;
        }

        public final int component5() {
            return this.top;
        }

        public final int component6() {
            return this.width;
        }

        public final int component7() {
            return this.height;
        }

        @NotNull
        public final List<String> component8() {
            return this.cells;
        }

        public final int component9() {
            return this.contextWindow;
        }

        @NotNull
        public final List<String> component10() {
            return this.cellContexts;
        }

        @NotNull
        public final String component11() {
            return this.comment;
        }

        @NotNull
        public final ContextualColumnDescription copy(int prediction, @NotNull String label, int screen, int left, int top, int width, int height, @NotNull List<String> cells2, int contextWindow, @NotNull List<String> cellContexts, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter(cells2, (String)"cells");
            Intrinsics.checkNotNullParameter(cellContexts, (String)"cellContexts");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            return new ContextualColumnDescription(prediction, label, screen, left, top, width, height, cells2, contextWindow, cellContexts, comment);
        }

        public static /* synthetic */ ContextualColumnDescription copy$default(ContextualColumnDescription contextualColumnDescription, int n, String string, int n2, int n3, int n4, int n5, int n6, List list, int n7, List list2, String string2, int n8, Object object) {
            if ((n8 & 1) != 0) {
                n = contextualColumnDescription.prediction;
            }
            if ((n8 & 2) != 0) {
                string = contextualColumnDescription.label;
            }
            if ((n8 & 4) != 0) {
                n2 = contextualColumnDescription.screen;
            }
            if ((n8 & 8) != 0) {
                n3 = contextualColumnDescription.left;
            }
            if ((n8 & 0x10) != 0) {
                n4 = contextualColumnDescription.top;
            }
            if ((n8 & 0x20) != 0) {
                n5 = contextualColumnDescription.width;
            }
            if ((n8 & 0x40) != 0) {
                n6 = contextualColumnDescription.height;
            }
            if ((n8 & 0x80) != 0) {
                list = contextualColumnDescription.cells;
            }
            if ((n8 & 0x100) != 0) {
                n7 = contextualColumnDescription.contextWindow;
            }
            if ((n8 & 0x200) != 0) {
                list2 = contextualColumnDescription.cellContexts;
            }
            if ((n8 & 0x400) != 0) {
                string2 = contextualColumnDescription.comment;
            }
            return contextualColumnDescription.copy(n, string, n2, n3, n4, n5, n6, list, n7, list2, string2);
        }

        @NotNull
        public String toString() {
            return "ContextualColumnDescription(prediction=" + this.prediction + ", label=" + this.label + ", screen=" + this.screen + ", left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + ", cells=" + this.cells + ", contextWindow=" + this.contextWindow + ", cellContexts=" + this.cellContexts + ", comment=" + this.comment + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.prediction);
            result = result * 31 + this.label.hashCode();
            result = result * 31 + Integer.hashCode(this.screen);
            result = result * 31 + Integer.hashCode(this.left);
            result = result * 31 + Integer.hashCode(this.top);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + ((Object)this.cells).hashCode();
            result = result * 31 + Integer.hashCode(this.contextWindow);
            result = result * 31 + ((Object)this.cellContexts).hashCode();
            result = result * 31 + this.comment.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextualColumnDescription)) {
                return false;
            }
            ContextualColumnDescription contextualColumnDescription = (ContextualColumnDescription)other;
            if (this.prediction != contextualColumnDescription.prediction) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)contextualColumnDescription.label)) {
                return false;
            }
            if (this.screen != contextualColumnDescription.screen) {
                return false;
            }
            if (this.left != contextualColumnDescription.left) {
                return false;
            }
            if (this.top != contextualColumnDescription.top) {
                return false;
            }
            if (this.width != contextualColumnDescription.width) {
                return false;
            }
            if (this.height != contextualColumnDescription.height) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cells, contextualColumnDescription.cells)) {
                return false;
            }
            if (this.contextWindow != contextualColumnDescription.contextWindow) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cellContexts, contextualColumnDescription.cellContexts)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comment, (Object)contextualColumnDescription.comment);
        }
    }

    @JsonIgnoreProperties(value={"centerX", "centerY", "order", "rectangle"})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 V2\u00020\u0001:\u0001VBs\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0005H\u00c6\u0003J\t\u0010H\u001a\u00020\u0005H\u00c6\u0003J\t\u0010I\u001a\u00020\u0007H\u00c6\u0003J\t\u0010J\u001a\u00020\u0007H\u00c6\u0003J\t\u0010K\u001a\u00020\u0007H\u00c6\u0003J\t\u0010L\u001a\u00020\u0007H\u00c6\u0003J\t\u0010M\u001a\u00020\u0005H\u00c6\u0003J\t\u0010N\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Jy\u0010P\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010T\u001a\u00020\u0005H\u00d6\u0001J\b\u0010U\u001a\u00020\u0003H\u0016R\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0018R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010$R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0013\"\u0004\b.\u0010\u0018R\u0011\u0010/\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010&R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0013\"\u0004\b8\u0010\u0018R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010&\"\u0004\b:\u0010(R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001b\"\u0004\b<\u0010$R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010&\"\u0004\b>\u0010(R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u001b\"\u0004\b@\u0010$R\u0011\u0010A\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001bR\u0011\u0010C\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001b\u00a8\u0006W"}, d2={"Lai/platon/scent/ml/ML$Record;", "", "label", "", "prediction", "", "top", "", "left", "width", "height", "seq", "labelOrder", "text", "url", "block", "(Ljava/lang/String;IFFFFIILjava/lang/String;Ljava/lang/String;I)V", "alignedX", "getAlignedX", "()I", "alignedY", "getAlignedY", "getBlock", "setBlock", "(I)V", "bottom", "getBottom", "()F", "centerX", "getCenterX", "centerY", "getCenterY", "geoOrder", "getGeoOrder", "getHeight", "setHeight", "(F)V", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "getLabelOrder", "setLabelOrder", "getLeft", "setLeft", "getPrediction", "setPrediction", "rectString", "getRectString", "rectangle", "Ljava/awt/Rectangle;", "getRectangle", "()Ljava/awt/Rectangle;", "right", "getRight", "getSeq", "setSeq", "getText", "setText", "getTop", "setTop", "getUrl", "setUrl", "getWidth", "setWidth", "x", "getX", "y", "getY", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "scent-build"})
    public static final class Record {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private String label;
        private int prediction;
        private float top;
        private float left;
        private float width;
        private float height;
        private int seq;
        private int labelOrder;
        @Nullable
        private String text;
        @NotNull
        private String url;
        private int block;
        public static final int LAST_GROUP_ORDER = 10000000;
        @NotNull
        private static final String[] FIELD_NAMES;

        public Record(@NotNull String label, int prediction, float top, float left, float width, float height, int seq, int labelOrder, @Nullable String text, @NotNull String url, int block) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.label = label;
            this.prediction = prediction;
            this.top = top;
            this.left = left;
            this.width = width;
            this.height = height;
            this.seq = seq;
            this.labelOrder = labelOrder;
            this.text = text;
            this.url = url;
            this.block = block;
        }

        public /* synthetic */ Record(String string, int n, float f, float f2, float f3, float f4, int n2, int n3, String string2, String string3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                string = "";
            }
            if ((n5 & 2) != 0) {
                n = 0;
            }
            if ((n5 & 4) != 0) {
                f = 0.0f;
            }
            if ((n5 & 8) != 0) {
                f2 = 0.0f;
            }
            if ((n5 & 0x10) != 0) {
                f3 = 0.0f;
            }
            if ((n5 & 0x20) != 0) {
                f4 = 0.0f;
            }
            if ((n5 & 0x40) != 0) {
                n2 = 0;
            }
            if ((n5 & 0x80) != 0) {
                n3 = -1;
            }
            if ((n5 & 0x100) != 0) {
                string2 = null;
            }
            if ((n5 & 0x400) != 0) {
                n4 = 0;
            }
            this(string, n, f, f2, f3, f4, n2, n3, string2, string3, n4);
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.label = string;
        }

        public final int getPrediction() {
            return this.prediction;
        }

        public final void setPrediction(int n) {
            this.prediction = n;
        }

        public final float getTop() {
            return this.top;
        }

        public final void setTop(float f) {
            this.top = f;
        }

        public final float getLeft() {
            return this.left;
        }

        public final void setLeft(float f) {
            this.left = f;
        }

        public final float getWidth() {
            return this.width;
        }

        public final void setWidth(float f) {
            this.width = f;
        }

        public final float getHeight() {
            return this.height;
        }

        public final void setHeight(float f) {
            this.height = f;
        }

        public final int getSeq() {
            return this.seq;
        }

        public final void setSeq(int n) {
            this.seq = n;
        }

        public final int getLabelOrder() {
            return this.labelOrder;
        }

        public final void setLabelOrder(int n) {
            this.labelOrder = n;
        }

        @Nullable
        public final String getText() {
            return this.text;
        }

        public final void setText(@Nullable String string) {
            this.text = string;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.url = string;
        }

        public final int getBlock() {
            return this.block;
        }

        public final void setBlock(int n) {
            this.block = n;
        }

        public final float getX() {
            return this.left;
        }

        public final float getY() {
            return this.top;
        }

        public final float getCenterX() {
            return this.left + this.width / (float)2;
        }

        public final float getCenterY() {
            return this.top + this.height / (float)2;
        }

        public final int getAlignedX() {
            return Companion.alignX$default(Companion, this.left, 0, 2, null);
        }

        public final int getAlignedY() {
            return Companion.alignY$default(Companion, this.top, 0, 2, null);
        }

        public final float getRight() {
            return this.left + this.width;
        }

        public final float getBottom() {
            return this.top + this.height;
        }

        public final int getGeoOrder() {
            return Companion.alignY$default(Companion, this.getCenterY(), 0, 2, null) * 10000 + (int)this.getCenterX();
        }

        @NotNull
        public final Rectangle getRectangle() {
            return new Rectangle((int)this.left, (int)this.top, (int)this.width, (int)this.height);
        }

        @NotNull
        public final String getRectString() {
            return (int)this.left + " " + (int)this.top + " " + (int)this.width + " " + (int)this.height;
        }

        @NotNull
        public String toString() {
            return this.label + "," + this.prediction + "," + this.top + "," + this.left + "," + this.width + "," + this.height + "," + this.seq + "," + this.labelOrder + "," + this.text + "," + this.url;
        }

        @NotNull
        public final String component1() {
            return this.label;
        }

        public final int component2() {
            return this.prediction;
        }

        public final float component3() {
            return this.top;
        }

        public final float component4() {
            return this.left;
        }

        public final float component5() {
            return this.width;
        }

        public final float component6() {
            return this.height;
        }

        public final int component7() {
            return this.seq;
        }

        public final int component8() {
            return this.labelOrder;
        }

        @Nullable
        public final String component9() {
            return this.text;
        }

        @NotNull
        public final String component10() {
            return this.url;
        }

        public final int component11() {
            return this.block;
        }

        @NotNull
        public final Record copy(@NotNull String label, int prediction, float top, float left, float width, float height, int seq, int labelOrder, @Nullable String text, @NotNull String url, int block) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Record(label, prediction, top, left, width, height, seq, labelOrder, text, url, block);
        }

        public static /* synthetic */ Record copy$default(Record record, String string, int n, float f, float f2, float f3, float f4, int n2, int n3, String string2, String string3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = record.label;
            }
            if ((n5 & 2) != 0) {
                n = record.prediction;
            }
            if ((n5 & 4) != 0) {
                f = record.top;
            }
            if ((n5 & 8) != 0) {
                f2 = record.left;
            }
            if ((n5 & 0x10) != 0) {
                f3 = record.width;
            }
            if ((n5 & 0x20) != 0) {
                f4 = record.height;
            }
            if ((n5 & 0x40) != 0) {
                n2 = record.seq;
            }
            if ((n5 & 0x80) != 0) {
                n3 = record.labelOrder;
            }
            if ((n5 & 0x100) != 0) {
                string2 = record.text;
            }
            if ((n5 & 0x200) != 0) {
                string3 = record.url;
            }
            if ((n5 & 0x400) != 0) {
                n4 = record.block;
            }
            return record.copy(string, n, f, f2, f3, f4, n2, n3, string2, string3, n4);
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = result * 31 + Integer.hashCode(this.prediction);
            result = result * 31 + Float.hashCode(this.top);
            result = result * 31 + Float.hashCode(this.left);
            result = result * 31 + Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.height);
            result = result * 31 + Integer.hashCode(this.seq);
            result = result * 31 + Integer.hashCode(this.labelOrder);
            result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
            result = result * 31 + this.url.hashCode();
            result = result * 31 + Integer.hashCode(this.block);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Record)) {
                return false;
            }
            Record record = (Record)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)record.label)) {
                return false;
            }
            if (this.prediction != record.prediction) {
                return false;
            }
            if (Float.compare(this.top, record.top) != 0) {
                return false;
            }
            if (Float.compare(this.left, record.left) != 0) {
                return false;
            }
            if (Float.compare(this.width, record.width) != 0) {
                return false;
            }
            if (Float.compare(this.height, record.height) != 0) {
                return false;
            }
            if (this.seq != record.seq) {
                return false;
            }
            if (this.labelOrder != record.labelOrder) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)record.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)record.url)) {
                return false;
            }
            return this.block == record.block;
        }

        static {
            String[] stringArray = new String[]{"label", "prediction", "top", "left", "width", "height", "seq", "text", "url"};
            FIELD_NAMES = stringArray;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/ml/ML$Record$Companion;", "", "()V", "FIELD_NAMES", "", "", "getFIELD_NAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "LAST_GROUP_ORDER", "", "alignX", "x", "", "gridWidth", "alignY", "y", "gridHeight", "parse", "Lai/platon/scent/ml/ML$Record;", "line", "version", "parse1", "parts", "", "parse2", "scent-build"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String[] getFIELD_NAMES() {
                return FIELD_NAMES;
            }

            public final int alignX(float x, int gridWidth) {
                int w = gridWidth;
                int ax = MathKt.roundToInt((float)(x / (float)w)) * w;
                return ax;
            }

            public static /* synthetic */ int alignX$default(Companion companion, float f, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    n = 50;
                }
                return companion.alignX(f, n);
            }

            public final int alignY(float y, int gridHeight) {
                int h = gridHeight;
                int ay = MathKt.roundToInt((float)(y / (float)h)) * h;
                return ay;
            }

            public static /* synthetic */ int alignY$default(Companion companion, float f, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    n = 50;
                }
                return companion.alignY(f, n);
            }

            @NotNull
            public final Record parse(@NotNull String line, int version) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String[] stringArray = new String[]{","};
                List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                return switch (version) {
                    case 1 -> this.parse1(parts);
                    case 2 -> this.parse2(parts);
                    default -> throw new IllegalArgumentException("Unknown version: " + version);
                };
            }

            public static /* synthetic */ Record parse$default(Companion companion, String string, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    n = 2;
                }
                return companion.parse(string, n);
            }

            private final Record parse1(List<String> parts) {
                String label = parts.get(0);
                int prediction = Integer.parseInt(parts.get(1));
                float top = Float.parseFloat(parts.get(2));
                float left = Float.parseFloat(parts.get(3));
                float width = Float.parseFloat(parts.get(4));
                float height = Float.parseFloat(parts.get(5));
                int labelOrder = Integer.parseInt(parts.get(6));
                String text = parts.get(7);
                String url = parts.get(8);
                int seq = 0;
                return new Record(label, prediction, top, left, width, height, labelOrder, seq, text, url, 0, 1024, null);
            }

            private final Record parse2(List<String> parts) {
                String label = parts.get(0);
                int prediction = Integer.parseInt(parts.get(1));
                float top = Float.parseFloat(parts.get(2));
                float left = Float.parseFloat(parts.get(3));
                float width = Float.parseFloat(parts.get(4));
                float height = Float.parseFloat(parts.get(5));
                int seq = Integer.parseInt(parts.get(6));
                int labelOrder = Integer.parseInt(parts.get(7));
                String text = parts.get(8);
                String url = parts.get(9);
                return new Record(label, prediction, top, left, width, height, labelOrder, seq, text, url, 0, 1024, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/ml/ML$RecordList;", "", "records", "", "Lai/platon/scent/ml/ML$Record;", "(Ljava/util/List;)V", "getRecords", "()Ljava/util/List;", "size", "", "getSize", "()I", "add", "", "record", "isEmpty", "", "isNotEmpty", "scent-build"})
    public static final class RecordList {
        @NotNull
        private final List<Record> records;

        public RecordList(@NotNull List<Record> records) {
            Intrinsics.checkNotNullParameter(records, (String)"records");
            this.records = records;
        }

        public /* synthetic */ RecordList(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @NotNull
        public final List<Record> getRecords() {
            return this.records;
        }

        public final int getSize() {
            return this.records.size();
        }

        public final boolean isEmpty() {
            return this.records.isEmpty();
        }

        public final boolean isNotEmpty() {
            return !((Collection)this.records).isEmpty();
        }

        public final void add(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            this.records.add(record);
        }

        public RecordList() {
            this(null, 1, null);
        }
    }
}

