/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.clustering.io;

import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultFieldListTable;
import ai.platon.scent.ml.MLResultLoader;
import ai.platon.scent.ml.clustering.io.ClusteringResultFieldListLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J8\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00180\u00172\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lai/platon/scent/ml/clustering/io/ClusteringResultFieldListLoader;", "Lai/platon/scent/ml/MLResultLoader;", "csvPaths", "", "Ljava/nio/file/Path;", "(Ljava/util/List;)V", "headerNames", "", "", "getHeaderNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "urlColumnIndex", "", "getUrlColumnIndex", "()I", "buildRows", "", "csvParser", "Lorg/apache/commons/csv/CSVParser;", "filterDatasets", "outputPath", "filter1", "Lkotlin/Function1;", "", "filter2", "Lai/platon/scent/ml/ML$Record;", "load", "Lai/platon/scent/ml/MLResultFieldListTable;", "parseRecord", "url", "csvRecord", "Lorg/apache/commons/csv/CSVRecord;", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nClusteringResultFieldListLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusteringResultFieldListLoader.kt\nai/platon/scent/ml/clustering/io/ClusteringResultFieldListLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1864#2,3:76\n1855#2,2:79\n*S KotlinDebug\n*F\n+ 1 ClusteringResultFieldListLoader.kt\nai/platon/scent/ml/clustering/io/ClusteringResultFieldListLoader\n*L\n33#1:76,3\n50#1:79,2\n*E\n"})
public class ClusteringResultFieldListLoader
extends MLResultLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Path> csvPaths;
    @NotNull
    private final String[] headerNames;
    @NotNull
    private static final String EXAMPLE_RESOURCE = "data/hua/dataset.nodes.unsupervised.result.20000.field.list.csv";

    public ClusteringResultFieldListLoader(@NotNull List<? extends Path> csvPaths2) {
        Intrinsics.checkNotNullParameter(csvPaths2, (String)"csvPaths");
        this.csvPaths = csvPaths2;
        this.headerNames = ML.Record.Companion.getFIELD_NAMES();
    }

    @Override
    @NotNull
    public String[] getHeaderNames() {
        return this.headerNames;
    }

    private final int getUrlColumnIndex() {
        return ArraysKt.indexOf((Object[])this.getHeaderNames(), (Object)"url");
    }

    @Override
    @NotNull
    public MLResultFieldListTable load() {
        super.loadAllCSV(this.csvPaths);
        return new MLResultFieldListTable(this.getUrlToRecords(), this.getPredictionToColumns());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void buildRows(@NotNull CSVParser csvParser) {
        Intrinsics.checkNotNullParameter((Object)csvParser, (String)"csvParser");
        int urlIndex = this.getUrlColumnIndex();
        Iterable $this$forEachIndexed$iv = (Iterable)csvParser;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Map cells2;
            void csvRecord;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CSVRecord cSVRecord = (CSVRecord)item$iv;
            int i = n;
            boolean bl = false;
            String url = csvRecord.get(urlIndex);
            if (!URLUtils.isStandard((String)url)) continue;
            Intrinsics.checkNotNull((Object)url);
            Intrinsics.checkNotNull((Object)csvRecord);
            ML.Record cell = this.parseRecord(url, (CSVRecord)csvRecord);
            Intrinsics.checkNotNullExpressionValue((Object)this.getUrlToRecords().computeIfAbsent(url, arg_0 -> ClusteringResultFieldListLoader.buildRows$lambda$1$lambda$0(buildRows.1.cells.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            cells2.put(cell.getPrediction(), cell);
        }
    }

    public final void filterDatasets(@NotNull Path outputPath, @NotNull Function1<? super String, Boolean> filter1, @NotNull Function1<? super ML.Record, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter(filter1, (String)"filter1");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter2");
        Iterable $this$forEach$iv = this.csvPaths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            List<String> list = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            Sequence lines2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), filter1), (Function1)filterDatasets.2.lines.1.INSTANCE), filter2);
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            Files.writeString(outputPath, (CharSequence)SequencesKt.joinToString$default((Sequence)lines2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), new OpenOption[0]);
        }
    }

    public static /* synthetic */ void filterDatasets$default(ClusteringResultFieldListLoader clusteringResultFieldListLoader, Path path, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filterDatasets");
        }
        if ((n & 4) != 0) {
            function12 = filterDatasets.1.INSTANCE;
        }
        clusteringResultFieldListLoader.filterDatasets(path, (Function1<? super String, Boolean>)function1, (Function1<? super ML.Record, Boolean>)function12);
    }

    @NotNull
    protected ML.Record parseRecord(@NotNull String url, @NotNull CSVRecord csvRecord) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)csvRecord, (String)"csvRecord");
        String string = csvRecord.get("label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        String string2 = csvRecord.get("prediction");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        int n = MathKt.roundToInt((float)Float.parseFloat(string2));
        String string3 = csvRecord.get("top");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
        float f = Float.parseFloat(string3);
        String string4 = csvRecord.get("left");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"get(...)");
        float f2 = Float.parseFloat(string4);
        String string5 = csvRecord.get("width");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"get(...)");
        float f3 = Float.parseFloat(string5);
        String string6 = csvRecord.get("height");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"get(...)");
        float f4 = Float.parseFloat(string6);
        String string7 = csvRecord.get("seq");
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"get(...)");
        int n2 = MathKt.roundToInt((float)Float.parseFloat(string7));
        String string8 = csvRecord.get("text");
        String string9 = csvRecord.get("url");
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"get(...)");
        return new ML.Record(string, n, f, f2, f3, f4, n2, -1, string8, string9, 0, 1024, null);
    }

    private static final Map buildRows$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/ml/clustering/io/ClusteringResultFieldListLoader$Companion;", "", "()V", "EXAMPLE_RESOURCE", "", "getEXAMPLE_RESOURCE", "()Ljava/lang/String;", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getEXAMPLE_RESOURCE() {
            return EXAMPLE_RESOURCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

