/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.Documents;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.scent.view.builder.EntityViewBuilder;
import ai.platon.scent.view.builder.HtmlViewBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0004J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u001e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0004J8\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0004J<\u0010#\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\b\b\u0002\u0010!\u001a\u00020\u00152\b\b\u0002\u0010\"\u001a\u00020\u0015H\u0004J\b\u0010%\u001a\u00020\u0015H\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0004J\u0006\u0010(\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lai/platon/scent/view/builder/HtmlViewBuilder;", "Lai/platon/scent/view/builder/EntityViewBuilder;", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "doc", "Lai/platon/pulsar/dom/FeaturedDocument;", "getDoc", "()Lai/platon/pulsar/dom/FeaturedDocument;", "adjustAllImageSize", "", "root", "Lorg/jsoup/nodes/Element;", "adjustAttributes", "adjustImageSize", "img", "build", "buildDocument", "baseUri", "", "buildLinks", "attributes", "", "Lai/platon/pulsar/dom/model/PageAttribute;", "buildPureImages", "buildTable", "buildTableHead", "table", "label", "name", "value", "extractor", "selector", "buildTableRow", "richText", "toString", "tryBuildLink", "link", "view", "Companion", "scent-build"})
public class HtmlViewBuilder
extends EntityViewBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeaturedDocument doc;
    @NotNull
    private static final Logger logger = LogsKt.getLogger((Object)Companion);
    @NotNull
    private static final String[] permittedAttributes;
    @NotNull
    private static final String templateResource;
    @NotNull
    private static FeaturedDocument template;

    public HtmlViewBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(pageEntity, conf);
        this.doc = new FeaturedDocument(template);
    }

    @NotNull
    public final FeaturedDocument getDoc() {
        return this.doc;
    }

    @Override
    public void build() {
        HtmlViewBuilder.buildDocument$default(this, null, 1, null);
    }

    @NotNull
    public final FeaturedDocument view() {
        return this.doc;
    }

    @NotNull
    public final FeaturedDocument buildDocument(@NotNull String baseUri) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        Element element = this.doc.getBody().getElementsByTag("div").first();
        if (element == null) {
            return FeaturedDocument.Companion.getNIL();
        }
        Element wrapper = element;
        Element element2 = wrapper.appendElement("div");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element div = element2;
        Element element3 = div.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"appendElement(...)");
        Element table = element3;
        table.attr("class", "table tablesorter scent-build");
        this.buildTableHead(table, "Labels", "Key", "Value", "Extractor", "Path");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        ArrayList preorderedAttributes = arrayList;
        TreeMultimap treeMultimap = TreeMultimap.create((arg_0, arg_1) -> HtmlViewBuilder.buildDocument$lambda$0(buildDocument.alphabetOrderedAttributes.1.INSTANCE, arg_0, arg_1), (arg_0, arg_1) -> HtmlViewBuilder.buildDocument$lambda$1(buildDocument.alphabetOrderedAttributes.2.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)treeMultimap, (String)"create(...)");
        TreeMultimap alphabetOrderedAttributes2 = treeMultimap;
        String[] stringArray = new String[]{""};
        String[] builderOrder = this.getConf().getStrings("scent.builder.build.order.by.category", stringArray);
        Intrinsics.checkNotNull((Object)builderOrder);
        for (String category : builderOrder) {
            for (PageAttribute attr : this.getPageEntity().getAttributes().values()) {
                Intrinsics.checkNotNull((Object)category);
                if (!attr.hasCategory(category)) continue;
                Intrinsics.checkNotNull((Object)attr);
                if (!this.validateAttribute(attr)) continue;
                preorderedAttributes.add(attr);
            }
        }
        for (PageAttribute attr : preorderedAttributes) {
            String string;
            Object object = attr.getCategory();
            if (object == null || (object = object.getFullName()) == null) {
                object = "";
            }
            String string2 = attr.getName();
            String string3 = attr.getRichText();
            String string4 = attr.getExtractor();
            if (string4 == null) {
                string4 = "";
            }
            if ((string = attr.getValuePath()) == null) {
                string = "";
            }
            this.buildTableRow(table, (String)object, string2, string3, string4, string);
        }
        int counter = 5;
        while (counter-- > 0) {
            this.buildTableRow(table, "------------", "------------", "------Trivial Information Below------", "------------", "------------");
        }
        for (PageAttribute attr : this.getPageEntity().getAttributes().values()) {
            if (preorderedAttributes.contains(attr)) continue;
            Intrinsics.checkNotNull((Object)attr);
            if (!this.validateAttribute(attr)) continue;
            Object object = attr.getCategory();
            if (object == null || (object = object.getFullName()) == null) {
                object = "";
            }
            alphabetOrderedAttributes2.put(object, (Object)attr);
        }
        for (PageAttribute attr : alphabetOrderedAttributes2.values()) {
            String string;
            Intrinsics.checkNotNull((Object)attr);
            if (!this.validateAttribute(attr)) continue;
            Object object = attr.getCategory();
            if (object == null || (object = object.getFullName()) == null) {
                object = "";
            }
            String string5 = attr.getName();
            String string6 = attr.getRichText();
            String string7 = attr.getExtractor();
            if (string7 == null) {
                string7 = "";
            }
            if ((string = attr.getValuePath()) == null) {
                string = "";
            }
            this.buildTableRow(table, (String)object, string5, string6, string7, string);
        }
        this.adjustAttributes(this.doc.getBody());
        return this.doc;
    }

    public static /* synthetic */ FeaturedDocument buildDocument$default(HtmlViewBuilder htmlViewBuilder, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildDocument");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        return htmlViewBuilder.buildDocument(string);
    }

    @NotNull
    protected final Element buildPureImages(@NotNull Element root, @NotNull Collection<PageAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        for (Element img : root.getElementsByTag("img")) {
            img.removeAttr("alt");
            img.removeAttr("style");
        }
        return root;
    }

    @NotNull
    protected final Element buildLinks(@NotNull Element root, @NotNull Collection<PageAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        for (PageAttribute attr : attributes) {
            root.append(attr.getValue());
        }
        return root;
    }

    @NotNull
    protected final Element buildTable(@NotNull Element root, @NotNull Collection<PageAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Element element = root.appendElement("table");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element table = element;
        for (PageAttribute attr : attributes) {
            Element td;
            Element th;
            Element tr;
            if (attr.getValue().length() > 300) continue;
            Intrinsics.checkNotNullExpressionValue((Object)table.appendElement("tr"), (String)"appendElement(...)");
            Intrinsics.checkNotNullExpressionValue((Object)tr.appendElement("td"), (String)"appendElement(...)");
            Intrinsics.checkNotNullExpressionValue((Object)tr.appendElement("td"), (String)"appendElement(...)");
            th.text(attr.getName());
            td.text(attr.getValue());
        }
        return table;
    }

    @NotNull
    protected final Element buildTableHead(@NotNull Element table, @NotNull String label, @NotNull String name, @NotNull String value, @NotNull String extractor, @NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Element element = table.appendElement("thead");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element tbody = element;
        Element element2 = tbody.appendElement("tr");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element tr = element2;
        Element element3 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"appendElement(...)");
        Element th = element3;
        Element element4 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"appendElement(...)");
        Element th2 = element4;
        Element element5 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"appendElement(...)");
        Element th3 = element5;
        Element element6 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element6, (String)"appendElement(...)");
        Element th4 = element6;
        Element element7 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element7, (String)"appendElement(...)");
        Element th5 = element7;
        th.text(label).addClass("label");
        th2.text(name).addClass("name");
        th3.text(value).addClass("value");
        th4.text(extractor).addClass("extractor");
        th5.text(selector).addClass("selector");
        return tr;
    }

    @NotNull
    protected final Element buildTableRow(@NotNull Element table, @NotNull String label, @NotNull String name, @NotNull String richText, @NotNull String extractor, @NotNull String selector) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)richText, (String)"richText");
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Object value = richText;
        Element element = table.appendElement("tr");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendElement(...)");
        Element tr = element;
        Element element2 = tr.appendElement("th");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"appendElement(...)");
        Element th = element2;
        Element element3 = tr.appendElement("td");
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"appendElement(...)");
        Element td = element3;
        Element element4 = tr.appendElement("td");
        Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"appendElement(...)");
        Element td2 = element4;
        Element element5 = tr.appendElement("td");
        Intrinsics.checkNotNullExpressionValue((Object)element5, (String)"appendElement(...)");
        Element td3 = element5;
        Element element6 = tr.appendElement("td");
        Intrinsics.checkNotNullExpressionValue((Object)element6, (String)"appendElement(...)");
        Element td4 = element6;
        th.attr("data-seperate-line", StringUtils.repeat((String)"-", (int)100));
        th.text(label).addClass("label");
        td.text(name).addClass("name");
        if (!StringsKt.contains$default((CharSequence)((CharSequence)value), (CharSequence)"table", (boolean)false, (int)2, null)) {
            CharSequence charSequence = (CharSequence)value;
            Regex regex = new Regex("<tbody");
            String string = "<div";
            value = regex.replace(charSequence, string);
            charSequence = (CharSequence)value;
            regex = new Regex("<tr");
            string = "<div";
            value = regex.replace(charSequence, string);
            charSequence = (CharSequence)value;
            regex = new Regex("<td");
            string = "<div";
            value = regex.replace(charSequence, string);
        }
        if (((String)value).length() > 10000) {
            value = "(too long " + ((String)value).length() + " content)";
        }
        if (StringsKt.contains$default((CharSequence)((CharSequence)value), (CharSequence)"<html", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((CharSequence)value), (CharSequence)"<body", (boolean)false, (int)2, null)) {
            value = "(the entire page)";
        }
        value = StringsKt.replace((String)value, (String)"<script", (String)"<script-del", (boolean)true);
        value = this.tryBuildLink(name, (String)value);
        td2.append((String)value).addClass("value");
        td3.text(extractor).addClass("extractor");
        if (((CharSequence)selector).length() > 0) {
            td4.attr("title", selector);
            td4.text("..." + StringUtils.substring((String)selector, (int)-10)).addClass("selector");
        }
        return tr;
    }

    public static /* synthetic */ Element buildTableRow$default(HtmlViewBuilder htmlViewBuilder, Element element, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTableRow");
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            string5 = "";
        }
        return htmlViewBuilder.buildTableRow(element, string, string2, string3, string4, string5);
    }

    protected final void adjustAllImageSize(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.adjustImageSize(root);
        for (Element img : root.select("img")) {
            Intrinsics.checkNotNull((Object)img);
            this.adjustImageSize(img);
        }
    }

    protected final void adjustImageSize(@NotNull Element img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        if (Intrinsics.areEqual((Object)img.tagName(), (Object)"img")) {
            int width = NodeExtKt.getWidth((Node)((Node)img));
            if (width > 200) {
                img.attr("width", String.valueOf(width));
            }
            if (width > 1000) {
                img.remove();
            }
        }
    }

    @NotNull
    protected final String tryBuildLink(@NotNull String name, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Object link1 = link;
        if (StringsKt.startsWith$default((String)link1, (String)"http:", (boolean)false, (int)2, null)) {
            CharSequence charSequence = (CharSequence)link1;
            if (new Regex("http.+\\.js").matches(charSequence)) {
                link1 = (String)link1 + ".rename";
            }
            link1 = "<a href='" + (String)link1 + "' target='_blank'>" + (String)link1 + "</a>";
        } else if (StringsKt.startsWith$default((String)link1, (String)"file:", (boolean)false, (int)2, null)) {
            link1 = "<a href='" + (String)link1 + "' target='_blank'>" + (String)link1 + "</a>";
        }
        return link1;
    }

    protected final void adjustAttributes(@NotNull Element root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        for (Element ele : root.getAllElements()) {
            Attributes validAttrs = new Attributes();
            if (!ele.attributes().isEmpty()) {
                for (Attribute attr : ele.attributes()) {
                    if (ArrayUtils.contains((Object[])permittedAttributes, (Object)attr.getKey())) {
                        validAttrs.put(attr);
                    }
                    String string = attr.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-key>(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"scent-", (boolean)false, (int)2, null)) continue;
                    String string2 = attr.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-key>(...)");
                    validAttrs.put(StringsKt.replace$default((String)string2, (String)"scent-", (String)"", (boolean)false, (int)4, null), attr.getValue());
                }
                ele.clearAttributes();
                ele.attributes().addAll(validAttrs);
            }
            if (!Intrinsics.areEqual((Object)ele.tagName(), (Object)"a")) continue;
            ele.attr("target", "_blank");
        }
    }

    @NotNull
    public String toString() {
        return this.doc.toString();
    }

    private static final int buildDocument$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int buildDocument$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        String[] stringArray = new String[]{"charset", "lang", "content", "http-equiv", "id", "class", "title", "href", "height", "width", "alt", "src"};
        permittedAttributes = stringArray;
        templateResource = "wwwroot/template/page.table.html";
        template = FeaturedDocument.Companion.getNIL();
        InputStream stream = ResourceLoader.INSTANCE.getResourceAsStream(templateResource);
        if (stream != null) {
            template = Documents.INSTANCE.parse(stream, "UTF-8", "");
        } else {
            logger.error("Failed to load resource " + templateResource);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lai/platon/scent/view/builder/HtmlViewBuilder$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "permittedAttributes", "", "", "getPermittedAttributes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "template", "Lai/platon/pulsar/dom/FeaturedDocument;", "getTemplate", "()Lai/platon/pulsar/dom/FeaturedDocument;", "setTemplate", "(Lai/platon/pulsar/dom/FeaturedDocument;)V", "templateResource", "getTemplateResource", "()Ljava/lang/String;", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getPermittedAttributes() {
            return permittedAttributes;
        }

        @NotNull
        public final String getTemplateResource() {
            return templateResource;
        }

        @NotNull
        public final FeaturedDocument getTemplate() {
            return template;
        }

        public final void setTemplate(@NotNull FeaturedDocument featuredDocument) {
            Intrinsics.checkNotNullParameter((Object)featuredDocument, (String)"<set-?>");
            template = featuredDocument;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

