/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.view.builder.ml.XLSXBuilder;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0014\u0010\u000e\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011J\u001e\u0010\u0018\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J(\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J0\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u001f2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u0011H\u0002J0\u0010,\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u001f2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u0011H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lai/platon/scent/view/builder/ml/MLResultXLSXBuilder;", "Lai/platon/scent/view/builder/ml/XLSXBuilder;", "type", "", "projectId", "mlResultTable", "Lai/platon/scent/ml/MLResultTable;", "outputBaseDir", "Ljava/nio/file/Path;", "columnsPerURL", "", "(Ljava/lang/String;Ljava/lang/String;Lai/platon/scent/ml/MLResultTable;Ljava/nio/file/Path;I)V", "logger", "Lorg/slf4j/Logger;", "build", "outputFile", "orderedColumns", "", "Lai/platon/scent/ml/ML$Column;", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "buildAll", "", "strategies", "Lai/platon/scent/ml/ML$BuilderStrategy;", "createHeaders", "columns", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "createRows", "fillLabelHeader", "labelRow", "Lorg/apache/poi/ss/usermodel/Row;", "fillPredictionHeader", "predictionRow", "writeHeader2", "rowNum", "label", "columnCount", "writeRow", "id", "url", "row", "records", "Lai/platon/scent/ml/ML$Record;", "writeRow2", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nMLResultXLSXBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLResultXLSXBuilder.kt\nai/platon/scent/view/builder/ml/MLResultXLSXBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1549#2:274\n1620#2,3:275\n1855#2,2:278\n1864#2,3:281\n1855#2,2:284\n1864#2,2:286\n1549#2:288\n1620#2,2:289\n288#2,2:291\n1622#2:293\n1866#2:294\n1549#2:295\n1620#2,3:296\n1549#2:299\n1620#2,3:300\n1#3:280\n*S KotlinDebug\n*F\n+ 1 MLResultXLSXBuilder.kt\nai/platon/scent/view/builder/ml/MLResultXLSXBuilder\n*L\n73#1:274\n73#1:275,3\n79#1:278,2\n143#1:281,3\n148#1:284,2\n164#1:286,2\n166#1:288\n166#1:289,2\n166#1:291,2\n166#1:293\n164#1:294\n63#1:295\n63#1:296,3\n64#1:299\n64#1:300,3\n*E\n"})
public final class MLResultXLSXBuilder
extends XLSXBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String type;
    @NotNull
    private final String projectId;
    @NotNull
    private final MLResultTable mlResultTable;
    @NotNull
    private final Path outputBaseDir;
    private final int columnsPerURL;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final List<String> HEADER_DESCRIPTIONS;
    @NotNull
    private static final List<String> HEADER_NAMES;
    @NotNull
    private static final List<String> HEADERS;

    public MLResultXLSXBuilder(@NotNull String type, @NotNull String projectId, @NotNull MLResultTable mlResultTable, @NotNull Path outputBaseDir, int columnsPerURL) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)mlResultTable, (String)"mlResultTable");
        Intrinsics.checkNotNullParameter((Object)outputBaseDir, (String)"outputBaseDir");
        this.type = type;
        this.projectId = projectId;
        this.mlResultTable = mlResultTable;
        this.outputBaseDir = outputBaseDir;
        this.columnsPerURL = columnsPerURL;
        this.logger = LogsKt.getLogger((Object)this);
    }

    public /* synthetic */ MLResultXLSXBuilder(String string, String string2, MLResultTable mLResultTable, Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 20;
        }
        this(string, string2, mLResultTable, path, n);
    }

    /*
     * WARNING - void declaration
     */
    public final void buildAll() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)MLResultTable.Filter.PERFECT), (Object)"perfect"), TuplesKt.to((Object)((Object)MLResultTable.Filter.QUALIFIED), (Object)"")};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ML.BuilderStrategy((MLResultTable.Filter)((Object)it.getFirst()), (String)it.getSecond()));
        }
        List strategies = (List)destination$iv$iv;
        this.buildAll(strategies);
    }

    public final void buildAll(@NotNull List<ML.BuilderStrategy> strategies) {
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Iterable $this$forEach$iv = strategies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ML.BuilderStrategy builderStrategy = (ML.BuilderStrategy)element$iv;
            boolean bl = false;
            MLResultTable.Filter strategy = builderStrategy.component1();
            String identifier = builderStrategy.component2();
            String fileName = StringsKt.replace$default((String)(this.projectId + "." + identifier + ".xlsx"), (String)"..", (String)".", (boolean)false, (int)4, null);
            Path outputFile = this.outputBaseDir.resolve(fileName);
            Files.deleteIfExists(outputFile);
            try {
                List columns = MLResultTable.filterColumnList$default(this.mlResultTable, strategy, 0, 2, null);
                Intrinsics.checkNotNull((Object)outputFile);
                this.build(outputFile, columns);
            }
            catch (Exception e) {
                this.logger.warn("Failed to build view with strategy " + strategy + " | {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Path build(@NotNull Path outputFile, @NotNull List<ML.Column> orderedColumns) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter(orderedColumns, (String)"orderedColumns");
        XSSFWorkbook workbook = this.build(orderedColumns);
        Closeable closeable = Files.newOutputStream(outputFile, new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            workbook.write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return outputFile;
    }

    @NotNull
    public final XSSFWorkbook build(@NotNull List<ML.Column> orderedColumns) {
        Intrinsics.checkNotNullParameter(orderedColumns, (String)"orderedColumns");
        if (orderedColumns.isEmpty()) {
            this.logger.warn("No columns to write to XLSX file.");
            return new XSSFWorkbook();
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("MLResult");
        Intrinsics.checkNotNull((Object)sheet);
        this.createHeaders(orderedColumns, (Sheet)sheet);
        this.createRows(orderedColumns, (Sheet)sheet);
        this.setStyle(workbook);
        return workbook;
    }

    /*
     * WARNING - void declaration
     */
    private final void createHeaders(List<ML.Column> columns, Sheet sheet) {
        if (columns.isEmpty()) {
            this.logger.warn("No columns to write to XLSX file.");
            return;
        }
        Iterable $this$forEachIndexed$iv = HEADERS;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void label;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int rowNum = n;
            boolean bl = false;
            this.writeHeader(rowNum, (String)label, columns.size(), sheet);
        }
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, HEADER_NAMES.size() - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int j = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            sheet.getRow(j).getCell(0).setCellValue(HEADER_NAMES.get(j));
        }
        Row row = sheet.getRow(1);
        Intrinsics.checkNotNullExpressionValue((Object)row, (String)"getRow(...)");
        this.fillPredictionHeader(row, columns);
        Row row2 = sheet.getRow(2);
        Intrinsics.checkNotNullExpressionValue((Object)row2, (String)"getRow(...)");
        this.fillLabelHeader(row2, columns);
    }

    /*
     * WARNING - void declaration
     */
    private final void createRows(List<ML.Column> columns, Sheet sheet) {
        int rowNum = 0;
        rowNum = HEADERS.size();
        Iterable $this$forEachIndexed$iv = this.mlResultTable.getUrls();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void url;
            void $this$mapTo$iv$iv;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            Row row = sheet.createRow(rowNum);
            Iterable $this$map$iv = columns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object v0;
                Collection collection;
                block4: {
                    void it;
                    ML.Column column2 = (ML.Column)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$firstOrNull$iv = it.getCells();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ML.Record it2 = (ML.Record)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2.getUrl(), (Object)url)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                collection.add(v0);
            }
            List records = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)row);
            this.writeRow(i + 1, (String)url, row, records);
            ++rowNum;
        }
    }

    private final void writeHeader2(int rowNum, String label, int columnCount, Sheet sheet) {
        Row row = sheet.createRow(rowNum);
        row.createCell(0).setCellValue("ID");
        int k = 0;
        for (int j = 0; j < columnCount; ++j) {
            if (k % this.columnsPerURL == 0) {
                Object value = j == 0 ? "URL" : "URL" + k;
                row.createCell(++k).setCellValue((String)value);
            }
            row.createCell(++k).setCellValue(label + k);
        }
    }

    private final void fillPredictionHeader(Row predictionRow, List<ML.Column> columns) {
        if (predictionRow.getLastCellNum() != columns.size()) {
            this.logger.info("The cluster ID row does not match the columns.");
        }
        int n = predictionRow.getLastCellNum();
        for (int j = 2; j < n; ++j) {
            String value = predictionRow.getCell(j).getStringCellValue();
            Intrinsics.checkNotNull((Object)value);
            CharSequence charSequence = value;
            if (!new Regex("C\\d+").matches(charSequence)) continue;
            int prediction = columns.get(j - 2).getPrediction();
            predictionRow.getCell(j).setCellValue("C" + prediction);
        }
    }

    private final void fillLabelHeader(Row labelRow, List<ML.Column> columns) {
        if (labelRow.getLastCellNum() != columns.size()) {
            this.logger.info("The label row does not match the columns.");
        }
        int n = labelRow.getLastCellNum();
        for (int j = 2; j < n; ++j) {
            String label;
            String value = labelRow.getCell(j).getStringCellValue();
            Intrinsics.checkNotNull((Object)value);
            CharSequence charSequence = value;
            if (!new Regex("L\\d+").matches(charSequence) || !(!StringsKt.isBlank((CharSequence)(label = columns.get(j - 2).getLabel())))) continue;
            labelRow.getCell(j).setCellValue(label);
        }
    }

    private final void writeRow(int id, String url, Row row, List<ML.Record> records) {
        row.createCell(0).setCellValue(String.valueOf(id));
        row.createCell(1).setCellValue(url);
        int columnCount = records.size();
        for (int j = 2; j < columnCount; ++j) {
            ML.Record record = records.get(j - 2);
            Object object = record;
            if (object == null || (object = ((ML.Record)object).getText()) == null) {
                object = "";
            }
            Object text = object;
            row.createCell(j).setCellValue((String)text);
        }
    }

    private final void writeRow2(int id, String url, Row row, List<ML.Record> records) {
        row.createCell(0).setCellValue(String.valueOf(id));
        int columnCount = records.size();
        int k = 0;
        for (int j = 0; j < columnCount; ++j) {
            Object object;
            ML.Record record = records.get(j);
            if (k % this.columnsPerURL == 0) {
                row.createCell(++k).setCellValue(url);
            }
            if ((object = record) == null || (object = ((ML.Record)object).getText()) == null) {
                object = "";
            }
            Object text = object;
            row.createCell(++k).setCellValue((String)text);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"\n"};
        HEADER_DESCRIPTIONS = StringsKt.split$default((CharSequence)"HEADER:H\nCLUSTER_ID:C\nLABEL:L\nEXPERT_LABEL:E\nREVISED_LABEL:RE\nFORMAT_ANALYSIS:FA\nCONTENT_ANALYSIS:CA\nCONTEXT_VERIFICATION:CV\nOTHER_ANALYSIS:OA\nCLUSTER_ID_VERIFY:CIV\nSAMPLE:S", (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$map$iv = HEADER_DESCRIPTIONS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringBefore$default((String)it, (String)":", null, (int)2, null));
        }
        HEADER_NAMES = (List)destination$iv$iv;
        $this$map$iv = HEADER_DESCRIPTIONS;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringAfter$default((String)it, (String)":", null, (int)2, null));
        }
        HEADERS = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lai/platon/scent/view/builder/ml/MLResultXLSXBuilder$Companion;", "", "()V", "HEADERS", "", "", "getHEADERS", "()Ljava/util/List;", "HEADER_DESCRIPTIONS", "getHEADER_DESCRIPTIONS", "HEADER_NAMES", "getHEADER_NAMES", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getHEADER_DESCRIPTIONS() {
            return HEADER_DESCRIPTIONS;
        }

        @NotNull
        public final List<String> getHEADER_NAMES() {
            return HEADER_NAMES;
        }

        @NotNull
        public final List<String> getHEADERS() {
            return HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

