/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.llm;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.llm.DatasetAnalysisLoader;
import ai.platon.scent.llm.DatasetAndAnalysis;
import ai.platon.scent.llm.local.LocalDataExpertAnswer;
import ai.platon.scent.llm.response.Analysis;
import ai.platon.scent.llm.response.DataExpertAnswerV4;
import ai.platon.scent.llm.response.NamingTaskV4;
import ai.platon.scent.ml.clustering.ClusteringProject;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/llm/DatasetAnalysisAssigner;", "", "()V", "logger", "Lorg/slf4j/Logger;", "fillExpertLabelRow", "", "sheet", "Lorg/apache/poi/xssf/usermodel/XSSFSheet;", "analysis", "", "Lai/platon/scent/llm/local/LocalDataExpertAnswer;", "loadAndAssignExpertAnalysis", "Lai/platon/scent/llm/DatasetAndAnalysis;", "datasetFile", "Ljava/io/File;", "answerBaseDir", "Ljava/nio/file/Path;", "loadDatasetAndAnalysis", "refineDataAnalysis", "analysisList", "setCellValue", "i", "", "j", "value", "", "scent-build"})
@SourceDebugExtension(value={"SMAP\nDatasetAnalysisAssigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasetAnalysisAssigner.kt\nai/platon/scent/llm/DatasetAnalysisAssigner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,219:1\n1477#2:220\n1502#2,3:221\n1505#2,3:231\n1864#2,3:234\n1194#2,2:237\n1222#2,4:239\n372#3,7:224\n*S KotlinDebug\n*F\n+ 1 DatasetAnalysisAssigner.kt\nai/platon/scent/llm/DatasetAnalysisAssigner\n*L\n119#1:220\n119#1:221,3\n119#1:231,3\n122#1:234,3\n162#1:237,2\n162#1:239,4\n119#1:224,7\n*E\n"})
public final class DatasetAnalysisAssigner {
    @NotNull
    private final Logger logger = LogsKt.getLogger((Object)this);

    @NotNull
    public final DatasetAndAnalysis loadDatasetAndAnalysis(@NotNull Path datasetFile, @NotNull Path answerBaseDir) throws IllegalArgumentException, FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)datasetFile, (String)"datasetFile");
        Intrinsics.checkNotNullParameter((Object)answerBaseDir, (String)"answerBaseDir");
        if (!Files.exists(datasetFile, new LinkOption[0])) {
            throw new FileNotFoundException("The dataset file does not exist.");
        }
        if (!Files.exists(answerBaseDir, new LinkOption[0])) {
            throw new FileNotFoundException("The answer base directory does not exist.");
        }
        if (PathsKt.listDirectoryEntries((Path)answerBaseDir, (String)"*answer*").isEmpty()) {
            throw new FileNotFoundException("The answer base directory does not contain any answer file | " + answerBaseDir);
        }
        if (!Intrinsics.areEqual((Object)PathsKt.getExtension((Path)datasetFile), (Object)"xlsx")) {
            throw new IllegalArgumentException("The dataset file must be in XLSX format.");
        }
        ClusteringProject project = ClusteringProject.Companion.fromPath(answerBaseDir);
        DatasetAnalysisLoader answerLoader = new DatasetAnalysisLoader(project.getId(), answerBaseDir, datasetFile);
        XSSFWorkbook workbook = answerLoader.loadClusteringResultXLSXView();
        List<LocalDataExpertAnswer> answers = answerLoader.loadLocalDataExpertAnswers();
        if (answers.isEmpty()) {
            this.logger.warn("No data expert answer loaded in expected directory | {}", (Object)answerBaseDir);
            return new DatasetAndAnalysis(workbook, CollectionsKt.emptyList());
        }
        this.logger.info("{} data expert answer loaded | {}", (Object)answers.size(), (Object)answerBaseDir);
        this.logger.info("Clustering result XLSX view loaded form {}", (Object)datasetFile);
        return new DatasetAndAnalysis(workbook, answers);
    }

    @NotNull
    public final DatasetAndAnalysis loadAndAssignExpertAnalysis(@NotNull File datasetFile, @NotNull File answerBaseDir) throws IllegalArgumentException, FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)datasetFile, (String)"datasetFile");
        Intrinsics.checkNotNullParameter((Object)answerBaseDir, (String)"answerBaseDir");
        Path path = datasetFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = answerBaseDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return this.loadAndAssignExpertAnalysis(path, path2);
    }

    @NotNull
    public final DatasetAndAnalysis loadAndAssignExpertAnalysis(@NotNull Path datasetFile, @NotNull Path answerBaseDir) throws IllegalArgumentException, FileNotFoundException {
        Intrinsics.checkNotNullParameter((Object)datasetFile, (String)"datasetFile");
        Intrinsics.checkNotNullParameter((Object)answerBaseDir, (String)"answerBaseDir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(answerBaseDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileNotFoundException("The answer base directory does not exist | " + answerBaseDir);
        }
        if (PathsKt.listDirectoryEntries((Path)answerBaseDir, (String)"*answer*").isEmpty()) {
            throw new FileNotFoundException("The answer base directory does not contain any answer file | " + answerBaseDir);
        }
        DatasetAndAnalysis datasetAndAnalysis = this.loadDatasetAndAnalysis(datasetFile, answerBaseDir);
        XSSFWorkbook dataset = datasetAndAnalysis.component1();
        List<LocalDataExpertAnswer> analysis = datasetAndAnalysis.component2();
        if (analysis.isEmpty()) {
            return datasetAndAnalysis;
        }
        XSSFSheet sheet = dataset.getSheetAt(0);
        Intrinsics.checkNotNull((Object)sheet);
        this.fillExpertLabelRow(sheet, analysis);
        return datasetAndAnalysis;
    }

    /*
     * WARNING - void declaration
     */
    public final void refineDataAnalysis(@NotNull List<LocalDataExpertAnswer> analysisList) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(analysisList, (String)"analysisList");
        Iterable $this$groupBy$iv = analysisList;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            LocalDataExpertAnswer it = (LocalDataExpertAnswer)element$iv$iv;
            boolean bl = false;
            Object object2 = it.getAnswer();
            if (object2 == null || (object2 = ((DataExpertAnswerV4)object2).getNamingTask()) == null || (object2 = ((NamingTaskV4)object2).getFieldName()) == null) {
                object2 = ".";
            }
            Object key$iv$iv = object2;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map fieldNameMap = destination$iv$iv;
        for (Map.Entry entry : fieldNameMap.entrySet()) {
            String fieldName = (String)entry.getKey();
            List answers = (List)entry.getValue();
            if (answers.size() <= 1) continue;
            Iterable $this$forEachIndexed$iv = answers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void answer;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                $this$getOrPut$iv$iv$iv = (LocalDataExpertAnswer)item$iv;
                int i = n;
                boolean bl = false;
                DataExpertAnswerV4 dataExpertAnswerV4 = answer.getAnswer();
                NamingTaskV4 namingTaskV4 = dataExpertAnswerV4 != null ? dataExpertAnswerV4.getNamingTask() : null;
                if (namingTaskV4 == null) continue;
                namingTaskV4.setFieldName(fieldName + (i + 1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fillExpertLabelRow(XSSFSheet sheet, List<LocalDataExpertAnswer> analysis) {
        XSSFRow xSSFRow;
        XSSFRow xSSFRow2;
        XSSFRow predictionRow;
        void $this$associateByTo$iv$iv;
        if (analysis.isEmpty()) {
            this.logger.warn("The answers are empty.");
            return;
        }
        XSSFRow headerRow = sheet.getRow(0);
        if (headerRow == null) {
            this.logger.warn("The header row is missing in the XLSX sheet.");
            return;
        }
        this.refineDataAnalysis(analysis);
        int columnCount = headerRow.getLastCellNum();
        Iterable $this$associateBy$iv = analysis;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LocalDataExpertAnswer localDataExpertAnswer = (LocalDataExpertAnswer)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getAnswerFile().getPrediction(), element$iv$iv);
        }
        Map groupedAnalysis = destination$iv$iv;
        XSSFRow xSSFRow3 = sheet.getRow(1);
        if (xSSFRow3 == null) {
            xSSFRow3 = predictionRow = sheet.createRow(1);
        }
        if ((xSSFRow2 = sheet.getRow(2)) == null) {
            XSSFRow labelRow;
            xSSFRow2 = labelRow = sheet.createRow(2);
        }
        if ((xSSFRow = sheet.getRow(3)) == null) {
            xSSFRow = sheet.createRow(3);
        }
        XSSFRow expertLabelRow = xSSFRow;
        int n = columnCount;
        for (int j = 2; j < n; ++j) {
            Object metaData;
            String string;
            Object object;
            Object otherAnalysis;
            Object object2;
            Object contextVerification;
            Object object3;
            Object formatAnalysis;
            Object object4;
            Object contentAnalysis;
            Object object5;
            Object sample0;
            Object object6;
            Object fieldName;
            XSSFCell xSSFCell = predictionRow.getCell(j);
            if (xSSFCell == null) {
                xSSFCell = predictionRow.createCell(j);
            }
            XSSFCell predictionCell = xSSFCell;
            String string2 = predictionCell.getStringCellValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStringCellValue(...)");
            Object object7 = StringsKt.toIntOrNull((String)StringsKt.substringAfter$default((String)string2, (String)"C", null, (int)2, null));
            if (object7 == null) {
                object7 = "-1";
            }
            Integer prediction = object7;
            LocalDataExpertAnswer localDataExpertAnswer = (LocalDataExpertAnswer)groupedAnalysis.get(prediction);
            DataExpertAnswerV4 answer = localDataExpertAnswer != null ? localDataExpertAnswer.getAnswer() : null;
            Object object8 = answer;
            if (object8 == null || (object8 = ((DataExpertAnswerV4)object8).getNamingTask()) == null || (object8 = ((NamingTaskV4)object8).getFieldName()) == null) {
                object8 = fieldName = ".";
            }
            if ((object6 = answer) == null || (object6 = ((DataExpertAnswerV4)object6).getSamples()) == null || (object6 = (String)CollectionsKt.getOrNull((List)object6, (int)0)) == null || (object6 = StringsKt.substringAfter$default((String)object6, (String)":", null, (int)2, null)) == null) {
                object6 = sample0 = "";
            }
            if ((object5 = answer) == null || (object5 = ((DataExpertAnswerV4)object5).getNamingTask()) == null || (object5 = ((NamingTaskV4)object5).getAnalysis()) == null || (object5 = ((Analysis)object5).getContentAnalysis()) == null) {
                object5 = contentAnalysis = ".";
            }
            if ((object4 = answer) == null || (object4 = ((DataExpertAnswerV4)object4).getNamingTask()) == null || (object4 = ((NamingTaskV4)object4).getAnalysis()) == null || (object4 = ((Analysis)object4).getFormatAnalysis()) == null) {
                object4 = formatAnalysis = ".";
            }
            if ((object3 = answer) == null || (object3 = ((DataExpertAnswerV4)object3).getNamingTask()) == null || (object3 = ((NamingTaskV4)object3).getAnalysis()) == null || (object3 = ((Analysis)object3).getContextVerification()) == null) {
                object3 = contextVerification = ".";
            }
            if ((object2 = answer) == null || (object2 = ((DataExpertAnswerV4)object2).getNamingTask()) == null || (object2 = ((NamingTaskV4)object2).getAnalysis()) == null || (object2 = ((Analysis)object2).getOtherAnalysis()) == null) {
                object2 = otherAnalysis = ".";
            }
            if ((object = answer) == null || (object = ((DataExpertAnswerV4)object).getMetadata()) == null) {
                object = MapsKt.emptyMap();
            }
            if ((string = (String)(metaData = object).get("prediction")) == null) {
                string = "N/A";
            }
            String verifyingPrediction = string;
            this.setCellValue(sheet, 3, j, (String)fieldName);
            this.setCellValue(sheet, 4, j, (String)fieldName);
            this.setCellValue(sheet, 5, j, (String)contentAnalysis);
            this.setCellValue(sheet, 6, j, (String)formatAnalysis);
            this.setCellValue(sheet, 7, j, (String)contextVerification);
            this.setCellValue(sheet, 8, j, (String)otherAnalysis);
            this.setCellValue(sheet, 9, j, verifyingPrediction);
            this.setCellValue(sheet, 10, j, (String)sample0);
        }
    }

    private final void setCellValue(XSSFSheet sheet, int i, int j, String value) {
        block2: {
            String firstValue;
            String string;
            XSSFRow xSSFRow = sheet.getRow(i);
            if ((xSSFRow != null && (xSSFRow = xSSFRow.getCell(0)) != null ? xSSFRow.getStringCellValue() : (string = null)) == null) {
                string = "";
            }
            if (StringUtils.isNumeric((CharSequence)(firstValue = string))) {
                return;
            }
            XSSFRow xSSFRow2 = sheet.getRow(i);
            if (xSSFRow2 == null || (xSSFRow2 = xSSFRow2.getCell(j)) == null) break block2;
            xSSFRow2.setCellValue(value);
        }
    }
}

