/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.Frequency;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.math.geometric.GeometricsKt;
import ai.platon.scent.ml.ML;
import ai.platon.scent.ml.MLResultLoader;
import ai.platon.scent.ml.MLResultTable;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H&J\b\u0010#\u001a\u00020\u001eH\u0002J/\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110%H\u0000\u00a2\u0006\u0002\b)J\u001d\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020&H\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u000200H&J\u0016\u00101\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030%H\u0014J\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u000203H\u0004R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R)\u0010\u0019\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001a0\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014\u00a8\u00066"}, d2={"Lai/platon/scent/ml/MLResultLoader;", "", "()V", "format", "Lorg/apache/commons/csv/CSVFormat;", "getFormat", "()Lorg/apache/commons/csv/CSVFormat;", "headerNames", "", "", "getHeaderNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "predictionToColumns", "", "", "Lai/platon/scent/ml/ML$Column;", "getPredictionToColumns", "()Ljava/util/Map;", "predictions", "Lai/platon/pulsar/common/Frequency;", "getPredictions", "()Lai/platon/pulsar/common/Frequency;", "urlToRecords", "Lai/platon/scent/ml/ML$Record;", "getUrlToRecords", "buildCSVFormat", "buildColumnBidiList", "", "buildPredictionToColumnIndex", "buildRows", "csvParser", "Lorg/apache/commons/csv/CSVParser;", "divideCellsInToBlocks", "generateTestBlocks", "", "Ljava/awt/Rectangle;", "xs", "ys", "generateTestBlocks$scent_build", "isIntersected", "", "block", "cellRectangle", "isIntersected$scent_build", "load", "Lai/platon/scent/ml/MLResultTable;", "loadAllCSV", "csvPaths", "Ljava/nio/file/Path;", "loadCSV", "csvPath", "scent-build"})
@SourceDebugExtension(value={"SMAP\nMLResultLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLResultLoader.kt\nai/platon/scent/ml/MLResultLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,235:1\n1855#2,2:236\n1549#2:238\n1620#2,3:239\n766#2:242\n857#2,2:243\n1477#2:246\n1502#2,3:247\n1505#2,3:257\n1477#2:260\n1502#2,3:261\n1505#2,3:271\n1549#2:274\n1620#2,3:275\n1549#2:278\n1620#2,3:279\n766#2:296\n857#2:297\n2624#2,3:298\n858#2:301\n1855#2:302\n1864#2,3:303\n1856#2:306\n1045#2:307\n1864#2,3:308\n1855#2:311\n1855#2,2:312\n1856#2:316\n1#3:245\n372#4,7:250\n372#4,7:264\n526#4:282\n511#4,6:283\n526#4:289\n511#4,6:290\n215#5,2:314\n*S KotlinDebug\n*F\n+ 1 MLResultLoader.kt\nai/platon/scent/ml/MLResultLoader\n*L\n44#1:236,2\n93#1:238\n93#1:239,3\n93#1:242\n93#1:243,2\n97#1:246\n97#1:247,3\n97#1:257,3\n98#1:260\n98#1:261,3\n98#1:271,3\n99#1:274\n99#1:275,3\n100#1:278\n100#1:279,3\n127#1:296\n127#1:297\n127#1:298,3\n127#1:301\n131#1:302\n132#1:303,3\n131#1:306\n177#1:307\n178#1:308,3\n185#1:311\n186#1:312,2\n185#1:316\n97#1:250,7\n98#1:264,7\n103#1:282\n103#1:283,6\n109#1:289\n109#1:290,6\n190#1:314,2\n*E\n"})
public abstract class MLResultLoader {
    @NotNull
    private final Logger logger = LogsKt.getLogger((Object)this);
    @NotNull
    private final Map<String, Map<Integer, ML.Record>> urlToRecords = new LinkedHashMap();
    @NotNull
    private final Map<Integer, ML.Column> predictionToColumns = new LinkedHashMap();
    @NotNull
    private final Frequency<Integer> predictions = new Frequency(null, 1, null);
    @NotNull
    private final String[] headerNames = ML.Record.Companion.getFIELD_NAMES();

    @NotNull
    public final Map<String, Map<Integer, ML.Record>> getUrlToRecords() {
        return this.urlToRecords;
    }

    @NotNull
    public final Map<Integer, ML.Column> getPredictionToColumns() {
        return this.predictionToColumns;
    }

    @NotNull
    public final Frequency<Integer> getPredictions() {
        return this.predictions;
    }

    @NotNull
    public String[] getHeaderNames() {
        return this.headerNames;
    }

    @NotNull
    public CSVFormat getFormat() {
        return this.buildCSVFormat();
    }

    @NotNull
    public abstract MLResultTable load();

    protected void loadAllCSV(@NotNull List<? extends Path> csvPaths2) throws IOException {
        Intrinsics.checkNotNullParameter(csvPaths2, (String)"csvPaths");
        if (csvPaths2.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = csvPaths2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)((Object)path).toString(), (String)".csv", (boolean)false, (int)2, null)) continue;
            this.loadCSV(path);
        }
        this.buildColumnBidiList();
    }

    protected final void loadCSV(@NotNull Path csvPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)csvPath, (String)"csvPath");
        File csvFile = new File(csvPath.toUri());
        if (!csvFile.exists()) {
            return;
        }
        this.logger.info("Loading CSV file | {}", (Object)csvPath);
        CSVParser csvParser = new CSVParser((Reader)new FileReader(csvFile), this.getFormat());
        this.buildRows(csvParser);
        this.buildPredictionToColumnIndex();
    }

    public abstract void buildRows(@NotNull CSVParser var1);

    /*
     * WARNING - void declaration
     */
    private final void divideCellsInToBlocks() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        Iterator $this$filterTo$iv$iv4;
        Rectangle it;
        Collection collection;
        Iterable $this$mapTo$iv$iv3;
        if (this.urlToRecords.isEmpty()) {
            return;
        }
        Collection cells2 = ((Map)CollectionsKt.first((Iterable)this.urlToRecords.values())).values();
        if (cells2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = cells2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            ML.Record record = (ML.Record)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ML.Record)((Object)it)).getRectangle());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv3 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv4.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            it = (Rectangle)element$iv$iv;
            boolean bl = false;
            if (!(it.width <= 400 && it.height <= 400)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List testCellRectangles = (List)destination$iv$iv;
        $this$filterTo$iv$iv4 = ((Iterable)cells2).iterator();
        if (!$this$filterTo$iv$iv4.hasNext()) {
            throw new NoSuchElementException();
        }
        ML.Record it422 = (ML.Record)$this$filterTo$iv$iv4.next();
        boolean bl = false;
        float it422 = it422.getRight();
        while ($this$filterTo$iv$iv4.hasNext()) {
            ML.Record it32 = (ML.Record)$this$filterTo$iv$iv4.next();
            $i$a$-maxOf-MLResultLoader$divideCellsInToBlocks$maxRight$1 = false;
            float it32 = it32.getRight();
            it422 = Math.max(it422, it32);
        }
        float maxRight = it422 + 1.0f;
        Iterator it422 = ((Iterable)cells2).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        ML.Record it22 = (ML.Record)it422.next();
        boolean bl2 = false;
        float it22 = it22.getBottom();
        while (it422.hasNext()) {
            ML.Record it52 = (ML.Record)it422.next();
            $i$a$-maxOf-MLResultLoader$divideCellsInToBlocks$maxBottom$1 = false;
            float it52 = it52.getBottom();
            it22 = Math.max(it22, it52);
        }
        float maxBottom = it22 + 1.0f;
        Iterable $this$groupBy$iv = cells2;
        boolean $i$f$groupBy = false;
        Iterable it52 = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            ML.Record it3 = (ML.Record)element$iv$iv;
            boolean bl3 = false;
            Integer key$iv$iv = ML.Record.Companion.alignY(it3.getY(), 2);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map horizontalCollinearCells = destination$iv$iv2;
        Iterable $this$groupBy$iv2 = cells2;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv2 = $this$groupBy$iv2;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ML.Record it5 = (ML.Record)element$iv$iv;
            boolean bl5 = false;
            Integer key$iv$iv = ML.Record.Companion.alignX(it5.getX(), 2);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map verticalCollinearCells = destination$iv$iv3;
        Iterable $this$map$iv2 = horizontalCollinearCells.values();
        boolean $i$f$map2 = false;
        destination$iv$iv3 = $this$map$iv2;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it6;
            List bl5 = (List)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl7 = false;
            collection.add(it6.size());
        }
        List horizontalLineSizes = CollectionsKt.take((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv4)), (int)5);
        Iterable $this$map$iv3 = verticalCollinearCells.values();
        boolean $i$f$map3 = false;
        destination$iv$iv4 = $this$map$iv3;
        Object destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it7;
            List bl7 = (List)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl8 = false;
            collection.add(it7.size());
        }
        List verticalLineSizes = CollectionsKt.take((Iterable)CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv5)), (int)5);
        Map $this$filter$iv2 = horizontalCollinearCells;
        boolean $i$f$filter2 = false;
        destination$iv$iv5 = $this$filter$iv2;
        Map destination$iv$iv6 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator item$iv$iv = $this$filterTo$iv$iv3.entrySet().iterator();
        while (item$iv$iv.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it8 = element$iv$iv = item$iv$iv.next();
            boolean bl9 = false;
            if (!(((List)it8.getValue()).size() >= ((Number)CollectionsKt.last((List)horizontalLineSizes)).intValue())) continue;
            destination$iv$iv6.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        List horizontalLines = CollectionsKt.toMutableList((Collection)destination$iv$iv6.keySet());
        horizontalLines.add(0);
        horizontalLines.add((int)maxRight);
        CollectionsKt.sort((List)horizontalLines);
        Map $this$filter$iv3 = verticalCollinearCells;
        boolean $i$f$filter222 = false;
        destination$iv$iv6 = $this$filter$iv3;
        Map destination$iv$iv7 = new LinkedHashMap();
        boolean $i$f$filterTo222 = false;
        Iterator element$iv$iv = $this$filterTo$iv$iv2.entrySet().iterator();
        while (element$iv$iv.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it9 = element$iv$iv2 = element$iv$iv.next();
            boolean bl10 = false;
            if (!(((List)it9.getValue()).size() >= ((Number)CollectionsKt.last((List)verticalLineSizes)).intValue())) continue;
            destination$iv$iv7.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        List verticalLines = CollectionsKt.toMutableList((Collection)destination$iv$iv7.keySet());
        verticalLines.add(0);
        verticalLines.add((int)maxBottom);
        CollectionsKt.sort((List)verticalLines);
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)horizontalLineSizes, null, null, null, (int)0, null, null, (int)63, null));
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)horizontalLines, null, null, null, (int)0, null, null, (int)63, null));
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)verticalLineSizes, null, null, null, (int)0, null, null, (int)63, null));
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)verticalLines, null, null, null, (int)0, null, null, (int)63, null));
        List<Rectangle> testBlocks = this.generateTestBlocks$scent_build(verticalLines, horizontalLines);
        Object[] $i$f$filter222 = new Object[]{horizontalLines.size(), verticalLines.size(), testBlocks.size(), cells2.size()};
        this.logger.info("Total {} horizontal lines and {} vertical lines, {} test blocks for {} cells", $i$f$filter222);
        Iterable $this$filter$iv4 = testBlocks;
        boolean $i$f$filter3 = false;
        Iterable $i$f$filterTo222 = $this$filter$iv4;
        Collection destination$iv$iv8 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            boolean bl11;
            block25: {
                Rectangle block = (Rectangle)element$iv$iv3;
                boolean bl12 = false;
                Iterable $this$none$iv = testCellRectangles;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl11 = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        Rectangle it10 = (Rectangle)element$iv2;
                        boolean bl13 = false;
                        if (!it10.intersects(block)) continue;
                        bl11 = false;
                        break block25;
                    }
                    bl11 = true;
                }
            }
            if (!bl11) continue;
            destination$iv$iv8.add(element$iv$iv3);
        }
        List blocks = (List)destination$iv$iv8;
        this.logger.info("Total {} blocks. {}", (Object)blocks.size(), (Object)CollectionsKt.joinToString$default((Iterable)blocks, (CharSequence)", ", null, null, (int)0, null, (Function1)divideCellsInToBlocks.1.INSTANCE, (int)30, null));
        Iterable $this$forEach$iv = cells2;
        boolean $i$f$forEach = false;
        block12: for (Object element$iv : $this$forEach$iv) {
            ML.Record cell = (ML.Record)element$iv;
            boolean bl14 = false;
            Iterable $this$forEachIndexed$iv = blocks;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void block;
                int n;
                Object element$iv2;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv2 = (Rectangle)item$iv;
                int i = n;
                boolean bl15 = false;
                if (!block.contains(cell.getRectangle())) continue;
                cell.setBlock(1 + i);
                continue block12;
            }
        }
    }

    public final boolean isIntersected$scent_build(@NotNull Rectangle block, @NotNull Rectangle cellRectangle) {
        boolean intersected;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)cellRectangle, (String)"cellRectangle");
        Rectangle intersection = block.intersection(cellRectangle);
        boolean bl = intersected = intersection.width >= 5 && intersection.height >= 5;
        if (intersected) {
            // empty if block
        }
        return intersected;
    }

    @NotNull
    public final List<Rectangle> generateTestBlocks$scent_build(@NotNull List<Integer> xs, @NotNull List<Integer> ys) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        List rects = new ArrayList();
        int n = xs.size() - 1;
        for (int i = 0; i < n; ++i) {
            int x1 = ((Number)xs.get(i)).intValue();
            int n2 = xs.size();
            for (int i2 = i; i2 < n2; ++i2) {
                int x2 = ((Number)xs.get(i2)).intValue();
                int n3 = ys.size() - 1;
                for (int j = 0; j < n3; ++j) {
                    int y1 = ((Number)ys.get(j)).intValue();
                    int n4 = ys.size();
                    for (int j2 = j; j2 < n4; ++j2) {
                        int y2 = ((Number)ys.get(j2)).intValue();
                        Rectangle rect = new Rectangle(x1 - 1, y1 - 1, x2 - x1 + 1, y2 - y1 + 1);
                        if (rect.width < 100 || rect.height < 100 || GeometricsKt.getArea((Rectangle)rect) < 160000) continue;
                        rects.add(rect);
                    }
                }
            }
        }
        return rects;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildColumnBidiList() {
        Iterable $this$sortedBy$iv = this.predictionToColumns.values();
        boolean $i$f$sortedBy = false;
        List sortedColumns = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ML.Column it = (ML.Column)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOrder());
                it = (ML.Column)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOrder()));
            }
        });
        Iterable $this$forEachIndexed$iv = sortedColumns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ML.Column column3 = (ML.Column)item$iv;
            int j = n;
            boolean bl = false;
            column2.setPrevious((ML.Column)CollectionsKt.getOrNull((List)sortedColumns, (int)(j - 1)));
            column2.setNext((ML.Column)CollectionsKt.getOrNull((List)sortedColumns, (int)(j + 1)));
        }
    }

    private final void buildPredictionToColumnIndex() {
        Iterable $this$forEach$iv = this.urlToRecords.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv2;
            Map columns = (Map)element$iv;
            boolean bl = false;
            Object $this$forEach$iv2 = columns.values();
            boolean $i$f$forEach2 = false;
            Iterator<Object> iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv2 = iterator.next();
                ML.Record record = (ML.Record)element$iv2;
                boolean bl2 = false;
                this.predictions.add((Comparable)Integer.valueOf(record.getPrediction()));
            }
            $this$forEach$iv2 = columns;
            $i$f$forEach2 = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                ML.Column column2;
                Object object = element$iv2 = (Map.Entry)iterator.next();
                boolean bl3 = false;
                int prediction = ((Number)object.getKey()).intValue();
                ML.Record record = (ML.Record)object.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)this.predictionToColumns.computeIfAbsent(prediction, arg_0 -> MLResultLoader.buildPredictionToColumnIndex$lambda$20$lambda$19$lambda$18((Function1)new Function1<Integer, ML.Column>(prediction, record){
                    final /* synthetic */ int $prediction;
                    final /* synthetic */ ML.Record $record;
                    {
                        this.$prediction = $prediction;
                        this.$record = $record;
                        super(1);
                    }

                    @NotNull
                    public final ML.Column invoke(@NotNull Integer it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new ML.Column(this.$prediction, this.$record.getLabel(), new ArrayList<E>(), null, null, 24, null);
                    }
                }, arg_0)), (String)"computeIfAbsent(...)");
                column2.getCells().add(record);
            }
        }
    }

    private final CSVFormat buildCSVFormat() {
        CSVFormat.Builder builder = CSVFormat.ORACLE.builder();
        if (!(this.getHeaderNames().length == 0)) {
            String[] stringArray = this.getHeaderNames();
            builder.setHeader(Arrays.copyOf(stringArray, stringArray.length)).setSkipHeaderRecord(false);
        }
        CSVFormat cSVFormat = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)cSVFormat, (String)"build(...)");
        return cSVFormat;
    }

    private static final ML.Column buildPredictionToColumnIndex$lambda$20$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ML.Column)$tmp0.invoke(p0);
    }
}

