/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.classifier;

import ai.platon.scent.common.MLPaths;
import ai.platon.scent.ml.MLProject;
import ai.platon.scent.ml.classifier.ClassifierProject;
import ai.platon.scent.view.builder.ml.classifier.ClassifierResultViewsBuilder;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.file.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001cR\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\tR\u0019\u0010\u0015\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\tR\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0019\u0010\u0019\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\t\u00a8\u0006\""}, d2={"Lai/platon/scent/ml/classifier/ClassifierProject;", "", "id", "", "(Ljava/lang/String;)V", "classifierResultBaseDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getClassifierResultBaseDir", "()Ljava/nio/file/Path;", "getId", "()Ljava/lang/String;", "lazyViewBuilders", "", "Lai/platon/scent/view/builder/ml/classifier/ClassifierResultViewsBuilder;", "getLazyViewBuilders", "()Ljava/util/List;", "lazyViewBuilders$delegate", "Lkotlin/Lazy;", "modelDir", "getModelDir", "predictInfoFile", "getPredictInfoFile", "predictionAndMinimalFeaturesDirs", "getPredictionAndMinimalFeaturesDirs", "viewBuilderInfoFile", "getViewBuilderInfoFile", "buildViews", "", "rebuild", "", "hasNewerClassifierResult", "tryBuildViews", "Companion", "scent-build"})
@SourceDebugExtension(value={"SMAP\nClassifierProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierProject.kt\nai/platon/scent/ml/classifier/ClassifierProject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1855#2,2:162\n1855#2,2:164\n*S KotlinDebug\n*F\n+ 1 ClassifierProject.kt\nai/platon/scent/ml/classifier/ClassifierProject\n*L\n143#1:162,2\n156#1:164,2\n*E\n"})
public class ClassifierProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Lazy lazyViewBuilders$delegate;

    public ClassifierProject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.lazyViewBuilders$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ClassifierResultViewsBuilder>>(this){
            final /* synthetic */ ClassifierProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ClassifierResultViewsBuilder> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.this$0.getPredictionAndMinimalFeaturesDirs();
                ClassifierProject classifierProject = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ClassifierResultViewsBuilder(classifierProject.getId(), (Path)it, null, 4, null));
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private final List<ClassifierResultViewsBuilder> getLazyViewBuilders() {
        Lazy lazy = this.lazyViewBuilders$delegate;
        return (List)lazy.getValue();
    }

    public final Path getClassifierResultBaseDir() {
        return MLPaths.INSTANCE.getPredictionDatasetBaseDir().resolve(this.id);
    }

    public final Path getModelDir() {
        return this.getClassifierResultBaseDir().resolve("model");
    }

    public final Path getViewBuilderInfoFile() {
        return this.getClassifierResultBaseDir().resolve("viewBuilderInfo.txt");
    }

    public final Path getPredictInfoFile() {
        return this.getViewBuilderInfoFile().resolveSibling("predictInfo.txt");
    }

    @NotNull
    public final List<Path> getPredictionAndMinimalFeaturesDirs() {
        List<Object> list = Files.walk(this.getClassifierResultBaseDir(), new FileVisitOption[0]).filter(arg_0 -> ClassifierProject._get_predictionAndMinimalFeaturesDirs_$lambda$0(predictionAndMinimalFeaturesDirs.1.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    public final boolean hasNewerClassifierResult() {
        return Files.exists(this.getViewBuilderInfoFile(), new LinkOption[0]) && PathUtils.isNewer((Path)this.getPredictInfoFile(), (Path)this.getViewBuilderInfoFile());
    }

    public final void buildViews(boolean rebuild) {
        Iterable $this$forEach$iv = this.getLazyViewBuilders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifierResultViewsBuilder it = (ClassifierResultViewsBuilder)element$iv;
            boolean bl = false;
            it.build(rebuild);
        }
    }

    public static /* synthetic */ void buildViews$default(ClassifierProject classifierProject, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildViews");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        classifierProject.buildViews(bl);
    }

    public final void tryBuildViews() {
        Iterable $this$forEach$iv = this.getLazyViewBuilders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassifierResultViewsBuilder it = (ClassifierResultViewsBuilder)element$iv;
            boolean bl = false;
            it.tryBuild(false);
        }
    }

    private static final boolean _get_predictionAndMinimalFeaturesDirs_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/ml/classifier/ClassifierProject$Companion;", "", "()V", "fromFile", "Lai/platon/scent/ml/classifier/ClassifierProject;", "file", "Ljava/io/File;", "fromFileOrNull", "fromPath", "path", "Ljava/nio/file/Path;", "fromPathOrNull", "isWithinProjectDir", "", "lastProject", "lastProjectOrNull", "matches", "scent-build"})
    @SourceDebugExtension(value={"SMAP\nClassifierProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierProject.kt\nai/platon/scent/ml/classifier/ClassifierProject$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n766#2:162\n857#2,2:163\n766#2:165\n857#2,2:166\n1963#2,14:168\n*S KotlinDebug\n*F\n+ 1 ClassifierProject.kt\nai/platon/scent/ml/classifier/ClassifierProject$Companion\n*L\n75#1:162\n75#1:163,2\n76#1:165\n76#1:166,2\n77#1:168,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassifierProject fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            return this.fromPath(path);
        }

        @Nullable
        public final ClassifierProject fromFileOrNull(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            return this.fromPathOrNull(path);
        }

        @NotNull
        public final ClassifierProject fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            ClassifierProject classifierProject = this.fromPathOrNull(path);
            if (classifierProject == null) {
                throw new IllegalArgumentException("No classifier project found | " + path);
            }
            return classifierProject;
        }

        @Nullable
        public final ClassifierProject fromPathOrNull(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String string = MLProject.Companion.findProjectId(path);
            if (string == null) {
                return null;
            }
            String projectId = string;
            return new ClassifierProject(projectId);
        }

        public final boolean isWithinProjectDir(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.fromPathOrNull(path) != null;
        }

        @NotNull
        public final ClassifierProject lastProject() {
            ClassifierProject classifierProject = this.lastProjectOrNull();
            if (classifierProject == null) {
                throw new IllegalArgumentException("No classifier project found");
            }
            return classifierProject;
        }

        @Nullable
        public final ClassifierProject lastProjectOrNull() {
            Path projectDir;
            Object v0;
            Path it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)MLPaths.INSTANCE.getPredictionDatasetBaseDir(), null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv;
                boolean bl = false;
                if (!Files.isDirectory(it, new LinkOption[0])) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv;
                boolean bl = false;
                if (!Companion.matches(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Path it2 = (Path)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = Files.getLastModifiedTime(it2, new LinkOption[0]);
                    do {
                        Object e$iv = iterator$iv.next();
                        Path it3 = (Path)e$iv;
                        $i$a$-maxByOrNull-ClassifierProject$Companion$lastProjectOrNull$projectDir$3 = false;
                        Comparable v$iv = Files.getLastModifiedTime(it3, new LinkOption[0]);
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Path path = projectDir = (Path)v0;
            return path != null ? this.fromPath(path) : null;
        }

        public final boolean matches(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence charSequence = string;
            return MLPaths.INSTANCE.getProjectBaseDirPattern().matches(charSequence);
        }

        public final boolean matches(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CharSequence charSequence = PathsKt.getName((Path)path);
            return MLPaths.INSTANCE.getProjectBaseDirPattern().matches(charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

