/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.clustering;

import ai.platon.scent.common.MLPaths;
import ai.platon.scent.ml.clustering.PromptFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aJ\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001e"}, d2={"Lai/platon/scent/ml/clustering/AnswerFile;", "", "projectId", "", "prediction", "", "label", "extension", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "fileName", "getFileName", "getLabel", "getPrediction", "()I", "getProjectId", "equals", "", "other", "getPromptFile", "Lai/platon/scent/ml/clustering/PromptFile;", "hashCode", "toFile", "Ljava/io/File;", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "toString", "Companion", "scent-build"})
public final class AnswerFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectId;
    private final int prediction;
    @NotNull
    private final String label;
    @NotNull
    private final String extension;
    @NotNull
    private final String fileName;
    @NotNull
    public static final String EXAMPLE_STRING = "prompt.p1723201624.0.excellent.answer.json";
    @NotNull
    private static final AnswerFile EXAMPLE = new AnswerFile("p1723201624", 0, "excellent", null, 8, null);
    @NotNull
    private static final Regex PATTERN = MLPaths.INSTANCE.getAnswerFileNamePattern();

    public AnswerFile(@NotNull String projectId, int prediction, @NotNull String label, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.projectId = projectId;
        this.prediction = prediction;
        this.label = label;
        this.extension = extension;
        this.fileName = StringsKt.replace$default((String)("prompt." + this.projectId + "." + this.prediction + "." + this.label + ".answer." + this.extension), (String)"..", (String)".", (boolean)false, (int)4, null);
    }

    public /* synthetic */ AnswerFile(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "json";
        }
        this(string, n, string2, string3);
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    public final int getPrediction() {
        return this.prediction;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final Path toPath() {
        return Path.of(this.fileName, new String[0]);
    }

    @NotNull
    public final File toFile() {
        return new File(this.fileName);
    }

    @NotNull
    public final PromptFile getPromptFile() {
        return new PromptFile(this.projectId, this.prediction, this.label, null, 8, null);
    }

    @NotNull
    public String toString() {
        return this.fileName;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof AnswerFile) ? false : (!Intrinsics.areEqual((Object)this.projectId, (Object)((AnswerFile)other).projectId) ? false : (this.prediction != ((AnswerFile)other).prediction ? false : (!Intrinsics.areEqual((Object)this.label, (Object)((AnswerFile)other).label) ? false : Intrinsics.areEqual((Object)this.extension, (Object)((AnswerFile)other).extension)))));
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = 31 * result + Integer.hashCode(this.prediction);
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/ml/clustering/AnswerFile$Companion;", "", "()V", "EXAMPLE", "Lai/platon/scent/ml/clustering/AnswerFile;", "getEXAMPLE", "()Lai/platon/scent/ml/clustering/AnswerFile;", "EXAMPLE_STRING", "", "PATTERN", "Lkotlin/text/Regex;", "getPATTERN", "()Lkotlin/text/Regex;", "fromFile", "file", "Ljava/io/File;", "fromFileName", "fileName", "fromPath", "path", "Ljava/nio/file/Path;", "matches", "", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnswerFile getEXAMPLE() {
            return EXAMPLE;
        }

        @NotNull
        public final Regex getPATTERN() {
            return PATTERN;
        }

        public final boolean matches(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Regex regex = this.getPATTERN();
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return regex.matches((CharSequence)string);
        }

        public final boolean matches(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return this.getPATTERN().matches((CharSequence)fileName);
        }

        @NotNull
        public final AnswerFile fromFile(@NotNull File file) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return this.fromFileName(string);
        }

        @NotNull
        public final AnswerFile fromPath(@NotNull Path path) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return this.fromFile(file);
        }

        @NotNull
        public final AnswerFile fromFileName(@NotNull String fileName) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            MatchResult matchResult = Regex.find$default((Regex)this.getPATTERN(), (CharSequence)fileName, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid file name: " + fileName);
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String clusteringProjectId = (String)destructured.getMatch().getGroupValues().get(1);
            String prediction = (String)destructured.getMatch().getGroupValues().get(2);
            String label = (String)destructured.getMatch().getGroupValues().get(3);
            String extension = (String)destructured.getMatch().getGroupValues().get(4);
            return new AnswerFile(clusteringProjectId, Integer.parseInt(prediction), label, extension);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

