/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.clustering;

import ai.platon.scent.common.MLPaths;
import ai.platon.scent.llm.DatasetAnalysisAssigner;
import ai.platon.scent.llm.DatasetAndAnalysis;
import ai.platon.scent.ml.MLResultTable;
import ai.platon.scent.ml.clustering.AnswerFile;
import ai.platon.scent.ml.clustering.ClusteringProjectException;
import ai.platon.scent.ml.clustering.PromptFile;
import ai.platon.scent.view.builder.ml.clustering.ClusteringResultViewsBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000b\b\u0016\u0018\u0000 K2\u00020\u0001:\u0004IJKLB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00102\u001a\u0002032\b\b\u0002\u00104\u001a\u000205J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0010\u00109\u001a\u00020\u00062\b\b\u0002\u0010:\u001a\u000205J\u0006\u0010;\u001a\u000207J\u0006\u0010<\u001a\u000207J\u0006\u0010=\u001a\u000207J\u0006\u0010>\u001a\u000207J\u0006\u0010?\u001a\u000207J \u0010@\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020\u0003J \u0010D\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020\u0003J\u0006\u0010E\u001a\u000205J\u0010\u0010F\u001a\u0002052\b\b\u0002\u0010:\u001a\u000205J\b\u0010G\u001a\u00020\u0003H\u0016J\u0012\u0010H\u001a\u0004\u0018\u0001032\b\b\u0002\u00104\u001a\u000205R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0019\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0019\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0019\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001c\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\tR\u0019\u0010\u001e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\tR\u0019\u0010 \u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\tR\u0019\u0010\"\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\tR\u0019\u0010$\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\tR\u0019\u0010&\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\tR\u0019\u0010(\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\tR\u0019\u0010*\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\tR\u0019\u0010,\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\tR\u0019\u0010.\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\tR\u0019\u00100\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\t\u00a8\u0006M"}, d2={"Lai/platon/scent/ml/clustering/ClusteringProject;", "", "id", "", "(Ljava/lang/String;)V", "baseDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getBaseDir", "()Ljava/nio/file/Path;", "builderInfoFile", "getBuilderInfoFile", "clusteringInfoFile", "getClusteringInfoFile", "clusteringResultBaseDir", "getClusteringResultBaseDir", "explainedXlsxViewPath", "getExplainedXlsxViewPath", "htmlViewPath", "getHtmlViewPath", "getId", "()Ljava/lang/String;", "lazyViewBuilder", "Lai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder;", "getLazyViewBuilder", "()Lai/platon/scent/view/builder/ml/clustering/ClusteringResultViewsBuilder;", "lazyViewBuilder$delegate", "Lkotlin/Lazy;", "predictionAndMinimalFeaturesDir", "getPredictionAndMinimalFeaturesDir", "promptAdditionalGuideFile", "getPromptAdditionalGuideFile", "promptInfoFile", "getPromptInfoFile", "promptRevisedViewBaseDir", "getPromptRevisedViewBaseDir", "promptTaskResultBaseDir", "getPromptTaskResultBaseDir", "promptTemplateFile", "getPromptTemplateFile", "promptViewBaseDir", "getPromptViewBaseDir", "revisedXlsxViewPath", "getRevisedXlsxViewPath", "viewBaseDir", "getViewBaseDir", "viewBuilderInfoFile", "getViewBuilderInfoFile", "xlsxViewPath", "getXlsxViewPath", "assignExpertAnalysis", "Lai/platon/scent/llm/DatasetAndAnalysis;", "write", "", "buildPromptViews", "", "buildRevisedEachColumnPromptView", "buildViews", "rebuild", "buildXSLXView", "buildXSLXViews", "copyPromptToAskLLM", "deletePromptViews", "deleteViewBaseDir", "getAnswerFile", "prediction", "", "label", "getPromptFile", "shouldAssignExpertAnalysis", "shouldBuildViews", "toString", "tryAssignExpertAnalysis", "Cluster", "ClusteringResult", "Companion", "DataExpertSuggestions", "scent-build"})
@SourceDebugExtension(value={"SMAP\nClusteringProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusteringProject.kt\nai/platon/scent/ml/clustering/ClusteringProject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1#2:328\n1855#3,2:329\n*S KotlinDebug\n*F\n+ 1 ClusteringProject.kt\nai/platon/scent/ml/clustering/ClusteringProject\n*L\n318#1:329,2\n*E\n"})
public class ClusteringProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Lazy lazyViewBuilder$delegate;
    private final Path explainedXlsxViewPath;

    public ClusteringProject(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.lazyViewBuilder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClusteringResultViewsBuilder>(this){
            final /* synthetic */ ClusteringProject this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ClusteringResultViewsBuilder invoke() {
                String string = this.this$0.getId();
                Path path = this.this$0.getPredictionAndMinimalFeaturesDir();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-predictionAndMinimalFeaturesDir>(...)");
                return new ClusteringResultViewsBuilder(string, path, this.this$0.getViewBaseDir(), 0, 8, null);
            }
        }));
        this.explainedXlsxViewPath = this.getViewBaseDir().resolve(this.id + ".explained.xlsx");
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private final ClusteringResultViewsBuilder getLazyViewBuilder() {
        Lazy lazy = this.lazyViewBuilder$delegate;
        return (ClusteringResultViewsBuilder)lazy.getValue();
    }

    public final Path getClusteringResultBaseDir() {
        return MLPaths.INSTANCE.getUnsupervisedTaskResultBaseDir().resolve(this.id);
    }

    public final Path getBaseDir() {
        return this.getClusteringResultBaseDir();
    }

    public final Path getClusteringInfoFile() {
        return this.getBaseDir().resolve("clusteringInfo.txt");
    }

    public final Path getViewBuilderInfoFile() {
        return this.getBaseDir().resolve("viewBuilderInfo.txt");
    }

    public final Path getPredictionAndMinimalFeaturesDir() {
        return this.getBaseDir().resolve("predictionAndMinimalFeatures");
    }

    public final Path getViewBaseDir() {
        return this.getBaseDir().resolve("predictionAndMinimalFeatures.views");
    }

    public final Path getHtmlViewPath() {
        return this.getViewBaseDir().resolve(this.id + ".html");
    }

    public final Path getXlsxViewPath() {
        return this.getViewBaseDir().resolve(this.id + ".xlsx");
    }

    public final Path getRevisedXlsxViewPath() {
        return this.getViewBaseDir().resolve(this.id + ".revised.xlsx");
    }

    public final Path getExplainedXlsxViewPath() {
        return this.explainedXlsxViewPath;
    }

    public final Path getPromptViewBaseDir() {
        return this.getViewBaseDir().resolve("prompts");
    }

    public final Path getPromptTemplateFile() {
        return this.getBaseDir().resolve("llm.prompt.template.txt");
    }

    public final Path getPromptAdditionalGuideFile() {
        return this.getBaseDir().resolve("llm.prompt.additional.guide.txt");
    }

    public final Path getPromptRevisedViewBaseDir() {
        return this.getViewBaseDir().resolve("prompts.revised");
    }

    public final Path getPromptTaskResultBaseDir() {
        return MLPaths.INSTANCE.getPromptTaskResultBaseDir().resolve(this.id);
    }

    public final Path getPromptInfoFile() {
        return this.getPromptViewBaseDir().resolveSibling("promptInfo.txt");
    }

    public final Path getBuilderInfoFile() {
        return this.getClusteringResultBaseDir().resolve("builderInfo.txt");
    }

    public final Path getPromptFile(int prediction, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.getPromptTaskResultBaseDir().resolve(new PromptFile(this.id, prediction, label, null, 8, null).getFileName());
    }

    public static /* synthetic */ Path getPromptFile$default(ClusteringProject clusteringProject, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPromptFile");
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        return clusteringProject.getPromptFile(n, string);
    }

    public final Path getAnswerFile(int prediction, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.getPromptTaskResultBaseDir().resolve(new AnswerFile(this.id, prediction, label, null, 8, null).getFileName());
    }

    public static /* synthetic */ Path getAnswerFile$default(ClusteringProject clusteringProject, int n, String string, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAnswerFile");
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        return clusteringProject.getAnswerFile(n, string);
    }

    public final void deleteViewBaseDir() throws IOException {
        Path path = this.getViewBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-viewBaseDir>(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileUtils.deleteDirectory((File)this.getViewBaseDir().toFile());
        }
    }

    public final boolean shouldBuildViews(boolean rebuild) {
        if (rebuild) {
            return true;
        }
        if (!Files.exists(this.getClusteringInfoFile(), new LinkOption[0])) {
            return false;
        }
        return !Files.exists(this.getViewBaseDir(), new LinkOption[0]);
    }

    public static /* synthetic */ boolean shouldBuildViews$default(ClusteringProject clusteringProject, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: shouldBuildViews");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return clusteringProject.shouldBuildViews(bl);
    }

    @NotNull
    public final Path buildViews(boolean rebuild) {
        return this.getLazyViewBuilder().build(rebuild);
    }

    public static /* synthetic */ Path buildViews$default(ClusteringProject clusteringProject, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildViews");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return clusteringProject.buildViews(bl);
    }

    public final void buildXSLXViews() {
        this.getLazyViewBuilder().buildXLSXViews();
    }

    public final void buildXSLXView() {
        ClusteringResultViewsBuilder clusteringResultViewsBuilder = this.getLazyViewBuilder();
        Path path = this.getXlsxViewPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-xlsxViewPath>(...)");
        clusteringResultViewsBuilder.buildXLSXView(MLResultTable.Filter.QUALIFIED, path);
    }

    public final void buildPromptViews() {
        ClusteringResultViewsBuilder clusteringResultViewsBuilder = this.getLazyViewBuilder();
        Path path = this.getPromptViewBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-promptViewBaseDir>(...)");
        clusteringResultViewsBuilder.buildPromptView(path);
    }

    public final void deletePromptViews() {
        FileUtils.deleteDirectory((File)this.getPromptViewBaseDir().toFile());
    }

    public final void buildRevisedEachColumnPromptView() {
        ClusteringResultViewsBuilder clusteringResultViewsBuilder = this.getLazyViewBuilder();
        Path path = this.getPromptRevisedViewBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-promptRevisedViewBaseDir>(...)");
        clusteringResultViewsBuilder.buildRevisedEachColumnPromptView(this.id, path);
    }

    public final boolean shouldAssignExpertAnalysis() {
        Path path = this.getPromptTaskResultBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-promptTaskResultBaseDir>(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return false;
        }
        Path path3 = this.getPromptTaskResultBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"<get-promptTaskResultBaseDir>(...)");
        if (PathsKt.listDirectoryEntries((Path)path3, (String)"*answer*").isEmpty()) {
            return false;
        }
        return Files.exists(this.getPromptInfoFile(), new LinkOption[0]) && Files.exists(this.getRevisedXlsxViewPath(), new LinkOption[0]) && !Files.exists(this.explainedXlsxViewPath, new LinkOption[0]);
    }

    @Nullable
    public final DatasetAndAnalysis tryAssignExpertAnalysis(boolean write) {
        if (this.shouldAssignExpertAnalysis()) {
            return ClusteringProject.assignExpertAnalysis$default(this, false, 1, null);
        }
        return null;
    }

    public static /* synthetic */ DatasetAndAnalysis tryAssignExpertAnalysis$default(ClusteringProject clusteringProject, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryAssignExpertAnalysis");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return clusteringProject.tryAssignExpertAnalysis(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DatasetAndAnalysis assignExpertAnalysis(boolean write) throws ClusteringProjectException {
        DatasetAnalysisAssigner applier = new DatasetAnalysisAssigner();
        try {
            Path path = this.getRevisedXlsxViewPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-revisedXlsxViewPath>(...)");
            Path path2 = this.getPromptTaskResultBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"<get-promptTaskResultBaseDir>(...)");
            DatasetAndAnalysis datasetAndAnalysis = applier.loadAndAssignExpertAnalysis(path, path2);
            if (datasetAndAnalysis.getAnalysis().isEmpty()) {
                return datasetAndAnalysis;
            }
            if (write) {
                Path xlsxOutputFile = this.explainedXlsxViewPath;
                Intrinsics.checkNotNull((Object)xlsxOutputFile);
                Path tempXLSXOutputFileName = xlsxOutputFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)xlsxOutputFile) + ".tmp.xlsx");
                CopyOption[] copyOptionArray = (CopyOption[])new FileOutputStream(tempXLSXOutputFileName.toFile());
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)copyOptionArray;
                    boolean bl = false;
                    datasetAndAnalysis.getDataset().write((OutputStream)it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
                }
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(tempXLSXOutputFileName, xlsxOutputFile, copyOptionArray);
            }
            return datasetAndAnalysis;
        }
        catch (FileNotFoundException e) {
            throw new ClusteringProjectException("The dataset file or the answer file does not exist.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ClusteringProjectException("The dataset file is not in XLSX format, or the answer file is not in JSON format.", e);
        }
    }

    public static /* synthetic */ DatasetAndAnalysis assignExpertAnalysis$default(ClusteringProject clusteringProject, boolean bl, int n, Object object) throws ClusteringProjectException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assignExpertAnalysis");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return clusteringProject.assignExpertAnalysis(bl);
    }

    public final void copyPromptToAskLLM() {
        Path path = this.getPromptViewBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-promptViewBaseDir>(...)");
        Iterable $this$forEach$iv = PathsKt.listDirectoryEntries((Path)path, (String)"prompt.*.txt");
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            MLPaths.INSTANCE.copyToPrompt(it);
        }
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/ml/clustering/ClusteringProject$Cluster;", "", "id", "", "(I)V", "getId", "()I", "scent-build"})
    public static final class Cluster {
        private final int id;

        public Cluster(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lai/platon/scent/ml/clustering/ClusteringProject$ClusteringResult;", "", "project", "Lai/platon/scent/ml/clustering/ClusteringProject;", "clusters", "", "Lai/platon/scent/ml/clustering/ClusteringProject$Cluster;", "(Lai/platon/scent/ml/clustering/ClusteringProject;Ljava/util/List;)V", "getClusters", "()Ljava/util/List;", "getProject", "()Lai/platon/scent/ml/clustering/ClusteringProject;", "scent-build"})
    public static final class ClusteringResult {
        @NotNull
        private final ClusteringProject project;
        @NotNull
        private final List<Cluster> clusters;

        public ClusteringResult(@NotNull ClusteringProject project, @NotNull List<Cluster> clusters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(clusters, (String)"clusters");
            this.project = project;
            this.clusters = clusters;
        }

        @NotNull
        public final ClusteringProject getProject() {
            return this.project;
        }

        @NotNull
        public final List<Cluster> getClusters() {
            return this.clusters;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0004J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/ml/clustering/ClusteringProject$Companion;", "", "()V", "fromFile", "Lai/platon/scent/ml/clustering/ClusteringProject;", "file", "Ljava/io/File;", "fromPath", "path", "Ljava/nio/file/Path;", "lastProject", "lastProjectOrNull", "matches", "", "scent-build"})
    @SourceDebugExtension(value={"SMAP\nClusteringProject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClusteringProject.kt\nai/platon/scent/ml/clustering/ClusteringProject$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n766#2:328\n857#2,2:329\n766#2:331\n857#2,2:332\n1963#2,14:334\n*S KotlinDebug\n*F\n+ 1 ClusteringProject.kt\nai/platon/scent/ml/clustering/ClusteringProject$Companion\n*L\n68#1:328\n68#1:329,2\n69#1:331\n69#1:332,2\n70#1:334,14\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClusteringProject fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new ClusteringProject(FilesKt.getNameWithoutExtension((File)file));
        }

        @NotNull
        public final ClusteringProject fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new ClusteringProject(((Object)path.getFileName()).toString());
        }

        @NotNull
        public final ClusteringProject lastProject() {
            ClusteringProject clusteringProject = this.lastProjectOrNull();
            if (clusteringProject == null) {
                throw new RuntimeException("No clustering project found.");
            }
            return clusteringProject;
        }

        @Nullable
        public final ClusteringProject lastProjectOrNull() {
            Path projectDir;
            Object v1;
            Path it;
            Iterable $this$filterTo$iv$iv;
            Path path = MLPaths.INSTANCE.getUnsupervisedTaskResultBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-unsupervisedTaskResultBaseDir>(...)");
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv;
                boolean bl = false;
                if (!Files.isDirectory(it, new LinkOption[0])) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv;
                boolean bl = false;
                if (!Companion.matches(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Path it2 = (Path)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = Files.getLastModifiedTime(it2, new LinkOption[0]);
                    do {
                        Object e$iv = iterator$iv.next();
                        Path it3 = (Path)e$iv;
                        $i$a$-maxByOrNull-ClusteringProject$Companion$lastProjectOrNull$projectDir$3 = false;
                        Comparable v$iv = Files.getLastModifiedTime(it3, new LinkOption[0]);
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Path path2 = projectDir = (Path)v1;
            return path2 != null ? this.fromPath(path2) : null;
        }

        public final boolean matches(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence charSequence = string;
            return MLPaths.INSTANCE.getProjectBaseDirPattern().matches(charSequence);
        }

        public final boolean matches(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            CharSequence charSequence = PathsKt.getName((Path)path);
            return MLPaths.INSTANCE.getProjectBaseDirPattern().matches(charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lai/platon/scent/ml/clustering/ClusteringProject$DataExpertSuggestions;", "", "project", "Lai/platon/scent/ml/clustering/ClusteringProject;", "culster", "Lai/platon/scent/ml/clustering/ClusteringProject$Cluster;", "suggestions", "", "", "(Lai/platon/scent/ml/clustering/ClusteringProject;Lai/platon/scent/ml/clustering/ClusteringProject$Cluster;Ljava/util/List;)V", "getCulster", "()Lai/platon/scent/ml/clustering/ClusteringProject$Cluster;", "getProject", "()Lai/platon/scent/ml/clustering/ClusteringProject;", "getSuggestions", "()Ljava/util/List;", "scent-build"})
    public static final class DataExpertSuggestions {
        @NotNull
        private final ClusteringProject project;
        @NotNull
        private final Cluster culster;
        @NotNull
        private final List<String> suggestions;

        public DataExpertSuggestions(@NotNull ClusteringProject project, @NotNull Cluster culster, @NotNull List<String> suggestions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)culster, (String)"culster");
            Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
            this.project = project;
            this.culster = culster;
            this.suggestions = suggestions;
        }

        @NotNull
        public final ClusteringProject getProject() {
            return this.project;
        }

        @NotNull
        public final Cluster getCulster() {
            return this.culster;
        }

        @NotNull
        public final List<String> getSuggestions() {
            return this.suggestions;
        }
    }
}

