/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml.clustering;

import ai.platon.scent.common.MLPaths;
import ai.platon.scent.ml.clustering.AnswerFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0005H\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fJ\b\u0010!\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006#"}, d2={"Lai/platon/scent/ml/clustering/PromptFile;", "", "projectId", "", "prediction", "", "label", "extension", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "fileName", "getFileName", "getLabel", "getPrediction", "()I", "getProjectId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getAnswerFile", "Lai/platon/scent/ml/clustering/AnswerFile;", "hashCode", "toFile", "Ljava/io/File;", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "toString", "Companion", "scent-build"})
public final class PromptFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectId;
    private final int prediction;
    @NotNull
    private final String label;
    @NotNull
    private final String extension;
    @NotNull
    public static final String EXAMPLE_STRING = "prompt.p1723201624.0.remarkable.txt";
    @NotNull
    private static final PromptFile EXAMPLE = new PromptFile("p1723201624", 0, "remarkable", null, 8, null);
    @NotNull
    private static final Regex PATTERN = MLPaths.INSTANCE.getPromptFileNamePattern();

    public PromptFile(@NotNull String projectId, int prediction, @NotNull String label, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.projectId = projectId;
        this.prediction = prediction;
        this.label = label;
        this.extension = extension;
    }

    public /* synthetic */ PromptFile(String string, int n, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "txt";
        }
        this(string, n, string2, string3);
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    public final int getPrediction() {
        return this.prediction;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final String getFileName() {
        return StringsKt.replace$default((String)("prompt." + this.projectId + "." + this.prediction + "." + this.label + "." + this.extension), (String)"..", (String)".", (boolean)false, (int)4, null);
    }

    public final Path toPath() {
        return Path.of(this.getFileName(), new String[0]);
    }

    @NotNull
    public final File toFile() {
        return new File(this.getFileName());
    }

    @NotNull
    public final AnswerFile getAnswerFile() {
        return new AnswerFile(this.projectId, this.prediction, this.label, null, 8, null);
    }

    @NotNull
    public String toString() {
        return this.getFileName();
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof PromptFile) ? false : (!Intrinsics.areEqual((Object)this.projectId, (Object)((PromptFile)other).projectId) ? false : (this.prediction != ((PromptFile)other).prediction ? false : (!Intrinsics.areEqual((Object)this.label, (Object)((PromptFile)other).label) ? false : Intrinsics.areEqual((Object)this.extension, (Object)((PromptFile)other).extension)))));
    }

    public int hashCode() {
        int result = this.projectId.hashCode();
        result = 31 * result + Integer.hashCode(this.prediction);
        result = 31 * result + this.label.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    @NotNull
    public final String component1() {
        return this.projectId;
    }

    public final int component2() {
        return this.prediction;
    }

    @NotNull
    public final String component3() {
        return this.label;
    }

    @NotNull
    public final String component4() {
        return this.extension;
    }

    @NotNull
    public final PromptFile copy(@NotNull String projectId, int prediction, @NotNull String label, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return new PromptFile(projectId, prediction, label, extension);
    }

    public static /* synthetic */ PromptFile copy$default(PromptFile promptFile, String string, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = promptFile.projectId;
        }
        if ((n2 & 2) != 0) {
            n = promptFile.prediction;
        }
        if ((n2 & 4) != 0) {
            string2 = promptFile.label;
        }
        if ((n2 & 8) != 0) {
            string3 = promptFile.extension;
        }
        return promptFile.copy(string, n, string2, string3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/ml/clustering/PromptFile$Companion;", "", "()V", "EXAMPLE", "Lai/platon/scent/ml/clustering/PromptFile;", "getEXAMPLE", "()Lai/platon/scent/ml/clustering/PromptFile;", "EXAMPLE_STRING", "", "PATTERN", "Lkotlin/text/Regex;", "getPATTERN", "()Lkotlin/text/Regex;", "fromFile", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "fromFileName", "fileName", "matches", "", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PromptFile getEXAMPLE() {
            return EXAMPLE;
        }

        @NotNull
        public final Regex getPATTERN() {
            return PATTERN;
        }

        public final boolean matches(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Regex regex = this.getPATTERN();
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return regex.matches((CharSequence)string);
        }

        public final boolean matches(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return this.getPATTERN().matches((CharSequence)fileName);
        }

        @NotNull
        public final PromptFile fromFile(@NotNull File file) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return this.fromFileName(string);
        }

        @NotNull
        public final PromptFile fromFile(@NotNull Path path) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return this.fromFile(file);
        }

        @NotNull
        public final PromptFile fromFileName(@NotNull String fileName) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            MatchResult matchResult = Regex.find$default((Regex)this.getPATTERN(), (CharSequence)fileName, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid file name: " + fileName);
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String projectId = (String)destructured.getMatch().getGroupValues().get(1);
            String prediction = (String)destructured.getMatch().getGroupValues().get(2);
            String label = (String)destructured.getMatch().getGroupValues().get(3);
            String extension = (String)destructured.getMatch().getGroupValues().get(4);
            return new PromptFile(projectId, Integer.parseInt(prediction), label, extension);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

