/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.model.PageAttribute;
import ai.platon.pulsar.dom.model.PageEntity;
import com.google.common.collect.LinkedListMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H&J\b\u0010\u0011\u001a\u00020\u0010H\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0004J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0004J\b\u0010\u0017\u001a\u00020\u0010H\u0004J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/view/builder/EntityViewBuilder;", "", "pageEntity", "Lai/platon/pulsar/dom/model/PageEntity;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/dom/model/PageEntity;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "setConf", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getPageEntity", "()Lai/platon/pulsar/dom/model/PageEntity;", "setPageEntity", "(Lai/platon/pulsar/dom/model/PageEntity;)V", "build", "", "buildColors", "buildEntityName", "", "text", "getAttrValue", "attrName", "rebuildKeywords", "validateAttribute", "", "attr", "Lai/platon/pulsar/dom/model/PageAttribute;", "Companion", "scent-build"})
public abstract class EntityViewBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PageEntity pageEntity;
    @NotNull
    private ImmutableConfig conf;
    private static final Logger logger = LoggerFactory.getLogger(EntityViewBuilder.class);
    @NotNull
    private static final String[] PermittedAttributes;
    @NotNull
    private static final LinkedListMultimap<String, String> attrAliases;

    public EntityViewBuilder(@NotNull PageEntity pageEntity, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"pageEntity");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.pageEntity = pageEntity;
        this.conf = conf;
    }

    @NotNull
    protected final PageEntity getPageEntity() {
        return this.pageEntity;
    }

    protected final void setPageEntity(@NotNull PageEntity pageEntity) {
        Intrinsics.checkNotNullParameter((Object)pageEntity, (String)"<set-?>");
        this.pageEntity = pageEntity;
    }

    @NotNull
    protected final ImmutableConfig getConf() {
        return this.conf;
    }

    protected final void setConf(@NotNull ImmutableConfig immutableConfig) {
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"<set-?>");
        this.conf = immutableConfig;
    }

    public abstract void build();

    @NotNull
    protected final String getAttrValue(@NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        String attrValue = this.pageEntity.firstText(attrName);
        if (!(((CharSequence)attrValue).length() == 0)) {
            return attrValue;
        }
        for (String alias : attrAliases.get((Object)attrName)) {
            Intrinsics.checkNotNull((Object)alias);
            attrValue = this.pageEntity.firstText(alias);
            if (((CharSequence)attrValue).length() == 0) continue;
            return attrValue;
        }
        return "";
    }

    protected final boolean validateAttribute(@NotNull PageAttribute attr) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        return true;
    }

    @NotNull
    protected final String buildEntityName(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return text;
    }

    protected final void buildColors() {
        String name = "color";
        HashSet colorStrings = new HashSet();
        Set colorAttributes = this.pageEntity.get(name);
        for (PageAttribute colorAttribute : colorAttributes) {
            String[] stringArray = StringUtils.split((String)colorAttribute.getValue());
            colorStrings.addAll(Arrays.asList(Arrays.copyOf(stringArray, stringArray.length)));
        }
        this.pageEntity.getAttributes().remove(name);
        for (String string : colorStrings) {
        }
    }

    protected final void rebuildKeywords() {
        logger.warn("rebuildKeywords need a test");
        String name = "page-keywords";
        HashSet<String> keywordStrings = new HashSet<String>();
        Set keywordAttributes = this.pageEntity.get(name);
        for (PageAttribute keywordAttribute : keywordAttributes) {
            String value = keywordAttribute.getValue();
            String[] keywords = StringUtils.split((String)value, (String)",\uff0c\u3001|");
            Intrinsics.checkNotNull((Object)keywords);
            for (String keyword : keywords) {
                keywordStrings.add(StringUtils.trimToEmpty((String)keyword));
            }
        }
        this.pageEntity.getAttributes().remove(name);
        for (String keyword : keywordStrings) {
            Intrinsics.checkNotNull((Object)keyword);
            this.pageEntity.add(new PageAttribute(name, keyword, null, null, null, null, null, null, 252, null));
        }
    }

    static {
        String[] stringArray = new String[]{"id", "class", "title", "href", "height", "width", "alt", "src", ""};
        PermittedAttributes = stringArray;
        LinkedListMultimap linkedListMultimap = LinkedListMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)linkedListMultimap, (String)"create(...)");
        attrAliases = linkedListMultimap;
        attrAliases.put((Object)"\u4ea7\u54c1\u540d\u79f0", (Object)"\u4ea7\u54c1\u540d\u79f0");
        attrAliases.put((Object)"\u4ea4\u6613\u5e73\u53f0\u540d\u79f0", (Object)"\u4ea4\u6613\u5e73\u53f0\u540d\u79f0");
        attrAliases.put((Object)"\u4ea4\u6613\u5e73\u53f0\u57df\u540d", (Object)"\u4ea4\u6613\u5e73\u53f0\u57df\u540d");
        attrAliases.put((Object)"\u9500\u552e\u4ef7", (Object)"\u9500\u552e\u4ef7");
        attrAliases.put((Object)"\u53ef\u9009\u989c\u8272", (Object)"\u53ef\u9009\u989c\u8272");
        attrAliases.put((Object)"\u53ef\u9009\u7248\u672c", (Object)"\u53ef\u9009\u7248\u672c");
        attrAliases.put((Object)"\u552e\u540e\u670d\u52a1", (Object)"\u552e\u540e\u670d\u52a1");
        attrAliases.put((Object)"\u7269\u6d41\u4fe1\u606f", (Object)"\u7269\u6d41\u4fe1\u606f");
        attrAliases.put((Object)"\u652f\u4ed8\u8bf4\u660e", (Object)"\u652f\u4ed8\u8bf4\u660e");
        attrAliases.put((Object)"\u5546\u54c1\u8be6\u7ec6\u4ecb\u7ecd", (Object)"\u5546\u54c1\u8be6\u7ec6\u4ecb\u7ecd");
        attrAliases.put((Object)"\u7f51\u9875\u6807\u9898", (Object)"\u7f51\u9875\u6807\u9898");
        attrAliases.put((Object)"\u7f51\u9875\u6458\u8981", (Object)"\u7f51\u9875\u6458\u8981");
        attrAliases.put((Object)"\u7f51\u9875\u5173\u952e\u8bcd", (Object)"\u7f51\u9875\u5173\u952e\u8bcd");
        attrAliases.put((Object)"\u7f51\u9875\u94fe\u63a5", (Object)"\u7f51\u9875\u94fe\u63a5");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/platon/scent/view/builder/EntityViewBuilder$Companion;", "", "()V", "PermittedAttributes", "", "", "getPermittedAttributes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "attrAliases", "Lcom/google/common/collect/LinkedListMultimap;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scent-build"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getPermittedAttributes() {
            return PermittedAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

