/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.view.builder.ml;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.apache.commons.lang3.SystemUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J(\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/view/builder/ml/XLSXBuilder;", "", "()V", "createCellStyle", "Lorg/apache/poi/xssf/usermodel/XSSFCellStyle;", "workbook", "Lorg/apache/poi/xssf/usermodel/XSSFWorkbook;", "setStyle", "", "writeHeader", "rowNum", "", "label", "", "columnCount", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "scent-build"})
@SourceDebugExtension(value={"SMAP\nXLSXBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XLSXBuilder.kt\nai/platon/scent/view/builder/ml/XLSXBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 XLSXBuilder.kt\nai/platon/scent/view/builder/ml/XLSXBuilder\n*L\n36#1:81,2\n*E\n"})
public abstract class XLSXBuilder {
    protected final void writeHeader(int rowNum, @NotNull String label, int columnCount, @NotNull Sheet sheet) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        Row row = sheet.createRow(rowNum);
        row.createCell(0).setCellValue("ID");
        row.createCell(1).setCellValue("URL");
        for (int j = 2; j < columnCount; ++j) {
            row.createCell(j).setCellValue(label + j);
        }
    }

    protected final void setStyle(@NotNull XSSFWorkbook workbook) {
        Intrinsics.checkNotNullParameter((Object)workbook, (String)"workbook");
        XSSFSheet xSSFSheet = workbook.getSheet("MLResult");
        if (xSSFSheet == null) {
            return;
        }
        XSSFSheet sheet = xSSFSheet;
        if (sheet.getRow(0) == null) {
            return;
        }
        XSSFCellStyle style = this.createCellStyle(workbook);
        XSSFRow xSSFRow = sheet.getRow(0);
        Intrinsics.checkNotNullExpressionValue((Object)xSSFRow, (String)"getRow(...)");
        int columnCount = CollectionsKt.count((Iterable)((Iterable)xSSFRow));
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, columnCount - 1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int j = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            sheet.autoSizeColumn(j);
            sheet.setDefaultColumnStyle(j, (CellStyle)style);
        }
    }

    @NotNull
    protected final XSSFCellStyle createCellStyle(@NotNull XSSFWorkbook workbook) {
        Intrinsics.checkNotNullParameter((Object)workbook, (String)"workbook");
        XSSFCellStyle style = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        if (SystemUtils.IS_OS_WINDOWS) {
            // empty if block
        }
        style.getFont().setBold(false);
        font.setFontHeightInPoints((short)11);
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.LIGHT_GREEN.getIndex());
        Intrinsics.checkNotNull((Object)style);
        return style;
    }
}

